/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.HashSet;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class FieldHidesSuperclassFieldInspection
extends BaseInspection {
    public boolean m_ignoreInvisibleFields = true;
    public boolean ignoreStaticFields = true;

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            FieldHidesSuperclassFieldInspection.$$$reportNull$$$0(0);
        }
        this.defaultWriteSettings(node, "ignoreStaticFields");
        this.writeBooleanOption(node, "ignoreStaticFields", true);
    }

    @NotNull
    public String getID() {
        if ("FieldNameHidesFieldInSuperclass" == null) {
            FieldHidesSuperclassFieldInspection.$$$reportNull$$$0(1);
        }
        return "FieldNameHidesFieldInSuperclass";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("field.name.hides.in.superclass.display.name", new Object[0]);
        if (string == null) {
            FieldHidesSuperclassFieldInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("field.name.hides.in.superclass.problem.descriptor", new Object[0]);
        if (string == null) {
            FieldHidesSuperclassFieldInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("field.name.hides.in.superclass.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreInvisibleFields");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new FieldHidesSuperclassFieldVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ig/visibility/FieldHidesSuperclassFieldInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ig/visibility/FieldHidesSuperclassFieldInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class FieldHidesSuperclassFieldVisitor
    extends BaseInspectionVisitor {
        private FieldHidesSuperclassFieldVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            PsiClass aClass;
            if (field == null) {
                FieldHidesSuperclassFieldVisitor.$$$reportNull$$$0(0);
            }
            if ((aClass = field.getContainingClass()) == null) {
                return;
            }
            String fieldName = field.getName();
            if ("serialVersionUID".equals(fieldName)) {
                return;
            }
            HashSet<PsiClass> visitedClasses = new HashSet<PsiClass>();
            for (PsiClass ancestorClass = aClass.getSuperClass(); ancestorClass != null; ancestorClass = ancestorClass.getSuperClass()) {
                if (!visitedClasses.add(ancestorClass)) {
                    return;
                }
                PsiField ancestorField = ancestorClass.findFieldByName(fieldName, false);
                if (ancestorField == null || FieldHidesSuperclassFieldInspection.this.m_ignoreInvisibleFields && !ClassUtils.isFieldVisible(ancestorField, aClass) || FieldHidesSuperclassFieldInspection.this.ignoreStaticFields && field.hasModifierProperty("static") && ancestorField.hasModifierProperty("static")) continue;
                this.registerFieldError(field, new Object[0]);
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/visibility/FieldHidesSuperclassFieldInspection$FieldHidesSuperclassFieldVisitor", "visitField"));
        }
    }
}

