/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.visibility;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import org.jetbrains.annotations.NotNull;

public class TypeParameterHidesVisibleTypeInspection
extends BaseInspection {
    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("type.parameter.hides.visible.type.display.name", new Object[0]);
        if (string == null) {
            TypeParameterHidesVisibleTypeInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        if (aClass instanceof PsiTypeParameter) {
            String string = InspectionGadgetsBundle.message("type.parameter.hides.type.parameter.problem.descriptor", aClass.getName());
            if (string == null) {
                TypeParameterHidesVisibleTypeInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String name = aClass.getQualifiedName();
        if (name == null) {
            name = aClass.getName();
        }
        String string = InspectionGadgetsBundle.message("type.parameter.hides.visible.type.problem.descriptor", name);
        if (string == null) {
            TypeParameterHidesVisibleTypeInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TypeParameterHidesVisibleTypeVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/visibility/TypeParameterHidesVisibleTypeInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class TypeParameterHidesVisibleTypeVisitor
    extends BaseInspectionVisitor {
        private TypeParameterHidesVisibleTypeVisitor() {
        }

        public void visitTypeParameter(PsiTypeParameter parameter2) {
            PsiClass aClass;
            super.visitTypeParameter(parameter2);
            String unqualifiedClassName = parameter2.getName();
            PsiTypeParameterListOwner context = parameter2.getOwner();
            if (context == null) {
                return;
            }
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)parameter2.getProject()).getResolveHelper();
            while (true) {
                if (context.hasModifierProperty("static")) {
                    return;
                }
                if ((context = (PsiTypeParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)context, PsiTypeParameterListOwner.class)) == null) {
                    return;
                }
                aClass = resolveHelper.resolveReferencedClass(unqualifiedClassName, (PsiElement)context);
                if (aClass instanceof PsiTypeParameter) {
                    PsiTypeParameter typeParameter = (PsiTypeParameter)aClass;
                    PsiTypeParameterListOwner owner = typeParameter.getOwner();
                    if (owner == null) {
                        return;
                    }
                    if (!owner.equals(context)) continue;
                }
                if (aClass != null) break;
            }
            this.registerClassError((PsiClass)parameter2, aClass);
        }
    }
}

