/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.exceptions;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExceptionUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.exceptions.DetailExceptionsPredicate;
import com.siyeh.ipp.exceptions.HierarchicalTypeComparator;
import com.siyeh.ipp.exceptions.ObscureThrownExceptionsIntention;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DetailExceptionsIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        DetailExceptionsPredicate detailExceptionsPredicate = new DetailExceptionsPredicate();
        if (detailExceptionsPredicate == null) {
            DetailExceptionsIntention.$$$reportNull$$$0(0);
        }
        return detailExceptionsPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        PsiCatchSection[] catchSections;
        PsiCodeBlock tryBlock;
        PsiTryStatement tryStatement;
        if (element == null) {
            DetailExceptionsIntention.$$$reportNull$$$0(1);
        }
        if ((tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTryStatement.class)) == null) {
            return;
        }
        CommentTracker commentTracker = new CommentTracker();
        StringBuilder newTryStatement = new StringBuilder("try");
        HashSet<PsiClassType> exceptionsThrown = new HashSet<PsiClassType>();
        PsiResourceList resourceList = tryStatement.getResourceList();
        if (resourceList != null) {
            newTryStatement.append(commentTracker.text((PsiElement)resourceList));
            ExceptionUtils.calculateExceptionsThrown((PsiElement)resourceList, exceptionsThrown);
        }
        if ((tryBlock = tryStatement.getTryBlock()) == null) {
            return;
        }
        String tryBlockText = commentTracker.text((PsiElement)tryBlock);
        newTryStatement.append(tryBlockText);
        ExceptionUtils.calculateExceptionsThrown((PsiElement)tryBlock, exceptionsThrown);
        HierarchicalTypeComparator comparator = new HierarchicalTypeComparator();
        for (PsiCatchSection catchSection : catchSections = tryStatement.getCatchSections()) {
            PsiParameter parameter2 = catchSection.getParameter();
            PsiCodeBlock block = catchSection.getCatchBlock();
            if (parameter2 == null || block == null) continue;
            PsiType caughtType = parameter2.getType();
            List<Object> exceptionsToExpand = new ArrayList<PsiClassType>(exceptionsThrown.size());
            for (PsiClassType aExceptionsThrown : exceptionsThrown) {
                if (!caughtType.isAssignableFrom((PsiType)aExceptionsThrown)) continue;
                exceptionsToExpand.add(aExceptionsThrown);
            }
            exceptionsThrown.removeAll(exceptionsToExpand);
            PsiClassType commonSuperType = null;
            PsiClass commonSuper = ObscureThrownExceptionsIntention.findCommonSuperClass(exceptionsToExpand.toArray(PsiClassType.EMPTY_ARRAY));
            if (commonSuper != null && (commonSuperType = JavaPsiFacade.getElementFactory((Project)commonSuper.getProject()).createType(commonSuper)).equals((Object)caughtType)) {
                commonSuperType = null;
            }
            if (commonSuperType != null) {
                exceptionsToExpand = Collections.singletonList(commonSuperType);
            } else {
                Collections.sort(exceptionsToExpand, comparator);
            }
            for (PsiClassType psiClassType : exceptionsToExpand) {
                newTryStatement.append("catch(").append(psiClassType.getCanonicalText()).append(' ').append(parameter2.getName()).append(')');
                newTryStatement.append(commentTracker.text((PsiElement)block));
            }
        }
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock != null) {
            newTryStatement.append("finally").append(commentTracker.text((PsiElement)finallyBlock));
        }
        String newStatement = newTryStatement.toString();
        PsiReplacementUtil.replaceStatementAndShortenClassNames((PsiStatement)tryStatement, newStatement, commentTracker);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/siyeh/ipp/exceptions/DetailExceptionsIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/siyeh/ipp/exceptions/DetailExceptionsIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

