/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.groovy;

import com.intellij.openapi.util.Ref;
import java.io.File;
import java.io.IOException;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.incremental.CompiledClass;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.groovy.GroovyOutputConsumer;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;

class DefaultOutputConsumer
implements GroovyOutputConsumer {
    private final ModuleLevelBuilder.OutputConsumer myOutputConsumer;

    DefaultOutputConsumer(ModuleLevelBuilder.OutputConsumer outputConsumer) {
        this.myOutputConsumer = outputConsumer;
    }

    @Override
    public void registerCompiledClass(BuildTarget<?> target, File srcFile, File outputFile, byte[] bytes) throws IOException {
        this.myOutputConsumer.registerCompiledClass(target, new CompiledClass(outputFile, srcFile, DefaultOutputConsumer.readClassName(bytes), new BinaryContent(bytes)));
    }

    private static String readClassName(byte[] classBytes) throws IOException {
        final Ref nameRef = Ref.create(null);
        new ClassReader(classBytes).accept(new ClassVisitor(458752){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                nameRef.set((Object)name.replace('/', '.'));
            }
        }, 7);
        return (String)nameRef.get();
    }
}

