/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.codeStyle.bean;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.codeStyle.bean.CodeStyleBeanGenerator;

public class CodeStyleBeanIntention
implements IntentionAction {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        if ("Generate CodeStyle methods" == null) {
            CodeStyleBeanIntention.$$$reportNull$$$0(0);
        }
        return "Generate CodeStyle methods";
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        if ("Language plugin" == null) {
            CodeStyleBeanIntention.$$$reportNull$$$0(1);
        }
        return "Language plugin";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiClass beanClass;
        if (project == null) {
            CodeStyleBeanIntention.$$$reportNull$$$0(2);
        }
        if ((beanClass = CodeStyleBeanIntention.findBeanClass(file)) != null) {
            PsiElement currElement;
            int offset = editor.getCaretModel().getOffset();
            if (beanClass.getTextRange().contains(offset) && (currElement = file.findElementAt(offset)) != null && currElement.getParent() == beanClass) {
                ASTNode leftBrace = TreeUtil.findSibling((ASTNode)currElement.getNode(), (IElementType)JavaTokenType.RBRACE);
                ASTNode rightBrace = TreeUtil.findSiblingBackward((ASTNode)currElement.getNode(), (IElementType)JavaTokenType.LBRACE);
                return leftBrace != null && rightBrace != null;
            }
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiClass beanClass;
        if (project == null) {
            CodeStyleBeanIntention.$$$reportNull$$$0(3);
        }
        if ((beanClass = CodeStyleBeanIntention.findBeanClass(file)) != null) {
            CodeStyleBeanIntention.generateAccessors(beanClass, editor, file);
        }
    }

    @Nullable
    private static PsiClass findBeanClass(@NotNull PsiFile file) {
        if (file == null) {
            CodeStyleBeanIntention.$$$reportNull$$$0(4);
        }
        if (file instanceof PsiJavaFile) {
            PsiClass[] classes;
            for (PsiClass javaClass : classes = ((PsiJavaFile)file).getClasses()) {
                if (!CodeStyleBeanIntention.isCodeStyleBean(javaClass)) continue;
                return javaClass;
            }
        }
        return null;
    }

    private static boolean isCodeStyleBean(@NotNull PsiClass javaClass) {
        PsiReferenceList extendsList;
        if (javaClass == null) {
            CodeStyleBeanIntention.$$$reportNull$$$0(5);
        }
        if ((extendsList = javaClass.getExtendsList()) != null) {
            for (PsiClassType type : extendsList.getReferencedTypes()) {
                if (!"CodeStyleBean".equals(type.getClassName())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static void generateAccessors(@NotNull PsiClass beanClass, @NotNull Editor editor, @NotNull PsiFile file) {
        Project project;
        if (beanClass == null) {
            CodeStyleBeanIntention.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            CodeStyleBeanIntention.$$$reportNull$$$0(7);
        }
        if (file == null) {
            CodeStyleBeanIntention.$$$reportNull$$$0(8);
        }
        if ((project = editor.getProject()) != null) {
            int offset = editor.getCaretModel().getOffset();
            Language language = CodeStyleBeanIntention.getLanguage(beanClass, file);
            if (language != null) {
                CodeStyleBeanGenerator beanGenerator = new CodeStyleBeanGenerator(file, beanClass, language);
                String accessorsText = beanGenerator.generateBeanMethods();
                editor.getDocument().insertString(offset, (CharSequence)accessorsText);
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                CodeStyleManager.getInstance((Project)project).reformatText(file, offset, offset + accessorsText.length());
                for (String requiredImport : beanGenerator.getImports()) {
                    CodeStyleBeanIntention.addImport(file, beanClass, requiredImport);
                }
            }
        }
    }

    private static void addImport(@NotNull PsiFile file, @NotNull PsiClass beanClass, @NotNull String classFQN) {
        PsiClass psiClass;
        if (file == null) {
            CodeStyleBeanIntention.$$$reportNull$$$0(9);
        }
        if (beanClass == null) {
            CodeStyleBeanIntention.$$$reportNull$$$0(10);
        }
        if (classFQN == null) {
            CodeStyleBeanIntention.$$$reportNull$$$0(11);
        }
        if ((psiClass = CodeStyleBeanGenerator.resolveClass(classFQN, file)) != null) {
            JavaCodeStyleManager.getInstance((Project)beanClass.getProject()).addImport((PsiJavaFile)file, psiClass);
        }
    }

    @Nullable
    private static Language getLanguage(@NotNull PsiClass beanClass, @NotNull PsiFile file) {
        if (beanClass == null) {
            CodeStyleBeanIntention.$$$reportNull$$$0(12);
        }
        if (file == null) {
            CodeStyleBeanIntention.$$$reportNull$$$0(13);
        }
        for (PsiMethod method : beanClass.getMethods()) {
            PsiCodeBlock body;
            if (!"getLanguage".equals(method.getName()) || (body = method.getBody()) == null) continue;
            for (PsiStatement statement : body.getStatements()) {
                PsiClass resolved;
                PsiElement psiLangClass;
                PsiExpression retValue;
                if (!(statement instanceof PsiReturnStatement) || !((retValue = ((PsiReturnStatement)statement).getReturnValue()) instanceof PsiReferenceExpression) || (psiLangClass = retValue.getFirstChild()) == null || (resolved = CodeStyleBeanGenerator.resolveClass(psiLangClass.getText(), file)) == null) continue;
                try {
                    Class<?> langClass = Class.forName(resolved.getQualifiedName());
                    if (!Language.class.isAssignableFrom(langClass)) continue;
                    return Language.findInstance(langClass);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/codeStyle/bean/CodeStyleBeanIntention";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaClass";
                break;
            }
            case 6: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFQN";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/codeStyle/bean/CodeStyleBeanIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findBeanClass";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isCodeStyleBean";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generateAccessors";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addImport";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getLanguage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

