/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.refactoring;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.inspections.DescriptionType;
import org.jetbrains.idea.devkit.inspections.InspectionDescriptionInfo;
import org.jetbrains.idea.devkit.util.PsiUtil;

public class InspectionAutomaticRenamerFactory
implements AutomaticRenamerFactory {
    private static final String PROPERTY_RENAME_DESCRIPTION_AND_SHORT_NAME = "rename.inspection.description.and.short.name";
    private static final String INSPECTION_CLASS_SUFFIX = "Inspection";

    public boolean isApplicable(@NotNull PsiElement element) {
        if (element == null) {
            InspectionAutomaticRenamerFactory.$$$reportNull$$$0(0);
        }
        if (!(element instanceof PsiClass)) {
            return false;
        }
        if (!PsiUtil.isPluginProject(element.getProject())) {
            return false;
        }
        PsiClass inspectionClass = (PsiClass)element;
        String inspectionClassName = inspectionClass.getName();
        return inspectionClassName != null && inspectionClassName.endsWith(INSPECTION_CLASS_SUFFIX) && InheritanceUtil.isInheritor((PsiClass)inspectionClass, (String)DescriptionType.INSPECTION.getClassName()) && !InspectionAutomaticRenamerFactory.isGetShortNameMethodOverridden(inspectionClass);
    }

    @Nls
    @Nullable
    public String getOptionName() {
        return DevKitBundle.message("inspection.renamer.option.name", new Object[0]);
    }

    public boolean isEnabled() {
        return PropertiesComponent.getInstance().getBoolean(PROPERTY_RENAME_DESCRIPTION_AND_SHORT_NAME, true);
    }

    public void setEnabled(boolean enabled) {
        PropertiesComponent.getInstance().setValue(PROPERTY_RENAME_DESCRIPTION_AND_SHORT_NAME, enabled);
    }

    @NotNull
    public AutomaticRenamer createRenamer(PsiElement element, String newName, Collection<UsageInfo> usages) {
        InspectionAutomaticRenamer inspectionAutomaticRenamer = new InspectionAutomaticRenamer((PsiClass)element, newName);
        if (inspectionAutomaticRenamer == null) {
            InspectionAutomaticRenamerFactory.$$$reportNull$$$0(1);
        }
        return inspectionAutomaticRenamer;
    }

    @NotNull
    private static String getDescriptionFileName(String inspectionClassName) {
        String string = StringUtil.trimEnd((String)inspectionClassName, (String)INSPECTION_CLASS_SUFFIX);
        if (string == null) {
            InspectionAutomaticRenamerFactory.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    private static XmlAttribute getInspectionShortNameAttribute(Module module, PsiClass inspectionClass) {
        Extension extension = InspectionDescriptionInfo.findExtension(module, inspectionClass);
        return extension == null ? null : extension.getXmlTag().getAttribute("shortName");
    }

    private static boolean isGetShortNameMethodOverridden(PsiClass inspectionClass) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)inspectionClass);
        if (module == null) {
            return false;
        }
        return InspectionDescriptionInfo.create(module, inspectionClass).getShortNameMethod() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/refactoring/InspectionAutomaticRenamerFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/refactoring/InspectionAutomaticRenamerFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenamer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InspectionAutomaticRenamer
    extends AutomaticRenamer {
        InspectionAutomaticRenamer(PsiClass inspectionClass, String newName) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)inspectionClass);
            if (module == null) {
                return;
            }
            InspectionDescriptionInfo descriptionInfo = InspectionDescriptionInfo.create(module, inspectionClass);
            if (!descriptionInfo.isShortNameInXml() || descriptionInfo.getShortNameMethod() != null) {
                return;
            }
            PsiFile descriptionFile = descriptionInfo.getDescriptionFile();
            if (descriptionFile == null) {
                return;
            }
            String inspectionClassName = inspectionClass.getName();
            if (inspectionClassName == null) {
                return;
            }
            String descriptionFileName = descriptionFile.getName();
            String defaultShortName = InspectionAutomaticRenamerFactory.getDescriptionFileName(inspectionClassName);
            if (!newName.endsWith(InspectionAutomaticRenamerFactory.INSPECTION_CLASS_SUFFIX) || !defaultShortName.equals(FileUtil.getNameWithoutExtension((String)descriptionFileName))) {
                return;
            }
            XmlAttribute shortNameAttribute = InspectionAutomaticRenamerFactory.getInspectionShortNameAttribute(module, inspectionClass);
            if (shortNameAttribute == null) {
                return;
            }
            if (!defaultShortName.equals(shortNameAttribute.getValue())) {
                return;
            }
            VirtualFile descriptionVirtualFile = descriptionFile.getVirtualFile();
            if (descriptionVirtualFile == null) {
                return;
            }
            String newDescriptionFileName = InspectionAutomaticRenamerFactory.getDescriptionFileName(newName);
            if (newDescriptionFileName.equals(descriptionFileName)) {
                return;
            }
            String descriptionFileExtension = StringUtil.notNullize((String)descriptionVirtualFile.getExtension());
            this.myElements.add(descriptionFile);
            this.suggestAllNames(descriptionFileName, newDescriptionFileName + "." + descriptionFileExtension);
        }

        @Nls
        public String getDialogTitle() {
            return DevKitBundle.message("inspection.renamer.dialog.title", new Object[0]);
        }

        @Nls
        public String getDialogDescription() {
            return DevKitBundle.message("inspection.renamer.dialog.description", new Object[0]);
        }

        public String entityName() {
            return DevKitBundle.message("inspection.renamer.entity.name", new Object[0]);
        }

        public void findUsages(List<UsageInfo> result, boolean searchInStringsAndComments, boolean searchInNonJavaFiles, List<UnresolvableCollisionUsageInfo> unresolvedUsages, Map<PsiElement, String> allRenames) {
            super.findUsages(result, searchInStringsAndComments, searchInNonJavaFiles, unresolvedUsages, allRenames);
            if (allRenames == null) {
                return;
            }
            for (Map.Entry<PsiElement, String> entry : allRenames.entrySet()) {
                PsiFile pluginXmlFile;
                XmlAttributeValue shortNameValue;
                XmlAttribute shortNameAttribute;
                PsiClass inspectionClass;
                InspectionDescriptionInfo descriptionInfo;
                PsiFile descriptionFile;
                Module module;
                PsiElement element = entry.getKey();
                if (!(element instanceof PsiClass) || (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null || (descriptionFile = (descriptionInfo = InspectionDescriptionInfo.create(module, inspectionClass = (PsiClass)element)).getDescriptionFile()) == null || (shortNameAttribute = InspectionAutomaticRenamerFactory.getInspectionShortNameAttribute(module, inspectionClass)) == null || (shortNameValue = shortNameAttribute.getValueElement()) == null || (pluginXmlFile = shortNameAttribute.getContainingFile()) == null) continue;
                String newName = InspectionAutomaticRenamerFactory.getDescriptionFileName(entry.getValue());
                TextRange range = ElementManipulators.getValueTextRange((PsiElement)shortNameValue).shiftRight(shortNameValue.getTextRange().getStartOffset());
                result.add((UsageInfo)NonCodeUsageInfo.create((PsiFile)pluginXmlFile, (int)range.getStartOffset(), (int)range.getEndOffset(), (PsiElement)shortNameValue, (String)newName));
                break;
            }
        }
    }
}

