/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.usageProcessing;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.j2k.AccessorKind;
import org.jetbrains.kotlin.j2k.CodeConverter;
import org.jetbrains.kotlin.j2k.UtilsKt;
import org.jetbrains.kotlin.j2k.ast.Element;
import org.jetbrains.kotlin.j2k.ast.ElementKt;
import org.jetbrains.kotlin.j2k.ast.Expression;
import org.jetbrains.kotlin.j2k.ast.Identifier;
import org.jetbrains.kotlin.j2k.ast.QualifiedExpression;
import org.jetbrains.kotlin.j2k.ast.ThisExpression;
import org.jetbrains.kotlin.j2k.usageProcessing.ConvertedCodeProcessor;
import org.jetbrains.kotlin.j2k.usageProcessing.ElementRenamedCodeProcessor;
import org.jetbrains.kotlin.j2k.usageProcessing.ExternalCodeProcessor;
import org.jetbrains.kotlin.j2k.usageProcessing.UsageProcessing;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002 !B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/j2k/usageProcessing/FieldToPropertyProcessing;", "Lorg/jetbrains/kotlin/j2k/usageProcessing/UsageProcessing;", "field", "Lcom/intellij/psi/PsiField;", "propertyName", "", "isNullable", "", "replaceReadWithFieldReference", "replaceWriteWithFieldReference", "(Lcom/intellij/psi/PsiField;Ljava/lang/String;ZZZ)V", "convertedCodeProcessor", "Lorg/jetbrains/kotlin/j2k/usageProcessing/ConvertedCodeProcessor;", "getConvertedCodeProcessor", "()Lorg/jetbrains/kotlin/j2k/usageProcessing/ConvertedCodeProcessor;", "javaCodeProcessors", "", "Lorg/jetbrains/kotlin/j2k/usageProcessing/ExternalCodeProcessor;", "getJavaCodeProcessors", "()Ljava/util/List;", "setJavaCodeProcessors", "(Ljava/util/List;)V", "kotlinCodeProcessors", "Lorg/jetbrains/kotlin/j2k/usageProcessing/ElementRenamedCodeProcessor;", "getKotlinCodeProcessors", "targetElement", "Lcom/intellij/psi/PsiElement;", "getTargetElement", "()Lcom/intellij/psi/PsiElement;", "accessorName", "kind", "Lorg/jetbrains/kotlin/j2k/AccessorKind;", "MyConvertedCodeProcessor", "UseAccessorsJavaCodeProcessor", "j2k"})
public final class FieldToPropertyProcessing
implements UsageProcessing {
    @Nullable
    private final ConvertedCodeProcessor convertedCodeProcessor;
    @NotNull
    private List<? extends ExternalCodeProcessor> javaCodeProcessors;
    @NotNull
    private final List<ElementRenamedCodeProcessor> kotlinCodeProcessors;
    private final PsiField field;
    private final String propertyName;
    private final boolean isNullable;
    private final boolean replaceReadWithFieldReference;
    private final boolean replaceWriteWithFieldReference;

    @Override
    @NotNull
    public PsiElement getTargetElement() {
        return (PsiElement)this.field;
    }

    @Override
    @Nullable
    public ConvertedCodeProcessor getConvertedCodeProcessor() {
        return this.convertedCodeProcessor;
    }

    @Override
    @NotNull
    public List<ExternalCodeProcessor> getJavaCodeProcessors() {
        return this.javaCodeProcessors;
    }

    public void setJavaCodeProcessors(@NotNull List<? extends ExternalCodeProcessor> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.javaCodeProcessors = list;
    }

    @NotNull
    public List<ElementRenamedCodeProcessor> getKotlinCodeProcessors() {
        return this.kotlinCodeProcessors;
    }

    private final String accessorName(AccessorKind kind2) {
        return (kind2 == AccessorKind.GETTER ? "get" : "set") + StringsKt.capitalize((String)this.propertyName);
    }

    public FieldToPropertyProcessing(@NotNull PsiField field, @NotNull String propertyName, boolean isNullable, boolean replaceReadWithFieldReference, boolean replaceWriteWithFieldReference) {
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        Intrinsics.checkParameterIsNotNull((Object)propertyName, (String)"propertyName");
        this.field = field;
        this.propertyName = propertyName;
        this.isNullable = isNullable;
        this.replaceReadWithFieldReference = replaceReadWithFieldReference;
        this.replaceWriteWithFieldReference = replaceWriteWithFieldReference;
        ConvertedCodeProcessor convertedCodeProcessor2 = this.convertedCodeProcessor = Intrinsics.areEqual((Object)this.field.getName(), (Object)this.propertyName) ^ true || this.replaceReadWithFieldReference || this.replaceWriteWithFieldReference ? (ConvertedCodeProcessor)new MyConvertedCodeProcessor() : null;
        this.javaCodeProcessors = this.field.hasModifierProperty("private") ? CollectionsKt.emptyList() : (Intrinsics.areEqual((Object)this.field.getName(), (Object)this.propertyName) ^ true ? CollectionsKt.listOf((Object[])new ExternalCodeProcessor[]{new ElementRenamedCodeProcessor(this.propertyName), new UseAccessorsJavaCodeProcessor()}) : CollectionsKt.listOf((Object)new UseAccessorsJavaCodeProcessor()));
        this.kotlinCodeProcessors = Intrinsics.areEqual((Object)this.field.getName(), (Object)this.propertyName) ^ true ? CollectionsKt.listOf((Object)new ElementRenamedCodeProcessor(this.propertyName)) : CollectionsKt.emptyList();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/j2k/usageProcessing/FieldToPropertyProcessing$MyConvertedCodeProcessor;", "Lorg/jetbrains/kotlin/j2k/usageProcessing/ConvertedCodeProcessor;", "(Lorg/jetbrains/kotlin/j2k/usageProcessing/FieldToPropertyProcessing;)V", "convertVariableUsage", "Lorg/jetbrains/kotlin/j2k/ast/Expression;", "expression", "Lcom/intellij/psi/PsiReferenceExpression;", "codeConverter", "Lorg/jetbrains/kotlin/j2k/CodeConverter;", "j2k"})
    private final class MyConvertedCodeProcessor
    implements ConvertedCodeProcessor {
        @Override
        @Nullable
        public Expression convertVariableUsage(@NotNull PsiReferenceExpression expression, @NotNull CodeConverter codeConverter) {
            PsiReferenceExpression psiReferenceExpression;
            Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)codeConverter, (String)"codeConverter");
            boolean useFieldReference = FieldToPropertyProcessing.this.replaceReadWithFieldReference && PsiUtil.isAccessedForReading((PsiExpression)((PsiExpression)expression)) || FieldToPropertyProcessing.this.replaceWriteWithFieldReference && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)expression));
            Identifier identifier = Identifier.Companion.withNoPrototype$default(Identifier.Companion, useFieldReference ? "field" : FieldToPropertyProcessing.this.propertyName, FieldToPropertyProcessing.this.isNullable, false, null, 12, null);
            PsiExpression qualifier = expression.getQualifierExpression();
            if (qualifier != null && !useFieldReference) {
                return new QualifiedExpression(CodeConverter.convertExpression$default(codeConverter, qualifier, false, 2, null), identifier, UtilsKt.dot(expression));
            }
            PsiElementFactory elementFactory = PsiElementFactory.SERVICE.getInstance((Project)expression.getProject());
            try {
                PsiExpression psiExpression = elementFactory.createExpressionFromText(identifier.getName(), (PsiElement)expression);
                if (!(psiExpression instanceof PsiReferenceExpression)) {
                    psiExpression = null;
                }
                PsiReferenceExpression psiReferenceExpression2 = (PsiReferenceExpression)psiExpression;
                if (psiReferenceExpression2 == null) {
                    return identifier;
                }
                psiReferenceExpression = psiReferenceExpression2;
            }
            catch (IncorrectOperationException e) {
                return identifier;
            }
            PsiReferenceExpression refExpr = psiReferenceExpression;
            return refExpr.resolve() == null ? (Expression)identifier : (Expression)new QualifiedExpression((Expression)ElementKt.assignNoPrototype((Element)new ThisExpression(Identifier.Companion.getEmpty())), identifier, null);
        }

        @Override
        @Nullable
        public Expression convertMethodUsage(@NotNull PsiMethodCallExpression methodCall, @NotNull CodeConverter codeConverter) {
            Intrinsics.checkParameterIsNotNull((Object)methodCall, (String)"methodCall");
            Intrinsics.checkParameterIsNotNull((Object)codeConverter, (String)"codeConverter");
            return ConvertedCodeProcessor.DefaultImpls.convertMethodUsage(this, methodCall, codeConverter);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u001a\u0010\n\u001a\u00020\t2\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\tH\u0002J\u001d\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u0010J1\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r*\u00020\t2\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u0014R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/j2k/usageProcessing/FieldToPropertyProcessing$UseAccessorsJavaCodeProcessor;", "Lorg/jetbrains/kotlin/j2k/usageProcessing/ExternalCodeProcessor;", "(Lorg/jetbrains/kotlin/j2k/usageProcessing/FieldToPropertyProcessing;)V", "factory", "Lcom/intellij/psi/PsiElementFactory;", "kotlin.jvm.PlatformType", "generateGetterCall", "Lcom/intellij/psi/PsiMethodCallExpression;", "qualifier", "Lcom/intellij/psi/PsiExpression;", "generateSetterCall", "value", "processUsage", "", "Lcom/intellij/psi/PsiReference;", "reference", "(Lcom/intellij/psi/PsiReference;)[Lcom/intellij/psi/PsiReference;", "replaceWithModificationCalls", "op", "", "(Lcom/intellij/psi/PsiExpression;Lcom/intellij/psi/PsiExpression;Ljava/lang/String;Lcom/intellij/psi/PsiExpression;)[Lcom/intellij/psi/PsiReference;", "j2k"})
    private final class UseAccessorsJavaCodeProcessor
    implements ExternalCodeProcessor {
        private final PsiElementFactory factory;

        @Override
        @Nullable
        public PsiReference[] processUsage(@NotNull PsiReference reference) {
            PsiElement parent;
            Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
            PsiElement psiElement = reference.getElement();
            if (!(psiElement instanceof PsiReferenceExpression)) {
                psiElement = null;
            }
            PsiReferenceExpression psiReferenceExpression = (PsiReferenceExpression)psiElement;
            if (psiReferenceExpression == null) {
                return null;
            }
            PsiReferenceExpression refExpr = psiReferenceExpression;
            PsiExpression qualifier = refExpr.getQualifierExpression();
            PsiElement psiElement2 = parent = refExpr.getParent();
            if (psiElement2 instanceof PsiAssignmentExpression) {
                if (Intrinsics.areEqual((Object)refExpr, (Object)((PsiAssignmentExpression)parent).getLExpression())) {
                    String assignmentOpText;
                    if (Intrinsics.areEqual((Object)((PsiAssignmentExpression)parent).getOperationTokenType(), (Object)JavaTokenType.EQ)) {
                        PsiExpression psiExpression = ((PsiAssignmentExpression)parent).getRExpression();
                        if (psiExpression == null) {
                            return null;
                        }
                        PsiElement psiElement3 = parent.replace((PsiElement)this.generateSetterCall(qualifier, psiExpression));
                        if (psiElement3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiMethodCallExpression");
                        }
                        PsiMethodCallExpression callExpr = (PsiMethodCallExpression)psiElement3;
                        PsiReference[] psiReferenceArray = new PsiReference[1];
                        PsiReferenceExpression psiReferenceExpression2 = callExpr.getMethodExpression();
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceExpression2, (String)"callExpr.methodExpression");
                        psiReferenceArray[0] = (PsiReference)psiReferenceExpression2;
                        return psiReferenceArray;
                    }
                    PsiJavaToken psiJavaToken = ((PsiAssignmentExpression)parent).getOperationSign();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiJavaToken, (String)"parent.operationSign");
                    String string = assignmentOpText = psiJavaToken.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"assignmentOpText");
                    boolean bl = StringsKt.endsWith$default((String)string, (String)"=", (boolean)false, (int)2, null);
                    if (_Assertions.ENABLED && !bl) {
                        String string2 = "Assertion failed";
                        throw (Throwable)((Object)new AssertionError((Object)string2));
                    }
                    String string3 = assignmentOpText;
                    int n = 0;
                    int n2 = assignmentOpText.length() - 1;
                    String string4 = string3.substring(n, n2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String opText = string4;
                    PsiExpression psiExpression = ((PsiAssignmentExpression)parent).getRExpression();
                    if (psiExpression == null) {
                        return null;
                    }
                    return this.replaceWithModificationCalls((PsiExpression)parent, qualifier, opText, psiExpression);
                }
            } else if (psiElement2 instanceof PsiPrefixExpression || psiElement2 instanceof PsiPostfixExpression) {
                String opText;
                PsiPrefixExpression operationType;
                PsiPrefixExpression psiPrefixExpression;
                PsiElement psiElement4 = parent;
                if (!(psiElement4 instanceof PsiPrefixExpression)) {
                    psiElement4 = null;
                }
                if ((psiPrefixExpression = (PsiPrefixExpression)psiElement4) == null || (psiPrefixExpression = psiPrefixExpression.getOperationTokenType()) == null) {
                    PsiElement psiElement5 = parent;
                    if (psiElement5 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiPostfixExpression");
                    }
                    psiPrefixExpression = ((PsiPostfixExpression)psiElement5).getOperationTokenType();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)psiPrefixExpression, (String)"(parent as? PsiPrefixExp\u2026ssion).operationTokenType");
                PsiPrefixExpression psiPrefixExpression2 = operationType = psiPrefixExpression;
                String string = Intrinsics.areEqual((Object)psiPrefixExpression2, (Object)JavaTokenType.PLUSPLUS) ? "+" : (opText = Intrinsics.areEqual((Object)psiPrefixExpression2, (Object)JavaTokenType.MINUSMINUS) ? "-" : null);
                if (opText != null) {
                    PsiElement psiElement6 = parent;
                    if (psiElement6 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiExpression");
                    }
                    PsiExpression psiExpression = (PsiExpression)psiElement6;
                    PsiExpression psiExpression2 = this.factory.createExpressionFromText("1", null);
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiExpression2, (String)"factory.createExpressionFromText(\"1\", null)");
                    return this.replaceWithModificationCalls(psiExpression, qualifier, opText, psiExpression2);
                }
            }
            PsiElement psiElement7 = refExpr.replace((PsiElement)this.generateGetterCall(qualifier));
            if (psiElement7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiMethodCallExpression");
            }
            PsiMethodCallExpression callExpr = (PsiMethodCallExpression)psiElement7;
            PsiReference[] psiReferenceArray = new PsiReference[1];
            PsiReferenceExpression psiReferenceExpression3 = callExpr.getMethodExpression();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceExpression3, (String)"callExpr.methodExpression");
            psiReferenceArray[0] = (PsiReference)psiReferenceExpression3;
            return psiReferenceArray;
        }

        private final PsiReference[] replaceWithModificationCalls(@NotNull PsiExpression $receiver, PsiExpression qualifier, String op, PsiExpression value2) {
            PsiMethodCallExpression getCall = this.generateGetterCall(qualifier);
            PsiExpression psiExpression = this.factory.createExpressionFromText("x " + op + " y", null);
            if (psiExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiBinaryExpression");
            }
            PsiBinaryExpression binary = (PsiBinaryExpression)psiExpression;
            binary.getLOperand().replace((PsiElement)getCall);
            PsiExpression psiExpression2 = binary.getROperand();
            if (psiExpression2 == null) {
                Intrinsics.throwNpe();
            }
            psiExpression2.replace((PsiElement)value2);
            PsiExpression psiExpression3 = this.generateSetterCall(qualifier, (PsiExpression)binary);
            if (psiExpression3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiMethodCallExpression");
            }
            PsiMethodCallExpression setCall = (PsiMethodCallExpression)psiExpression3;
            PsiElement psiElement = $receiver.replace((PsiElement)setCall);
            if (psiElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiMethodCallExpression");
            }
            setCall = (PsiMethodCallExpression)psiElement;
            PsiExpressionList psiExpressionList = setCall.getArgumentList();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiExpressionList, (String)"setCall.argumentList");
            Object[] objectArray = psiExpressionList.getExpressions();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"setCall.argumentList.expressions");
            Object object = ArraysKt.single((Object[])objectArray);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiBinaryExpression");
            }
            binary = (PsiBinaryExpression)object;
            PsiExpression psiExpression4 = binary.getLOperand();
            if (psiExpression4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiMethodCallExpression");
            }
            getCall = (PsiMethodCallExpression)psiExpression4;
            PsiReference[] psiReferenceArray = new PsiReference[2];
            PsiReferenceExpression psiReferenceExpression = getCall.getMethodExpression();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceExpression, (String)"getCall.methodExpression");
            psiReferenceArray[0] = (PsiReference)psiReferenceExpression;
            PsiReferenceExpression psiReferenceExpression2 = setCall.getMethodExpression();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceExpression2, (String)"setCall.methodExpression");
            psiReferenceArray[1] = (PsiReference)psiReferenceExpression2;
            return psiReferenceArray;
        }

        private final PsiMethodCallExpression generateGetterCall(PsiExpression qualifier) {
            String text2 = FieldToPropertyProcessing.this.accessorName(AccessorKind.GETTER) + "()";
            String expressionText = qualifier != null ? qualifier.getText() + '.' + text2 : text2;
            PsiExpression psiExpression = this.factory.createExpressionFromText(expressionText, null);
            if (psiExpression == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiMethodCallExpression");
            }
            return (PsiMethodCallExpression)psiExpression;
        }

        private final PsiExpression generateSetterCall(PsiExpression qualifier, PsiExpression value2) {
            String text2 = FieldToPropertyProcessing.this.accessorName(AccessorKind.SETTER) + "(" + value2.getText() + ")";
            String expressionText = qualifier != null ? qualifier.getText() + '.' + text2 : text2;
            PsiExpression psiExpression = this.factory.createExpressionFromText(expressionText, null);
            Intrinsics.checkExpressionValueIsNotNull((Object)psiExpression, (String)"factory.createExpression\u2026ext(expressionText, null)");
            return psiExpression;
        }

        public UseAccessorsJavaCodeProcessor() {
            this.factory = PsiElementFactory.SERVICE.getInstance((Project)FieldToPropertyProcessing.this.field.getProject());
        }
    }
}

