/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.ide.FileSelectInContext;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.newStructureView.StructureViewComponent;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.ChooseSubsequentPropertyValueEditorAction;
import com.intellij.lang.properties.editor.NoPropertySelectedPanel;
import com.intellij.lang.properties.editor.PropertiesValueHighlighter;
import com.intellij.lang.properties.editor.ResourceBundleEditorFileListener;
import com.intellij.lang.properties.editor.ResourceBundleEditorHighlighter;
import com.intellij.lang.properties.editor.ResourceBundleEditorKeepEmptyValueToggleAction;
import com.intellij.lang.properties.editor.ResourceBundleEditorViewElement;
import com.intellij.lang.properties.editor.ResourceBundleFileStructureViewElement;
import com.intellij.lang.properties.editor.ResourceBundlePropertiesUpdateManager;
import com.intellij.lang.properties.editor.ResourceBundlePropertyStructureViewElement;
import com.intellij.lang.properties.editor.ResourceBundleStructureViewComponent;
import com.intellij.lang.properties.editor.inspections.incomplete.IncompletePropertyInspection;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertiesResourceBundleUtil;
import com.intellij.lang.properties.xml.XmlPropertiesFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileEditor.DocumentsEditor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.Alarm;
import com.intellij.util.EditorPopupHandler;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.Stack;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.Scrollable;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceBundleEditor
extends UserDataHolderBase
implements DocumentsEditor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.properties.editor.ResourceBundleEditor");
    @NonNls
    private static final String VALUES = "values";
    @NonNls
    private static final String NO_PROPERTY_SELECTED = "noPropertySelected";
    public static final Key<ResourceBundleEditor> RESOURCE_BUNDLE_EDITOR_KEY = Key.create((String)"resourceBundleEditor");
    private final StructureViewComponent myStructureViewComponent;
    private final Map<VirtualFile, EditorEx> myEditors;
    private final ResourceBundle myResourceBundle;
    private final ResourceBundlePropertiesUpdateManager myPropertiesInsertDeleteManager;
    private final Map<VirtualFile, JPanel> myTitledPanels;
    private final JComponent myNoPropertySelectedPanel;
    private final Project myProject;
    private final DataProviderPanel myDataProviderPanel;
    private final Set<VirtualFile> myBackSlashPressed;
    private final Alarm mySelectionChangeAlarm;
    private final JPanel myValuesPanel;
    private final JPanel myStructureViewPanel;
    private volatile boolean myDisposed;
    private ResourceBundleEditorFileListener myVfsListener;
    private Editor mySelectedEditor;
    private String myPropertyToSelectWhenVisible;
    private final ResourceBundleEditorHighlighter myHighlighter;

    public ResourceBundleEditor(@NotNull ResourceBundle resourceBundle) {
        TreeElement child;
        IProperty property;
        if (resourceBundle == null) {
            ResourceBundleEditor.$$$reportNull$$$0(0);
        }
        this.myNoPropertySelectedPanel = new NoPropertySelectedPanel().getComponent();
        this.myBackSlashPressed = new THashSet();
        this.mySelectionChangeAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myProject = resourceBundle.getProject();
        JPanel splitPanel = new JPanel();
        this.myValuesPanel = new JPanel();
        this.myStructureViewPanel = new JPanel();
        OnePixelSplitter splitter = new OnePixelSplitter(false);
        splitter.setFirstComponent((JComponent)this.myStructureViewPanel);
        splitter.setSecondComponent((JComponent)this.myValuesPanel);
        splitter.setShowDividerControls(true);
        splitter.setHonorComponentsMinimumSize(true);
        splitter.setAndLoadSplitterProportionKey(((Object)((Object)this)).getClass() + ".splitter");
        splitPanel.setLayout(new BorderLayout());
        splitPanel.add((Component)splitter, "Center");
        this.myResourceBundle = resourceBundle;
        this.myPropertiesInsertDeleteManager = new ResourceBundlePropertiesUpdateManager(resourceBundle);
        this.myStructureViewComponent = new ResourceBundleStructureViewComponent(this.myResourceBundle, this);
        this.myStructureViewPanel.setLayout(new BorderLayout());
        this.myStructureViewPanel.add((Component)this.myStructureViewComponent, "Center");
        this.myStructureViewComponent.getTree().getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){
            private IProperty selectedProperty;
            private VirtualFile selectedPropertiesFile;

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (ResourceBundleEditor.this.getSelectedElementIfOnlyOne() instanceof ResourceBundleFileStructureViewElement) {
                    ((CardLayout)ResourceBundleEditor.this.myValuesPanel.getLayout()).show(ResourceBundleEditor.this.myValuesPanel, ResourceBundleEditor.NO_PROPERTY_SELECTED);
                    this.writePreviouslySelectedPropertyValue(e);
                    this.selectedPropertiesFile = null;
                    this.selectedProperty = null;
                    return;
                }
                if (Comparing.equal((Object)e.getNewLeadSelectionPath(), (Object)e.getOldLeadSelectionPath()) || ResourceBundleEditor.this.getSelectedProperty() == null) {
                    return;
                }
                if (!this.arePropertiesEquivalent(this.selectedProperty, ResourceBundleEditor.this.getSelectedProperty()) || !Comparing.equal((Object)this.selectedPropertiesFile, (Object)ResourceBundleEditor.this.getSelectedPropertiesFile())) {
                    this.writePreviouslySelectedPropertyValue(e);
                    this.selectedProperty = ResourceBundleEditor.this.getSelectedProperty();
                    this.selectedPropertiesFile = ResourceBundleEditor.this.getSelectedPropertiesFile();
                    ResourceBundleEditor.this.selectionChanged();
                }
            }

            private void writePreviouslySelectedPropertyValue(TreeSelectionEvent e) {
                if (this.selectedProperty != null && e.getOldLeadSelectionPath() != null) {
                    for (Map.Entry entry : ResourceBundleEditor.this.myEditors.entrySet()) {
                        if (entry.getValue() != ResourceBundleEditor.this.mySelectedEditor) continue;
                        ResourceBundleEditor.this.writeEditorPropertyValue(this.selectedProperty.getName(), ResourceBundleEditor.this.mySelectedEditor, (VirtualFile)entry.getKey());
                        break;
                    }
                }
            }

            private boolean arePropertiesEquivalent(@Nullable IProperty oldSelected, @Nullable IProperty newSelected) {
                if (oldSelected == newSelected) {
                    return true;
                }
                if (oldSelected == null || newSelected == null) {
                    return false;
                }
                PsiElement oldPsiElement = oldSelected.getPsiElement();
                if (!oldPsiElement.isValid()) {
                    return false;
                }
                return oldPsiElement.isEquivalentTo(newSelected.getPsiElement());
            }
        });
        this.myEditors = new ConcurrentHashMap<VirtualFile, EditorEx>();
        this.myTitledPanels = new THashMap();
        this.recreateEditorsPanel();
        TreeElement[] children = this.myStructureViewComponent.getTreeModel().getRoot().getChildren();
        if (children.length != 0 && (property = ((ResourceBundlePropertyStructureViewElement)(child = children[0])).getProperty()) != null) {
            String propName = property.getUnescapedKey();
            this.setState(new ResourceBundleEditorState(propName));
        }
        this.myDataProviderPanel = new DataProviderPanel(splitPanel);
        this.installPropertiesChangeListeners();
        this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                ResourceBundleEditor.this.onSelectionChanged(event);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/properties/editor/ResourceBundleEditor$2", "selectionChanged"));
            }
        });
        this.myHighlighter = this.myResourceBundle.getDefaultPropertiesFile() instanceof XmlPropertiesFile ? null : new ResourceBundleEditorHighlighter(this);
    }

    public ResourceBundle getResourceBundle() {
        return this.myResourceBundle;
    }

    public void updateTreeRoot() {
        this.myStructureViewComponent.rebuild();
    }

    @NotNull
    public ResourceBundlePropertiesUpdateManager getPropertiesInsertDeleteManager() {
        ResourceBundlePropertiesUpdateManager resourceBundlePropertiesUpdateManager = this.myPropertiesInsertDeleteManager;
        if (resourceBundlePropertiesUpdateManager == null) {
            ResourceBundleEditor.$$$reportNull$$$0(1);
        }
        return resourceBundlePropertiesUpdateManager;
    }

    private void onSelectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            ResourceBundleEditor.$$$reportNull$$$0(2);
        }
        FileEditor oldEditor = event.getOldEditor();
        FileEditor newEditor = event.getNewEditor();
        if (oldEditor != this && newEditor != this) {
            return;
        }
        if (newEditor == this) {
            if (oldEditor instanceof TextEditor) {
                this.myPropertiesInsertDeleteManager.reload();
                this.setStructureViewSelectionFromPropertiesFile(((TextEditor)oldEditor).getEditor());
            } else if (this.myPropertyToSelectWhenVisible != null) {
                this.setStructureViewSelection(this.myPropertyToSelectWhenVisible);
                this.myPropertyToSelectWhenVisible = null;
            }
        } else if (newEditor instanceof TextEditor) {
            this.setPropertiesFileSelectionFromStructureView(((TextEditor)newEditor).getEditor());
        }
    }

    private void setStructureViewSelectionFromPropertiesFile(@NotNull Editor propertiesFileEditor) {
        Document document;
        int line;
        if (propertiesFileEditor == null) {
            ResourceBundleEditor.$$$reportNull$$$0(3);
        }
        if ((line = propertiesFileEditor.getCaretModel().getLogicalPosition().line) >= (document = propertiesFileEditor.getDocument()).getLineCount()) {
            return;
        }
        String propertyName = ResourceBundleEditor.getPropertyName(document, line);
        if (propertyName == null) {
            return;
        }
        this.setStructureViewSelection(propertyName);
    }

    private void setStructureViewSelection(@NotNull String propertyName) {
        if (propertyName == null) {
            ResourceBundleEditor.$$$reportNull$$$0(4);
        }
        if (this.myStructureViewComponent.isDisposed()) {
            return;
        }
        JTree tree = this.myStructureViewComponent.getTree();
        Object root = tree.getModel().getRoot();
        if (AbstractTreeUi.isLoadingChildrenFor((Object)root)) {
            boolean isEditorVisible = false;
            for (FileEditor editor : FileEditorManager.getInstance((Project)this.myProject).getSelectedEditors()) {
                if (editor != this) continue;
                isEditorVisible = true;
                break;
            }
            if (!isEditorVisible) {
                this.myPropertyToSelectWhenVisible = propertyName;
                return;
            }
            this.mySelectionChangeAlarm.cancelAllRequests();
            this.mySelectionChangeAlarm.addRequest(() -> {
                if (propertyName == null) {
                    ResourceBundleEditor.$$$reportNull$$$0(24);
                }
                this.mySelectionChangeAlarm.cancelAllRequests();
                this.setStructureViewSelection(propertyName);
            }, 500);
            return;
        }
        Stack toCheck = ContainerUtilRt.newStack();
        toCheck.push((Object)this.myStructureViewComponent.getTreeModel().getRoot());
        while (!toCheck.isEmpty()) {
            TreeElement element = (TreeElement)toCheck.pop();
            PsiElement value = element instanceof ResourceBundlePropertyStructureViewElement ? ((ResourceBundlePropertyStructureViewElement)element).getPsiElement() : null;
            IProperty property = PropertiesImplUtil.getProperty(value);
            if (property != null && propertyName.equals(property.getUnescapedKey())) {
                this.myStructureViewComponent.select((Object)property, true);
                this.selectionChanged();
                return;
            }
            for (TreeElement treeElement : element.getChildren()) {
                toCheck.push((Object)treeElement);
            }
        }
    }

    public void flush() {
        this.myVfsListener.flush();
    }

    @Nullable
    private static String getPropertyName(@NotNull Document document, int line) {
        if (document == null) {
            ResourceBundleEditor.$$$reportNull$$$0(5);
        }
        int startOffset = document.getLineStartOffset(line);
        int endOffset = StringUtil.indexOf((CharSequence)document.getCharsSequence(), (char)'=', (int)startOffset, (int)document.getLineEndOffset(line));
        if (endOffset <= startOffset) {
            return null;
        }
        String propertyName = document.getCharsSequence().subSequence(startOffset, endOffset).toString().trim();
        return propertyName.isEmpty() ? null : propertyName;
    }

    private void setPropertiesFileSelectionFromStructureView(@NotNull Editor propertiesFileEditor) {
        String selectedPropertyName;
        if (propertiesFileEditor == null) {
            ResourceBundleEditor.$$$reportNull$$$0(6);
        }
        if ((selectedPropertyName = this.getSelectedPropertyName()) == null) {
            return;
        }
        Document document = propertiesFileEditor.getDocument();
        for (int i = 0; i < document.getLineCount(); ++i) {
            String propertyName = ResourceBundleEditor.getPropertyName(document, i);
            if (!selectedPropertyName.equals(propertyName)) continue;
            propertiesFileEditor.getCaretModel().moveToLogicalPosition(new LogicalPosition(i, 0));
            return;
        }
    }

    private void writeEditorPropertyValue(@Nullable String propertyName, @NotNull Editor editor, @NotNull VirtualFile propertiesFile) {
        String currentSelectedProperty;
        if (editor == null) {
            ResourceBundleEditor.$$$reportNull$$$0(7);
        }
        if (propertiesFile == null) {
            ResourceBundleEditor.$$$reportNull$$$0(8);
        }
        String currentValue = editor.getDocument().getText();
        String string = currentSelectedProperty = propertyName == null ? this.getSelectedPropertyName() : propertyName;
        if (currentSelectedProperty == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (propertiesFile == null) {
                ResourceBundleEditor.$$$reportNull$$$0(22);
            }
            WriteCommandAction.runWriteCommandAction((Project)this.myProject, () -> {
                if (propertiesFile == null) {
                    ResourceBundleEditor.$$$reportNull$$$0(23);
                }
                try {
                    if (currentValue.isEmpty() && ResourceBundleEditorKeepEmptyValueToggleAction.keepEmptyProperties() && !propertiesFile.equals(this.myResourceBundle.getDefaultPropertiesFile().getVirtualFile())) {
                        this.myPropertiesInsertDeleteManager.deletePropertyIfExist(currentSelectedProperty, PropertiesImplUtil.getPropertiesFile(propertiesFile, this.myProject));
                    } else {
                        this.myPropertiesInsertDeleteManager.insertOrUpdateTranslation(currentSelectedProperty, currentValue, PropertiesImplUtil.getPropertiesFile(propertiesFile, this.myProject));
                    }
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            });
        });
    }

    void recreateEditorsPanel() {
        if (!this.myProject.isOpen() || this.myDisposed) {
            return;
        }
        this.myValuesPanel.removeAll();
        this.myValuesPanel.setLayout(new CardLayout());
        MyJPanel valuesPanelComponent = new MyJPanel(new GridBagLayout());
        this.myValuesPanel.add((Component)new JBScrollPane(valuesPanelComponent){

            public void updateUI() {
                super.updateUI();
                this.getViewport().setBackground(UIUtil.getPanelBackground());
            }
        }, VALUES);
        this.myValuesPanel.add((Component)this.myNoPropertySelectedPanel, NO_PROPERTY_SELECTED);
        List<PropertiesFile> propertiesFiles = this.myResourceBundle.getPropertiesFiles();
        GridBagConstraints gc = new GridBagConstraints(0, 0, 0, 0, 0.0, 0.0, 18, 1, (Insets)JBUI.insets((int)5), 0, 0);
        this.releaseAllEditors();
        this.myTitledPanels.clear();
        int y = 0;
        EditorEx previousEditor = null;
        EditorEx firstEditor = null;
        for (final PropertiesFile propertiesFile : propertiesFiles) {
            final EditorEx editor = this.createEditor();
            Editor oldEditor = (Editor)this.myEditors.put(propertiesFile.getVirtualFile(), editor);
            if (firstEditor == null) {
                firstEditor = editor;
            }
            if (previousEditor != null) {
                editor.putUserData(ChooseSubsequentPropertyValueEditorAction.PREV_EDITOR_KEY, (Object)previousEditor);
                previousEditor.putUserData(ChooseSubsequentPropertyValueEditorAction.NEXT_EDITOR_KEY, (Object)editor);
            }
            previousEditor = editor;
            if (oldEditor != null) {
                EditorFactory.getInstance().releaseEditor(oldEditor);
            }
            editor.setViewer(!propertiesFile.getVirtualFile().isWritable());
            editor.getContentComponent().addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    if (editor.isViewer()) {
                        editor.setViewer(ReadonlyStatusHandler.getInstance((Project)ResourceBundleEditor.this.myProject).ensureFilesWritable(new VirtualFile[]{propertiesFile.getVirtualFile()}).hasReadonlyFiles());
                    }
                }
            });
            editor.addFocusListener(new FocusChangeListener(){

                public void focusGained(@NotNull Editor editor) {
                    if (editor == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    ResourceBundleEditor.this.mySelectedEditor = editor;
                }

                public void focusLost(@NotNull Editor editor) {
                    if (editor == null) {
                        5.$$$reportNull$$$0(1);
                    }
                    if (!editor.isViewer() && propertiesFile.getContainingFile().isValid()) {
                        ResourceBundleEditor.this.writeEditorPropertyValue(null, editor, propertiesFile.getVirtualFile());
                        ResourceBundleEditor.this.myVfsListener.flush();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "editor";
                    objectArray2[1] = "com/intellij/lang/properties/editor/ResourceBundleEditor$5";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "focusGained";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "focusLost";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            gc.gridx = 0;
            gc.gridy = y++;
            gc.gridheight = 1;
            gc.gridwidth = 0;
            gc.weightx = 1.0;
            gc.weighty = 1.0;
            gc.anchor = 10;
            String title = propertiesFile.getName();
            title = title + PropertiesUtil.getPresentableLocale(propertiesFile.getLocale());
            JPanel comp = new JPanel(new BorderLayout()){

                @Override
                public Dimension getPreferredSize() {
                    Insets insets = this.getBorder().getBorderInsets(this);
                    return new Dimension(100, editor.getLineHeight() * 4 + insets.top + insets.bottom);
                }
            };
            comp.add((Component)editor.getComponent(), "Center");
            comp.setBorder((Border)IdeBorderFactory.createTitledBorder((String)title, (boolean)false));
            this.myTitledPanels.put(propertiesFile.getVirtualFile(), comp);
            valuesPanelComponent.add((Component)comp, gc);
        }
        if (previousEditor != null) {
            previousEditor.putUserData(ChooseSubsequentPropertyValueEditorAction.NEXT_EDITOR_KEY, firstEditor);
            firstEditor.putUserData(ChooseSubsequentPropertyValueEditorAction.PREV_EDITOR_KEY, previousEditor);
        }
        gc.gridx = 0;
        gc.gridy = y;
        gc.gridheight = 0;
        gc.gridwidth = 0;
        gc.weightx = 10.0;
        gc.weighty = 1.0;
        valuesPanelComponent.add((Component)new JPanel(), gc);
        this.selectionChanged();
        this.myValuesPanel.repaint();
        this.updateEditorsFromProperties(true);
    }

    @NotNull
    public static String getPropertyEditorValue(@Nullable IProperty property) {
        if (property == null) {
            if ("" == null) {
                ResourceBundleEditor.$$$reportNull$$$0(9);
            }
            return "";
        }
        String rawValue = property.getValue();
        String string = rawValue == null ? "" : PropertiesResourceBundleUtil.fromPropertyValueToValueEditor(rawValue);
        if (string == null) {
            ResourceBundleEditor.$$$reportNull$$$0(10);
        }
        return string;
    }

    void updateEditorsFromProperties(boolean checkIsUnderUndoRedoAction) {
        String propertyName = this.getSelectedPropertyName();
        ((CardLayout)this.myValuesPanel.getLayout()).show(this.myValuesPanel, propertyName == null ? NO_PROPERTY_SELECTED : VALUES);
        if (propertyName == null) {
            return;
        }
        UndoManagerImpl undoManager = (UndoManagerImpl)UndoManager.getInstance((Project)this.myProject);
        for (PropertiesFile propertiesFile : this.myResourceBundle.getPropertiesFiles()) {
            EditorEx editor = this.myEditors.get(propertiesFile.getVirtualFile());
            if (editor == null) continue;
            IProperty property = propertiesFile.findPropertyByKey(propertyName);
            DocumentEx document = editor.getDocument();
            CommandProcessor.getInstance().executeCommand(null, () -> this.lambda$updateEditorsFromProperties$4(checkIsUnderUndoRedoAction, undoManager, property, (Document)document, propertiesFile), "", (Object)this);
            JPanel titledPanel = this.myTitledPanels.get(propertiesFile.getVirtualFile());
            ((TitledBorder)titledPanel.getBorder()).setTitleColor((Color)(property == null ? JBColor.RED : UIUtil.getLabelTextForeground()));
            titledPanel.repaint();
        }
    }

    private void installPropertiesChangeListeners() {
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        if (this.myVfsListener != null) {
            throw new AssertionError((Object)"Listeners can't be initialized twice");
        }
        this.myVfsListener = new ResourceBundleEditorFileListener(this);
        virtualFileManager.addVirtualFileListener((VirtualFileListener)this.myVfsListener, (Disposable)this);
        PsiTreeChangeAdapter psiTreeChangeAdapter = new PsiTreeChangeAdapter(){

            public void childAdded(@NotNull PsiTreeChangeEvent event) {
                ResourceBundle bundle;
                PropertiesFile propertiesFile;
                PsiFile file;
                if (event == null) {
                    7.$$$reportNull$$$0(0);
                }
                if ((file = event.getFile()) instanceof XmlFile && (propertiesFile = PropertiesImplUtil.getPropertiesFile(file)) != null && (bundle = propertiesFile.getResourceBundle()).equals(ResourceBundleEditor.this.myResourceBundle) && !ResourceBundleEditor.this.myEditors.containsKey(propertiesFile.getVirtualFile())) {
                    ResourceBundleEditor.this.recreateEditorsPanel();
                }
            }

            public void childRemoved(@NotNull PsiTreeChangeEvent event) {
                IProperty property;
                ResourceBundle bundle;
                PsiFile file;
                PropertiesFile propertiesFile;
                if (event == null) {
                    7.$$$reportNull$$$0(1);
                }
                if ((propertiesFile = PropertiesImplUtil.getPropertiesFile(file = event.getFile())) != null && (bundle = propertiesFile.getResourceBundle()).equals(ResourceBundleEditor.this.myResourceBundle) && ResourceBundleEditor.this.myEditors.containsKey(propertiesFile.getVirtualFile()) && (property = PropertiesImplUtil.getProperty(event.getParent())) != null && Comparing.equal((String)property.getName(), (String)ResourceBundleEditor.this.getSelectedPropertyName())) {
                    ResourceBundleEditor.this.updateEditorsFromProperties(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/lang/properties/editor/ResourceBundleEditor$7";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        PsiManager.getInstance((Project)this.myProject).addPsiTreeChangeListener((PsiTreeChangeListener)psiTreeChangeAdapter, (Disposable)this);
    }

    private void selectionChanged() {
        this.myBackSlashPressed.clear();
        UIUtil.invokeLaterIfNeeded(() -> {
            this.updateEditorsFromProperties(true);
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(this.myProject);
            if (statusBar != null) {
                statusBar.setInfo("Selected property: " + this.getSelectedPropertyName());
            }
        });
    }

    private void updateDocumentFromPropertyValue(String value, Document document, VirtualFile propertiesFile) {
        String text = value;
        if (this.myBackSlashPressed.contains(propertiesFile)) {
            text = text + "\\";
        }
        document.putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)Boolean.TRUE);
        document.replaceString(0, document.getTextLength(), (CharSequence)text);
        document.putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)Boolean.FALSE);
    }

    @NotNull
    private JBIterable<Object> getSelectedNodes() {
        if (!this.isValid()) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                ResourceBundleEditor.$$$reportNull$$$0(11);
            }
            return jBIterable;
        }
        JTree tree = this.myStructureViewComponent.getTree();
        JBIterable jBIterable = JBIterable.of((Object[])tree.getSelectionModel().getSelectionPaths()).map(TreeUtil::getLastUserObject);
        if (jBIterable == null) {
            ResourceBundleEditor.$$$reportNull$$$0(12);
        }
        return jBIterable;
    }

    @Nullable
    private String getSelectedPropertyName() {
        IProperty selectedProperty = this.getSelectedProperty();
        return selectedProperty == null ? null : selectedProperty.getName();
    }

    @Nullable
    IProperty getSelectedProperty() {
        ResourceBundleEditorViewElement first = (ResourceBundleEditorViewElement)this.getSelectedNodes().filter(AbstractTreeNode.class).filterMap(AbstractTreeNode::getValue).filter(ResourceBundleEditorViewElement.class).first();
        return first instanceof ResourceBundlePropertyStructureViewElement ? ((ResourceBundlePropertyStructureViewElement)first).getProperty() : null;
    }

    @NotNull
    public Collection<ResourceBundleEditorViewElement> getSelectedElements() {
        List list = this.getSelectedNodes().filter(AbstractTreeNode.class).filterMap(AbstractTreeNode::getValue).filter(ResourceBundleEditorViewElement.class).toList();
        if (list == null) {
            ResourceBundleEditor.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Nullable
    public ResourceBundleEditorViewElement getSelectedElementIfOnlyOne() {
        Collection<ResourceBundleEditorViewElement> selectedElements = this.getSelectedElements();
        return selectedElements.size() == 1 ? (ResourceBundleEditorViewElement)ContainerUtil.getFirstItem(selectedElements) : null;
    }

    public void selectNextIncompleteProperty() {
        String currentKey;
        int idx;
        if (this.getSelectedNodes().size() != 1) {
            return;
        }
        IProperty selectedProperty = this.getSelectedProperty();
        if (selectedProperty == null) {
            return;
        }
        ResourceBundleFileStructureViewElement root = (ResourceBundleFileStructureViewElement)this.myStructureViewComponent.getTreeModel().getRoot();
        Set propertyKeys = ResourceBundleFileStructureViewElement.getPropertiesMap(this.myResourceBundle, root.isShowOnlyIncomplete()).keySet();
        boolean isAlphaSorted = this.myStructureViewComponent.isActionActive("ALPHA_COMPARATOR");
        ArrayList keysOrder = new ArrayList(propertyKeys);
        if (isAlphaSorted) {
            Collections.sort(keysOrder);
        }
        LOG.assertTrue((idx = keysOrder.indexOf(currentKey = selectedProperty.getKey())) != -1);
        IncompletePropertyInspection incompletePropertyInspection = IncompletePropertyInspection.getInstance((PsiElement)this.myResourceBundle.getDefaultPropertiesFile().getContainingFile());
        for (int i = 1; i < keysOrder.size(); ++i) {
            int trimmedIndex = (i + idx) % keysOrder.size();
            String key = (String)keysOrder.get(trimmedIndex);
            if (incompletePropertyInspection.isPropertyComplete(key, this.myResourceBundle)) continue;
            this.selectProperty(key);
            return;
        }
    }

    @NotNull
    public JComponent getComponent() {
        DataProviderPanel dataProviderPanel = this.myDataProviderPanel;
        if (dataProviderPanel == null) {
            ResourceBundleEditor.$$$reportNull$$$0(14);
        }
        return dataProviderPanel;
    }

    public StructureViewComponent getStructureViewComponent() {
        return this.myStructureViewComponent;
    }

    private Object getData(@NotNull String dataId) {
        if (dataId == null) {
            ResourceBundleEditor.$$$reportNull$$$0(15);
        }
        if (SelectInContext.DATA_KEY.is(dataId)) {
            VirtualFile file = this.getSelectedPropertiesFile();
            return file == null ? null : new FileSelectInContext(this.myProject, file);
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            for (Map.Entry<VirtualFile, EditorEx> entry : this.myEditors.entrySet()) {
                if (entry.getValue() != this.mySelectedEditor) continue;
                VirtualFile f = entry.getKey();
                String name = this.getSelectedPropertyName();
                if (name == null) continue;
                PropertiesFile file = PropertiesImplUtil.getPropertiesFile(f, this.myProject);
                LOG.assertTrue(file != null);
                List<IProperty> properties = file.findPropertiesByKey(name);
                if (properties.isEmpty()) {
                    return new Navigatable[]{file.getContainingFile()};
                }
                return properties.stream().map(IProperty::getPsiElement).map(PsiElement::getNavigationElement).filter(p -> p != null).toArray(Navigatable[]::new);
            }
        }
        return null;
    }

    private VirtualFile getSelectedPropertiesFile() {
        if (this.mySelectedEditor == null) {
            return null;
        }
        VirtualFile selectedFile = null;
        for (Map.Entry<VirtualFile, EditorEx> entry : this.myEditors.entrySet()) {
            Editor editor = (Editor)entry.getValue();
            if (editor != this.mySelectedEditor) continue;
            selectedFile = entry.getKey();
            break;
        }
        return selectedFile;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myStructureViewPanel;
    }

    @NotNull
    public String getName() {
        if ("Resource Bundle" == null) {
            ResourceBundleEditor.$$$reportNull$$$0(16);
        }
        return "Resource Bundle";
    }

    @NotNull
    public ResourceBundleEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            ResourceBundleEditor.$$$reportNull$$$0(17);
        }
        ResourceBundleEditorState resourceBundleEditorState = new ResourceBundleEditorState(this.getSelectedPropertyName());
        if (resourceBundleEditorState == null) {
            ResourceBundleEditor.$$$reportNull$$$0(18);
        }
        return resourceBundleEditorState;
    }

    public void selectProperty(@Nullable String propertyName) {
        if (propertyName != null) {
            this.setStructureViewSelection(propertyName);
        }
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            ResourceBundleEditor.$$$reportNull$$$0(19);
        }
        this.selectProperty(((ResourceBundleEditorState)state).getPropertyName());
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return !this.myDisposed && !this.myProject.isDisposed();
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(this.myProject);
        if (statusBar != null) {
            statusBar.setInfo("");
        }
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            ResourceBundleEditor.$$$reportNull$$$0(20);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            ResourceBundleEditor.$$$reportNull$$$0(21);
        }
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return this.myHighlighter;
    }

    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
        if (this.mySelectedEditor != null) {
            for (Map.Entry<VirtualFile, EditorEx> entry : this.myEditors.entrySet()) {
                if (!this.mySelectedEditor.equals(entry.getValue())) continue;
                this.writeEditorPropertyValue(null, this.mySelectedEditor, entry.getKey());
            }
        }
        VirtualFileManager.getInstance().removeVirtualFileListener((VirtualFileListener)this.myVfsListener);
        this.myDisposed = true;
        Disposer.dispose((Disposable)this.myStructureViewComponent);
        this.releaseAllEditors();
    }

    private void releaseAllEditors() {
        for (Editor editor : this.myEditors.values()) {
            if (editor.isDisposed()) continue;
            EditorFactory.getInstance().releaseEditor(editor);
        }
        this.myEditors.clear();
    }

    public Document[] getDocuments() {
        return (Document[])ContainerUtil.map2Array(this.myEditors.keySet(), (Object[])new Document[this.myEditors.size()], propertiesFile -> FileDocumentManager.getInstance().getDocument(propertiesFile));
    }

    Map<VirtualFile, EditorEx> getTranslationEditors() {
        return this.myEditors;
    }

    private EditorEx createEditor() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document document = editorFactory.createDocument((CharSequence)"");
        EditorEx editor = (EditorEx)editorFactory.createEditor(document);
        this.reinitSettings(editor);
        editor.putUserData(RESOURCE_BUNDLE_EDITOR_KEY, (Object)this);
        return editor;
    }

    private void reinitSettings(final EditorEx editor) {
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        editor.setColorsScheme(scheme);
        editor.setBorder(BorderFactory.createLineBorder(JBColor.border(), 1));
        EditorSettings settings = editor.getSettings();
        settings.setLineNumbersShown(false);
        settings.setWhitespacesShown(false);
        settings.setLineMarkerAreaShown(false);
        settings.setIndentGuidesShown(false);
        settings.setFoldingOutlineShown(false);
        settings.setAdditionalColumnsCount(0);
        settings.setAdditionalLinesCount(0);
        settings.setRightMarginShown(true);
        settings.setRightMargin(60);
        settings.setVirtualSpace(false);
        editor.setHighlighter((EditorHighlighter)new LexerEditorHighlighter((SyntaxHighlighter)new PropertiesValueHighlighter(), scheme));
        editor.setVerticalScrollbarVisible(true);
        editor.setContextMenuGroupId(null);
        editor.addEditorMouseListener((EditorMouseListener)new EditorPopupHandler(){

            public void invokePopup(EditorMouseEvent event) {
                if (!event.isConsumed() && event.getArea() == EditorMouseEventArea.EDITING_AREA) {
                    DefaultActionGroup group = new DefaultActionGroup();
                    group.add(CustomActionsSchema.getInstance().getCorrectedAction("CutCopyPasteGroup"));
                    group.add(CustomActionsSchema.getInstance().getCorrectedAction("EditSource"));
                    group.addSeparator();
                    group.add(new AnAction("Propagate Value Across of Resource Bundle"){

                        public void actionPerformed(@NotNull AnActionEvent e) {
                            if (e == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            String valueToPropagate = editor.getDocument().getText();
                            String currentSelectedProperty = ResourceBundleEditor.this.getSelectedPropertyName();
                            if (currentSelectedProperty == null) {
                                return;
                            }
                            ApplicationManager.getApplication().runWriteAction(() -> WriteCommandAction.runWriteCommandAction((Project)ResourceBundleEditor.this.myProject, () -> {
                                try {
                                    PropertiesFile[] propertiesFiles = (PropertiesFile[])ResourceBundleEditor.this.myResourceBundle.getPropertiesFiles().stream().filter(f -> {
                                        IProperty property = f.findPropertyByKey(currentSelectedProperty);
                                        return property == null || !valueToPropagate.equals(property.getValue());
                                    }).toArray(PropertiesFile[]::new);
                                    PsiFile[] filesToPrepare = (PsiFile[])Arrays.stream(propertiesFiles).map(PropertiesFile::getContainingFile).toArray(PsiFile[]::new);
                                    if (FileModificationService.getInstance().preparePsiElementsForWrite((PsiElement[])filesToPrepare)) {
                                        for (PropertiesFile file : propertiesFiles) {
                                            ResourceBundleEditor.this.myPropertiesInsertDeleteManager.insertOrUpdateTranslation(currentSelectedProperty, valueToPropagate, file);
                                        }
                                        ResourceBundleEditor.this.recreateEditorsPanel();
                                    }
                                }
                                catch (IncorrectOperationException e1) {
                                    LOG.error((Throwable)e1);
                                }
                            }));
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/properties/editor/ResourceBundleEditor$8$1", "actionPerformed"));
                        }
                    });
                    EditorPopupHandler handler = EditorActionUtil.createEditorPopupHandler((ActionGroup)group);
                    handler.invokePopup(event);
                    event.consume();
                }
            }
        });
    }

    private /* synthetic */ void lambda$updateEditorsFromProperties$4(boolean checkIsUnderUndoRedoAction, UndoManagerImpl undoManager, IProperty property, Document document, PropertiesFile propertiesFile) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (!checkIsUnderUndoRedoAction || !undoManager.isActive() || !undoManager.isRedoInProgress() && !undoManager.isUndoInProgress()) {
                this.updateDocumentFromPropertyValue(ResourceBundleEditor.getPropertyEditorValue(property), document, propertiesFile.getVirtualFile());
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceBundle";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/editor/ResourceBundleEditor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesFileEditor";
                break;
            }
            case 4: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesFile";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/editor/ResourceBundleEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertiesInsertDeleteManager";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyEditorValue";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedNodes";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedElements";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onSelectionChanged";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setStructureViewSelectionFromPropertiesFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setStructureViewSelection";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setPropertiesFileSelectionFromStructureView";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "writeEditorPropertyValue";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$writeEditorPropertyValue$2";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setStructureViewSelection$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyJPanel
    extends JPanel
    implements Scrollable {
        private MyJPanel(LayoutManager layout) {
            super(layout);
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            Editor editor = (Editor)ResourceBundleEditor.this.myEditors.values().iterator().next();
            return editor.getLineHeight() * 4;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return visibleRect.height;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }

    private class DataProviderPanel
    extends JPanel
    implements DataProvider {
        private DataProviderPanel(JPanel panel) {
            super(new BorderLayout());
            this.add((Component)panel, "Center");
        }

        @Nullable
        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                DataProviderPanel.$$$reportNull$$$0(0);
            }
            return ResourceBundleEditor.this.getData(dataId);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/lang/properties/editor/ResourceBundleEditor$DataProviderPanel", "getData"));
        }
    }

    public static class ResourceBundleEditorState
    implements FileEditorState {
        private final String myPropertyName;

        public ResourceBundleEditorState(String propertyName) {
            this.myPropertyName = propertyName;
        }

        public boolean canBeMergedWith(FileEditorState otherState, FileEditorStateLevel level) {
            return false;
        }

        public String getPropertyName() {
            return this.myPropertyName;
        }
    }
}

