/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.RunDashboardAnimator;
import com.intellij.execution.dashboard.RunDashboardContributor;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.RunDashboardNode;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.sm.runner.ui.SMTestRunnerResultsForm;
import com.intellij.execution.testframework.sm.runner.ui.TestTreeRenderer;
import com.intellij.execution.testframework.sm.runner.ui.TestsPresentationUtil;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.progress.util.ColorProgressBar;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PsiNavigateUtil;
import org.jetbrains.annotations.NotNull;

public class JUnitRunDashboardContributor
extends RunDashboardContributor {
    private static final SimpleTextAttributes IGNORE_ATTRIBUTES = new SimpleTextAttributes(0, ColorProgressBar.YELLOW);
    private static final SimpleTextAttributes ERROR_ATTRIBUTES = new SimpleTextAttributes(0, ColorProgressBar.RED_TEXT);

    public JUnitRunDashboardContributor() {
        super((ConfigurationType)JUnitConfigurationType.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePresentation(@NotNull PresentationData presentation, @NotNull RunDashboardNode node) {
        if (presentation == null) {
            JUnitRunDashboardContributor.$$$reportNull$$$0(0);
        }
        if (node == null) {
            JUnitRunDashboardContributor.$$$reportNull$$$0(1);
        }
        if (!(node instanceof RunDashboardRunConfigurationNode)) {
            return;
        }
        boolean animated = false;
        try {
            RunContentDescriptor descriptor = node.getDescriptor();
            if (descriptor == null) {
                return;
            }
            ExecutionConsole executionConsole = descriptor.getExecutionConsole();
            if (!(executionConsole instanceof SMTRunnerConsoleView)) {
                return;
            }
            SMTestRunnerResultsForm resultsViewer = ((SMTRunnerConsoleView)executionConsole).getResultsViewer();
            animated = resultsViewer.isRunning();
            SMTestProxy.SMRootTestProxy rootNode = resultsViewer.getTestsRootNode();
            TestTreeRenderer renderer = new TestTreeRenderer(resultsViewer.getProperties());
            if (rootNode.isLeaf()) {
                TestsPresentationUtil.formatRootNodeWithoutChildren((SMTestProxy.SMRootTestProxy)rootNode, (TestTreeRenderer)renderer);
            } else {
                TestsPresentationUtil.formatRootNodeWithChildren((SMTestProxy.SMRootTestProxy)rootNode, (TestTreeRenderer)renderer);
            }
            if (renderer.getIcon() != null) {
                presentation.setIcon(renderer.getIcon());
            }
            JUnitRunDashboardContributor.addTestSummary(presentation, rootNode);
        }
        finally {
            RunDashboardAnimator animator = RunDashboardManager.getInstance((Project)node.getProject()).getAnimator();
            if (animator != null) {
                if (animated) {
                    animator.addNode(node);
                } else {
                    animator.removeNode(node);
                }
            }
        }
    }

    private static void addTestSummary(@NotNull PresentationData presentation, @NotNull SMTestProxy.SMRootTestProxy rootNode) {
        if (presentation == null) {
            JUnitRunDashboardContributor.$$$reportNull$$$0(2);
        }
        if (rootNode == null) {
            JUnitRunDashboardContributor.$$$reportNull$$$0(3);
        }
        if (rootNode.isLeaf()) {
            return;
        }
        TestsUIUtil.TestResultPresentation testResultPresentation = new TestsUIUtil.TestResultPresentation((AbstractTestProxy)rootNode).getPresentation();
        int failed = testResultPresentation.getFailedCount();
        int ignored = testResultPresentation.getIgnoredCount();
        int passed = testResultPresentation.getPassedCount();
        int total = passed + failed + testResultPresentation.getNotStartedCount();
        if (total == 0) {
            return;
        }
        presentation.addText(" [", SimpleTextAttributes.GRAY_ATTRIBUTES);
        boolean addSeparator = false;
        if (failed > 0) {
            presentation.addText("failed: " + failed, ERROR_ATTRIBUTES);
            addSeparator = true;
        }
        if (passed > 0 || ignored + failed == 0) {
            if (addSeparator) {
                presentation.addText(", ", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
            presentation.addText("passed: " + passed, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            addSeparator = true;
        }
        if (ignored > 0) {
            if (addSeparator) {
                presentation.addText(", ", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
            presentation.addText("ignored: " + ignored, IGNORE_ATTRIBUTES);
        }
        presentation.addText(" of " + total + "]", SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    public boolean handleDoubleClick(@NotNull RunConfiguration runConfiguration) {
        PsiMethod[] methods;
        if (runConfiguration == null) {
            JUnitRunDashboardContributor.$$$reportNull$$$0(4);
        }
        if (!(runConfiguration instanceof JUnitConfiguration)) {
            return false;
        }
        JUnitConfiguration jUnitConfiguration = (JUnitConfiguration)runConfiguration;
        String runClassName = jUnitConfiguration.getRunClass();
        if (runClassName == null) {
            return false;
        }
        PsiClass runClass = ((JavaRunConfigurationModule)jUnitConfiguration.getConfigurationModule()).findClass(runClassName);
        if (runClass == null) {
            return false;
        }
        PsiClass psiElement = runClass;
        String testMethod = jUnitConfiguration.getPersistentData().getMethodName();
        if (testMethod != null && (methods = runClass.findMethodsByName(testMethod, false)).length > 0) {
            psiElement = methods[0];
        }
        PsiNavigateUtil.navigate((PsiElement)psiElement);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/junit/JUnitRunDashboardContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updatePresentation";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addTestSummary";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "handleDoubleClick";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

