/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.branch.GitBranchOperation;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitBrancher;
import git4idea.branch.GitSmartOperationDialog;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitCompoundResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitLocalChangesWouldBeOverwrittenDetector;
import git4idea.commands.GitMessageWithFilesDetector;
import git4idea.commands.GitSimpleEventDetector;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.config.GitVcsSettings;
import git4idea.merge.GitConflictResolver;
import git4idea.merge.GitMergeCommittingConflictResolver;
import git4idea.merge.GitMerger;
import git4idea.repo.GitRepository;
import git4idea.reset.GitResetMode;
import git4idea.util.GitPreservingProcess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

class GitMergeOperation
extends GitBranchOperation {
    private static final Logger LOG = Logger.getInstance(GitMergeOperation.class);
    public static final String ROLLBACK_PROPOSAL = "You may rollback (reset to the commit before merging) not to let branches diverge.";
    @NotNull
    private final ChangeListManager myChangeListManager;
    @NotNull
    private final String myBranchToMerge;
    private final GitBrancher.DeleteOnMergeOption myDeleteOnMerge;
    @NotNull
    private final Map<GitRepository, Boolean> myConflictedRepositories;
    private GitPreservingProcess myPreservingProcess;

    GitMergeOperation(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler uiHandler, @NotNull Collection<GitRepository> repositories, @NotNull String branchToMerge, GitBrancher.DeleteOnMergeOption deleteOnMerge) {
        if (project == null) {
            GitMergeOperation.$$$reportNull$$$0(0);
        }
        if (git == null) {
            GitMergeOperation.$$$reportNull$$$0(1);
        }
        if (uiHandler == null) {
            GitMergeOperation.$$$reportNull$$$0(2);
        }
        if (repositories == null) {
            GitMergeOperation.$$$reportNull$$$0(3);
        }
        if (branchToMerge == null) {
            GitMergeOperation.$$$reportNull$$$0(4);
        }
        super(project, git, uiHandler, repositories);
        this.myConflictedRepositories = new HashMap<GitRepository, Boolean>();
        this.myBranchToMerge = branchToMerge;
        this.myDeleteOnMerge = deleteOnMerge;
        this.myChangeListManager = ChangeListManager.getInstance((Project)this.myProject);
    }

    @Override
    protected void execute() {
        LOG.info("starting");
        GitMergeOperation.saveAllDocuments();
        boolean fatalErrorHappened = false;
        int alreadyUpToDateRepositories = 0;
        try (AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)this.myProject, (String)this.getOperationName());){
            while (this.hasMoreRepositories() && !fatalErrorHappened) {
                GitRepository repository = this.next();
                LOG.info("next repository: " + repository);
                VirtualFile root = repository.getRoot();
                Collection<Change> changes = GitChangeUtils.getDiff(repository, "HEAD", this.myBranchToMerge, false);
                GitLocalChangesWouldBeOverwrittenDetector localChangesDetector = new GitLocalChangesWouldBeOverwrittenDetector(root, GitLocalChangesWouldBeOverwrittenDetector.Operation.MERGE);
                GitSimpleEventDetector unmergedFiles = new GitSimpleEventDetector(GitSimpleEventDetector.Event.UNMERGED_PREVENTING_MERGE);
                GitUntrackedFilesOverwrittenByOperationDetector untrackedOverwrittenByMerge = new GitUntrackedFilesOverwrittenByOperationDetector(root);
                GitSimpleEventDetector mergeConflict = new GitSimpleEventDetector(GitSimpleEventDetector.Event.MERGE_CONFLICT);
                GitSimpleEventDetector alreadyUpToDateDetector = new GitSimpleEventDetector(GitSimpleEventDetector.Event.ALREADY_UP_TO_DATE);
                GitCommandResult result2 = this.myGit.merge(repository, this.myBranchToMerge, Collections.emptyList(), localChangesDetector, unmergedFiles, untrackedOverwrittenByMerge, mergeConflict, alreadyUpToDateDetector);
                if (result2.success()) {
                    LOG.info("Merged successfully");
                    GitUtil.updateAndRefreshVfs(repository, changes);
                    this.markSuccessful(repository);
                    if (!alreadyUpToDateDetector.hasHappened()) continue;
                    ++alreadyUpToDateRepositories;
                    continue;
                }
                if (unmergedFiles.hasHappened()) {
                    LOG.info("Unmerged files error!");
                    this.fatalUnmergedFilesError();
                    fatalErrorHappened = true;
                    continue;
                }
                if (localChangesDetector.wasMessageDetected()) {
                    LOG.info("Local changes would be overwritten by merge!");
                    boolean smartMergeSucceeded = this.proposeSmartMergePerformAndNotify(repository, localChangesDetector);
                    if (smartMergeSucceeded) continue;
                    fatalErrorHappened = true;
                    continue;
                }
                if (mergeConflict.hasHappened()) {
                    LOG.info("Merge conflict");
                    this.myConflictedRepositories.put(repository, Boolean.FALSE);
                    GitUtil.updateAndRefreshVfs(repository);
                    this.markSuccessful(repository);
                    continue;
                }
                if (untrackedOverwrittenByMerge.wasMessageDetected()) {
                    LOG.info("Untracked files would be overwritten by merge!");
                    this.fatalUntrackedFilesError(repository.getRoot(), untrackedOverwrittenByMerge.getRelativeFilePaths());
                    fatalErrorHappened = true;
                    continue;
                }
                LOG.info("Unknown error. " + result2);
                this.fatalError(this.getCommonErrorTitle(), result2.getErrorOutputAsJoinedString());
                fatalErrorHappened = true;
            }
            if (fatalErrorHappened) {
                this.notifyAboutRemainingConflicts();
            } else {
                boolean allConflictsResolved = this.resolveConflicts();
                if (allConflictsResolved) {
                    if (alreadyUpToDateRepositories < this.getRepositories().size()) {
                        this.notifySuccess();
                    } else {
                        this.notifySuccess("Already up-to-date");
                    }
                }
            }
            this.restoreLocalChanges();
        }
    }

    private void notifyAboutRemainingConflicts() {
        if (!this.myConflictedRepositories.isEmpty()) {
            new MyMergeConflictResolver().notifyUnresolvedRemain();
        }
    }

    @Override
    protected void notifySuccess(@NotNull String message) {
        if (message == null) {
            GitMergeOperation.$$$reportNull$$$0(5);
        }
        switch (this.myDeleteOnMerge) {
            case DELETE: {
                super.notifySuccess(message);
                ApplicationManager.getApplication().invokeLater(() -> {
                    GitBrancher brancher = GitBrancher.getInstance(this.myProject);
                    brancher.deleteBranch(this.myBranchToMerge, new ArrayList<GitRepository>(this.getRepositories()));
                });
                break;
            }
            case PROPOSE: {
                String description = message + "<br/><a href='delete'>Delete " + this.myBranchToMerge + "</a>";
                VcsNotifier.getInstance((Project)this.myProject).notifySuccess("", description, (NotificationListener)new DeleteMergedLocalBranchNotificationListener());
                break;
            }
            case NOTHING: {
                super.notifySuccess(message);
            }
        }
    }

    private boolean resolveConflicts() {
        if (!this.myConflictedRepositories.isEmpty()) {
            return new MyMergeConflictResolver().merge();
        }
        return true;
    }

    private boolean proposeSmartMergePerformAndNotify(@NotNull GitRepository repository, @NotNull GitMessageWithFilesDetector localChangesOverwrittenByMerge) {
        Collection<String> absolutePaths;
        if (repository == null) {
            GitMergeOperation.$$$reportNull$$$0(6);
        }
        if (localChangesOverwrittenByMerge == null) {
            GitMergeOperation.$$$reportNull$$$0(7);
        }
        Pair<List<GitRepository>, List<Change>> conflictingRepositoriesAndAffectedChanges = this.getConflictingRepositoriesAndAffectedChanges(repository, localChangesOverwrittenByMerge, (String)this.myCurrentHeads.get(repository), this.myBranchToMerge);
        List allConflictingRepositories = (List)conflictingRepositoriesAndAffectedChanges.getFirst();
        List affectedChanges = (List)conflictingRepositoriesAndAffectedChanges.getSecond();
        GitSmartOperationDialog.Choice decision = this.myUiHandler.showSmartOperationDialog(this.myProject, affectedChanges, absolutePaths = GitUtil.toAbsolute(repository.getRoot(), localChangesOverwrittenByMerge.getRelativeFilePaths()), "merge", null);
        if (decision == GitSmartOperationDialog.Choice.SMART) {
            return this.doSmartMerge(allConflictingRepositories);
        }
        this.fatalLocalChangesError(this.myBranchToMerge);
        return false;
    }

    private void restoreLocalChanges() {
        if (this.myPreservingProcess != null) {
            this.myPreservingProcess.load();
        }
    }

    private boolean doSmartMerge(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            GitMergeOperation.$$$reportNull$$$0(8);
        }
        AtomicBoolean success = new AtomicBoolean();
        this.myPreservingProcess = new GitPreservingProcess(this.myProject, this.myGit, GitUtil.getRootsFromRepositories(repositories), "merge", this.myBranchToMerge, GitVcsSettings.UpdateChangesPolicy.STASH, this.getIndicator(), () -> {
            if (repositories == null) {
                GitMergeOperation.$$$reportNull$$$0(22);
            }
            success.set(this.doMerge(repositories));
        });
        this.myPreservingProcess.execute((Computable<Boolean>)((Computable)this.myConflictedRepositories::isEmpty));
        return success.get();
    }

    private boolean doMerge(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            GitMergeOperation.$$$reportNull$$$0(9);
        }
        for (GitRepository repository : repositories) {
            GitSimpleEventDetector mergeConflict = new GitSimpleEventDetector(GitSimpleEventDetector.Event.MERGE_CONFLICT);
            GitCommandResult result2 = this.myGit.merge(repository, this.myBranchToMerge, Collections.emptyList(), mergeConflict);
            if (!result2.success()) {
                if (mergeConflict.hasHappened()) {
                    this.myConflictedRepositories.put(repository, Boolean.TRUE);
                    GitUtil.updateAndRefreshVfs(repository);
                    this.markSuccessful(repository);
                    continue;
                }
                this.fatalError(this.getCommonErrorTitle(), result2.getErrorOutputAsJoinedString());
                return false;
            }
            GitUtil.updateAndRefreshVfs(repository);
            this.markSuccessful(repository);
        }
        return true;
    }

    @NotNull
    private String getCommonErrorTitle() {
        String string = "Could Not Merge " + this.myBranchToMerge;
        if (string == null) {
            GitMergeOperation.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    protected void rollback() {
        LOG.info("starting rollback...");
        ArrayList<GitRepository> repositoriesForSmartRollback = new ArrayList<GitRepository>();
        ArrayList<GitRepository> repositoriesForSimpleRollback = new ArrayList<GitRepository>();
        ArrayList<GitRepository> repositoriesForMergeRollback = new ArrayList<GitRepository>();
        for (GitRepository repository : this.getSuccessfulRepositories()) {
            if (this.myConflictedRepositories.containsKey(repository)) {
                repositoriesForMergeRollback.add(repository);
                continue;
            }
            if (this.thereAreLocalChangesIn(repository)) {
                repositoriesForSmartRollback.add(repository);
                continue;
            }
            repositoriesForSimpleRollback.add(repository);
        }
        LOG.info("for smart rollback: " + DvcsUtil.getShortNames(repositoriesForSmartRollback) + "; for simple rollback: " + DvcsUtil.getShortNames(repositoriesForSimpleRollback) + "; for merge rollback: " + DvcsUtil.getShortNames(repositoriesForMergeRollback));
        GitCompoundResult result2 = this.smartRollback(repositoriesForSmartRollback);
        for (GitRepository repository : repositoriesForSimpleRollback) {
            result2.append(repository, this.rollback(repository));
        }
        for (GitRepository repository : repositoriesForMergeRollback) {
            result2.append(repository, this.rollbackMerge(repository));
        }
        this.myConflictedRepositories.clear();
        if (!result2.totalSuccess()) {
            VcsNotifier.getInstance((Project)this.myProject).notifyError("Error during rollback", result2.getErrorOutputWithReposIndication());
        }
        LOG.info("rollback finished.");
    }

    @NotNull
    private GitCompoundResult smartRollback(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            GitMergeOperation.$$$reportNull$$$0(11);
        }
        LOG.info("Starting smart rollback...");
        GitCompoundResult result2 = new GitCompoundResult(this.myProject);
        Collection<VirtualFile> roots = GitUtil.getRootsFromRepositories(repositories);
        GitPreservingProcess preservingProcess = new GitPreservingProcess(this.myProject, this.myGit, roots, "merge", this.myBranchToMerge, GitVcsSettings.UpdateChangesPolicy.STASH, this.getIndicator(), () -> {
            if (repositories == null) {
                GitMergeOperation.$$$reportNull$$$0(21);
            }
            for (GitRepository repository : repositories) {
                result2.append(repository, this.rollback(repository));
            }
        });
        preservingProcess.execute();
        LOG.info("Smart rollback completed.");
        GitCompoundResult gitCompoundResult = result2;
        if (gitCompoundResult == null) {
            GitMergeOperation.$$$reportNull$$$0(12);
        }
        return gitCompoundResult;
    }

    @NotNull
    private GitCommandResult rollback(@NotNull GitRepository repository) {
        if (repository == null) {
            GitMergeOperation.$$$reportNull$$$0(13);
        }
        GitCommandResult gitCommandResult = this.myGit.reset(repository, GitResetMode.HARD, this.getInitialRevision(repository), new GitLineHandlerListener[0]);
        if (gitCommandResult == null) {
            GitMergeOperation.$$$reportNull$$$0(14);
        }
        return gitCommandResult;
    }

    @NotNull
    private GitCommandResult rollbackMerge(@NotNull GitRepository repository) {
        if (repository == null) {
            GitMergeOperation.$$$reportNull$$$0(15);
        }
        GitCommandResult result2 = this.myGit.resetMerge(repository, null);
        GitUtil.updateAndRefreshVfs(repository);
        GitCommandResult gitCommandResult = result2;
        if (gitCommandResult == null) {
            GitMergeOperation.$$$reportNull$$$0(16);
        }
        return gitCommandResult;
    }

    private boolean thereAreLocalChangesIn(@NotNull GitRepository repository) {
        if (repository == null) {
            GitMergeOperation.$$$reportNull$$$0(17);
        }
        return !this.myChangeListManager.getChangesIn(repository.getRoot()).isEmpty();
    }

    @Override
    @NotNull
    public String getSuccessMessage() {
        String string = String.format("Merged <b><code>%s</code></b> to <b><code>%s</code></b>", this.myBranchToMerge, GitMergeOperation.stringifyBranchesByRepos(this.myCurrentHeads));
        if (string == null) {
            GitMergeOperation.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getRollbackProposal() {
        String string = "However merge has succeeded for the following " + this.repositories() + ":<br/>" + this.successfulRepositoriesJoined() + "<br/>" + ROLLBACK_PROPOSAL;
        if (string == null) {
            GitMergeOperation.$$$reportNull$$$0(19);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getOperationName() {
        if ("merge" == null) {
            GitMergeOperation.$$$reportNull$$$0(20);
        }
        return "merge";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiHandler";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 11: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchToMerge";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 6: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localChangesOverwrittenByMerge";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/GitMergeOperation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/GitMergeOperation";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonErrorTitle";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "smartRollback";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "rollback";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "rollbackMerge";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuccessMessage";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getRollbackProposal";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperationName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "notifySuccess";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "proposeSmartMergePerformAndNotify";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doSmartMerge";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doMerge";
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "smartRollback";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "rollback";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "rollbackMerge";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "thereAreLocalChangesIn";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$smartRollback$2";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doSmartMerge$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class DeleteMergedLocalBranchNotificationListener
    extends NotificationListener.Adapter {
        private DeleteMergedLocalBranchNotificationListener() {
        }

        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (notification == null) {
                DeleteMergedLocalBranchNotificationListener.$$$reportNull$$$0(0);
            }
            if (event == null) {
                DeleteMergedLocalBranchNotificationListener.$$$reportNull$$$0(1);
            }
            if (event.getDescription().equalsIgnoreCase("delete")) {
                notification.expire();
                GitBrancher.getInstance(GitMergeOperation.this.myProject).deleteBranch(GitMergeOperation.this.myBranchToMerge, new ArrayList<GitRepository>(GitMergeOperation.this.getRepositories()));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "notification";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "event";
                    break;
                }
            }
            objectArray[1] = "git4idea/branch/GitMergeOperation$DeleteMergedLocalBranchNotificationListener";
            objectArray[2] = "hyperlinkActivated";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyMergeConflictResolver
    extends GitMergeCommittingConflictResolver {
        MyMergeConflictResolver() {
            super(GitMergeOperation.this.myProject, GitMergeOperation.this.myGit, new GitMerger(GitMergeOperation.this.myProject), GitUtil.getRootsFromRepositories(GitMergeOperation.this.myConflictedRepositories.keySet()), new GitConflictResolver.Params(GitMergeOperation.this.myProject), true);
        }

        @Override
        protected void notifyUnresolvedRemain() {
            this.notifyWarning(GitMergeOperation.this.myBranchToMerge + " Merged with Conflicts", "");
        }
    }
}

