/**
 * @file xmss.h
 * Includes headers required for Extended Hash-Based Signatures (XMSS)
 * as described in [1]. @see Botan::XMSS_PublicKey and @see
 * Botan::XMSS_PrivateKey for further
 * details.
 *
 * <pre>
 * [1] XMSS: Extended Hash-Based Signatures,
 *     draft-itrf-cfrg-xmss-hash-based-signatures-06
 *     Release: July 2016.
 *     https://datatracker.ietf.org/doc/draft-irtf-cfrg-xmss-hash-based-signatures/?include_text=1
 * </pre>
 *
 * (C) 2016,2017 Matthias Gierlings
 *
 * Botan is released under the Simplified BSD License (see license.txt)
 **/

#ifndef BOTAN_XMSS_H_
#define BOTAN_XMSS_H_

#include <botan/xmss_publickey.h>
#include <botan/xmss_privatekey.h>

#endif
