/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.clock;

import java.io.Serializable;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import org.linkedin.util.clock.Clock;
import org.linkedin.util.collections.CollectionsUtils;
import org.linkedin.util.lang.LangUtils;

public class Timespan
implements Comparable<Timespan>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final Timespan ZERO_YEARS = new Timespan(0L, TimeUnit.YEAR);
    public static final Timespan ZERO_MONTHS = new Timespan(0L, TimeUnit.MONTH);
    public static final Timespan ZERO_WEEKS = new Timespan(0L, TimeUnit.WEEK);
    public static final Timespan ZERO_DAYS = new Timespan(0L, TimeUnit.DAY);
    public static final Timespan ZERO_HOURS = new Timespan(0L, TimeUnit.HOUR);
    public static final Timespan ZERO_MINUTES = new Timespan(0L, TimeUnit.MINUTE);
    public static final Timespan ZERO_SECONDS = new Timespan(0L, TimeUnit.SECOND);
    public static final Timespan ZERO_MILLISECONDS = new Timespan(0L, TimeUnit.MILLISECOND);
    public static final Timespan ONE_SECOND = new Timespan(1L, TimeUnit.SECOND);
    public static final Timespan ONE_MINUTE = new Timespan(1L, TimeUnit.MINUTE);
    private static final EnumMap<TimeUnit, Timespan> ZERO_TIMESPANS = new EnumMap(TimeUnit.class);
    private static final TimeUnit[] TIME_UNIT_ORDER = CollectionsUtils.reverse(TimeUnit.values());
    private static final EnumSet<TimeUnit> CANONICAL_TIME_UNITS;
    private final long _duration;
    private final TimeUnit _timeUnit;

    public Timespan(long durationInMilliseconds) {
        this(durationInMilliseconds, TimeUnit.MILLISECOND);
    }

    public Timespan(long duration, TimeUnit timeUnit) {
        this._duration = duration;
        this._timeUnit = timeUnit;
    }

    public TimeUnit getTimeUnit() {
        return this._timeUnit;
    }

    public long getDuration() {
        return this._duration;
    }

    public Timespan add(Timespan other) {
        if (this.getTimeUnit() == other.getTimeUnit()) {
            return new Timespan(this.getDuration() + other.getDuration(), this.getTimeUnit());
        }
        return new Timespan(this.getDurationInMilliseconds() + other.getDurationInMilliseconds(), TimeUnit.MILLISECOND);
    }

    public Timespan substractWithZeroFloor(Timespan other) {
        if (this.getTimeUnit() == other.getTimeUnit()) {
            long delta = Math.max(0L, this.getDuration() - other.getDuration());
            return new Timespan(delta, this.getTimeUnit());
        }
        long delta = Math.max(0L, this.getDurationInMilliseconds() - other.getDurationInMilliseconds());
        return new Timespan(delta, TimeUnit.MILLISECOND);
    }

    public long getDurationInMilliseconds() {
        return this.getDuration() * this.getTimeUnit().getMillisecondsCount();
    }

    public long getDuration(TimeUnit timeUnit) {
        return this.truncate(timeUnit).getDuration();
    }

    public long getDurationInSeconds() {
        return this.getDuration(TimeUnit.SECOND);
    }

    public long getDurationInMinutes() {
        return this.getDuration(TimeUnit.MINUTE);
    }

    public long getDurationInHours() {
        return this.getDuration(TimeUnit.HOUR);
    }

    public Timespan toMillisecondsTimespan() {
        if (this.getTimeUnit() == TimeUnit.MILLISECOND) {
            return this;
        }
        return new Timespan(this.getDurationInMilliseconds(), TimeUnit.MILLISECOND);
    }

    public Timespan truncate(TimeUnit timeUnit) {
        if (this.getTimeUnit() == timeUnit) {
            return this;
        }
        return Timespan.truncateDurationToUnit(this.getDurationInMilliseconds(), timeUnit);
    }

    public EnumMap<TimeUnit, Timespan> getCanonicalTimespans() {
        return this.getAsTimespans(CANONICAL_TIME_UNITS);
    }

    public String getCanonicalString() {
        return this.getAsString(CANONICAL_TIME_UNITS);
    }

    public EnumMap<TimeUnit, Timespan> getAsTimespans(TimeUnit ... timeUnits) {
        return this.getAsTimespans(CollectionsUtils.toEnumSet(TimeUnit.class, (Enum[])timeUnits));
    }

    public EnumMap<TimeUnit, Timespan> getAsTimespans(EnumSet<TimeUnit> timeUnits) {
        EnumMap<TimeUnit, Timespan> res = new EnumMap<TimeUnit, Timespan>(TimeUnit.class);
        long durationInMillis = this.getDurationInMilliseconds();
        for (TimeUnit timeUnit : TIME_UNIT_ORDER) {
            if (!timeUnits.contains((Object)timeUnit)) continue;
            Timespan timespan = Timespan.truncateDurationToUnit(durationInMillis, timeUnit);
            res.put(timeUnit, timespan);
            durationInMillis -= timespan.getDurationInMilliseconds();
        }
        return res;
    }

    public Timespan filter(TimeUnit ... timeUnits) {
        return this.filter(CollectionsUtils.toEnumSet(TimeUnit.class, (Enum[])timeUnits));
    }

    public Timespan filter(EnumSet<TimeUnit> timeUnits) {
        Timespan res = null;
        EnumMap<TimeUnit, Timespan> canonicalTimespans = this.getCanonicalTimespans();
        for (TimeUnit timeUnit : TIME_UNIT_ORDER) {
            Timespan timespan;
            if (!timeUnits.contains((Object)timeUnit) || (timespan = canonicalTimespans.get((Object)timeUnit)) == null || timespan.getDuration() <= 0L) continue;
            res = res == null ? timespan : res.add(timespan);
        }
        if (res == null) {
            res = ZERO_TIMESPANS.get(timeUnits.iterator().next());
        }
        return res;
    }

    public String getAsString(TimeUnit ... timeUnits) {
        return this.getAsString(CollectionsUtils.toEnumSet(TimeUnit.class, (Enum[])timeUnits));
    }

    public String getAsString(EnumSet<TimeUnit> timeUnits) {
        StringBuilder sb = new StringBuilder();
        EnumMap<TimeUnit, Timespan> canonicalTimespans = this.getAsTimespans(timeUnits);
        for (TimeUnit timeUnit : TIME_UNIT_ORDER) {
            long duration;
            if (!canonicalTimespans.containsKey((Object)timeUnit) || (duration = canonicalTimespans.get((Object)timeUnit).getDuration()) <= 0L) continue;
            sb.append(duration).append(timeUnit.getDisplayChar());
        }
        if (sb.length() == 0) {
            sb.append(0);
            if (timeUnits.contains((Object)this.getTimeUnit())) {
                sb.append(this.getTimeUnit().getDisplayChar());
            }
        }
        return sb.toString();
    }

    public boolean equalsDurationInMilliseconds(Timespan timespan) {
        if (timespan.getTimeUnit() == this.getTimeUnit()) {
            return timespan.getDuration() == this.getDuration();
        }
        return this.getDurationInMilliseconds() == timespan.getDurationInMilliseconds();
    }

    public long futureTimeMillis(Clock clock) {
        return this.futureTimeMillis(clock.currentTimeMillis());
    }

    public long futureTimeMillis(long baseMilliseconds) {
        return baseMilliseconds + this.getDurationInMilliseconds();
    }

    public long pastTimeMillis(Clock clock) {
        return clock.currentTimeMillis() - this.getDurationInMilliseconds();
    }

    public long pastTimeMillis(long baseMillis) {
        return baseMillis - this.getDurationInMilliseconds();
    }

    public Date futureDate(Clock clock) {
        return new Date(this.futureTimeMillis(clock));
    }

    public Date futureDate(Date baseDate) {
        return new Date(baseDate.getTime() + this.getDurationInMilliseconds());
    }

    public Date pastDate(Date baseDate) {
        return new Date(this.pastTimeMillis(baseDate.getTime()));
    }

    public Date pastDateMillis(Clock clock) {
        return new Date(this.pastTimeMillis(clock));
    }

    @Override
    public int compareTo(Timespan timespan) {
        if (timespan.getTimeUnit() == this.getTimeUnit()) {
            return LangUtils.compare(this.getDuration(), timespan.getDuration());
        }
        return LangUtils.compare(this.getDurationInMilliseconds(), timespan.getDurationInMilliseconds());
    }

    private static Timespan truncateDurationToUnit(long durationInMillis, TimeUnit timeUnit) {
        Timespan res = durationInMillis >= timeUnit.getMillisecondsCount() ? new Timespan(durationInMillis / timeUnit.getMillisecondsCount(), timeUnit) : ZERO_TIMESPANS.get((Object)timeUnit);
        return res;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Timespan timespan = (Timespan)o;
        return this.compareTo(timespan) == 0;
    }

    public int hashCode() {
        long duration = this.getDurationInMilliseconds();
        return (int)(duration ^ duration >>> 32);
    }

    public String toString() {
        return this.getCanonicalString();
    }

    public static Timespan create(Timespan ... timespans) {
        if (timespans == null) {
            return null;
        }
        if (timespans.length == 0) {
            return ZERO_MILLISECONDS;
        }
        Timespan res = timespans[0];
        for (int i = 1; i < timespans.length; ++i) {
            Timespan timespan = timespans[i];
            res = res.add(timespan);
        }
        return res;
    }

    public static Timespan parse(String timespan) {
        return Timespan.parseTimespan(timespan);
    }

    public static Timespan valueOf(String timespan) {
        return Timespan.parseTimespan(timespan);
    }

    public static Timespan milliseconds(long milliseconds) {
        return new Timespan(milliseconds);
    }

    public static Timespan seconds(long seconds) {
        return new Timespan(seconds, TimeUnit.SECOND);
    }

    public static Timespan minutes(long minutes) {
        return new Timespan(minutes, TimeUnit.MINUTE);
    }

    public static Timespan parseTimespan(String timespan) {
        if (timespan == null) {
            return null;
        }
        int len = timespan.length();
        if (len == 0) {
            return ZERO_MILLISECONDS;
        }
        int count = 0;
        int timeUnitOrderIdx = 0;
        int timeUnitOrderLen = TIME_UNIT_ORDER.length;
        Timespan[] timespans = new Timespan[timeUnitOrderLen];
        int startDigitsIdx = 0;
        boolean expectingDigits = true;
        block4: for (int i = 0; i < len; ++i) {
            char c = timespan.charAt(i);
            if (c >= '0' && c <= '9') {
                expectingDigits = false;
                continue;
            }
            if (expectingDigits) {
                throw new IllegalArgumentException("found " + c + " was expecting a digit");
            }
            while (timeUnitOrderIdx < timeUnitOrderLen) {
                TimeUnit timeUnit = TIME_UNIT_ORDER[timeUnitOrderIdx];
                String displayChar = timeUnit.getDisplayChar();
                if (displayChar.length() == 0) {
                    throw new IllegalArgumentException("found nothing was expecting: " + c);
                }
                if (c == displayChar.charAt(0)) {
                    try {
                        long duration = Long.parseLong(timespan.substring(startDigitsIdx, i));
                        timespans[timeUnitOrderIdx++] = new Timespan(duration, timeUnit);
                        startDigitsIdx = i + 1;
                        expectingDigits = true;
                        ++count;
                        continue block4;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
                ++timeUnitOrderIdx;
            }
        }
        if (startDigitsIdx < len) {
            try {
                long duration = Long.parseLong(timespan.substring(startDigitsIdx, len));
                timespans[timeUnitOrderLen - 1] = new Timespan(duration, TimeUnit.MILLISECOND);
                ++count;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(e);
            }
        }
        Timespan[] ts = new Timespan[count];
        int idx = 0;
        for (int i = 0; i < timespans.length; ++i) {
            Timespan t = timespans[i];
            if (t == null) continue;
            ts[idx++] = t;
        }
        return Timespan.create(ts);
    }

    public static long toMilliseconds(String timespan) {
        return Timespan.parseTimespan(timespan).getDurationInMilliseconds();
    }

    static {
        ZERO_TIMESPANS.put(TimeUnit.YEAR, ZERO_YEARS);
        ZERO_TIMESPANS.put(TimeUnit.MONTH, ZERO_MONTHS);
        ZERO_TIMESPANS.put(TimeUnit.WEEK, ZERO_WEEKS);
        ZERO_TIMESPANS.put(TimeUnit.DAY, ZERO_DAYS);
        ZERO_TIMESPANS.put(TimeUnit.HOUR, ZERO_HOURS);
        ZERO_TIMESPANS.put(TimeUnit.MINUTE, ZERO_MINUTES);
        ZERO_TIMESPANS.put(TimeUnit.SECOND, ZERO_SECONDS);
        ZERO_TIMESPANS.put(TimeUnit.MILLISECOND, ZERO_MILLISECONDS);
        CANONICAL_TIME_UNITS = EnumSet.range(TimeUnit.MILLISECOND, TimeUnit.YEAR);
    }

    public static enum TimeUnit {
        MILLISECOND(1L, ""),
        SECOND(1000L * MILLISECOND.getMillisecondsCount(), "s"),
        MINUTE(60L * SECOND.getMillisecondsCount(), "m"),
        HOUR(60L * MINUTE.getMillisecondsCount(), "h"),
        DAY(24L * HOUR.getMillisecondsCount(), "d"),
        WEEK(7L * DAY.getMillisecondsCount(), "w"),
        MONTH(30L * DAY.getMillisecondsCount(), "M"),
        YEAR(365L * DAY.getMillisecondsCount(), "y");

        private final long _millisecondsCount;
        private final String _displayChar;

        private TimeUnit(long millisecondsCount, String displayChar) {
            this._millisecondsCount = millisecondsCount;
            this._displayChar = displayChar;
        }

        public long getMillisecondsCount() {
            return this._millisecondsCount;
        }

        public String getDisplayChar() {
            return this._displayChar;
        }
    }
}

