/*
 * Decompiled with CFR 0.152.
 */
package wrappers;

import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Set;
import wrappers.Mongo3Interface;

public class Client3 {
    static boolean DEBUG = true;
    static final Console c = System.console();
    static Mongo3Interface jdi = null;

    public static void main(String[] args) {
        int rc;
        int level = 0;
        boolean desc = false;
        String[] parms = new String[4];
        jdi = new Mongo3Interface(DEBUG);
        parms[0] = Client3.getLine("URI: ", false);
        parms[1] = Client3.getLine("Database: ", false);
        parms[2] = null;
        parms[3] = null;
        if (parms[0] == null) {
            parms[0] = "mongodb://localhost:27017";
        }
        if (parms[1] == null) {
            parms[1] = "test";
        }
        if ((rc = jdi.MongoConnect(parms)) == 0) {
            String name;
            System.out.println("Successfully connected to " + parms[0]);
            block0: while ((name = Client3.getLine("Collection: ", false)) != null) {
                int ncol;
                boolean brc;
                if (jdi.GetCollection(name)) {
                    System.out.println("GetCollection failed");
                } else {
                    System.out.println("Collection size: " + jdi.GetCollSize());
                }
                String pipeline = Client3.getLine("Pipeline: ", false);
                if (pipeline == null || (desc = pipeline.equals("*"))) {
                    String query = Client3.getLine("Filter: ", false);
                    String fields = Client3.getLine("Proj: ", false);
                    if (desc) {
                        level = Integer.parseInt(Client3.getLine("Level: ", false));
                    }
                    brc = jdi.FindColl(query, fields);
                } else {
                    brc = jdi.AggregateColl(pipeline);
                }
                System.out.println("Returned brc = " + brc);
                if (!brc && !desc) {
                    int i = 0;
                    while (jdi.ReadNext() > 0 && i < 10) {
                        Set<String> columns = jdi.GetColumns();
                        for (String col : columns) {
                            System.out.println(String.valueOf(col) + "=" + jdi.GetField(col));
                        }
                        if (name.equalsIgnoreCase("gtst")) {
                            System.out.println("gtst=" + jdi.GetField("*"));
                        }
                        if (name.equalsIgnoreCase("inventory")) {
                            System.out.println("warehouse=" + jdi.GetField("instock.0.warehouse"));
                            System.out.println("quantity=" + jdi.GetField("instock.1.qty"));
                        }
                        if (name.equalsIgnoreCase("restaurants")) {
                            System.out.println("score=" + jdi.GetField("grades.0.score"));
                            System.out.println("date=" + jdi.GetField("grades.0.date"));
                        }
                        ++i;
                    }
                    continue;
                }
                if (!desc) continue;
                int i = 0;
                while ((ncol = jdi.ReadNext()) > 0 && i < 2) {
                    if (Client3.discovery(null, "", ncol, level)) continue block0;
                    System.out.println("--------------");
                    ++i;
                }
            }
            rc = jdi.MongoDisconnect();
            System.out.println("Disconnect returned " + rc);
        } else {
            System.out.println(String.valueOf(jdi.GetErrmsg()) + " rc=" + rc);
        }
    }

    private static boolean discovery(Object obj, String name, int ncol, int level) {
        int[] val = new int[5];
        Object ret = null;
        String bvn = null;
        int k = 0;
        while (k < ncol) {
            ret = jdi.ColumnDesc(obj, k, val, level);
            bvn = jdi.ColDescName();
            if (ret != null) {
                Client3.discovery(ret, name.concat(bvn).concat("."), val[4], level - 1);
            } else if (val[0] > 0) {
                System.out.println(String.valueOf(name) + bvn + ": type=" + val[0] + " length=" + val[1] + " prec=" + val[2] + " nullable=" + val[3]);
            } else if (val[0] < 0) {
                System.out.println(jdi.GetErrmsg());
            }
            ++k;
        }
        return false;
    }

    private static String getLine(String p, boolean b) {
        String response;
        if (c != null) {
            response = b ? new String(c.readPassword(p, new Object[0])) : c.readLine(p, new Object[0]);
        } else {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            System.out.print(p);
            try {
                response = in.readLine();
            }
            catch (IOException e) {
                response = "";
            }
        }
        return response.isEmpty() ? null : response;
    }
}

