/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xsl.transform;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.api.xml.cookies.CookieMessage;
import org.netbeans.api.xml.cookies.CookieObserver;
import org.netbeans.api.xml.cookies.TransformableCookie;
import org.netbeans.api.xml.cookies.XMLProcessorDetail;
import org.netbeans.modules.xsl.utils.TransformUtil;
import org.netbeans.spi.xml.cookies.DefaultXMLProcessorDetail;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;
import org.xml.sax.SAXParseException;

public class TransformServlet
extends HttpServlet {
    private static final long serialVersionUID = 1632869007241230624L;
    private static TransformableCookie transformable;
    private static Source xmlSource;
    private static Source xslSource;

    public static void prepare(TransformableCookie trans, Source xml, Source xsl) {
        transformable = trans;
        xmlSource = xml;
        xslSource = xsl;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void destroy() {
        xmlSource = null;
        xslSource = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out = null;
        Observer notifier = new Observer();
        try {
            String guessOutputExt = TransformUtil.guessOutputExt(xslSource);
            String mimeType = guessOutputExt.equals("txt") ? "text/plain" : (guessOutputExt.equals("xml") ? "text/xml" : (guessOutputExt.equals("html") ? "text/html;charset=UTF-8" : null));
            if (mimeType != null) {
                response.setContentType(mimeType);
            }
            out = response.getWriter();
            StreamResult outputResult = new StreamResult(out);
            TransformUtil.transform(xmlSource, transformable, xslSource, outputResult, notifier);
        }
        catch (Exception exc) {
            CookieMessage message = null;
            if (!(exc instanceof TransformerException)) {
                message = exc instanceof SAXParseException ? new CookieMessage(TransformUtil.unwrapExceptionMessage(exc), 3, (Object)new DefaultXMLProcessorDetail((SAXParseException)exc)) : new CookieMessage(exc.getLocalizedMessage(), 3);
            }
            if (message != null) {
                notifier.receive(message);
            }
            assert (out != null);
            response.setContentType("text/html;charset=UTF-8");
            out.println("<html><head>");
            out.println("    <title>" + NbBundle.getMessage(TransformServlet.class, (String)"MSG_error_html_title") + "</title>");
            out.println("    <style>" + NbBundle.getMessage(TransformServlet.class, (String)"MSG_error_html_style") + "</style>");
            out.println("     <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
            out.println("</head><body>");
            out.println("    <h2>" + NbBundle.getMessage(TransformServlet.class, (String)"MSG_error_page_title") + "</h2>");
            out.println("    <p>" + NbBundle.getMessage(TransformServlet.class, (String)"MSG_error_page_message") + "</p>");
            out.println("    <hr size=\"1\" noshade=\"\" />\n" + this.generateReport(notifier.getList()) + "<hr size=\"1\" noshade=\"\" />");
            out.println("    <p>" + NbBundle.getMessage(TransformServlet.class, (String)"MSG_error_bottom_message") + "</p>");
            out.println("</body></html>");
        }
        finally {
            out.close();
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "XSL Transformation Preview Servlet";
    }

    public static URL getServletURL() throws MalformedURLException, UnknownHostException {
        URL base = TransformServlet.getSampleHTTPServerURL();
        URL root = new URL(base.getProtocol(), base.getHost(), base.getPort(), "/servlet/" + TransformServlet.class.getName() + "/");
        return root;
    }

    private static URL getSampleHTTPServerURL() {
        FileObject fo = FileUtil.getConfigFile((String)"HTTPServer_DUMMY");
        if (fo == null) {
            return null;
        }
        URL u = URLMapper.findURL((FileObject)fo, (int)2);
        return u;
    }

    private String generateReport(List msgList) {
        StringBuffer sb = new StringBuffer();
        try {
            for (CookieMessage msg : msgList) {
                String systemId;
                XMLProcessorDetail detail = (XMLProcessorDetail)msg.getDetail(XMLProcessorDetail.class);
                sb.append("    &nbsp;&nbsp;&nbsp;&nbsp;<font class=\"").append(this.levelName(msg.getLevel())).append("\">").append(msg.getMessage()).append("</font>");
                if (detail == null || (systemId = this.preferFileName(detail.getSystemId())) == null) continue;
                sb.append("&nbsp;(<font class=\"system-id\">");
                boolean isFile = systemId.startsWith("file:");
                if (isFile) {
                    sb.append("<a href=\"").append(systemId).append("\">");
                }
                sb.append(systemId);
                if (isFile) {
                    sb.append("</a>");
                }
                sb.append("</font>\n");
                sb.append("&nbsp;[<font class=\"line-number\">").append(detail.getLineNumber()).append("</font>])<br>");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    private String preferFileName(String systemId) {
        String name = systemId;
        try {
            URL url = new URL(systemId);
            FileObject fo = URLMapper.findFileObject((URL)url);
            if (fo != null) {
                name = TransformUtil.getURLName(fo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return name;
    }

    private String levelName(int level) {
        if (level == 3) {
            return "fatal-error";
        }
        if (level == 2) {
            return "error";
        }
        if (level == 1) {
            return "warning";
        }
        return "informational";
    }

    private static class Observer
    implements CookieObserver {
        private final List msgList = new Vector();

        public void receive(CookieMessage msg) {
            this.msgList.add(msg);
        }

        public List getList() {
            return this.msgList;
        }
    }
}

