/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import org.netbeans.lib.terminalemulator.Coord;

public class Extent {
    public Coord begin;
    public Coord end;

    public Extent(Coord begin, Coord end) {
        this.begin = (Coord)begin.clone();
        this.end = (Coord)end.clone();
    }

    public String toString() {
        return "Extent[" + this.begin + " " + this.end + "]";
    }

    public Extent order() {
        if (this.begin.compareTo(this.end) > 0) {
            Coord tmp = this.begin;
            this.begin = this.end;
            this.end = tmp;
        }
        return this;
    }

    public boolean intersects(int arow, int col) {
        if (this.begin.row > arow) {
            return false;
        }
        if (this.end.row < arow) {
            return false;
        }
        if (this.begin.row == this.end.row) {
            return col >= this.begin.col && col <= this.end.col;
        }
        if (arow == this.begin.row) {
            return col >= this.begin.col;
        }
        if (arow == this.end.row) {
            return col <= this.end.col;
        }
        return true;
    }
}

