/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.tiles3;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javax.servlet.ServletContext;
import org.apache.tiles.request.ApplicationResource;
import org.apache.tiles.request.locale.URLApplicationResource;
import org.apache.tiles.request.servlet.ServletApplicationContext;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.support.ServletContextResourcePatternResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringWildcardServletTilesApplicationContext
extends ServletApplicationContext {
    private final ResourcePatternResolver resolver;

    public SpringWildcardServletTilesApplicationContext(ServletContext servletContext) {
        super(servletContext);
        this.resolver = new ServletContextResourcePatternResolver(servletContext);
    }

    public ApplicationResource getResource(String localePath) {
        ApplicationResource retValue = null;
        Collection<ApplicationResource> urlSet = this.getResources(localePath);
        if (urlSet != null && !urlSet.isEmpty()) {
            retValue = urlSet.iterator().next();
        }
        return retValue;
    }

    public ApplicationResource getResource(ApplicationResource base, Locale locale) {
        ApplicationResource retValue = null;
        Collection<ApplicationResource> urlSet = this.getResources(base.getLocalePath(locale));
        if (urlSet != null && !urlSet.isEmpty()) {
            retValue = urlSet.iterator().next();
        }
        return retValue;
    }

    public Collection<ApplicationResource> getResources(String path) {
        Object[] resources;
        try {
            resources = this.resolver.getResources(path);
        }
        catch (IOException ex) {
            return Collections.emptyList();
        }
        ArrayList<ApplicationResource> resourceList = new ArrayList<ApplicationResource>();
        if (!ObjectUtils.isEmpty((Object[])resources)) {
            for (Object resource : resources) {
                try {
                    URL url = resource.getURL();
                    resourceList.add((ApplicationResource)new URLApplicationResource(url.toExternalForm(), url));
                }
                catch (IOException ex) {
                    throw new IllegalArgumentException("No URL for " + resource.toString(), ex);
                }
            }
        }
        return resourceList;
    }
}

