/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.checker;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class Checker
implements ContentHandler {
    private ErrorHandler errorHandler;
    private Locator locator;

    public void warn(String message) throws SAXException {
        if (this.errorHandler != null) {
            SAXParseException spe = new SAXParseException(message, this.locator);
            this.errorHandler.warning(spe);
        }
    }

    public void warn(String message, Locator overrideLocator) throws SAXException {
        if (this.errorHandler != null) {
            SAXParseException spe = new SAXParseException(message, overrideLocator);
            this.errorHandler.warning(spe);
        }
    }

    public void err(String message, Locator overrideLocator) throws SAXException {
        if (this.errorHandler != null) {
            SAXParseException spe = new SAXParseException(message, overrideLocator);
            this.errorHandler.error(spe);
        }
    }

    public void err(String message) throws SAXException {
        if (this.errorHandler != null) {
            SAXParseException spe = new SAXParseException(message, this.locator);
            this.errorHandler.error(spe);
        }
    }

    public void reset() {
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public Locator getDocumentLocator() {
        return this.locator;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        this.reset();
    }

    @Override
    public void endDocument() throws SAXException {
        this.reset();
    }

    @Override
    public final void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.characters(ch, start, length);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }
}

