/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project.fxml;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.javafx2.project.JFXProjectUtils;
import org.netbeans.modules.javafx2.project.fxml.ConfigureFXMLCSSPanelVisual;
import org.netbeans.modules.javafx2.project.fxml.ConfigureFXMLControllerPanelVisual;
import org.netbeans.modules.javafx2.project.fxml.ConfigureFXMLPanelVisual;
import org.netbeans.modules.javafx2.project.fxml.SourceGroupSupport;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class FXMLTemplateWizardIterator
implements WizardDescriptor.InstantiatingIterator<WizardDescriptor> {
    static final String PROP_SRC_ROOTS = "srcRootFolder";
    static final String PROP_ROOT_FOLDER = "rootFolder";
    static final String PROP_JAVA_CONTROLLER_ENABLED = "javaControllerEnabled";
    static final String PROP_JAVA_CONTROLLER_NAME_PROPERTY = "javaController";
    static final String PROP_JAVA_CONTROLLER_EXISTING_PROPERTY = "javaControllerExisting";
    static final String PROP_CSS_ENABLED = "cssEnabled";
    static final String PROP_CSS_NAME_PROPERTY = "CSS";
    static final String PROP_CSS_EXISTING_PROPERTY = "CSSExisting";
    static final String FXML_FILE_EXTENSION = ".fxml";
    static final String JAVA_FILE_EXTENSION = ".java";
    static final String CSS_FILE_EXTENSION = ".css";
    static final String defaultMavenFXMLPackage = "fxml";
    static final String defaultMavenImagesPackage = "images";
    static final String defaultMavenCSSPackage = "styles";
    static final char[] NO_FILENAME_CHARS = new char[]{'/', '<', '>', '\\', '|', '\"', '\n', '\r', '\t', '\u0000', '\f', '`', '?', '*', ':'};
    private WizardDescriptor wizard;
    private SourceGroupSupport supportFXML;
    private SourceGroupSupport supportController;
    private SourceGroupSupport supportCSS;
    private boolean isMavenOrGradle = false;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;

    public static WizardDescriptor.InstantiatingIterator<WizardDescriptor> create() {
        return new FXMLTemplateWizardIterator();
    }

    private FXMLTemplateWizardIterator() {
    }

    public String name() {
        switch (this.index) {
            default: {
                return NbBundle.getMessage(FXMLTemplateWizardIterator.class, (String)"LBL_ConfigureFXMLPanel_Name");
            }
            case 1: {
                return NbBundle.getMessage(FXMLTemplateWizardIterator.class, (String)"LBL_ConfigureFXMLPanel_Controller_Name");
            }
            case 2: 
        }
        return NbBundle.getMessage(FXMLTemplateWizardIterator.class, (String)"LBL_ConfigureFXMLPanel_CSS_Name");
    }

    public void initialize(WizardDescriptor wizard) {
        this.wizard = wizard;
        Project project = Templates.getProject((WizardDescriptor)wizard);
        if (project == null) {
            throw new IllegalStateException(NbBundle.getMessage(FXMLTemplateWizardIterator.class, (String)"MSG_ConfigureFXMLPanel_Project_Null_Error"));
        }
        this.isMavenOrGradle = JFXProjectUtils.isMavenProject(project) || JFXProjectUtils.isGradleProject(project);
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupsJava = sources.getSourceGroups("java");
        SourceGroup[] sourceGroupsResources = sources.getSourceGroups("resources");
        if (sourceGroupsJava == null || sourceGroupsJava.length == 0) {
            throw new IllegalStateException(NbBundle.getMessage(FXMLTemplateWizardIterator.class, (String)"MSG_ConfigureFXMLPanel_SGs_Error"));
        }
        if (this.isMavenOrGradle) {
            this.supportFXML = new SourceGroupSupport("resources");
            this.supportCSS = new SourceGroupSupport("resources");
            if (sourceGroupsResources != null && sourceGroupsResources.length > 0) {
                this.supportFXML.addSourceGroups(sourceGroupsResources);
                this.supportCSS.addSourceGroups(sourceGroupsResources);
            } else {
                this.supportFXML.addSourceGroupProxy(project, NbBundle.getMessage(FXMLTemplateWizardIterator.class, (String)"LAB_ProjectResources"), new String[]{defaultMavenFXMLPackage, defaultMavenImagesPackage, defaultMavenCSSPackage});
                this.supportCSS.addSourceGroupProxy(project, NbBundle.getMessage(FXMLTemplateWizardIterator.class, (String)"LAB_ProjectResources"), new String[]{defaultMavenFXMLPackage, defaultMavenImagesPackage, defaultMavenCSSPackage});
                FileObject dirFXML = this.supportFXML.getCurrentPackageFolder(true);
                if (dirFXML == null) {
                    this.supportFXML = new SourceGroupSupport("java");
                    this.supportFXML.addSourceGroups(sourceGroupsJava);
                    this.supportCSS = new SourceGroupSupport("java");
                    this.supportCSS.addSourceGroups(sourceGroupsJava);
                }
            }
        } else {
            this.supportFXML = new SourceGroupSupport("java");
            this.supportFXML.addSourceGroups(sourceGroupsJava);
            this.supportCSS = new SourceGroupSupport("java");
            this.supportCSS.addSourceGroups(sourceGroupsJava);
        }
        this.supportController = new SourceGroupSupport("java");
        this.supportController.addSourceGroups(sourceGroupsJava);
        this.supportController.setParent(this.supportFXML);
        this.supportCSS.setParent(this.supportFXML);
        this.index = 0;
        this.panels = this.createPanels(project, this.supportFXML, this.supportController, this.supportCSS);
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    private WizardDescriptor.Panel[] createPanels(Project project, SourceGroupSupport supportFXML, SourceGroupSupport supportController, SourceGroupSupport supportCSS) {
        return new WizardDescriptor.Panel[]{new ConfigureFXMLPanelVisual.Panel(project, supportFXML, this.isMavenOrGradle), new ConfigureFXMLControllerPanelVisual.Panel(supportController, this.isMavenOrGradle), new ConfigureFXMLCSSPanelVisual.Panel(supportCSS, this.isMavenOrGradle)};
    }

    private String[] createSteps() {
        return new String[]{NbBundle.getMessage(FXMLTemplateWizardIterator.class, (String)"LAB_FXMLStep0"), NbBundle.getMessage(FXMLTemplateWizardIterator.class, (String)"LAB_FXMLStep1"), NbBundle.getMessage(FXMLTemplateWizardIterator.class, (String)"LAB_FXMLStep2"), NbBundle.getMessage(FXMLTemplateWizardIterator.class, (String)"LAB_FXMLStep3")};
    }

    public void uninitialize(WizardDescriptor wizard) {
    }

    public Set instantiate() throws IOException, IllegalArgumentException {
        HashSet<FileObject> set = new HashSet<FileObject>(3);
        FileObject dirFXML = this.supportFXML.getCurrentPackageFolder(true);
        DataFolder dfFXML = DataFolder.findFolder((FileObject)dirFXML);
        String targetNameFXML = this.supportFXML.getCurrentFileName();
        DataFolder dfController = null;
        String targetNameController = null;
        Object enabledControllerProperty = this.wizard.getProperty(PROP_JAVA_CONTROLLER_ENABLED);
        Object controllerNameProperty = this.wizard.getProperty(PROP_JAVA_CONTROLLER_NAME_PROPERTY);
        Object controllerExistingProperty = this.wizard.getProperty(PROP_JAVA_CONTROLLER_EXISTING_PROPERTY);
        boolean enabledController = enabledControllerProperty != null ? (Boolean)enabledControllerProperty : false;
        String controllerName = controllerNameProperty != null ? (String)controllerNameProperty : null;
        String controllerExisting = controllerExistingProperty != null ? (String)controllerExistingProperty : null;
        String controllerFullName = null;
        if (controllerExisting != null && !controllerExisting.isEmpty()) {
            File f = new File(controllerExisting);
            if (f.exists()) {
                FileObject fo = FileUtil.toFileObject((File)f);
                controllerFullName = JFXProjectUtils.getRelativePath(dirFXML, fo);
                if (controllerFullName == null) {
                    controllerFullName = controllerExisting;
                }
            } else {
                controllerFullName = controllerExisting;
            }
        } else if (enabledController) {
            FileObject dirController = this.supportController.getCurrentPackageFolder(true);
            dfController = DataFolder.findFolder((FileObject)dirController);
            targetNameController = this.supportController.getCurrentFileName();
            controllerFullName = FXMLTemplateWizardIterator.getPreselectedPackage(this.supportController.getCurrentSourceGroup(), dirController) + "." + targetNameController;
        }
        DataFolder dfCSS = null;
        Object enabledCSSProperty = this.wizard.getProperty(PROP_CSS_ENABLED);
        Object cssNameProperty = this.wizard.getProperty(PROP_CSS_NAME_PROPERTY);
        Object cssExistingProperty = this.wizard.getProperty(PROP_CSS_EXISTING_PROPERTY);
        boolean enabledCSS = enabledCSSProperty != null ? (Boolean)enabledCSSProperty : false;
        String cssName = cssNameProperty != null ? (String)cssNameProperty : null;
        String cssExisting = cssExistingProperty != null ? (String)cssExistingProperty : null;
        String cssFullName = null;
        if (enabledCSS) {
            if (cssExisting != null && !cssExisting.isEmpty()) {
                String srcPath = FileUtil.normalizeFile((File)FileUtil.toFile((FileObject)this.supportCSS.getCurrentSourceGroupFolder())).getPath();
                File f = new File(srcPath + File.separator + cssExisting);
                if (f.exists()) {
                    FileObject fo = FileUtil.toFileObject((File)f);
                    String string = cssFullName = fo.getParent().equals(dirFXML) ? fo.getNameExt() : JFXProjectUtils.getRelativePath(this.supportCSS.getCurrentSourceGroupFolder(), fo);
                    if (cssFullName == null) {
                        cssFullName = cssExisting;
                    }
                } else {
                    cssFullName = cssExisting;
                }
                if ((cssFullName.contains("/") || cssFullName.contains("\\")) && !cssFullName.startsWith("/") && !cssFullName.startsWith("\\")) {
                    cssFullName = "/" + cssFullName;
                }
            } else {
                FileObject dirCSS = this.supportCSS.getCurrentPackageFolder(true);
                dfCSS = DataFolder.findFolder((FileObject)dirCSS);
                String targetNameCSS = this.supportCSS.getCurrentFileName();
                assert (targetNameCSS.equals(cssName));
                Object path = FXMLTemplateWizardIterator.getPreselectedPackage(this.supportCSS.getCurrentSourceGroup(), dirCSS);
                cssFullName = path != null && dfFXML != null && !dfFXML.equals(dfCSS) ? "/" + ((String)path).replace('.', '/') + "/" + targetNameCSS : targetNameCSS;
            }
        }
        HashMap<String, String> params = new HashMap<String, String>();
        if (controllerFullName != null) {
            params.put("controller", controllerFullName);
        }
        if (cssFullName != null) {
            cssFullName = cssFullName.substring(0, cssFullName.length() - CSS_FILE_EXTENSION.length());
            cssFullName = cssFullName.replace("\\", "/");
            params.put("css", cssFullName);
        }
        if (cssName != null) {
            cssName = cssName.substring(0, cssName.length() - CSS_FILE_EXTENSION.length());
        }
        FileObject xmlTemplate = FileUtil.getConfigFile((String)"Templates/javafx/FXML.fxml");
        DataObject dXMLTemplate = DataObject.find((FileObject)xmlTemplate);
        DataObject dobj = dXMLTemplate.createFromTemplate(dfFXML, targetNameFXML, params);
        set.add(dobj.getPrimaryFile());
        if (enabledController && dfController != null) {
            assert (controllerName.equals(targetNameController));
            FileObject javaTemplate = FileUtil.getConfigFile((String)"Templates/javafx/FXMLController.java");
            DataObject dJavaTemplate = DataObject.find((FileObject)javaTemplate);
            DataObject dobj2 = dJavaTemplate.createFromTemplate(dfController, controllerName);
            set.add(dobj2.getPrimaryFile());
        }
        if (enabledCSS && dfCSS != null) {
            FileObject cssTemplate = FileUtil.getConfigFile((String)"Templates/javafx/FXML.css");
            DataObject dCSSTemplate = DataObject.find((FileObject)cssTemplate);
            DataObject dobj3 = dCSSTemplate.createFromTemplate(dfCSS, cssName);
            set.add(dobj3.getPrimaryFile());
        }
        return set;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.panels[this.index];
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    static Object getPreselectedPackage(SourceGroupSupport.SourceGroupProxy group, FileObject folder) {
        if (folder == null) {
            return null;
        }
        FileObject root = group.getRootFolder();
        String relPath = FileUtil.getRelativePath((FileObject)root, (FileObject)folder);
        if (relPath == null) {
            return null;
        }
        String name = relPath.replace('/', '.');
        return name;
    }

    static void setErrorMessage(String key, WizardDescriptor settings) {
        if (key == null) {
            settings.getNotificationLineSupport().clearMessages();
        } else {
            settings.getNotificationLineSupport().setErrorMessage(NbBundle.getMessage(FXMLTemplateWizardIterator.class, (String)key));
        }
    }

    static void setInfoMessage(String key, WizardDescriptor settings) {
        if (key == null) {
            settings.getNotificationLineSupport().clearMessages();
        } else {
            settings.getNotificationLineSupport().setInformationMessage(NbBundle.getMessage(FXMLTemplateWizardIterator.class, (String)key));
        }
    }

    public static boolean isValidPackageName(String str) {
        if (str.length() > 0 && str.charAt(0) == '.') {
            return false;
        }
        StringTokenizer st = new StringTokenizer(str, ".");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.isEmpty()) {
                return false;
            }
            if (Utilities.isJavaIdentifier((String)token)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidPackage(FileObject root, String path) {
        if (root == null || path == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(path, ".");
        while (st.hasMoreTokens()) {
            if ((root = root.getFileObject(st.nextToken())) == null) {
                return true;
            }
            if (!root.isData()) continue;
            return false;
        }
        return true;
    }

    static String fileExist(String fileName) {
        if (!new File(fileName).exists()) {
            return NbBundle.getMessage(FXMLTemplateWizardIterator.class, (String)"MSG_file_doesnt_exist", (Object)fileName);
        }
        return null;
    }

    static boolean validFileName(String name) {
        if (name == null) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            for (int j = 0; j < NO_FILENAME_CHARS.length; ++j) {
                if (name.charAt(i) != NO_FILENAME_CHARS[j]) continue;
                return false;
            }
        }
        return true;
    }

    public static String canUseFileName(File rootFolder, String fileName) {
        assert (rootFolder != null);
        String relFileName = rootFolder.getPath() + File.separatorChar + fileName;
        if (!FXMLTemplateWizardIterator.validFileName(fileName)) {
            return NbBundle.getMessage(FXMLTemplateWizardIterator.class, (String)"MSG_invalid_file_name");
        }
        if (new File(relFileName).exists()) {
            return NbBundle.getMessage(FXMLTemplateWizardIterator.class, (String)"MSG_file_already_exist", (Object)relFileName);
        }
        if (!rootFolder.canWrite()) {
            return NbBundle.getMessage(FXMLTemplateWizardIterator.class, (String)"MSG_fs_is_readonly");
        }
        return null;
    }

    static String canUseFileName(FileObject targetFolder, String folderName, String newObjectName, String extension) {
        File targetPackage;
        StringBuilder sb;
        String newObjectNameToDisplay = newObjectName;
        if (newObjectName != null) {
            newObjectName = newObjectName.replace('.', '/');
        }
        if (extension != null && extension.length() > 0) {
            sb = new StringBuilder();
            sb.append(newObjectName);
            sb.append('.');
            sb.append(extension);
            newObjectName = sb.toString();
        }
        if (extension != null && extension.length() > 0) {
            sb = new StringBuilder();
            sb.append(newObjectNameToDisplay);
            sb.append('.');
            sb.append(extension);
            newObjectNameToDisplay = sb.toString();
        }
        String relFileName = folderName + '/' + newObjectName;
        if (targetFolder == null) {
            return NbBundle.getMessage(FXMLTemplateWizardIterator.class, (String)"MSG_fs_or_folder_does_not_exist");
        }
        File file = targetPackage = folderName != null ? new File(FileUtil.toFile((FileObject)targetFolder), folderName) : FileUtil.toFile((FileObject)targetFolder);
        if (targetPackage != null ? targetPackage.exists() && !targetPackage.canWrite() : !targetFolder.canWrite()) {
            return NbBundle.getMessage(FXMLTemplateWizardIterator.class, (String)"MSG_fs_is_readonly");
        }
        if (FXMLTemplateWizardIterator.existFileName(targetFolder, relFileName)) {
            return NbBundle.getMessage(FXMLTemplateWizardIterator.class, (String)"MSG_file_already_exist", (Object)newObjectNameToDisplay);
        }
        return null;
    }

    private static boolean existFileName(FileObject targetFolder, String relFileName) {
        File fold = FileUtil.toFile((FileObject)targetFolder);
        return fold.exists() ? new File(fold, relFileName).exists() : targetFolder.getFileObject(relFileName) != null;
    }

    static class FXMLTemplateFileFilter
    extends FileFilter {
        private Type type;

        private FXMLTemplateFileFilter(Type type) {
            this.type = type;
        }

        public static FXMLTemplateFileFilter createFXMLFilter() {
            return new FXMLTemplateFileFilter(Type.FXML);
        }

        public static FXMLTemplateFileFilter createJavaFilter() {
            return new FXMLTemplateFileFilter(Type.JAVA);
        }

        public static FXMLTemplateFileFilter createCSSFilter() {
            return new FXMLTemplateFileFilter(Type.CSS);
        }

        @Override
        public boolean accept(File f) {
            String extension;
            if (f.isDirectory()) {
                return true;
            }
            switch (this.type) {
                default: {
                    extension = FXMLTemplateWizardIterator.FXML_FILE_EXTENSION;
                    break;
                }
                case JAVA: {
                    extension = FXMLTemplateWizardIterator.JAVA_FILE_EXTENSION;
                    break;
                }
                case CSS: {
                    extension = FXMLTemplateWizardIterator.CSS_FILE_EXTENSION;
                }
            }
            return ("." + FileUtil.getExtension((String)f.getName())).equals(extension);
        }

        @Override
        public String getDescription() {
            String key;
            switch (this.type) {
                default: {
                    key = "LBL_ConfigureFXMLPanel_FileChooser_FXML_Description";
                    break;
                }
                case JAVA: {
                    key = "LBL_ConfigureFXMLPanel_FileChooser_Java_Description";
                    break;
                }
                case CSS: {
                    key = "LBL_ConfigureFXMLPanel_FileChooser_CSS_Description";
                }
            }
            return NbBundle.getMessage(ConfigureFXMLControllerPanelVisual.class, (String)key);
        }

        private static enum Type {
            FXML,
            JAVA,
            CSS;

        }
    }

    static class SrcFileSystemView
    extends FileSystemView {
        private static final String newFolderStringWin = UIManager.getString("FileChooser.win32.newFolder");
        private static final String newFolderNextStringWin = UIManager.getString("FileChooser.win32.newFolder.subsequent");
        private static final String newFolderString = UIManager.getString("FileChooser.other.newFolder");
        private static final String newFolderNextString = UIManager.getString("FileChooser.other.newFolder.subsequent");
        private File[] roots;

        public SrcFileSystemView(File[] roots) {
            assert (roots != null && roots.length > 0);
            this.roots = roots;
        }

        @Override
        public File[] getRoots() {
            return this.roots;
        }

        @Override
        public boolean isRoot(File file) {
            for (File root : this.roots) {
                if (!root.equals(file)) continue;
                return true;
            }
            return false;
        }

        @Override
        public File getHomeDirectory() {
            return this.roots[0];
        }

        @Override
        public File createNewFolder(File containingDir) throws IOException {
            assert (containingDir != null);
            boolean win = Utilities.isWindows();
            File newFolder = this.createFileObject(containingDir, win ? newFolderStringWin : newFolderString);
            for (int i = 2; newFolder.exists() && i < 100; ++i) {
                newFolder = this.createFileObject(containingDir, MessageFormat.format(win ? newFolderNextStringWin : newFolderNextString, new Integer(i)));
            }
            if (newFolder.exists()) {
                throw new IOException(NbBundle.getMessage(FXMLTemplateWizardIterator.class, (String)"LBL_ConfigureFXMLPanel_Name", (Object)newFolder.getAbsolutePath()));
            }
            newFolder.mkdirs();
            return newFolder;
        }
    }
}

