/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.axi.impl;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIDocument;
import org.netbeans.modules.xml.axi.AXIType;
import org.netbeans.modules.xml.axi.AnyAttribute;
import org.netbeans.modules.xml.axi.AnyElement;
import org.netbeans.modules.xml.axi.Attribute;
import org.netbeans.modules.xml.axi.Compositor;
import org.netbeans.modules.xml.axi.ContentModel;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.axi.datatype.Datatype;
import org.netbeans.modules.xml.axi.impl.AXIComponentCreator;
import org.netbeans.modules.xml.axi.impl.AXIModelImpl;
import org.netbeans.modules.xml.axi.impl.AttributeImpl;
import org.netbeans.modules.xml.axi.impl.AttributeProxy;
import org.netbeans.modules.xml.axi.impl.AttributeRef;
import org.netbeans.modules.xml.axi.impl.ElementImpl;
import org.netbeans.modules.xml.axi.impl.ElementProxy;
import org.netbeans.modules.xml.axi.impl.ElementRef;
import org.netbeans.modules.xml.axi.impl.PeerValidator;
import org.netbeans.modules.xml.axi.impl.Util;
import org.netbeans.modules.xml.axi.visitor.DeepAXITreeVisitor;
import org.netbeans.modules.xml.schema.model.AttributeReference;
import org.netbeans.modules.xml.schema.model.ElementReference;
import org.netbeans.modules.xml.schema.model.GlobalAttribute;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.LocalAttribute;
import org.netbeans.modules.xml.schema.model.LocalElement;
import org.netbeans.modules.xml.schema.model.SchemaComponent;

public class AXIModelUpdater
extends DeepAXITreeVisitor {
    private AXIModelImpl model;
    private boolean syncCompleted;

    public AXIModelUpdater(AXIModelImpl model) {
        this.model = model;
    }

    public boolean doSync() {
        try {
            this.syncCompleted = false;
            this.model.getRoot().accept(this);
            for (AXIComponent child : this.model.getRoot().getChildren()) {
                if (child instanceof ContentModel) continue;
                child.accept(this);
            }
            for (ContentModel contentModel : this.model.getRoot().getContentModels()) {
                contentModel.accept(this);
            }
            this.syncCompleted = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.syncCompleted;
    }

    public void syncOne(AXIComponent component) {
        component.accept(this);
    }

    @Override
    protected void visitChildren(AXIComponent original) {
        if (!original.canVisitChildren()) {
            return;
        }
        if (original.getComponentType() == AXIComponent.ComponentType.PROXY && original.getModel() == original.getOriginal().getModel()) {
            return;
        }
        AXIComponentCreator creator = new AXIComponentCreator(this.model);
        AXIComponent altered = this.getAltered(original);
        assert (altered != null);
        List<AXIComponent> modifiedChildren = this.synchronize(original, altered);
        if (modifiedChildren == null || original instanceof AXIDocument) {
            return;
        }
        for (AXIComponent child : modifiedChildren) {
            child.accept(this);
        }
    }

    private AXIComponent getAltered(AXIComponent original) {
        if (original.getComponentType() == AXIComponent.ComponentType.PROXY) {
            return original.getOriginal();
        }
        AXIComponentCreator creator = new AXIComponentCreator(this.model);
        return creator.createNew(original.getPeer());
    }

    private List<AXIComponent> synchronize(AXIComponent original, AXIComponent altered) {
        List<AXIComponent> modifiedChildren = this.removeRemovedChildren(original, altered);
        this.addNewChildren(original, altered);
        return modifiedChildren;
    }

    private List<AXIComponent> removeRemovedChildren(AXIComponent original, AXIComponent altered) {
        ArrayList<AXIComponent> removedChildren = new ArrayList<AXIComponent>();
        ArrayList<AXIComponent> dirtyChildren = new ArrayList<AXIComponent>();
        for (AXIComponent oChild : original.getChildren()) {
            int index = this.childExists(oChild, altered, true);
            if (index == -1 || oChild.getPeer().getParent() == null || oChild.getPeer().getModel() == null) {
                removedChildren.add(oChild);
                continue;
            }
            dirtyChildren.add(oChild);
        }
        for (AXIComponent child : removedChildren) {
            original.removeChild(child);
        }
        return dirtyChildren;
    }

    private void addNewChildren(AXIComponent original, AXIComponent altered) {
        int size = altered.getChildren().size();
        for (int index = 0; index < size; ++index) {
            AXIComponent aChild = (AXIComponent)altered.getChildren().get(index);
            int indexInOriginalTree = this.childExists(aChild, original, false);
            if (indexInOriginalTree == -1) {
                if (original.getComponentType() == AXIComponent.ComponentType.PROXY) {
                    AXIComponent proxy = this.model.getComponentFactory().createProxy(aChild);
                    original.addChildAtIndex(proxy, index);
                    continue;
                }
                if (aChild.getPeer() == null || aChild.getPeer().getModel() == null) continue;
                original.addChildAtIndex(aChild, index);
                continue;
            }
            if (aChild.getComponentType() != AXIComponent.ComponentType.PROXY) continue;
            aChild.getSharedComponent().removeListener(aChild);
        }
    }

    private int childExists(AXIComponent child, AXIComponent parent, boolean checkOriginal) {
        int size = parent.getChildren().size();
        for (int index = 0; index < size; ++index) {
            AXIComponent c = (AXIComponent)parent.getChildren().get(index);
            if (c.getPeer() != child.getPeer()) continue;
            if (checkOriginal && !this.validateOriginal(child, c)) {
                return -1;
            }
            return index;
        }
        return -1;
    }

    private boolean validateOriginal(AXIComponent original, AXIComponent altered) {
        PeerValidator validator = new PeerValidator();
        if (!validator.validate(original)) {
            return false;
        }
        return altered.getComponentType() != AXIComponent.ComponentType.PROXY || original.getComponentType() == AXIComponent.ComponentType.PROXY;
    }

    @Override
    public void visit(AXIDocument document) {
        Util.updateAXIDocument(document);
        this.visitChildren(document);
    }

    @Override
    public void visit(Element element) {
        if (element instanceof ElementImpl) {
            this.visit((ElementImpl)element);
        }
        if (element instanceof ElementRef) {
            this.visit((ElementRef)element);
        }
        if (element instanceof ElementProxy) {
            ((ElementProxy)element).forceFireEvent();
        }
    }

    public void visit(ElementImpl element) {
        SchemaComponent schemaComponent = element.getPeer();
        if (schemaComponent instanceof LocalElement) {
            Util.updateLocalElement(element);
        }
        if (schemaComponent instanceof GlobalElement) {
            Util.updateGlobalElement(element);
        }
        SchemaComponent newType = Util.getSchemaType(this.model, element.getPeer());
        AXIType axiType = Util.getAXIType(element, newType);
        if (element.getType() != axiType) {
            element.setType(axiType);
        }
        this.visitChildren(element);
    }

    public void visit(ElementRef elementRef) {
        ElementReference ref = (ElementReference)elementRef.getPeer();
        GlobalElement newGE = (GlobalElement)ref.getRef().get();
        SchemaComponent originalGE = elementRef.getReferent().getPeer();
        if (originalGE == newGE) {
            Util.updateElementReference(elementRef);
            elementRef.forceFireEvent();
            this.visitChildren(elementRef);
            return;
        }
        AXIComponent newElement = Util.lookup(elementRef.getModel(), (SchemaComponent)newGE);
        if (newElement != null && newElement instanceof Element) {
            elementRef.setRef((Element)newElement);
            elementRef.forceFireEvent();
        }
    }

    @Override
    public void visit(Attribute attribute) {
        if (attribute instanceof AttributeImpl) {
            this.visit((AttributeImpl)attribute);
        }
        if (attribute instanceof AttributeRef) {
            this.visit((AttributeRef)attribute);
        }
        if (attribute instanceof AttributeProxy) {
            ((AttributeProxy)attribute).forceFireEvent();
        }
    }

    public void visit(AttributeImpl attribute) {
        Datatype type;
        SchemaComponent schemaComponent = attribute.getPeer();
        if (schemaComponent instanceof LocalAttribute) {
            Util.updateLocalAttribute(attribute);
            type = Util.getDatatype(attribute.getModel(), (SchemaComponent)((LocalAttribute)schemaComponent));
            if (type != null) {
                attribute.setType(type);
            }
        }
        if (schemaComponent instanceof GlobalAttribute) {
            Util.updateGlobalAttribute(attribute);
            type = Util.getDatatype(attribute.getModel(), (SchemaComponent)((GlobalAttribute)schemaComponent));
            if (type != null) {
                attribute.setType(type);
            }
        }
    }

    public void visit(AttributeRef attributeRef) {
        GlobalAttribute newGA;
        AttributeReference ref = (AttributeReference)attributeRef.getPeer();
        SchemaComponent originalGA = attributeRef.getReferent().getPeer();
        if (originalGA == (newGA = (GlobalAttribute)ref.getRef().get())) {
            Util.updateAttributeReference(attributeRef);
            attributeRef.forceFireEvent();
            return;
        }
        AXIComponent newAttr = Util.lookup(attributeRef.getModel(), (SchemaComponent)newGA);
        if (newAttr != null && newAttr instanceof Attribute) {
            attributeRef.setRef((Attribute)newAttr);
            attributeRef.forceFireEvent();
        }
    }

    @Override
    public void visit(Compositor compositor) {
        Util.updateCompositor(compositor);
        this.visitChildren(compositor);
    }

    @Override
    public void visit(ContentModel contentModel) {
        Util.updateContentModel(contentModel);
        this.visitChildren(contentModel);
    }

    @Override
    public void visit(AnyAttribute attribute) {
        Util.updateAnyAttribute(attribute);
    }

    @Override
    public void visit(AnyElement element) {
        Util.updateAnyElement(element);
    }
}

