/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.tasks.dashboard;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.QueryImpl;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.tasks.DashboardUtils;
import org.netbeans.modules.bugtracking.tasks.actions.Actions;
import org.netbeans.modules.bugtracking.tasks.dashboard.CategoryNode;
import org.netbeans.modules.bugtracking.tasks.dashboard.DashboardViewer;
import org.netbeans.modules.bugtracking.tasks.dashboard.EmptyContentNode;
import org.netbeans.modules.bugtracking.tasks.dashboard.QueryNode;
import org.netbeans.modules.bugtracking.tasks.dashboard.Refreshable;
import org.netbeans.modules.team.commons.treelist.AsynchronousNode;
import org.netbeans.modules.team.commons.treelist.LinkButton;
import org.netbeans.modules.team.commons.treelist.TreeLabel;
import org.netbeans.modules.team.commons.treelist.TreeListNode;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class RepositoryNode
extends AsynchronousNode<Collection<QueryImpl>>
implements Comparable<RepositoryNode>,
Refreshable {
    private final RepositoryImpl repository;
    private List<QueryNode> queryNodes;
    private List<QueryNode> filteredQueryNodes;
    private boolean refresh;
    private JPanel panel;
    private TreeLabel lblName;
    private final Object LOCK = new Object();
    private LinkButton btnRefresh;
    private LinkButton btnSearch;
    private LinkButton btnCreateTask;
    private LinkButton btnAddQuery;
    private Actions.CloseRepositoryNodeAction closeRepositoryAction;
    private Actions.OpenRepositoryNodeAction openRepositoryAction;
    private Map<String, QueryNode> queryNodesMap;
    private RepositoryListener repositoryListener;

    public RepositoryNode(RepositoryImpl repository) {
        this(repository, true);
    }

    public RepositoryNode(RepositoryImpl repository, boolean opened) {
        super(opened, null, repository.getDisplayName());
        this.repository = repository;
        this.refresh = false;
        this.queryNodesMap = new HashMap<String, QueryNode>();
        this.repositoryListener = new RepositoryListener();
    }

    protected Collection<QueryImpl> load() {
        if (this.refresh && this.queryNodes != null) {
            for (QueryNode queryNode : this.queryNodes) {
                queryNode.refreshContent();
            }
            this.refresh = false;
        }
        return this.getQueries();
    }

    protected void configure(JComponent component, Color foreground, Color background, boolean isSelected, boolean hasFocus, int rowWidth) {
        this.lblName.setText(DashboardUtils.getRepositoryDisplayText(this));
        this.lblName.setForeground(foreground);
    }

    protected JComponent createComponent(Collection<QueryImpl> data) {
        if (this.isOpened()) {
            this.updateNodes(data);
            this.setExpanded(true);
        }
        this.panel = new JPanel(new GridBagLayout());
        this.panel.setOpaque(false);
        JLabel iconLabel = new JLabel(this.getIcon());
        if (!this.isOpened()) {
            iconLabel.setEnabled(false);
        }
        this.panel.add((Component)iconLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0));
        this.lblName = new TreeLabel(this.getRepository().getDisplayName());
        this.panel.add((Component)this.lblName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 3), 0, 0));
        this.panel.add((Component)new JLabel(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        if (this.isOpened()) {
            this.btnRefresh = new LinkButton((Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugtracking/tasks/resources/refresh.png", (boolean)true), (Action)Actions.RefreshAction.createAction(new TreeListNode[]{this}));
            this.btnRefresh.setToolTipText(NbBundle.getMessage(CategoryNode.class, (String)"LBL_Refresh"));
            this.panel.add((Component)this.btnRefresh, new GridBagConstraints(9, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 3, 0, 0), 0, 0));
            this.btnSearch = new LinkButton((Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugtracking/tasks/resources/search_repo.png", (boolean)true), (Action)new Actions.QuickSearchAction(this));
            this.btnSearch.setToolTipText(NbBundle.getMessage(CategoryNode.class, (String)"LBL_SearchInRepo"));
            this.panel.add((Component)this.btnSearch, new GridBagConstraints(8, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 3, 0, 0), 0, 0));
            this.btnAddQuery = new LinkButton((Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugtracking/tasks/resources/add_query.png", (boolean)true), (Action)new Actions.CreateQueryAction(this));
            this.btnAddQuery.setToolTipText(NbBundle.getMessage(CategoryNode.class, (String)"LBL_CreateQuery"));
            this.btnAddQuery.setEnabled(!BugtrackingManager.isLocalConnectorID(this.getRepository().getConnectorId()));
            this.panel.add((Component)this.btnAddQuery, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 3, 0, 0), 0, 0));
            this.btnCreateTask = new LinkButton((Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugtracking/tasks/resources/add_task.png", (boolean)true), (Action)new Actions.CreateTaskAction(this));
            this.btnCreateTask.setToolTipText(NbBundle.getMessage(CategoryNode.class, (String)"LBL_CreateTask"));
            this.panel.add((Component)this.btnCreateTask, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 3, 0, 0), 0, 0));
        }
        return this.panel;
    }

    protected void attach() {
        super.attach();
        this.repository.addPropertyChangeListener(this.repositoryListener);
    }

    protected void dispose() {
        super.dispose();
        this.getRepository().removePropertyChangeListener(this.repositoryListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<TreeListNode> createChildren() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.filteredQueryNodes == null) {
                return new ArrayList<TreeListNode>(0);
            }
            DashboardViewer dashboard = DashboardViewer.getInstance();
            if (!this.filteredQueryNodes.isEmpty()) {
                List<QueryNode> filteredNodes = this.filteredQueryNodes;
                for (QueryNode queryNode : filteredNodes) {
                    boolean expand = dashboard.isNodeExpanded((TreeListNode)queryNode);
                    queryNode.setExpanded(expand);
                }
                Collections.sort(filteredNodes);
                return new ArrayList<QueryNode>(filteredNodes);
            }
            ArrayList<TreeListNode> children = new ArrayList<TreeListNode>();
            children.add((TreeListNode)new EmptyContentNode((TreeListNode)this, NbBundle.getMessage(RepositoryNode.class, (String)"LBL_NoQuery")));
            return children;
        }
    }

    private void updateNodes() {
        this.updateNodes(this.getQueries());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNodes(Collection<QueryImpl> queries) {
        Object object = this.LOCK;
        synchronized (object) {
            this.queryNodes = new ArrayList<QueryNode>();
            this.filteredQueryNodes = new ArrayList<QueryNode>();
            HashSet<String> keys = new HashSet<String>(this.queryNodesMap.keySet());
            for (QueryImpl query : queries) {
                QueryNode queryNode = this.queryNodesMap.get(query.getDisplayName());
                keys.remove(query.getDisplayName());
                if (queryNode == null) {
                    queryNode = new QueryNode(query, (TreeListNode)this);
                    this.queryNodesMap.put(query.getDisplayName(), queryNode);
                }
                queryNode.updateContent();
                this.queryNodes.add(queryNode);
                if (queryNode.getFilteredTaskCount() <= 0 && DashboardViewer.getInstance().expandNodes()) continue;
                this.filteredQueryNodes.add(queryNode);
            }
            for (String key : keys) {
                this.queryNodesMap.remove(key);
            }
        }
    }

    public final RepositoryImpl getRepository() {
        return this.repository;
    }

    public boolean isOpened() {
        return true;
    }

    public final Action[] getPopupActions() {
        List<TreeListNode> selectedNodes = DashboardViewer.getInstance().getSelectedNodes();
        RepositoryNode[] repositoryNodes = new RepositoryNode[selectedNodes.size()];
        boolean justRepositories = true;
        for (int i = 0; i < selectedNodes.size(); ++i) {
            TreeListNode treeListNode = selectedNodes.get(i);
            if (!(treeListNode instanceof RepositoryNode)) {
                justRepositories = false;
                break;
            }
            repositoryNodes[i] = (RepositoryNode)treeListNode;
        }
        ArrayList<Action> actions = new ArrayList<Action>();
        if (justRepositories) {
            actions.addAll(Actions.getRepositoryPopupActions(repositoryNodes));
            Action repositoryAction = this.getRepositoryAction(repositoryNodes);
            if (repositoryAction != null) {
                actions.add(null);
                actions.add(repositoryAction);
            }
        }
        actions.add(null);
        actions.addAll(Actions.getDefaultActions(selectedNodes.toArray(new TreeListNode[selectedNodes.size()])));
        return actions.toArray(new Action[actions.size()]);
    }

    private Action getRepositoryAction(RepositoryNode ... repositoryNodes) {
        boolean allOpened = true;
        boolean allClosed = true;
        for (RepositoryNode repositoryNode : repositoryNodes) {
            if (repositoryNode.isOpened()) {
                allClosed = false;
                continue;
            }
            allOpened = false;
        }
        if (allOpened) {
            if (this.closeRepositoryAction == null) {
                this.closeRepositoryAction = new Actions.CloseRepositoryNodeAction(repositoryNodes);
            }
            return this.closeRepositoryAction;
        }
        if (allClosed) {
            if (this.openRepositoryAction == null) {
                this.openRepositoryAction = new Actions.OpenRepositoryNodeAction(repositoryNodes);
            }
            return this.openRepositoryAction;
        }
        return null;
    }

    public List<QueryNode> getQueryNodes() {
        return this.queryNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getFilteredQueryCount() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.filteredQueryNodes != null ? this.filteredQueryNodes.size() : 0;
        }
    }

    public int getFilterHits() {
        if (this.filteredQueryNodes == null) {
            return 0;
        }
        int hits = 0;
        for (QueryNode queryNode : this.filteredQueryNodes) {
            hits += queryNode.getFilteredTaskCount();
        }
        return hits;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepositoryNode other = (RepositoryNode)obj;
        return this.repository.getId().equalsIgnoreCase(other.repository.getId());
    }

    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + (this.repository != null ? this.repository.hashCode() : 0);
        return hash;
    }

    @Override
    public int compareTo(RepositoryNode toCompare) {
        if (this.isOpened() != toCompare.isOpened()) {
            return this.isOpened() ? -1 : 1;
        }
        return this.repository.getDisplayName().compareToIgnoreCase(toCompare.repository.getDisplayName());
    }

    public String toString() {
        return this.repository.getDisplayName();
    }

    void updateContent(boolean initPaging) {
        this.updateNodes();
        if (initPaging) {
            this.initPaging();
        }
        this.refreshChildren();
    }

    Collection<QueryImpl> getQueries() {
        return this.repository.getQueries();
    }

    ImageIcon getIcon() {
        Image icon = this.repository.getIcon();
        ImageIcon imageIcon = icon == null ? ImageUtilities.loadImageIcon((String)"org/netbeans/modules/bugtracking/tasks/resources/remote_repo.png", (boolean)true) : new ImageIcon(icon);
        return imageIcon;
    }

    @Override
    public void refreshContent() {
        this.refresh = true;
        this.refresh();
    }

    private void initPaging() {
        for (QueryNode queryNode : this.queryNodes) {
            queryNode.initPaging();
        }
    }

    private class RepositoryListener
    implements PropertyChangeListener {
        private RepositoryListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Map attributes;
            String displayName;
            if (evt.getPropertyName().equals("bugtracking.repository.queries.changed")) {
                RepositoryNode.this.updateContent(false);
            } else if (evt.getPropertyName().equals("bugtracking.repository.attributes.changed") && evt.getNewValue() instanceof Map && (displayName = (String)(attributes = (Map)evt.getNewValue()).get("repository.attribute.displayName")) != null && !displayName.isEmpty() && RepositoryNode.this.lblName != null) {
                RepositoryNode.this.lblName.setText(displayName);
                RepositoryNode.this.fireContentChanged();
            }
        }
    }
}

