/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.RepositoryRegistry;
import org.netbeans.modules.bugtracking.spi.IssueFinder;

public class IssueFinderUtils {
    private IssueFinderUtils() {
    }

    public static Collection<IssueFinder> getIssueFinders() {
        LinkedList<IssueFinder> ret = new LinkedList<IssueFinder>();
        if (RepositoryRegistry.getInstance().isInitializing()) {
            return Collections.EMPTY_LIST;
        }
        Collection<RepositoryImpl> repos = RepositoryRegistry.getInstance().getKnownRepositories(false);
        for (RepositoryImpl r : repos) {
            IssueFinder issueFinder = r.getIssueFinder();
            if (issueFinder == null) continue;
            ret.add(issueFinder);
        }
        return ret;
    }

    public static int[] getIssueSpans(String text) {
        Collection<IssueFinder> issueFinders = IssueFinderUtils.getIssueFinders();
        if (issueFinders.isEmpty()) {
            return new int[0];
        }
        int[] result = null;
        int issueFindersWithResults = 0;
        for (IssueFinder issueFinder : issueFinders) {
            int[] subresult = issueFinder.getIssueSpans(text);
            boolean resultsValid = IssueFinderUtils.checkIssueSpans(subresult, text.length(), issueFinder);
            if (!resultsValid || subresult.length == 0) continue;
            if (++issueFindersWithResults == 1) {
                result = subresult;
            }
            if (result == null || result.length < 2) continue;
            break;
        }
        return result != null ? result : new int[]{};
    }

    public static List<HyperlinkSpanInfo> getIssueSpansExt(String text) {
        Collection<IssueFinder> issueFinders = IssueFinderUtils.getIssueFinders();
        if (issueFinders.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<HyperlinkSpanInfo> result = new ArrayList<HyperlinkSpanInfo>(4);
        int issueFindersWithResults = 0;
        for (IssueFinder issueFinder : issueFinders) {
            int[] subresult = issueFinder.getIssueSpans(text);
            boolean resultsValid = IssueFinderUtils.checkIssueSpans(subresult, text.length(), issueFinder);
            if (!resultsValid || subresult.length == 0) continue;
            ++issueFindersWithResults;
            for (int i = 0; i < subresult.length; i += 2) {
                result.add(new HyperlinkSpanInfo(issueFinder, subresult[i], subresult[i + 1]));
            }
        }
        return result;
    }

    public static String getIssueId(String issueHyperlinkText) {
        IssueFinder issueFinder = IssueFinderUtils.determineIssueFinder(issueHyperlinkText, 0, issueHyperlinkText.length());
        if (issueFinder == null) {
            return null;
        }
        return issueFinder.getIssueId(issueHyperlinkText);
    }

    public static IssueFinder determineIssueFinder(String text, int startOffset, int endOffset) {
        Collection<IssueFinder> issueFinders = IssueFinderUtils.getIssueFinders();
        for (IssueFinder issueFinder : issueFinders) {
            int[] spans = issueFinder.getIssueSpans(text);
            if (!IssueFinderUtils.checkSpansContainsPair(spans, startOffset, endOffset)) continue;
            return issueFinder;
        }
        return null;
    }

    private static boolean checkSpansContainsPair(int[] spans, int startOffset, int endOffset) {
        for (int i = 0; i < spans.length; i += 2) {
            if (spans[i] != startOffset || spans[i + 1] != endOffset) continue;
            return true;
        }
        return false;
    }

    private static int[] append(int[] arr1, int[] arr2) {
        int[] result = new int[arr1.length + arr2.length];
        System.arraycopy(arr1, 0, result, 0, arr1.length);
        System.arraycopy(arr2, 0, result, arr1.length, arr2.length);
        return result;
    }

    private static boolean checkIssueSpans(int[] spans, int textLength, IssueFinder issueFinder) {
        if (spans == null) {
            BugtrackingManager.LOG.log(Level.WARNING, "Issue finder {0} returned <null> from getIssueSpans(...).", issueFinder.getClass().getName());
            return false;
        }
        if (spans.length % 2 != 0) {
            BugtrackingManager.LOG.log(Level.WARNING, "{0}Issue finder  returned array containing odd number of  elements from method getIssueSpans().", issueFinder.getClass().getName());
            return false;
        }
        int index = 0;
        while (index < spans.length) {
            int low = spans[index++];
            int high = spans[index++];
            if (low < 0 || high < 0) {
                BugtrackingManager.LOG.log(Level.WARNING, "Issue finder {0} returned invalid data from method getIssueSpans() (negative index).", issueFinder.getClass().getName());
                return false;
            }
            if (low >= high) {
                BugtrackingManager.LOG.log(Level.WARNING, "Issue finder {0} returned invalid data from method getIssueSpans() (start >= end).", issueFinder.getClass().getName());
                return false;
            }
            if (high <= textLength) continue;
            BugtrackingManager.LOG.log(Level.WARNING, "Issue finder {0} returned invalid data from method getIssueSpans() (index > text length).", issueFinder.getClass().getName());
            return false;
        }
        return true;
    }

    public static class HyperlinkSpanInfo {
        public final IssueFinder issueFinder;
        public final int startOffset;
        public final int endOffset;

        public HyperlinkSpanInfo(IssueFinder finder, int start, int end) {
            this.issueFinder = finder;
            this.startOffset = start;
            this.endOffset = end;
        }
    }
}

