/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.nette2.ui.actions;

import org.netbeans.modules.csl.api.UiUtils;
import org.netbeans.modules.php.api.editor.EditorSupport;
import org.netbeans.modules.php.api.editor.PhpClass;
import org.netbeans.modules.php.api.editor.PhpType;
import org.netbeans.modules.php.nette2.utils.EditorUtils;
import org.netbeans.modules.php.spi.framework.actions.GoToActionAction;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

class Nette2GoToActionAction
extends GoToActionAction {
    private static final int NO_OFFSET = -1;
    private final FileObject fileObject;
    private int methodOffset = -1;

    public Nette2GoToActionAction(FileObject fileObject) {
        this.fileObject = fileObject;
    }

    public boolean goToAction() {
        boolean result = false;
        FileObject action = EditorUtils.getAction(this.fileObject);
        if (action != null) {
            UiUtils.open((FileObject)action, (int)this.getActionMethodOffset(action));
            result = true;
        }
        return result;
    }

    private int getActionMethodOffset(FileObject action) {
        String actionMethodName = EditorUtils.getActionName(this.fileObject);
        String renderMethodName = EditorUtils.getRenderName(this.fileObject);
        EditorSupport editorSupport = (EditorSupport)Lookup.getDefault().lookup(EditorSupport.class);
        for (PhpClass phpClass : editorSupport.getClasses(action)) {
            if (!phpClass.getName().endsWith("Presenter")) continue;
            this.methodOffset(actionMethodName, phpClass);
            this.methodOffset(renderMethodName, phpClass);
            return this.methodOffset == -1 ? phpClass.getOffset() : this.methodOffset;
        }
        return 0;
    }

    private void methodOffset(String methodName, PhpClass phpClass) {
        if (methodName != null && this.methodOffset == -1) {
            for (PhpType.Method method : phpClass.getMethods()) {
                if (!methodName.equals(method.getName())) continue;
                this.methodOffset = method.getOffset();
            }
        }
    }
}

