/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.completion.model;

import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.modules.javafx2.editor.completion.beans.FxDefinition;
import org.netbeans.modules.javafx2.editor.completion.beans.FxEvent;
import org.netbeans.modules.javafx2.editor.completion.model.FxNode;
import org.netbeans.modules.javafx2.editor.completion.model.FxNodeVisitor;
import org.netbeans.modules.javafx2.editor.completion.model.HasContent;
import org.netbeans.modules.javafx2.editor.completion.model.PropertySetter;

public final class EventHandler
extends FxNode
implements HasContent {
    private String event;
    private Object content;
    private boolean methodRef;
    private ElementHandle<ExecutableElement> handler;
    private FxEvent eventInfo;

    EventHandler(String eventName) {
        this.event = eventName;
    }

    EventHandler asMethodRef() {
        this.methodRef = true;
        return this;
    }

    void addContent(CharSequence content) {
        this.content = PropertySetter.addCharContent(this.content, content);
    }

    public String getEvent() {
        return this.event;
    }

    @Override
    public CharSequence getContent() {
        if (this.methodRef) {
            return null;
        }
        return this.doGetContent();
    }

    public boolean hasContent() {
        return this.content != null;
    }

    private CharSequence doGetContent() {
        CharSequence s = PropertySetter.getValContent(this.content);
        if (s != this.content) {
            this.content = s;
        }
        return s;
    }

    @CheckForNull
    public FxEvent getEventInfo() {
        return this.eventInfo;
    }

    @Override
    public FxNode.Kind getKind() {
        return FxNode.Kind.Event;
    }

    @Override
    public void accept(FxNodeVisitor v) {
        v.visitEvent(this);
    }

    @Override
    public String getSourceName() {
        return "on" + Character.toUpperCase(this.event.charAt(0)) + this.event.substring(1);
    }

    public CharSequence getHandlerName() {
        if (!this.methodRef) {
            return null;
        }
        return this.doGetContent();
    }

    void setEventInfo(FxEvent info) {
        this.eventInfo = info;
    }

    void setHandler(ElementHandle<ExecutableElement> handler) {
        this.handler = handler;
    }

    public boolean isScript() {
        return !this.methodRef;
    }

    public ElementHandle<ExecutableElement> getHandler() {
        return this.handler;
    }

    @Override
    void resolve(ElementHandle nameHandle, TypeMirrorHandle typeHandle, ElementHandle<TypeElement> sourceTypeHandle, FxDefinition info) {
        this.eventInfo = (FxEvent)info;
        this.setHandler((ElementHandle<ExecutableElement>)nameHandle);
    }
}

