/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.remote;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.web.common.remote.Bundle;
import org.netbeans.modules.web.common.remote.RemoteFilesCache;
import org.netbeans.modules.web.common.spi.RemoteFSDecorator;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.StatusDecorator;
import org.openide.util.Lookup;

public class RemoteFS
extends AbstractFileSystem {
    private static RemoteFS DEFAULT = new RemoteFS();
    private final Map<String, URL> urlCache = new HashMap<String, URL>();
    private final StatusDecorator status;

    private RemoteFS() {
        this.list = new RemoteList();
        this.info = new RemoteInfo();
        this.attr = new RemoteAttributes();
        RemoteFSDecorator rfsd = (RemoteFSDecorator)Lookup.getDefault().lookup(RemoteFSDecorator.class);
        if (rfsd != null) {
            rfsd.setDefaultDecorator(new RemoteStatus());
            this.status = rfsd;
        } else {
            this.status = new RemoteStatus();
        }
    }

    public static RemoteFS getDefault() {
        return DEFAULT;
    }

    public String getDisplayName() {
        return Bundle.RemoteFSDisplayName();
    }

    public boolean isReadOnly() {
        return true;
    }

    public AbstractFileSystem.List getList() {
        return this.list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL getURLforName(String name) {
        Map<String, URL> map = this.urlCache;
        synchronized (map) {
            return this.urlCache.get(name);
        }
    }

    private FileObject getDelegateFor(String name) {
        return this.getDelegateFor(name, true);
    }

    private FileObject getDelegateFor(String name, boolean asynchronous) {
        URL url = this.getURLforName(name);
        if (url == null) {
            return null;
        }
        try {
            return RemoteFilesCache.getDefault().getRemoteFile(url, asynchronous);
        }
        catch (IOException ex) {
            return null;
        }
    }

    private String getNameFrom(URL url) {
        String surl = url.toExternalForm();
        if (surl.substring(0, 7).equalsIgnoreCase("http://")) {
            surl = surl.substring(7);
        } else if (surl.substring(0, 8).equalsIgnoreCase("https://")) {
            surl = surl.substring(8);
        }
        surl = surl.replace('/', '_');
        surl = surl.replace('\\', '_');
        return surl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject getFileForURL(URL url) {
        String surl = this.getNameFrom(url);
        FileObject fo = this.getRoot().getFileObject(surl, "");
        if (fo != null) {
            return fo;
        }
        Map<String, URL> map = this.urlCache;
        synchronized (map) {
            this.urlCache.put(surl, url);
        }
        this.getRoot().refresh();
        return this.getRoot().getFileObject(surl, "");
    }

    public StatusDecorator getDecorator() {
        return this.status;
    }

    private class RemoteStatus
    implements StatusDecorator {
        RemoteStatus() {
        }

        public String annotateNameHtml(String name, Set<? extends FileObject> files) {
            return null;
        }

        public String annotateName(String name, Set<? extends FileObject> files) {
            int n = files.size();
            if (n == 1) {
                FileObject fo = files.iterator().next();
                if (fo.isRoot()) {
                    return Bundle.LBL_RemoteFiles();
                }
                URL url = RemoteFS.this.getURLforName(fo.getNameExt());
                String path = url.getPath();
                int index = path.lastIndexOf(47);
                int index2 = path.lastIndexOf(92);
                if (index2 >= 0) {
                    index = index < 0 ? index2 : Math.max(index, index2);
                }
                if (index != -1) {
                    name = path.substring(index + 1);
                }
                return name;
            }
            int index = name.lastIndexOf(47);
            int index2 = name.lastIndexOf(92);
            if (index2 >= 0) {
                index = index < 0 ? index2 : Math.max(index, index2);
            }
            if (index != -1) {
                name = name.substring(index + 1);
            }
            return name;
        }
    }

    private class RemoteAttributes
    implements AbstractFileSystem.Attr {
        RemoteAttributes() {
        }

        public Object readAttribute(String name, String attrName) {
            if ("java.io.File".equals(attrName)) {
                return null;
            }
            FileObject fo = RemoteFS.this.getDelegateFor(name);
            if (fo != null) {
                return fo.getAttribute(attrName);
            }
            return null;
        }

        public void writeAttribute(String name, String attrName, Object value) throws IOException {
            FileObject fo = RemoteFS.this.getDelegateFor(name);
            if (fo == null) {
                throw new IOException("Did not find '" + name + "'");
            }
            fo.setAttribute(attrName, value);
        }

        public Enumeration<String> attributes(String name) {
            FileObject fo = RemoteFS.this.getDelegateFor(name);
            if (fo != null) {
                return fo.getAttributes();
            }
            return Collections.enumeration(Collections.EMPTY_LIST);
        }

        public void renameAttributes(String oldName, String newName) {
            throw new UnsupportedOperationException("Not supported.");
        }

        public void deleteAttributes(String name) {
            FileObject fo = RemoteFS.this.getDelegateFor(name);
            if (fo != null) {
                Enumeration attributes = fo.getAttributes();
                for (String attr : Collections.list(attributes)) {
                    try {
                        fo.setAttribute(attr, null);
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private class RemoteInfo
    implements AbstractFileSystem.Info {
        RemoteInfo() {
        }

        public Date lastModified(String name) {
            FileObject fo = RemoteFS.this.getDelegateFor(name);
            if (fo != null) {
                return fo.lastModified();
            }
            return new Date(0L);
        }

        public boolean folder(String name) {
            return name.isEmpty();
        }

        public boolean readOnly(String name) {
            return true;
        }

        public String mimeType(String name) {
            FileObject fo = RemoteFS.this.getDelegateFor(name);
            if (fo != null) {
                return fo.getMIMEType();
            }
            return "content/unknown";
        }

        public long size(String name) {
            FileObject fo = RemoteFS.this.getDelegateFor(name, false);
            if (fo != null) {
                return fo.getSize();
            }
            return 0L;
        }

        public InputStream inputStream(String name) throws FileNotFoundException {
            FileObject fo = RemoteFS.this.getDelegateFor(name, false);
            if (fo != null) {
                return fo.getInputStream();
            }
            throw new FileNotFoundException("Did not find '" + name + "'");
        }

        public OutputStream outputStream(String name) throws IOException {
            throw new IOException("Can not write to remote files");
        }

        public void lock(String name) throws IOException {
            throw new IOException("Can not write to remote files");
        }

        public void unlock(String name) {
        }

        public void markUnimportant(String name) {
        }
    }

    private final class RemoteList
    implements AbstractFileSystem.List,
    ChangeListener {
        RemoteList() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String[] children(String f) {
            if (f.isEmpty()) {
                String[] childrenNames;
                Map map = RemoteFS.this.urlCache;
                synchronized (map) {
                    childrenNames = RemoteFS.this.urlCache.keySet().toArray(new String[0]);
                }
                return childrenNames;
            }
            return new String[0];
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            RemoteFS.this.refreshResource("", false);
        }
    }
}

