/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.navigation;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.netbeans.api.actions.Openable;
import org.netbeans.modules.jshell.env.JShellEnvironment;
import org.netbeans.modules.jshell.model.Rng;
import org.netbeans.modules.jshell.model.SnippetHandle;
import org.netbeans.modules.jshell.navigation.Bundle;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public class OpenAction
extends AbstractAction {
    private final Openable performer;

    public OpenAction(Openable performer) {
        super(Bundle.ACTION_Open());
        this.performer = performer;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.performer.open();
    }

    @Override
    public boolean isEnabled() {
        return super.isEnabled();
    }

    public static Openable createOpener(JShellEnvironment env, SnippetHandle h) {
        return new Performer(env, h);
    }

    static class Performer
    implements Openable {
        private final JShellEnvironment env;
        private final SnippetHandle theHandle;

        public Performer(JShellEnvironment env, SnippetHandle theHandle) {
            this.env = env;
            this.theHandle = theHandle;
        }

        public void open() {
            FileObject f = this.env.getConsoleFile();
            if (!f.isValid()) {
                StatusDisplayer.getDefault().setStatusText(Bundle.ERR_CannotLocateConsole());
                return;
            }
            if (this.theHandle.getSection() == null) {
                StatusDisplayer.getDefault().setStatusText(Bundle.ERR_NoSourceForSnippet());
                return;
            }
            try {
                DataObject d = DataObject.find((FileObject)f);
                EditorCookie cake = (EditorCookie)d.getLookup().lookup(EditorCookie.class);
                cake.openDocument();
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeLater(() -> this.performOpen(cake.getOpenedPanes()));
                } else {
                    this.performOpen(cake.getOpenedPanes());
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        private void performOpen(JEditorPane[] panes) {
            if (panes == null || panes.length == 0) {
                StatusDisplayer.getDefault().setStatusText(Bundle.ERR_ShellConsoleClosed());
                return;
            }
            JEditorPane p = panes[0];
            Rng[] fragments = this.theHandle.getFragments();
            int to = fragments[0].start;
            p.requestFocus();
            int pos = Math.min(p.getDocument().getLength() - 1, to);
            p.setCaretPosition(pos);
            try {
                Rectangle r = p.modelToView(pos);
                p.scrollRectToVisible(r);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

