/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.performance.guitracker;

import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.PrintStream;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.RepaintManager;
import org.netbeans.modules.performance.guitracker.ActionTracker;

public class LoggingRepaintManager
extends RepaintManager {
    private static final long MAX_TIMEOUT = 60000L;
    private static final boolean DEBUG_MODE = false;
    private static final String OS_NAME = System.getProperty("os.name", "");
    private final ActionTracker tr;
    private RepaintManager orig = null;
    private long lastPaint = 0L;
    private boolean hasDirtyMatches = false;
    private final LinkedList<RegionFilter> regionFilters;
    public static final RegionFilter IGNORE_STATUS_LINE_FILTER = new RegionFilter(){
        private JLabel statusLabel;
        private JComponent statusPanel;
        private JComponent statusLayeredPane;

        @Override
        public boolean accept(JComponent c) {
            if (this.statusLabel == null && c instanceof JLabel && "AutoHideStatusTextLabel".equals(c.getName())) {
                this.statusLabel = (JLabel)c;
                this.statusPanel = (JComponent)c.getParent();
                this.statusLayeredPane = (JComponent)this.statusPanel.getParent();
            }
            return c != this.statusLabel && c != this.statusPanel && c != this.statusLayeredPane && !c.getClass().getName().contains("StatusLine");
        }

        @Override
        public String getFilterName() {
            return "Ignores StatusLine content";
        }
    };
    public static final RegionFilter IGNORE_EXPLORER_TREE_FILTER = new RegionFilter(){

        @Override
        public boolean accept(JComponent c) {
            String cn = c.getClass().getName();
            return !"org.openide.explorer.view.TreeView$ExplorerTree".equals(cn);
        }

        @Override
        public String getFilterName() {
            return "Ignores TreeView$ExplorerTree";
        }
    };
    public static final RegionFilter IGNORE_DIFF_SIDEBAR_FILTER = new RegionFilter(){

        @Override
        public boolean accept(JComponent c) {
            String cn = c.getClass().getName();
            return !"org.netbeans.modules.versioning.diff.DiffSidebar".equals(cn);
        }

        @Override
        public String getFilterName() {
            return "Ignores versioning.diff.DiffSidebar";
        }
    };
    public static final RegionFilter EXPLORER_FILTER = new RegionFilter(){

        @Override
        public boolean accept(JComponent c) {
            for (Class<?> clz = c.getClass(); clz != null; clz = clz.getSuperclass()) {
                if (!clz.getPackage().getName().equals("org.openide.explorer.view")) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getFilterName() {
            return "Accept paints from package: org.openide.explorer.view";
        }
    };
    public static final RegionFilter EDITOR_FILTER = new RegionFilter(){

        @Override
        public boolean accept(JComponent c) {
            return c.getClass().getName().equals("org.openide.text.QuietEditorPane");
        }

        @Override
        public String getFilterName() {
            return "Accept paints from org.openide.text.QuietEditorPane";
        }
    };

    public LoggingRepaintManager(ActionTracker tr) {
        this.tr = tr;
        this.regionFilters = new LinkedList();
        this.resetRegionFilters();
    }

    public void setEnabled(boolean val) {
        if (this.isEnabled() != val) {
            if (val) {
                this.enable();
            } else {
                this.disable();
            }
        }
    }

    public boolean isEnabled() {
        return this.orig != null;
    }

    private void enable() {
        this.orig = LoggingRepaintManager.currentManager(new JLabel());
        LoggingRepaintManager.setCurrentManager(this);
    }

    private void disable() {
        LoggingRepaintManager.setCurrentManager(this.orig);
        this.orig = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDirtyRegion(JComponent c, int x, int y, int w, int h) {
        LoggingRepaintManager loggingRepaintManager = this;
        synchronized (loggingRepaintManager) {
            String log = LoggingRepaintManager.logContainerAndItsParents(c) + ", " + x + "," + y + "," + w + "," + h + ", " + Thread.currentThread().getName();
            if (w > 11 || h > 19) {
                if (this.regionFilters != null && !this.acceptedByRegionFilters(c)) {
                    this.tr.add(50, "IGNORED DirtyRegion: " + log);
                } else {
                    this.tr.add(50, "ADD DirtyRegion: " + log);
                    this.hasDirtyMatches = true;
                }
            }
        }
        super.addDirtyRegion(c, x, y, w, h);
    }

    public static String logComponent(Component c) {
        return c.getClass().getName() + "/" + c.getName();
    }

    public static String logContainerAndItsParents(Container c) {
        return LoggingRepaintManager.logComponent(c);
    }

    public static String getContainersChain(Container container) {
        StringBuilder ret = new StringBuilder();
        while ((container = container.getParent()) != null) {
            ret.append(" <- ").append(LoggingRepaintManager.logComponent(container));
        }
        return ret.toString();
    }

    public synchronized boolean acceptedByRegionFilters(JComponent c) {
        for (RegionFilter filter : this.regionFilters) {
            if (filter.accept(c)) continue;
            return false;
        }
        return true;
    }

    public void addRegionFilter(RegionFilter filter) {
        if (filter != null) {
            this.tr.add(51, "FILTER: " + filter.getFilterName());
            this.regionFilters.add(filter);
        }
    }

    public void removeRegionFilter(RegionFilter filter) {
        if (filter != null) {
            this.tr.add(51, "REMOVE FILTER: " + filter.getFilterName());
            this.regionFilters.remove(filter);
        }
    }

    public void resetRegionFilters() {
        this.tr.add(51, "FILTER: reset");
        this.regionFilters.clear();
    }

    @Override
    public void paintDirtyRegions() {
        super.paintDirtyRegions();
        if (this.tr != null && this.hasDirtyMatches) {
            this.lastPaint = System.nanoTime();
            this.tr.add(2, "PAINTING - done");
            this.hasDirtyMatches = false;
        }
    }

    public long waitNoPaintEvent(long timeout) {
        return this.waitNoPaintEvent(timeout, false);
    }

    private long waitNoPaintEvent(long timeout, boolean afterPaint) {
        long current;
        long first = current = System.nanoTime();
        while (ActionTracker.nanoToMili(current - this.lastPaint) < timeout || this.lastPaint == 0L && afterPaint) {
            try {
                Thread.sleep(Math.min(ActionTracker.nanoToMili(current - this.lastPaint) + 20L, timeout));
            }
            catch (InterruptedException e) {
                e.printStackTrace(System.err);
            }
            if (ActionTracker.nanoToMili((current = System.nanoTime()) - first) <= 60000L) continue;
            return ActionTracker.nanoToMili(this.lastPaint);
        }
        return ActionTracker.nanoToMili(this.lastPaint);
    }

    public static long measureStartup() {
        ActionTracker tr = ActionTracker.getInstance();
        LoggingRepaintManager rm = new LoggingRepaintManager(tr);
        rm.setEnabled(true);
        tr.startNewEventList("Startup time measurement");
        long waitAfterStartup = Long.getLong("org.netbeans.performance.waitafterstartup", 10000L);
        long time = rm.waitNoPaintEvent(waitAfterStartup, true);
        String fileName = System.getProperty("org.netbeans.log.startup.logfile");
        File logFile = new File(fileName.substring(0, fileName.lastIndexOf(46)) + ".xml");
        tr.stopRecording();
        try {
            tr.exportAsXML(new PrintStream(logFile));
        }
        catch (Exception exc) {
            System.err.println("Exception rises during writing log from painting of the main window :");
            exc.printStackTrace(System.err);
        }
        rm.setEnabled(false);
        return time;
    }

    public static interface RegionFilter {
        public boolean accept(JComponent var1);

        public String getFilterName();
    }
}

