/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.html.api.HtmlDataNode;
import org.netbeans.modules.html.editor.Bundle;
import org.netbeans.modules.html.editor.api.completion.HtmlCompletionItem;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.completion.AttrValuesCompletion;
import org.netbeans.modules.html.editor.lib.api.HtmlVersion;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.html.editor.lib.api.model.HtmlModel;
import org.netbeans.modules.html.editor.lib.api.model.HtmlModelFactory;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTag;
import org.netbeans.modules.html.editor.lib.api.model.HtmlTagAttribute;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.CursorMovedSchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.web.common.api.ValueCompletion;
import org.openide.cookies.EditorCookie;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.Exceptions;

public class HtmlElementProperties {
    private static final Logger LOGGER = Logger.getLogger(HtmlElementProperties.class.getSimpleName());
    private static final Level LEVEL = Level.FINE;

    static void parsed(final HtmlParserResult result, SchedulerEvent event) {
        try {
            int caretOffset;
            FileObject file = result.getSnapshot().getSource().getFileObject();
            if (file == null) {
                LOGGER.log(LEVEL, "null file, exit");
                return;
            }
            if (!file.isValid()) {
                LOGGER.log(LEVEL, "invalid file, exit");
                return;
            }
            final DataObject dobj = DataObject.find((FileObject)file);
            org.openide.nodes.Node dataObjectNode = dobj.getNodeDelegate();
            if (!(dataObjectNode instanceof HtmlDataNode)) {
                return;
            }
            final HtmlDataNode htmlNode = (HtmlDataNode)dataObjectNode;
            if (event == null) {
                LOGGER.log(LEVEL, "run() - NULL SchedulerEvent?!?!?!");
                caretOffset = -1;
            } else if (event instanceof CursorMovedSchedulerEvent) {
                caretOffset = ((CursorMovedSchedulerEvent)event).getCaretOffset();
            } else {
                LOGGER.log(LEVEL, "run() - !(event instanceof CursorMovedSchedulerEvent)");
                caretOffset = -1;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HtmlElementProperties.runInEDT(result, htmlNode, dobj, caretOffset);
                }
            });
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static void runInEDT(HtmlParserResult result, HtmlDataNode htmlNode, DataObject dobj, int caretOffset) {
        Node node;
        EditorCookie ec = (EditorCookie)dobj.getLookup().lookup(EditorCookie.class);
        if (ec == null) {
            return;
        }
        if (caretOffset == -1) {
            JEditorPane[] panes = ec.getOpenedPanes();
            if (panes != null && panes.length > 0) {
                JEditorPane pane = panes[0];
                caretOffset = pane.getCaretPosition();
            }
            LOGGER.log(LEVEL, "workarounded caret offset: {0}", caretOffset);
        }
        if ((node = result.findBySemanticRange(caretOffset, true)) != null && node.type() == ElementType.OPEN_TAG) {
            OpenTag ot = (OpenTag)node;
            JEditorPane[] panes = ec.getOpenedPanes();
            if (panes != null && panes.length > 0) {
                htmlNode.setPropertySets(new Node.PropertySet[]{new PropertiesPropertySet(result, ot)});
            }
        }
    }

    private static String[] findTags(String tagName, String attrName) {
        ValueCompletion<HtmlCompletionItem> support = AttrValuesCompletion.getSupport(tagName, attrName);
        if (support != null && support instanceof AttrValuesCompletion.ValuesSetSupport) {
            AttrValuesCompletion.ValuesSetSupport fixedValuesSupport = (AttrValuesCompletion.ValuesSetSupport)support;
            return fixedValuesSupport.getTags();
        }
        return null;
    }

    public static class PropertyValuesEditor
    extends PropertyEditorSupport
    implements ExPropertyEditor {
        private static String NONE_PROPERTY_NAME = "<none>";
        private String[] tags;

        public PropertyValuesEditor(String[] tags) {
            this.tags = new String[tags.length + 1];
            this.tags[0] = NONE_PROPERTY_NAME;
            System.arraycopy(tags, 0, this.tags, 1, tags.length);
        }

        @Override
        public synchronized String[] getTags() {
            return this.tags;
        }

        @Override
        public void setAsText(String str) {
            if (str == null) {
                return;
            }
            if (str.isEmpty() || NONE_PROPERTY_NAME.equals(str)) {
                this.setValue(str);
                return;
            }
            this.setValue(str);
        }

        @Override
        public String getAsText() {
            return this.getValue().toString();
        }

        public void attachEnv(PropertyEnv env) {
            env.getFeatureDescriptor().setValue("canEditAsText", Boolean.TRUE);
        }
    }

    private static class NewAttributeProperty
    extends PropertySupport<String> {
        private static final String EMPTY = "";
        private String attrName;
        private Document doc;
        private Snapshot snap;
        private OpenTag ot;
        private String[] tags;

        public NewAttributeProperty(Document doc, Snapshot snap, String attrName, OpenTag ot) {
            super(attrName, String.class, attrName, Bundle.new_attribute_tooltip(), true, doc != null);
            this.doc = doc;
            this.snap = snap;
            this.ot = ot;
            this.attrName = attrName;
            this.tags = HtmlElementProperties.findTags(ot.name().toString(), attrName);
        }

        public PropertyEditor getPropertyEditor() {
            return this.tags == null ? null : new PropertyValuesEditor(this.tags);
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return EMPTY;
        }

        public void setValue(String val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val.length() == 0) {
                return;
            }
            int astFrom = this.ot.from() + 1 + this.ot.name().length();
            final int docFrom = this.snap.getOriginalOffset(astFrom);
            if (docFrom != -1) {
                final StringBuilder insertBuilder = new StringBuilder().append(' ').append(this.attrName).append('=').append('\"').append(val).append('\"');
                ((BaseDocument)this.doc).runAtomicAsUser(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (NewAttributeProperty.this.doc.getText(docFrom, 1).trim().length() != 0) {
                                insertBuilder.append(' ');
                            }
                            NewAttributeProperty.this.doc.insertString(docFrom, insertBuilder.toString(), null);
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
            }
        }
    }

    private static class AttributeProperty
    extends PropertySupport<String> {
        private Attribute attr;
        private Document doc;
        private Snapshot snap;
        private String[] tags;

        public AttributeProperty(Document doc, Snapshot snap, OpenTag openTag, Attribute attr) {
            super(attr.name().toString(), String.class, attr.name().toString(), Bundle.edit_attribute_tooltip(), true, doc != null);
            this.doc = doc;
            this.snap = snap;
            this.attr = attr;
            this.tags = HtmlElementProperties.findTags(openTag.name().toString(), attr.name().toString());
        }

        public PropertyEditor getPropertyEditor() {
            return this.tags == null ? null : new PropertyValuesEditor(this.tags);
        }

        public String getHtmlDisplayName() {
            return "<b>" + this.attr.name() + "</b>";
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return this.attr.unquotedValue().toString();
        }

        public void setValue(final String val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            int astTo;
            int astFrom;
            if (val.length() == 0) {
                astFrom = this.attr.nameOffset() - 1;
                astTo = this.attr.valueOffset() + this.attr.value().length();
            } else {
                astFrom = this.attr.valueOffset() + (this.attr.isValueQuoted() ? 1 : 0);
                astTo = astFrom + this.attr.unquotedValue().length();
            }
            final int docFrom = this.snap.getOriginalOffset(astFrom);
            final int docTo = this.snap.getOriginalOffset(astTo);
            if (docFrom != -1 && docTo != -1) {
                ((BaseDocument)this.doc).runAtomicAsUser(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AttributeProperty.this.doc.remove(docFrom, docTo - docFrom);
                            if (val.length() > 0) {
                                AttributeProperty.this.doc.insertString(docFrom, val, null);
                            }
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
            }
        }
    }

    public static class PropertiesPropertySet
    extends Node.PropertySet {
        private OpenTag openTag;
        private HtmlParserResult res;

        public PropertiesPropertySet(HtmlParserResult res, OpenTag openTag) {
            this.res = res;
            this.openTag = openTag;
            this.setName(Bundle.element_element_attributes_title());
        }

        public Node.Property<String>[] getProperties() {
            Snapshot s = this.res.getSnapshot();
            Document doc = s.getSource().getDocument(false);
            ArrayList<PropertySupport> props = new ArrayList<PropertySupport>();
            HashSet<String> existingAttrNames = new HashSet<String>();
            for (Attribute a : this.openTag.attributes()) {
                props.add(new AttributeProperty(doc, s, this.openTag, a));
                existingAttrNames.add(a.name().toString().toLowerCase(Locale.ENGLISH));
            }
            HtmlModel model = HtmlModelFactory.getModel((HtmlVersion)this.res.getHtmlVersion());
            HtmlTag tagModel = model.getTag(this.openTag.name().toString());
            if (tagModel != null) {
                ArrayList<String> attrNames = new ArrayList<String>();
                for (HtmlTagAttribute htmlTagAttr : tagModel.getAttributes()) {
                    String name = htmlTagAttr.getName().toLowerCase();
                    if (existingAttrNames.contains(name)) continue;
                    attrNames.add(name);
                }
                Collections.sort(attrNames);
                for (String attrName : attrNames) {
                    props.add(new NewAttributeProperty(doc, s, attrName, this.openTag));
                }
            }
            return props.toArray(new Node.Property[0]);
        }
    }
}

