/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.testrunner;

import java.util.Collections;
import org.netbeans.modules.gsf.testrunner.api.Status;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.gsf.testrunner.api.Trouble;
import org.netbeans.modules.gsf.testrunner.ui.api.Manager;
import org.netbeans.modules.php.project.ui.testrunner.TestSuiteImpl;
import org.netbeans.modules.php.spi.testing.locate.Locations;
import org.netbeans.modules.php.spi.testing.run.TestCase;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;

public class TestCaseImpl
implements TestCase {
    private final TestSuiteImpl testSuite;
    private final Testcase testCase;

    TestCaseImpl(TestSuiteImpl testSuite, Testcase testCase) {
        assert (testSuite != null);
        assert (testCase != null);
        this.testSuite = testSuite;
        this.testCase = testCase;
    }

    public void setClassName(String className) {
        Parameters.notWhitespace((CharSequence)"className", (CharSequence)className);
        this.testSuite.checkFrozen();
        this.testCase.setClassName(className);
    }

    public void setLocation(Locations.Line location) {
        Parameters.notNull((CharSequence)"location", (Object)location);
        this.testSuite.checkFrozen();
        this.testCase.setLocation(FileUtil.toFile((FileObject)location.getFile()).getAbsolutePath());
    }

    public void setTime(long time) {
        this.testSuite.checkFrozen();
        this.testCase.setTimeMillis(time);
        this.testSuite.updateReport(time, false);
    }

    public void setStatus(TestCase.Status status) {
        Parameters.notNull((CharSequence)"status", (Object)status);
        this.testSuite.checkFrozen();
        this.testCase.setStatus(this.map(status));
    }

    public void setFailureInfo(String message, String[] stackTrace, boolean error, TestCase.Diff diff) {
        Parameters.notNull((CharSequence)"message", (Object)message);
        Parameters.notNull((CharSequence)"stackTrace", (Object)stackTrace);
        Parameters.notNull((CharSequence)"diff", (Object)diff);
        this.testSuite.checkFrozen();
        Trouble trouble = new Trouble(error);
        trouble.setStackTrace(this.createStackTrace(message, stackTrace));
        if (diff.isValid()) {
            Trouble.ComparisonFailure failure = new Trouble.ComparisonFailure(diff.getExpected(), diff.getActual());
            trouble.setComparisonFailure(failure);
        }
        this.testCase.setTrouble(trouble);
        Manager manager = this.testSuite.getTestSession().getManager();
        TestSession session = this.testSuite.getTestSession().getTestSession();
        manager.displayOutput(session, this.getClassName() + "::" + this.testCase.getName() + "()", error);
        manager.displayOutput(session, message, error);
        this.testCase.addOutputLines(Collections.singletonList("<u>" + this.testCase.getName() + ":</u>"));
        for (String s : stackTrace) {
            manager.displayOutput(session, s, error);
            this.testCase.addOutputLines(Collections.singletonList(s.replace("<", "&lt;")));
        }
        manager.displayOutput(session, "", false);
    }

    private String[] createStackTrace(String message, String[] stackTrace) {
        String[] tmp = new String[stackTrace.length + 1];
        tmp[0] = message;
        System.arraycopy(stackTrace, 0, tmp, 1, stackTrace.length);
        return tmp;
    }

    private String getClassName() {
        String className = this.testCase.getClassName();
        if (className != null) {
            return className;
        }
        className = this.testSuite.getTestSuite().getName();
        assert (className != null);
        return className;
    }

    private Status map(TestCase.Status status) {
        return Status.valueOf((String)status.name());
    }
}

