/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.util.Collections;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.netbeans.modules.parsing.spi.indexing.BinaryIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.ConstrainedBinaryIndexer;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;

@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public final class IndexerRegistrationProcessor
extends LayerGeneratingProcessor {
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(ConstrainedBinaryIndexer.Registration.class.getCanonicalName());
    }

    protected boolean handleProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws LayerGenerationException {
        for (Element element : roundEnv.getElementsAnnotatedWith(ConstrainedBinaryIndexer.Registration.class)) {
            assert (element.getKind().isClass());
            ConstrainedBinaryIndexer.Registration reg = element.getAnnotation(ConstrainedBinaryIndexer.Registration.class);
            Elements elements = this.processingEnv.getElementUtils();
            Types types = this.processingEnv.getTypeUtils();
            TypeElement binIndexerType = elements.getTypeElement(ConstrainedBinaryIndexer.class.getName());
            if (types.isSubtype(((TypeElement)element).asType(), binIndexerType.asType())) {
                String indexerName = reg.indexerName();
                if (indexerName == null) {
                    throw new LayerGenerationException("Indexer name has to be given.", element);
                }
                LayerBuilder.File f = this.layer(new Element[]{element}).instanceFile("Editors", null, null);
                f.stringvalue("instanceClass", BinaryIndexerFactory.class.getName());
                f.methodvalue("instanceCreate", ConstrainedBinaryIndexer.class.getName(), "create");
                f.instanceAttribute("delegate", ConstrainedBinaryIndexer.class);
                if (reg.requiredResource().length > 0) {
                    f.stringvalue("requiredResource", IndexerRegistrationProcessor.list(reg.requiredResource(), element));
                }
                if (reg.mimeType().length > 0) {
                    f.stringvalue("mimeType", IndexerRegistrationProcessor.list(reg.mimeType(), element));
                }
                if (reg.namePattern().length() > 0) {
                    f.stringvalue("namePattern", reg.namePattern());
                }
                f.stringvalue("name", indexerName);
                f.intvalue("version", reg.indexVersion());
                f.write();
                continue;
            }
            throw new LayerGenerationException("Annoated element is not a  subclass of BinaryIndexer.", element);
        }
        return true;
    }

    private static String list(String[] arr, Element e) throws LayerGenerationException {
        if (arr.length == 1) {
            return arr[0];
        }
        StringBuilder sb = new StringBuilder();
        for (String s : arr) {
            if (s.indexOf(44) >= 0) {
                throw new LayerGenerationException("',' is not allowed in the text", e);
            }
            sb.append(s).append(",");
        }
        return sb.substring(0, sb.length() - 1);
    }
}

