/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.project.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.libraries.LibrariesCustomizer;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.java.project.ui.Bundle;
import org.netbeans.modules.java.project.ui.FixPlatform;
import org.netbeans.modules.java.project.ui.FixProjectSourceLevel;
import org.netbeans.modules.java.project.ui.ProfileProblemsProviderImpl;
import org.netbeans.spi.java.project.support.ProjectPlatform;
import org.netbeans.spi.java.project.support.ui.BrokenReferencesSupport;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.support.ant.ui.VariablesSupport;
import org.netbeans.spi.project.ui.ProjectProblemResolver;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.spi.project.ui.support.ProjectProblemsProviderSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class ProjectProblemsProviders {
    static final String PLAT_PROP_ANT_NAME = "platform.ant.name";
    private static final Logger LOG = Logger.getLogger(ProjectProblemsProviders.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(ProjectProblemsProviders.class);

    private ProjectProblemsProviders() {
        throw new IllegalStateException(String.format("The %s cannot be instantiated.", this.getClass().getName()));
    }

    @NonNull
    public static ProjectProblemsProvider createReferenceProblemProvider(@NonNull AntProjectHelper projectHelper, @NonNull ReferenceHelper referenceHelper, @NonNull PropertyEvaluator evaluator, @NullAllowed BrokenReferencesSupport.PlatformUpdatedCallBack callback, @NonNull String[] properties, @NonNull String[] platformProperties) {
        ReferenceProblemProviderImpl pp = new ReferenceProblemProviderImpl(projectHelper, evaluator, referenceHelper, callback, properties, platformProperties);
        pp.attachListeners();
        return pp;
    }

    @NonNull
    public static ProjectProblemsProvider createPlatformVersionProblemProvider(@NonNull AntProjectHelper helper, @NonNull PropertyEvaluator evaluator, @NullAllowed BrokenReferencesSupport.PlatformUpdatedCallBack hook, @NonNull String platformType, @NonNull SpecificationVersion minimalVersion, @NonNull String platformProperty, String ... platformVersionProperties) {
        PlatformVersionProblemProviderImpl pp = new PlatformVersionProblemProviderImpl(helper, evaluator, hook, platformType, minimalVersion, platformProperty, platformVersionProperties);
        pp.attachListeners();
        return pp;
    }

    @NonNull
    public static ProjectProblemsProvider createProfileProblemProvider(@NonNull AntProjectHelper antProjectHelper, @NonNull ReferenceHelper refHelper, @NonNull PropertyEvaluator evaluator, @NonNull String profileProperty, String ... classPathProperties) {
        return new ProfileProblemsProviderImpl(antProjectHelper, refHelper, evaluator, profileProperty, classPathProperties);
    }

    @NonNull
    static Future<ProjectProblemsProvider.Result> future(@NullAllowed ProjectProblemsProvider.Result result) {
        return new Done(result);
    }

    @NonNull
    private static Set<? extends ProjectProblemsProvider.ProjectProblem> getReferenceProblems(@NullAllowed AntProjectHelper helper, @NullAllowed PropertyEvaluator evaluator, @NullAllowed ReferenceHelper refHelper, @NonNull String[] ps, @NullAllowed Collection<? super File> files, boolean abortAfterFirstProblem) {
        Map entries;
        LinkedHashSet<ProjectProblemsProvider.ProjectProblem> set = new LinkedHashSet<ProjectProblemsProvider.ProjectProblem>();
        StringBuilder all = new StringBuilder();
        LibraryManager.getDefault().getLibraries();
        if (helper == null || evaluator == null || refHelper == null) {
            return set;
        }
        ArrayDeque<FileResolver> fileReoslvers = new ArrayDeque<FileResolver>();
        EditableProperties ep = helper.getProperties("nbproject/project.properties");
        for (String p : ps) {
            String[] vals;
            String prop = evaluator.getProperty(p);
            if (prop == null) continue;
            LOG.log(Level.FINE, "Evaluated {0}={1}", new Object[]{p, prop});
            for (String v : vals = PropertyUtils.tokenizePath((String)prop)) {
                String val;
                if (!(v.startsWith("${file.reference.") || v.startsWith("${project.") || v.startsWith("${libs.") && v.endsWith(".classpath}") || v.startsWith("${var."))) {
                    all.append(v);
                    continue;
                }
                if (v.startsWith("${project.")) {
                    val = v.substring(2, v.indexOf(125));
                    set.add(ProjectProblemsProvider.ProjectProblem.createError((String)ProjectProblemsProviders.getDisplayName(RefType.PROJECT, val), (String)ProjectProblemsProviders.getDescription(RefType.PROJECT, val), (ProjectProblemResolver)new ProjectResolver(val, helper)));
                } else {
                    ProjectProblemsProvider.ProjectProblem problem;
                    val = v.substring(2, v.length() - 1);
                    if (v.startsWith("${file.reference")) {
                        FileResolver fr = new FileResolver(val, helper, fileReoslvers);
                        fileReoslvers.offer(fr);
                        problem = ProjectProblemsProvider.ProjectProblem.createError((String)ProjectProblemsProviders.getDisplayName(RefType.FILE, val), (String)ProjectProblemsProviders.getDescription(RefType.FILE, val), (ProjectProblemResolver)fr);
                    } else if (v.startsWith("${var")) {
                        problem = ProjectProblemsProvider.ProjectProblem.createError((String)ProjectProblemsProviders.getDisplayName(RefType.VARIABLE, v), (String)ProjectProblemsProviders.getDescription(RefType.VARIABLE, v), (ProjectProblemResolver)new VariableResolver(RefType.VARIABLE, v));
                    } else {
                        if (val.equals("libs.junit.classpath")) continue;
                        problem = ProjectProblemsProvider.ProjectProblem.createError((String)ProjectProblemsProviders.getDisplayName(RefType.LIBRARY, val), (String)ProjectProblemsProviders.getDescription(RefType.LIBRARY, val), (ProjectProblemResolver)new LibraryResolver(RefType.LIBRARY, val, refHelper));
                    }
                    set.add(problem);
                }
                if (abortAfterFirstProblem) break;
            }
            if (set.size() > 0 && abortAfterFirstProblem) break;
            String path = ep.getProperty(p);
            if (path == null) continue;
            for (String v : PropertyUtils.tokenizePath((String)path)) {
                String value;
                if (v.startsWith("${file.reference.")) {
                    v = ep.getProperty(v.substring(2, v.length() - 1));
                }
                if (v == null || !v.startsWith("${var.") || (value = evaluator.evaluate(v)).startsWith("${var.")) continue;
                File f = ProjectProblemsProviders.getFile(helper, evaluator, value);
                if (files != null) {
                    files.add(f);
                }
                if (f.exists()) continue;
                set.add(ProjectProblemsProvider.ProjectProblem.createError((String)ProjectProblemsProviders.getDisplayName(RefType.VARIABLE_CONTENT, v), (String)ProjectProblemsProviders.getDescription(RefType.VARIABLE_CONTENT, v), (ProjectProblemResolver)new VariableResolver(RefType.VARIABLE_CONTENT, v)));
            }
        }
        if ((entries = evaluator.getProperties()) == null) {
            throw new IllegalArgumentException("Properies mapping could not be computed (e.g. due to a circular definition). Evaluator: " + evaluator.toString());
        }
        for (Map.Entry entry : entries.entrySet()) {
            String unevaluatedValue;
            boolean alreadyChecked;
            File f;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key.startsWith("project.")) {
                if ("project.license".equals(key)) continue;
                f = ProjectProblemsProviders.getFile(helper, evaluator, value);
                if (files != null) {
                    files.add(f);
                }
                if (f.exists() || all.indexOf(value) == -1) continue;
                set.add(ProjectProblemsProvider.ProjectProblem.createError((String)ProjectProblemsProviders.getDisplayName(RefType.PROJECT, key), (String)ProjectProblemsProviders.getDescription(RefType.PROJECT, key), (ProjectProblemResolver)new ProjectResolver(key, helper)));
                continue;
            }
            if (!key.startsWith("file.reference")) continue;
            f = ProjectProblemsProviders.getFile(helper, evaluator, value);
            if (files != null) {
                files.add(f);
            }
            boolean bl = alreadyChecked = (unevaluatedValue = ep.getProperty(key)) != null ? unevaluatedValue.startsWith("${var.") : false;
            if (f.exists() || all.indexOf(value) == -1 || alreadyChecked) continue;
            FileResolver fr = new FileResolver(key, helper, fileReoslvers);
            fileReoslvers.offer(fr);
            set.add(ProjectProblemsProvider.ProjectProblem.createError((String)ProjectProblemsProviders.getDisplayName(RefType.FILE, key), (String)ProjectProblemsProviders.getDescription(RefType.FILE, key), (ProjectProblemResolver)fr));
        }
        HashSet<String> usedLibraries = new HashSet<String>();
        Pattern libPattern = Pattern.compile("\\$\\{(libs\\.[-._a-zA-Z0-9]+\\.classpath)\\}");
        for (String p : ps) {
            String propertyValue = ep.getProperty(p);
            if (propertyValue == null) continue;
            for (String v : PropertyUtils.tokenizePath((String)propertyValue)) {
                Matcher m = libPattern.matcher(v);
                if (!m.matches()) continue;
                usedLibraries.add(m.group(1));
            }
        }
        block6: for (String libraryRef : usedLibraries) {
            String libraryName = libraryRef.substring(5, libraryRef.length() - 10);
            Library lib = refHelper.findLibrary(libraryName);
            if (lib == null) {
                if (libraryName.equals("junit")) continue;
                set.add(ProjectProblemsProvider.ProjectProblem.createError((String)ProjectProblemsProviders.getDisplayName(RefType.LIBRARY, libraryRef), (String)ProjectProblemsProviders.getDescription(RefType.LIBRARY, libraryRef), (ProjectProblemResolver)new LibraryResolver(RefType.LIBRARY, libraryRef, refHelper)));
                continue;
            }
            for (URI uri : lib.getURIContent("classpath")) {
                FileObject fo;
                URI uri2 = LibrariesSupport.getArchiveFile((URI)uri);
                if (uri2 == null) {
                    uri2 = uri;
                }
                if (null != (fo = LibrariesSupport.resolveLibraryEntryFileObject((URL)lib.getManager().getLocation(), (URI)uri2)) || ProjectProblemsProviders.canResolveEvaluatedUri(helper.getStandardPropertyEvaluator(), lib.getManager().getLocation(), uri2)) continue;
                set.add(ProjectProblemsProvider.ProjectProblem.createError((String)ProjectProblemsProviders.getDisplayName(RefType.LIBRARY_CONTENT, libraryRef), (String)ProjectProblemsProviders.getDescription(RefType.LIBRARY_CONTENT, libraryRef), (ProjectProblemResolver)new LibraryResolver(RefType.LIBRARY_CONTENT, libraryRef, refHelper)));
                continue block6;
            }
        }
        return set;
    }

    @NonNull
    private static Set<ProjectProblemsProvider.ProjectProblem> getPlatformProblems(@NullAllowed PropertyEvaluator evaluator, @NonNull AntProjectHelper helper, @NullAllowed BrokenReferencesSupport.PlatformUpdatedCallBack callback, @NonNull String[] platformProperties, boolean abortAfterFirstProblem) {
        LinkedHashSet<ProjectProblemsProvider.ProjectProblem> set = new LinkedHashSet<ProjectProblemsProvider.ProjectProblem>();
        if (evaluator == null) {
            return set;
        }
        for (String pprop : platformProperties) {
            String prop = evaluator.getProperty(pprop);
            if (prop == null) continue;
            if (!ProjectProblemsProviders.existPlatform(FileOwnerQuery.getOwner((FileObject)helper.getProjectDirectory()), evaluator, prop)) {
                if (evaluator.getProperty(pprop + ".description") != null) {
                    prop = evaluator.getProperty(pprop + ".description");
                }
                set.add(ProjectProblemsProvider.ProjectProblem.createError((String)ProjectProblemsProviders.getDisplayName(RefType.PLATFORM, prop), (String)ProjectProblemsProviders.getDescription(RefType.PLATFORM, prop), (ProjectProblemResolver)new PlatformResolver(prop, pprop, null, evaluator, helper, callback)));
            }
            if (set.size() > 0 && abortAfterFirstProblem) break;
        }
        return set;
    }

    private static File getFile(AntProjectHelper helper, PropertyEvaluator evaluator, String name) {
        if (helper != null) {
            return new File(helper.resolvePath(name));
        }
        File f = new File(name);
        if (!f.exists()) {
            String basedir = evaluator.getProperty("basedir");
            assert (basedir != null);
            f = new File(new File(basedir), name);
        }
        return f;
    }

    private static boolean canResolveEvaluatedUri(PropertyEvaluator eval, URL libBase, URI libUri) {
        if (libUri.isAbsolute()) {
            return false;
        }
        String path = LibrariesSupport.convertURIToFilePath((URI)libUri);
        String newPath = eval.evaluate(path);
        if (newPath.equals(path)) {
            return false;
        }
        URI newUri = LibrariesSupport.convertFilePathToURI((String)newPath);
        return null != LibrariesSupport.resolveLibraryEntryFileObject((URL)libBase, (URI)newUri);
    }

    private static boolean existPlatform(@NullAllowed Project prj, @NonNull PropertyEvaluator eval, @NonNull String platform) {
        if (platform.equals("default_platform")) {
            return true;
        }
        for (JavaPlatform plat : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            if (!platform.equals(plat.getProperties().get(PLAT_PROP_ANT_NAME))) continue;
            return plat.isValid();
        }
        return prj == null ? false : ProjectPlatform.forProject((Project)prj, (PropertyEvaluator)eval, (String)"j2se") != null;
    }

    @NonNull
    private static String getDisplayName(@NonNull RefType type, @NonNull String id) {
        switch (type) {
            case LIBRARY: {
                return Bundle.LBL_BrokenLinksCustomizer_BrokenLibrary(ProjectProblemsProviders.getDisplayId(type, id));
            }
            case DEFINABLE_LIBRARY: {
                return Bundle.LBL_BrokenLinksCustomizer_BrokenDefinableLibrary(ProjectProblemsProviders.getDisplayId(type, id));
            }
            case LIBRARY_CONTENT: {
                return Bundle.LBL_BrokenLinksCustomizer_BrokenLibraryContent(ProjectProblemsProviders.getDisplayId(type, id));
            }
            case PROJECT: {
                return Bundle.LBL_BrokenLinksCustomizer_BrokenProjectReference(ProjectProblemsProviders.getDisplayId(type, id));
            }
            case FILE: {
                return Bundle.LBL_BrokenLinksCustomizer_BrokenFileReference(ProjectProblemsProviders.getDisplayId(type, id));
            }
            case PLATFORM: {
                return Bundle.LBL_BrokenLinksCustomizer_BrokenPlatform(ProjectProblemsProviders.getDisplayId(type, id));
            }
            case VARIABLE: {
                return Bundle.LBL_BrokenLinksCustomizer_BrokenVariable(ProjectProblemsProviders.getDisplayId(type, id));
            }
            case VARIABLE_CONTENT: {
                return Bundle.LBL_BrokenLinksCustomizer_BrokenVariableContent(ProjectProblemsProviders.getDisplayId(type, id));
            }
        }
        assert (false);
        return id;
    }

    private static String getDescription(@NonNull RefType type, @NonNull String id) {
        switch (type) {
            case LIBRARY: {
                return Bundle.LBL_BrokenLinksCustomizer_BrokenLibraryDesc(ProjectProblemsProviders.getDisplayId(type, id));
            }
            case DEFINABLE_LIBRARY: {
                return Bundle.LBL_BrokenLinksCustomizer_BrokenDefinableLibraryDesc(ProjectProblemsProviders.getDisplayId(type, id));
            }
            case LIBRARY_CONTENT: {
                return Bundle.LBL_BrokenLinksCustomizer_BrokenLibraryContentDesc(ProjectProblemsProviders.getDisplayId(type, id));
            }
            case PROJECT: {
                return Bundle.LBL_BrokenLinksCustomizer_BrokenProjectReferenceDesc(ProjectProblemsProviders.getDisplayId(type, id));
            }
            case FILE: {
                return Bundle.LBL_BrokenLinksCustomizer_BrokenFileReferenceDesc(ProjectProblemsProviders.getDisplayId(type, id));
            }
            case PLATFORM: {
                return Bundle.LBL_BrokenLinksCustomizer_BrokenPlatformDesc(ProjectProblemsProviders.getDisplayId(type, id));
            }
            case VARIABLE: {
                return Bundle.LBL_BrokenLinksCustomizer_BrokenVariableReferenceDesc(ProjectProblemsProviders.getDisplayId(type, id));
            }
            case VARIABLE_CONTENT: {
                return Bundle.LBL_BrokenLinksCustomizer_BrokenVariableContent(ProjectProblemsProviders.getDisplayId(type, id));
            }
        }
        assert (false);
        return id;
    }

    private static String getDisplayId(@NonNull RefType type, @NonNull String id) {
        switch (type) {
            case LIBRARY: 
            case DEFINABLE_LIBRARY: 
            case LIBRARY_CONTENT: {
                return id.substring(5, id.length() - 10);
            }
            case PROJECT: {
                return id.substring(8);
            }
            case FILE: {
                return id.substring(15);
            }
            case PLATFORM: {
                return id;
            }
            case VARIABLE: {
                return id.substring(6, id.indexOf(125));
            }
            case VARIABLE_CONTENT: {
                return id.substring(6, id.indexOf(125)) + id.substring(id.indexOf(125) + 1);
            }
        }
        assert (false);
        return id;
    }

    private static class OpenManagersWeakListener
    extends WeakReference<PropertyChangeListener>
    implements Runnable,
    PropertyChangeListener {
        public OpenManagersWeakListener(PropertyChangeListener listener) {
            super(listener, Utilities.activeReferenceQueue());
        }

        @Override
        public void run() {
            LibraryManager.removeOpenManagersPropertyChangeListener((PropertyChangeListener)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PropertyChangeListener listener = (PropertyChangeListener)this.get();
            if (listener != null) {
                listener.propertyChange(evt);
            }
        }
    }

    private static final class PlatformVersionProblemProviderImpl
    implements ProjectProblemsProvider,
    PropertyChangeListener {
        private final ProjectProblemsProviderSupport problemsProviderSupport = new ProjectProblemsProviderSupport((Object)this);
        private final AtomicBoolean listenersInitialized = new AtomicBoolean();
        private final AntProjectHelper helper;
        private final PropertyEvaluator eval;
        private final BrokenReferencesSupport.PlatformUpdatedCallBack hook;
        private final String platformType;
        private final SpecificationVersion minimalVersion;
        private final String platformProp;
        private final Set<String> versionProps;

        PlatformVersionProblemProviderImpl(@NonNull AntProjectHelper helper, @NonNull PropertyEvaluator eval, @NullAllowed BrokenReferencesSupport.PlatformUpdatedCallBack hook, @NonNull String platformType, @NonNull SpecificationVersion minimalVersion, @NonNull String platformProp, String ... versionProps) {
            assert (helper != null);
            assert (eval != null);
            assert (platformType != null);
            assert (minimalVersion != null);
            assert (platformProp != null);
            assert (versionProps != null);
            this.helper = helper;
            this.eval = eval;
            this.hook = hook;
            this.platformType = platformType;
            this.minimalVersion = minimalVersion;
            this.platformProp = platformProp;
            this.versionProps = new HashSet<String>(Arrays.asList(versionProps));
        }

        public void addPropertyChangeListener(@NonNull PropertyChangeListener listener) {
            Parameters.notNull((CharSequence)"listener", (Object)listener);
            this.problemsProviderSupport.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(@NonNull PropertyChangeListener listener) {
            Parameters.notNull((CharSequence)"listener", (Object)listener);
            this.problemsProviderSupport.removePropertyChangeListener(listener);
        }

        public Collection<? extends ProjectProblemsProvider.ProjectProblem> getProblems() {
            return this.problemsProviderSupport.getProblems(() -> {
                Collection currentProblems = (Collection)ProjectManager.mutex().readAccess(() -> {
                    ArrayList invalidVersionProps;
                    JavaPlatform activePlatform = this.getActivePlatform();
                    SpecificationVersion platformVersion = activePlatform == null ? null : activePlatform.getSpecification().getVersion();
                    SpecificationVersion minVersion = this.getInvalidJdkVersion(platformVersion, invalidVersionProps = new ArrayList(this.versionProps.size()));
                    if (minVersion != null) {
                        return Collections.singleton(ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.LBL_Invalid_JDK_Version(), (String)Bundle.HINT_Invalid_JDK_Vernsion(), (ProjectProblemResolver)new SourceTargetResolver(this.helper, this.hook, this.platformType, this.platformProp, invalidVersionProps, minVersion, platformVersion, this.minimalVersion)));
                    }
                    invalidVersionProps.clear();
                    if (this.getOutdatedJdkVersion(invalidVersionProps, this.minimalVersion)) {
                        return Collections.singleton(ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.LBL_Unsupported_Source(), (String)Bundle.HINT_Unsupported_Source(this.minimalVersion), (ProjectProblemResolver)new UpgradeSourceTargetResolver(this.helper, invalidVersionProps, this.minimalVersion)));
                    }
                    return Collections.emptySet();
                });
                return currentProblems;
            });
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if (propName == null || this.platformProp.equals(propName) || this.versionProps.contains(propName)) {
                this.problemsProviderSupport.fireProblemsChange();
            }
        }

        void attachListeners() {
            if (!this.listenersInitialized.compareAndSet(false, true)) {
                throw new IllegalStateException();
            }
            this.eval.addPropertyChangeListener((PropertyChangeListener)this);
        }

        @CheckForNull
        private SpecificationVersion getInvalidJdkVersion(@NullAllowed SpecificationVersion platformVersion, @NonNull Collection<? super String> invalidVersionProps) {
            SpecificationVersion minVersion = null;
            if (platformVersion != null) {
                for (String vp : this.versionProps) {
                    String value = this.eval.getProperty(vp);
                    if (value == null || value.isEmpty()) continue;
                    try {
                        SpecificationVersion vpVersion = new SpecificationVersion(value);
                        if (vpVersion.compareTo((Object)platformVersion) <= 0) continue;
                        invalidVersionProps.add(vp);
                        minVersion = this.max(minVersion, vpVersion);
                    }
                    catch (NumberFormatException nfe) {
                        LOG.log(Level.WARNING, "Property: {0} holds non valid version: {1}", new Object[]{vp, value});
                    }
                }
            }
            return minVersion;
        }

        private boolean getOutdatedJdkVersion(@NonNull Collection<? super String> invalidVersionProps, @NonNull SpecificationVersion minVersion) {
            boolean res = false;
            for (String vp : this.versionProps) {
                String value = this.eval.getProperty(vp);
                if (value == null || value.isEmpty()) continue;
                try {
                    SpecificationVersion vpVersion = new SpecificationVersion(value);
                    if (vpVersion.compareTo((Object)minVersion) >= 0) continue;
                    invalidVersionProps.add(vp);
                    res = true;
                }
                catch (NumberFormatException nfe) {
                    LOG.log(Level.WARNING, "Property: {0} holds non valid version: {1}", new Object[]{vp, value});
                }
            }
            return res;
        }

        @CheckForNull
        private SpecificationVersion max(@NullAllowed SpecificationVersion a, @NullAllowed SpecificationVersion b) {
            if (a == null) {
                return b;
            }
            if (b == null) {
                return a;
            }
            if (a.compareTo((Object)b) >= 0) {
                return a;
            }
            return b;
        }

        @CheckForNull
        private JavaPlatform getActivePlatform() {
            JavaPlatform[] installedPlatforms;
            String activePlatformId = this.eval.getProperty(this.platformProp);
            JavaPlatformManager pm = JavaPlatformManager.getDefault();
            if (activePlatformId == null) {
                return pm.getDefaultPlatform();
            }
            for (JavaPlatform javaPlatform : installedPlatforms = pm.getPlatforms(null, new Specification(this.platformType, null))) {
                String antName = (String)javaPlatform.getProperties().get(ProjectProblemsProviders.PLAT_PROP_ANT_NAME);
                if (!activePlatformId.equals(antName)) continue;
                return javaPlatform;
            }
            return null;
        }
    }

    private static final class ReferenceProblemProviderImpl
    implements ProjectProblemsProvider,
    PropertyChangeListener,
    FileChangeListener {
        private final ProjectProblemsProviderSupport problemsProviderSupport = new ProjectProblemsProviderSupport((Object)this);
        private final AtomicBoolean listenersInitialized = new AtomicBoolean();
        private final AntProjectHelper helper;
        private final PropertyEvaluator eval;
        private final ReferenceHelper refHelper;
        private final BrokenReferencesSupport.PlatformUpdatedCallBack callback;
        private final String[] refProps;
        private final String[] platformProps;
        private final Set<File> currentFiles;
        private Map<URL, Object[]> activeLibManLocs;

        ReferenceProblemProviderImpl(@NonNull AntProjectHelper helper, @NonNull PropertyEvaluator eval, @NonNull ReferenceHelper refHelper, @NullAllowed BrokenReferencesSupport.PlatformUpdatedCallBack callback, @NonNull String[] refProps, @NonNull String[] platformProps) {
            assert (helper != null);
            assert (eval != null);
            assert (refHelper != null);
            assert (refProps != null);
            assert (platformProps != null);
            this.helper = helper;
            this.eval = eval;
            this.refHelper = refHelper;
            this.callback = callback;
            this.refProps = Arrays.copyOf(refProps, refProps.length);
            this.platformProps = Arrays.copyOf(platformProps, platformProps.length);
            this.currentFiles = new HashSet<File>();
        }

        public void addPropertyChangeListener(@NonNull PropertyChangeListener listener) {
            Parameters.notNull((CharSequence)"listener", (Object)listener);
            this.problemsProviderSupport.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(@NonNull PropertyChangeListener listener) {
            Parameters.notNull((CharSequence)"listener", (Object)listener);
            this.problemsProviderSupport.removePropertyChangeListener(listener);
        }

        public Collection<? extends ProjectProblemsProvider.ProjectProblem> getProblems() {
            return this.problemsProviderSupport.getProblems(new ProjectProblemsProviderSupport.ProblemsCollector(){

                public Collection<? extends ProjectProblemsProvider.ProjectProblem> collectProblems() {
                    Collection currentProblems = (Collection)ProjectManager.mutex().readAccess(() -> {
                        LinkedHashSet newProblems = new LinkedHashSet();
                        HashSet allFiles = new HashSet();
                        newProblems.addAll(ProjectProblemsProviders.getReferenceProblems(helper, eval, refHelper, refProps, allFiles, false));
                        newProblems.addAll(ProjectProblemsProviders.getPlatformProblems(eval, helper, callback, platformProps, false));
                        this.updateFileListeners(allFiles);
                        return Collections.unmodifiableSet(newProblems);
                    });
                    return currentProblems;
                }
            });
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("openManagers".equals(evt.getPropertyName())) {
                this.addLibraryManagerListener();
            }
            this.problemsProviderSupport.fireProblemsChange();
        }

        public void fileDataCreated(FileEvent fe) {
            this.problemsProviderSupport.fireProblemsChange();
        }

        public void fileFolderCreated(FileEvent fe) {
            this.problemsProviderSupport.fireProblemsChange();
        }

        public void fileDeleted(FileEvent fe) {
            this.problemsProviderSupport.fireProblemsChange();
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.problemsProviderSupport.fireProblemsChange();
        }

        public void fileChanged(FileEvent fe) {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        void attachListeners() {
            if (!this.listenersInitialized.compareAndSet(false, true)) {
                throw new IllegalStateException();
            }
            this.eval.addPropertyChangeListener((PropertyChangeListener)this);
            JavaPlatformManager.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)JavaPlatformManager.getDefault()));
            LibraryManager.addOpenManagersPropertyChangeListener((PropertyChangeListener)new OpenManagersWeakListener(this));
            this.addLibraryManagerListener();
        }

        private synchronized void updateFileListeners(@NonNull Collection<? extends File> newFiles) {
            HashSet<? extends File> toAdd = new HashSet<File>(newFiles);
            toAdd.removeAll(this.currentFiles);
            HashSet<File> toRemove = new HashSet<File>(this.currentFiles);
            toRemove.removeAll(newFiles);
            for (File file : toRemove) {
                FileUtil.removeFileChangeListener((FileChangeListener)this, (File)file);
            }
            for (File file : toAdd) {
                FileUtil.addFileChangeListener((FileChangeListener)this, (File)file);
            }
            this.currentFiles.addAll(toAdd);
            this.currentFiles.removeAll(toRemove);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addLibraryManagerListener() {
            HashMap<URL, Object[]> oldLMs;
            boolean attachToDefault;
            ReferenceProblemProviderImpl referenceProblemProviderImpl = this;
            synchronized (referenceProblemProviderImpl) {
                boolean bl = attachToDefault = this.activeLibManLocs == null;
                if (attachToDefault) {
                    this.activeLibManLocs = new HashMap<URL, Object[]>();
                }
                oldLMs = new HashMap<URL, Object[]>(this.activeLibManLocs);
            }
            if (attachToDefault) {
                LibraryManager manager = LibraryManager.getDefault();
                manager.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)manager));
            }
            Collection managers = LibraryManager.getOpenManagers();
            HashMap<URL, LibraryManager> managerByLocation = new HashMap<URL, LibraryManager>();
            for (Object manager : managers) {
                URL url = manager.getLocation();
                if (url == null) continue;
                managerByLocation.put(url, (LibraryManager)manager);
            }
            HashMap<URL, Object[]> toRemove = new HashMap<URL, Object[]>(oldLMs);
            toRemove.keySet().removeAll(managerByLocation.keySet());
            for (Object[] pair : toRemove.values()) {
                ((LibraryManager)pair[0]).removePropertyChangeListener((PropertyChangeListener)pair[1]);
            }
            managerByLocation.keySet().removeAll(oldLMs.keySet());
            HashMap toAdd = new HashMap();
            for (Map.Entry e : managerByLocation.entrySet()) {
                LibraryManager manager = (LibraryManager)e.getValue();
                PropertyChangeListener listener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)manager);
                manager.addPropertyChangeListener(listener);
                toAdd.put(e.getKey(), new Object[]{manager, listener});
            }
            ReferenceProblemProviderImpl referenceProblemProviderImpl2 = this;
            synchronized (referenceProblemProviderImpl2) {
                this.activeLibManLocs.keySet().removeAll(toRemove.keySet());
                this.activeLibManLocs.putAll(toAdd);
            }
        }
    }

    private static final class Done
    implements Future<ProjectProblemsProvider.Result> {
        private final ProjectProblemsProvider.Result result;

        Done(@NonNull ProjectProblemsProvider.Result result) {
            Parameters.notNull((CharSequence)"result", (Object)result);
            this.result = result;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public ProjectProblemsProvider.Result get() throws InterruptedException, ExecutionException {
            return this.result;
        }

        @Override
        public ProjectProblemsProvider.Result get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.get();
        }
    }

    private static class UpgradeSourceTargetResolver
    implements ProjectProblemResolver {
        private final AntProjectHelper helper;
        private final Collection<? extends String> invalidVersionProps;
        private final SpecificationVersion minSourceVersion;

        UpgradeSourceTargetResolver(@NonNull AntProjectHelper helper, @NonNull Collection<? extends String> invalidVersionProps, @NonNull SpecificationVersion minSourceVersion) {
            assert (helper != null);
            assert (invalidVersionProps != null);
            assert (minSourceVersion != null);
            this.helper = helper;
            this.invalidVersionProps = invalidVersionProps;
            this.minSourceVersion = minSourceVersion;
        }

        public Future<ProjectProblemsProvider.Result> resolve() {
            final Project project = FileOwnerQuery.getOwner((FileObject)this.helper.getProjectDirectory());
            Object option = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)Bundle.MSG_UpgradeSourceLevel(this.minSourceVersion), Bundle.TITLE_UpgradeSourceLevel(ProjectUtils.getInformation((Project)project).getDisplayName()), 2, 3));
            if (option == NotifyDescriptor.OK_OPTION) {
                return RP.submit((Callable)new Callable<ProjectProblemsProvider.Result>(){

                    @Override
                    @NonNull
                    public ProjectProblemsProvider.Result call() throws Exception {
                        return (ProjectProblemsProvider.Result)ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<ProjectProblemsProvider.Result>(){

                            @NonNull
                            public ProjectProblemsProvider.Result run() {
                                try {
                                    EditableProperties ep = helper.getProperties("nbproject/project.properties");
                                    for (String prop : invalidVersionProps) {
                                        ep.setProperty(prop, minSourceVersion.toString());
                                    }
                                    helper.putProperties("nbproject/project.properties", ep);
                                    ProjectManager.getDefault().saveProject(project);
                                    return ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.RESOLVED);
                                }
                                catch (IOException ioe) {
                                    return ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED, (String)ioe.getMessage());
                                }
                            }
                        });
                    }
                });
            }
            return new Done(ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED));
        }
    }

    private static class SourceTargetResolver
    implements ProjectProblemResolver {
        private final String type;
        private final String platformProp;
        private final Collection<? extends String> invalidVersionProps;
        private final SpecificationVersion minVersion;
        private final SpecificationVersion platformVersion;
        private final SpecificationVersion minProjectSupportedVersion;
        private final Reference<AntProjectHelper> helperRef;
        private final BrokenReferencesSupport.PlatformUpdatedCallBack hook;

        SourceTargetResolver(@NonNull AntProjectHelper helper, @NullAllowed BrokenReferencesSupport.PlatformUpdatedCallBack hook, @NonNull String type, @NonNull String platformProp, @NonNull Collection<? extends String> invalidVersionProps, @NonNull SpecificationVersion minVersion, @NonNull SpecificationVersion platformVersion, @NonNull SpecificationVersion minProjectSupportedVersion) {
            Parameters.notNull((CharSequence)"helper", (Object)helper);
            Parameters.notNull((CharSequence)"type", (Object)type);
            Parameters.notNull((CharSequence)"platformProp", (Object)platformProp);
            Parameters.notNull((CharSequence)"invalidVersionProps", invalidVersionProps);
            Parameters.notNull((CharSequence)"minVersion", (Object)minVersion);
            Parameters.notNull((CharSequence)"platformVersion", (Object)platformVersion);
            Parameters.notNull((CharSequence)"minProjectSupportedVersion", (Object)minProjectSupportedVersion);
            this.helperRef = new WeakReference<AntProjectHelper>(helper);
            this.hook = hook;
            this.type = type;
            this.platformProp = platformProp;
            this.invalidVersionProps = invalidVersionProps;
            this.minVersion = minVersion;
            this.platformVersion = platformVersion;
            this.minProjectSupportedVersion = minProjectSupportedVersion;
        }

        public Future<ProjectProblemsProvider.Result> resolve() {
            AntProjectHelper helper = this.helperRef.get();
            if (helper != null) {
                Project project = FileOwnerQuery.getOwner((FileObject)helper.getProjectDirectory());
                FixProjectSourceLevel changeVersion = new FixProjectSourceLevel(this.type, this.minVersion, this.platformVersion, this.minProjectSupportedVersion);
                DialogDescriptor dd = new DialogDescriptor((Object)changeVersion, Bundle.LBL_ResolveJDKVersion(ProjectUtils.getInformation((Project)project).getDisplayName()));
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == DialogDescriptor.OK_OPTION) {
                    Callable<ProjectProblemsProvider.Result> resultFnc = () -> (ProjectProblemsProvider.Result)ProjectManager.mutex().writeAccess(() -> {
                        String antName;
                        if (changeVersion.isDowngradeLevel()) {
                            EditableProperties props = helper.getProperties("nbproject/project.properties");
                            for (String string : this.invalidVersionProps) {
                                props.put(string, this.platformVersion.toString());
                            }
                            helper.putProperties("nbproject/project.properties", props);
                            ProjectManager.getDefault().saveProject(FileOwnerQuery.getOwner((FileObject)helper.getProjectDirectory()));
                            return ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.RESOLVED);
                        }
                        JavaPlatform jp = changeVersion.getSelectedPlatform();
                        if (jp != null && (antName = (String)jp.getProperties().get(ProjectProblemsProviders.PLAT_PROP_ANT_NAME)) != null) {
                            EditableProperties editableProperties = helper.getProperties("nbproject/project.properties");
                            editableProperties.setProperty(this.platformProp, antName);
                            helper.putProperties("nbproject/project.properties", editableProperties);
                            if (this.hook != null) {
                                this.hook.platformPropertyUpdated(jp);
                            }
                            ProjectManager.getDefault().saveProject(project);
                            return ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.RESOLVED);
                        }
                        return ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED);
                    });
                    FutureTask<ProjectProblemsProvider.Result> result = new FutureTask<ProjectProblemsProvider.Result>(resultFnc);
                    RP.post(result);
                    return result;
                }
            }
            return new Done(ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED));
        }

        public boolean equals(Object other) {
            return other instanceof SourceTargetResolver;
        }

        public int hashCode() {
            return 17;
        }
    }

    private static class FileResolver
    extends ReferenceResolver {
        private final Queue<? extends FileResolver> peers;
        private ProjectProblemsProvider.Status resolved = ProjectProblemsProvider.Status.UNRESOLVED;

        FileResolver(@NonNull String id, @NonNull AntProjectHelper antProjectHelper, @NonNull Queue<? extends FileResolver> peers) {
            super(RefType.FILE, id, antProjectHelper);
            this.peers = peers;
        }

        @NonNull
        public Future<ProjectProblemsProvider.Result> resolve() {
            int option;
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(2);
            chooser.setDialogTitle(Bundle.LBL_BrokenLinksCustomizer_Resolve_File(ProjectProblemsProviders.getDisplayId(this.type, this.id)));
            if (lastSelectedFile != null) {
                chooser.setSelectedFile(lastSelectedFile);
            }
            if ((option = chooser.showOpenDialog(null)) == 0) {
                this.updateReference(chooser.getSelectedFile());
                lastSelectedFile = chooser.getSelectedFile();
                this.resolved = ProjectProblemsProvider.Status.RESOLVED;
            }
            return new Done(ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)this.resolved));
        }

        @Override
        void updateReference(@NonNull File file) {
            this.updateReferenceImpl(file);
            File parentFolder = file.getParentFile();
            for (FileResolver fileResolver : this.peers) {
                File f;
                if (this == fileResolver || fileResolver.resolved != ProjectProblemsProvider.Status.UNRESOLVED || !(f = new File(parentFolder, ProjectProblemsProviders.getDisplayId(this.type, this.id))).exists()) continue;
                this.updateReferenceImpl(f);
            }
        }
    }

    private static class ProjectResolver
    extends ReferenceResolver {
        ProjectResolver(@NonNull String id, @NonNull AntProjectHelper antProjectHelper) {
            super(RefType.PROJECT, id, antProjectHelper);
        }

        @NonNull
        public Future<ProjectProblemsProvider.Result> resolve() {
            int option;
            ProjectProblemsProvider.Status result = ProjectProblemsProvider.Status.UNRESOLVED;
            JFileChooser chooser = ProjectChooser.projectChooser();
            chooser.setDialogTitle(Bundle.LBL_BrokenLinksCustomizer_Resolve_Project(ProjectProblemsProviders.getDisplayId(this.type, this.id)));
            if (lastSelectedFile != null) {
                chooser.setSelectedFile(lastSelectedFile);
            }
            if ((option = chooser.showOpenDialog(null)) == 0) {
                this.updateReference(chooser.getSelectedFile());
                lastSelectedFile = chooser.getSelectedFile();
                result = ProjectProblemsProvider.Status.RESOLVED;
            }
            return new Done(ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)result));
        }

        @Override
        void updateReference(@NonNull File file) {
            this.updateReferenceImpl(file);
        }
    }

    private static abstract class ReferenceResolver
    extends BaseResolver {
        static File lastSelectedFile;
        private final Reference<AntProjectHelper> antProjectHelper;

        ReferenceResolver(@NonNull RefType type, @NonNull String id, @NonNull AntProjectHelper antProjectHelper) {
            super(type, id);
            this.antProjectHelper = new WeakReference<AntProjectHelper>(antProjectHelper);
        }

        abstract void updateReference(@NonNull File var1);

        final void updateReferenceImpl(@NonNull File file) {
            Project p;
            final String reference = this.id;
            final AntProjectHelper helper = this.antProjectHelper.get();
            if (helper == null) {
                return;
            }
            FileObject myProjDirFO = helper.getProjectDirectory();
            String propertiesFile = "nbproject/private/private.properties";
            final String path = file.getAbsolutePath();
            try {
                p = ProjectManager.getDefault().findProject(myProjDirFO);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                p = null;
            }
            final Project proj = p;
            ProjectManager.mutex().postWriteRequest(new Runnable(){

                @Override
                public void run() {
                    EditableProperties props = helper.getProperties("nbproject/private/private.properties");
                    if (!path.equals(props.getProperty(reference))) {
                        props.setProperty(reference, path);
                        helper.putProperties("nbproject/private/private.properties", props);
                    }
                    if (proj != null) {
                        try {
                            ProjectManager.getDefault().saveProject(proj);
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            });
        }
    }

    private static class VariableResolver
    extends BaseResolver {
        VariableResolver(@NonNull RefType type, @NonNull String id) {
            super(type, id);
        }

        @NonNull
        public Future<ProjectProblemsProvider.Result> resolve() {
            VariablesSupport.showVariablesCustomizer();
            return new Done(ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.RESOLVED));
        }
    }

    private static class LibraryResolver
    extends BaseResolver {
        private final Callable<Library> definer;
        private final Reference<ReferenceHelper> refHelper;

        LibraryResolver(@NonNull RefType type, @NonNull String id, @NonNull ReferenceHelper refHelper) {
            this(LibraryResolver.translate(type, id), id, refHelper);
        }

        private LibraryResolver(@NonNull Object[] typeDefiner, @NonNull String id, @NonNull ReferenceHelper refHelper) {
            super((RefType)((Object)typeDefiner[0]), id);
            this.definer = (Callable)typeDefiner[1];
            this.refHelper = new WeakReference<ReferenceHelper>(refHelper);
        }

        @NonNull
        public Future<ProjectProblemsProvider.Result> resolve() {
            if (this.type == RefType.DEFINABLE_LIBRARY) {
                return this.resolveByDefiner();
            }
            return new Done(ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)this.resolveByLibraryManager()));
        }

        private ProjectProblemsProvider.Status resolveByLibraryManager() {
            LibraryManager lm = this.getProjectLibraryManager();
            if (lm == null) {
                return ProjectProblemsProvider.Status.UNRESOLVED;
            }
            LibrariesCustomizer.showCustomizer(null, (LibraryManager)lm);
            return ProjectProblemsProvider.Status.RESOLVED;
        }

        private Future<ProjectProblemsProvider.Result> resolveByDefiner() {
            assert (this.definer != null);
            FutureTask<ProjectProblemsProvider.Result> future = new FutureTask<ProjectProblemsProvider.Result>(new Callable<ProjectProblemsProvider.Result>(){

                @Override
                public ProjectProblemsProvider.Result call() throws Exception {
                    ProjectProblemsProvider.Status result = ProjectProblemsProvider.Status.UNRESOLVED;
                    try {
                        Library lib = (Library)definer.call();
                        LOG.log(Level.FINE, "found {0}", lib);
                        result = ProjectProblemsProvider.Status.RESOLVED;
                    }
                    catch (Exception x) {
                        LOG.log(Level.INFO, null, x);
                        result = this.resolveByLibraryManager();
                    }
                    return ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)result);
                }
            });
            RP.post(future);
            return future;
        }

        @CheckForNull
        private LibraryManager getProjectLibraryManager() {
            ReferenceHelper rh = this.refHelper.get();
            return rh == null ? null : (rh.getProjectLibraryManager() != null ? rh.getProjectLibraryManager() : LibraryManager.getDefault());
        }

        @NonNull
        private static Object[] translate(@NonNull RefType original, @NonNull String id) {
            Callable<Library> _definer = null;
            if (original == RefType.LIBRARY) {
                String name = id.substring(5, id.length() - 10);
                for (BrokenReferencesSupport.LibraryDefiner ld : Lookup.getDefault().lookupAll(BrokenReferencesSupport.LibraryDefiner.class)) {
                    _definer = ld.missingLibrary(name);
                    if (_definer == null) continue;
                    return new Object[]{RefType.DEFINABLE_LIBRARY, _definer};
                }
            }
            return new Object[]{original, null};
        }
    }

    private static class PlatformResolver
    extends BaseResolver {
        private final String propertyName;
        private final String platformType;
        private final PropertyEvaluator eval;
        private final AntProjectHelper helper;
        private final BrokenReferencesSupport.PlatformUpdatedCallBack callback;

        PlatformResolver(@NonNull String id, @NonNull String propertyName, @NullAllowed String platformType, @NonNull PropertyEvaluator eval, @NonNull AntProjectHelper helper, @NullAllowed BrokenReferencesSupport.PlatformUpdatedCallBack callback) {
            super(RefType.PLATFORM, id);
            Parameters.notNull((CharSequence)"propertyName", (Object)propertyName);
            Parameters.notNull((CharSequence)"eval", (Object)eval);
            Parameters.notNull((CharSequence)"helper", (Object)helper);
            this.propertyName = propertyName;
            this.platformType = platformType;
            this.eval = eval;
            this.helper = helper;
            this.callback = callback;
        }

        @NonNull
        public Future<ProjectProblemsProvider.Result> resolve() {
            JButton ok = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)ok, (String)Bundle.LBL_OK());
            FixPlatform fixPlatform = new FixPlatform(this.propertyName, this.id, this.platformType, this.eval, this.helper, this.callback, ok);
            DialogDescriptor dd = new DialogDescriptor((Object)fixPlatform, Bundle.TXT_FixBrokenPlatform(), true, new Object[]{ok, DialogDescriptor.CANCEL_OPTION}, (Object)ok, 0, null, null);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == ok) {
                return fixPlatform.resolve();
            }
            return new Done(ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED));
        }
    }

    private static abstract class BaseResolver
    implements ProjectProblemResolver {
        protected final RefType type;
        protected final String id;

        BaseResolver(@NonNull RefType type, @NonNull String id) {
            Parameters.notNull((CharSequence)"type", (Object)((Object)type));
            Parameters.notNull((CharSequence)"id", (Object)id);
            this.type = type;
            this.id = id;
        }

        public final int hashCode() {
            int result = 17;
            result = 31 * result + this.type.hashCode();
            result = 31 * result + this.id.hashCode();
            return result;
        }

        public final boolean equals(@NullAllowed Object other) {
            if (!(other instanceof BaseResolver)) {
                return false;
            }
            BaseResolver otherResolver = (BaseResolver)other;
            return this.type.equals((Object)otherResolver.type) && this.id.equals(otherResolver.id);
        }

        public String toString() {
            return String.format("Resolver for %s %s", new Object[]{this.type, this.id});
        }
    }

    private static enum RefType {
        PROJECT,
        FILE,
        PLATFORM,
        LIBRARY,
        DEFINABLE_LIBRARY,
        LIBRARY_CONTENT,
        VARIABLE,
        VARIABLE_CONTENT;

    }
}

