/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.SelectionAwareListCellRenderer;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MergeableLineMarkerInfo<T extends PsiElement>
extends LineMarkerInfo<T> {
    private static final Logger LOG = Logger.getInstance(MergeableLineMarkerInfo.class);

    public MergeableLineMarkerInfo(@NotNull T element, @NotNull TextRange textRange, Icon icon, int updatePass, @Nullable Function<? super T, String> tooltipProvider, @Nullable GutterIconNavigationHandler<T> navHandler, @NotNull GutterIconRenderer.Alignment alignment) {
        if (element == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(0);
        }
        if (textRange == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(1);
        }
        if (alignment == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(2);
        }
        super(element, textRange, icon, updatePass, tooltipProvider, navHandler, alignment);
    }

    public abstract boolean canMergeWith(@NotNull MergeableLineMarkerInfo<?> var1);

    public abstract Icon getCommonIcon(@NotNull List<MergeableLineMarkerInfo> var1);

    @NotNull
    public Function<? super PsiElement, String> getCommonTooltip(@NotNull List<MergeableLineMarkerInfo> infos) {
        if (infos == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(3);
        }
        Function function = element -> {
            if (infos == null) {
                MergeableLineMarkerInfo.$$$reportNull$$$0(15);
            }
            HashSet tooltips = new HashSet(ContainerUtil.mapNotNull((Collection)infos, info -> info.getLineMarkerTooltip()));
            StringBuilder tooltip = new StringBuilder();
            for (String info2 : tooltips) {
                if (tooltip.length() > 0) {
                    tooltip.append("<hr size=1 noshade>");
                }
                tooltip.append(UIUtil.getHtmlBody((String)info2));
            }
            return XmlStringUtil.wrapInHtml((CharSequence)tooltip);
        };
        if (function == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(4);
        }
        return function;
    }

    @NotNull
    public GutterIconRenderer.Alignment getCommonIconAlignment(@NotNull List<MergeableLineMarkerInfo> infos) {
        if (infos == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(5);
        }
        GutterIconRenderer.Alignment alignment = GutterIconRenderer.Alignment.LEFT;
        if (alignment == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(6);
        }
        return alignment;
    }

    @NotNull
    public String getElementPresentation(@NotNull PsiElement element) {
        if (element == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(7);
        }
        String string = element.getText();
        if (string == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(8);
        }
        return string;
    }

    public int getCommonUpdatePass(@NotNull List<MergeableLineMarkerInfo> infos) {
        if (infos == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(9);
        }
        return this.updatePass;
    }

    @Deprecated
    public boolean configurePopupAndRenderer(@NotNull PopupChooserBuilder builder, @NotNull JBList list, @NotNull List<MergeableLineMarkerInfo> markers) {
        if (builder == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(10);
        }
        if (list == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(11);
        }
        if (markers == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(12);
        }
        return false;
    }

    @NotNull
    public static List<LineMarkerInfo<PsiElement>> merge(@NotNull List<? extends MergeableLineMarkerInfo<PsiElement>> markers) {
        if (markers == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(13);
        }
        SmartList result2 = new SmartList();
        for (int i = 0; i < markers.size(); ++i) {
            MergeableLineMarkerInfo<PsiElement> marker = markers.get(i);
            SmartList toMerge = new SmartList();
            for (int k = markers.size() - 1; k > i; --k) {
                MergeableLineMarkerInfo<PsiElement> current = markers.get(k);
                boolean canMergeWith = marker.canMergeWith(current);
                if (ApplicationManager.getApplication().isUnitTestMode() && !canMergeWith && current.canMergeWith(marker)) {
                    LOG.error(current.getClass() + "[" + current.getLineMarkerTooltip() + "] can merge " + marker.getClass() + "[" + marker.getLineMarkerTooltip() + "], but not contrariwise");
                }
                if (!canMergeWith) continue;
                toMerge.add(0, current);
                markers.remove(k);
            }
            if (toMerge.isEmpty()) {
                result2.add(marker);
                continue;
            }
            toMerge.add(0, marker);
            result2.add(new MyLineMarkerInfo((List)toMerge));
        }
        SmartList smartList = result2;
        if (smartList == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(14);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alignment";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/MergeableLineMarkerInfo";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/MergeableLineMarkerInfo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonTooltip";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonIconAlignment";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPresentation";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "merge";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCommonTooltip";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 14: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCommonIconAlignment";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getElementPresentation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCommonUpdatePass";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "configurePopupAndRenderer";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getCommonTooltip$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MergedGutterIconNavigationHandler
    implements GutterIconNavigationHandler<PsiElement> {
        private final List<LineMarkerInfo> myInfos;

        MergedGutterIconNavigationHandler(List<? extends MergeableLineMarkerInfo> markers) {
            ArrayList<? extends MergeableLineMarkerInfo> infos = new ArrayList<MergeableLineMarkerInfo>(markers);
            Collections.sort(infos, Comparator.comparingInt(o -> o.startOffset));
            this.myInfos = Collections.unmodifiableList(infos);
        }

        @NotNull
        List<LineMarkerInfo> getMergedLineMarkersInfos() {
            List<LineMarkerInfo> list = this.myInfos;
            if (list == null) {
                MergedGutterIconNavigationHandler.$$$reportNull$$$0(0);
            }
            return list;
        }

        @Override
        public void navigate(MouseEvent e, PsiElement elt) {
            IPopupChooserBuilder<LineMarkerInfo> builder = JBPopupFactory.getInstance().createPopupChooserBuilder(this.myInfos);
            builder.setRenderer(new SelectionAwareListCellRenderer(dom -> {
                Object element;
                Icon icon = null;
                GutterIconRenderer renderer = ((LineMarkerInfo)dom).createGutterRenderer();
                if (renderer != null) {
                    icon = renderer.getIcon();
                }
                String elementPresentation = (element = ((LineMarkerInfo)dom).getElement()) == null ? IdeBundle.message("node.structureview.invalid", new Object[0]) : (dom instanceof MergeableLineMarkerInfo ? ((MergeableLineMarkerInfo)dom).getElementPresentation((PsiElement)element) : element.getText());
                String text = StringUtil.first((String)elementPresentation, (int)100, (boolean)true).replace('\n', ' ');
                JBLabel label = new JBLabel(text, icon, 2);
                label.setBorder(JBUI.Borders.empty((int)2));
                return label;
            }));
            builder.setItemChosenCallback((Consumer<LineMarkerInfo>)((Consumer)value -> {
                GutterIconNavigationHandler handler = value.getNavigationHandler();
                if (handler != null) {
                    handler.navigate(e, value.getElement());
                }
            })).createPopup().show(new RelativePoint(e));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/MergeableLineMarkerInfo$MergedGutterIconNavigationHandler", "getMergedLineMarkersInfos"));
        }
    }

    private static class MyLineMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        private MyLineMarkerInfo(@NotNull List<? extends MergeableLineMarkerInfo<PsiElement>> markers) {
            if (markers == null) {
                MyLineMarkerInfo.$$$reportNull$$$0(0);
            }
            this(markers, markers.get(0));
        }

        private MyLineMarkerInfo(@NotNull List<? extends MergeableLineMarkerInfo> markers, @NotNull MergeableLineMarkerInfo template) {
            if (markers == null) {
                MyLineMarkerInfo.$$$reportNull$$$0(1);
            }
            if (template == null) {
                MyLineMarkerInfo.$$$reportNull$$$0(2);
            }
            super(template.getElement(), MyLineMarkerInfo.getCommonTextRange(markers), template.getCommonIcon(markers), template.getCommonUpdatePass(markers), template.getCommonTooltip(markers), MyLineMarkerInfo.getCommonNavigationHandler(markers), template.getCommonIconAlignment(markers));
        }

        @NotNull
        private static TextRange getCommonTextRange(@NotNull List<? extends MergeableLineMarkerInfo> markers) {
            if (markers == null) {
                MyLineMarkerInfo.$$$reportNull$$$0(3);
            }
            int startOffset = Integer.MAX_VALUE;
            int endOffset = Integer.MIN_VALUE;
            for (MergeableLineMarkerInfo mergeableLineMarkerInfo : markers) {
                startOffset = Math.min(startOffset, mergeableLineMarkerInfo.startOffset);
                endOffset = Math.max(endOffset, mergeableLineMarkerInfo.endOffset);
            }
            TextRange textRange = TextRange.create((int)startOffset, (int)endOffset);
            if (textRange == null) {
                MyLineMarkerInfo.$$$reportNull$$$0(4);
            }
            return textRange;
        }

        @NotNull
        private static GutterIconNavigationHandler<PsiElement> getCommonNavigationHandler(@NotNull List<? extends MergeableLineMarkerInfo> markers) {
            if (markers == null) {
                MyLineMarkerInfo.$$$reportNull$$$0(5);
            }
            MergedGutterIconNavigationHandler mergedGutterIconNavigationHandler = new MergedGutterIconNavigationHandler(markers);
            if (mergedGutterIconNavigationHandler == null) {
                MyLineMarkerInfo.$$$reportNull$$$0(6);
            }
            return mergedGutterIconNavigationHandler;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "markers";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "template";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/MergeableLineMarkerInfo$MyLineMarkerInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/MergeableLineMarkerInfo$MyLineMarkerInfo";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommonTextRange";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommonNavigationHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommonTextRange";
                    break;
                }
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommonNavigationHandler";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

