/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.module;

import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectGenerator;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PythonModuleTypeBase;
import com.jetbrains.python.newProject.PythonProjectGenerator;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonModuleBuilderBase
extends ModuleBuilder {
    private final List<Runnable> mySdkChangedListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final DirectoryProjectGenerator myGenerator;
    private Sdk mySdk;

    public PythonModuleBuilderBase() {
        this.myGenerator = null;
    }

    public PythonModuleBuilderBase(DirectoryProjectGenerator generator) {
        this.myGenerator = generator;
    }

    public String getGroupName() {
        return "Python";
    }

    public void setupRootModel(ModifiableRootModel rootModel) throws ConfigurationException {
        if (this.myJdk != null) {
            rootModel.setSdk(this.myJdk);
        } else {
            rootModel.inheritSdk();
        }
        this.doAddContentEntry(rootModel);
    }

    public ModuleType getModuleType() {
        return PythonModuleTypeBase.getInstance();
    }

    public Sdk getSdk() {
        return this.mySdk;
    }

    public void setSdk(Sdk sdk) {
        if (this.mySdk != sdk) {
            this.mySdk = sdk;
            for (Runnable runnable : this.mySdkChangedListeners) {
                runnable.run();
            }
        }
    }

    public void addSdkChangedListener(Runnable runnable) {
        this.mySdkChangedListeners.add(runnable);
    }

    public boolean isSuitableSdkType(SdkTypeId sdk) {
        return sdk instanceof PythonSdkType;
    }

    @Nullable
    public Module commitModule(@NotNull Project project, @Nullable ModifiableModuleModel model) {
        Module module2;
        if (project == null) {
            PythonModuleBuilderBase.$$$reportNull$$$0(0);
        }
        if ((module2 = super.commitModule(project, model)) != null && this.myGenerator != null) {
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module2);
            VirtualFile[] contentRoots = moduleRootManager.getContentRoots();
            VirtualFile dir = module2.getProject().getBaseDir();
            if (contentRoots.length > 0 && contentRoots[0] != null) {
                dir = contentRoots[0];
            }
            this.myGenerator.generateProject(project, dir, (Object)PythonProjectGenerator.NO_SETTINGS, module2);
        }
        return module2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/module/PythonModuleBuilderBase", "commitModule"));
    }
}

