/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.HtmlCodeStylePanelExtension;
import com.intellij.application.options.TagListDialog;
import com.intellij.application.options.codeStyle.RightMarginForm;
import com.intellij.ide.highlighter.XmlHighlighterFactory;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.xml.HtmlCodeStyleSettings;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Producer;
import com.intellij.util.ui.ListItemsDialogWrapper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class CodeStyleHtmlPanel
extends CodeStyleAbstractPanel {
    private JTextField myKeepBlankLines;
    private JComboBox myWrapAttributes;
    private JCheckBox myAlignAttributes;
    private JCheckBox myKeepWhiteSpaces;
    private JPanel myPanel;
    private JPanel myPreviewPanel;
    private JCheckBox mySpacesAroundEquality;
    private JCheckBox mySpacesAroundTagName;
    private JCheckBox myAlignText;
    private TextFieldWithBrowseButton myInsertNewLineTagNames;
    private TextFieldWithBrowseButton myRemoveNewLineTagNames;
    private TextFieldWithBrowseButton myDoNotAlignChildrenTagNames;
    private TextFieldWithBrowseButton myKeepWhiteSpacesTagNames;
    private TextFieldWithBrowseButton myInlineElementsTagNames;
    private JTextField myDoNotAlignChildrenMinSize;
    private JCheckBox myShouldKeepBlankLines;
    private JCheckBox mySpaceInEmptyTag;
    private JCheckBox myWrapText;
    private JCheckBox myShouldKeepLineBreaksInText;
    private TextFieldWithBrowseButton myDontBreakIfInlineContent;
    private JBScrollPane myJBScrollPane;
    private JPanel myRightMarginPanel;
    private JComboBox myQuotesCombo;
    private JBCheckBox myEnforceQuotesBox;
    private ComboBox myBeforeFirstAttributeCombo;
    private ComboBox myAfterLastAttributeCombo;
    private JPanel mySettingsPanel;
    private RightMarginForm myRightMarginForm;
    private final List<HtmlCodeStylePanelExtension.HtmlPanelCustomizer> myPanelCustomizers;

    public CodeStyleHtmlPanel(CodeStyleSettings settings) {
        super(settings);
        this.$$$setupUI$$$();
        this.installPreviewPanel(this.myPreviewPanel);
        CodeStyleHtmlPanel.fillWrappingCombo(this.myWrapAttributes);
        CodeStyleHtmlPanel.fillEnumCombobox(this.myQuotesCombo, CodeStyleSettings.QuoteStyle.class);
        CodeStyleHtmlPanel.fillEnumCombobox((JComboBox)this.myBeforeFirstAttributeCombo, CodeStyleSettings.HtmlTagNewLineStyle.class);
        CodeStyleHtmlPanel.fillEnumCombobox((JComboBox)this.myAfterLastAttributeCombo, CodeStyleSettings.HtmlTagNewLineStyle.class);
        CodeStyleHtmlPanel.customizeField(ApplicationBundle.message((String)"title.insert.new.line.before.tags", (Object[])new Object[0]), this.myInsertNewLineTagNames);
        CodeStyleHtmlPanel.customizeField(ApplicationBundle.message((String)"title.remove.line.breaks.before.tags", (Object[])new Object[0]), this.myRemoveNewLineTagNames);
        CodeStyleHtmlPanel.customizeField(ApplicationBundle.message((String)"title.do.not.indent.children.of", (Object[])new Object[0]), this.myDoNotAlignChildrenTagNames);
        CodeStyleHtmlPanel.customizeField(ApplicationBundle.message((String)"title.inline.elements", (Object[])new Object[0]), this.myInlineElementsTagNames);
        CodeStyleHtmlPanel.customizeField(ApplicationBundle.message((String)"title.keep.whitespaces.inside", (Object[])new Object[0]), this.myKeepWhiteSpacesTagNames);
        CodeStyleHtmlPanel.customizeField(ApplicationBundle.message((String)"title.dont.wrap.if.inline.content", (Object[])new Object[0]), this.myDontBreakIfInlineContent);
        this.myInsertNewLineTagNames.getTextField().setColumns(5);
        this.myRemoveNewLineTagNames.getTextField().setColumns(5);
        this.myDoNotAlignChildrenTagNames.getTextField().setColumns(5);
        this.myKeepWhiteSpacesTagNames.getTextField().setColumns(5);
        this.myInlineElementsTagNames.getTextField().setColumns(5);
        this.myDontBreakIfInlineContent.getTextField().setColumns(5);
        this.myQuotesCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean quotesRequired = !CodeStyleSettings.QuoteStyle.None.equals(CodeStyleHtmlPanel.this.myQuotesCombo.getSelectedItem());
                CodeStyleHtmlPanel.this.myEnforceQuotesBox.setEnabled(quotesRequired);
                if (!quotesRequired) {
                    CodeStyleHtmlPanel.this.myEnforceQuotesBox.setSelected(false);
                }
            }
        });
        this.addPanelToWatch(this.myPanel);
        this.myPanelCustomizers = HtmlCodeStylePanelExtension.getCustomizers();
        this.myPanelCustomizers.forEach(customizer -> customizer.customizeSettingsPanel(this.mySettingsPanel));
    }

    @Override
    protected EditorHighlighter createHighlighter(EditorColorsScheme scheme2) {
        return XmlHighlighterFactory.createXMLHighlighter(scheme2);
    }

    private void createUIComponents() {
        this.myRightMarginForm = new RightMarginForm(StdFileTypes.HTML.getLanguage(), this.getSettings());
        this.myRightMarginPanel = this.myRightMarginForm.getTopPanel();
        this.myJBScrollPane = new JBScrollPane(){

            public Dimension getPreferredSize() {
                Dimension prefSize = super.getPreferredSize();
                return new Dimension(prefSize.width + 15, prefSize.height);
            }
        };
    }

    private static void customizeField(String title, TextFieldWithBrowseButton uiField) {
        ListItemsDialogWrapper.installListItemsDialogForTextField(uiField, (Producer<? extends ListItemsDialogWrapper>)((Producer)() -> new TagListDialog(title)));
    }

    @Override
    protected int getRightMargin() {
        return 60;
    }

    @Override
    public void apply(CodeStyleSettings rootSettings) throws ConfigurationException {
        HtmlCodeStyleSettings settings = (HtmlCodeStyleSettings)rootSettings.getCustomSettings(HtmlCodeStyleSettings.class);
        settings.HTML_KEEP_BLANK_LINES = CodeStyleHtmlPanel.getIntValue(this.myKeepBlankLines);
        settings.HTML_ATTRIBUTE_WRAP = ourWrappings[this.myWrapAttributes.getSelectedIndex()];
        settings.HTML_TEXT_WRAP = this.myWrapText.isSelected() ? 1 : 0;
        settings.HTML_SPACE_INSIDE_EMPTY_TAG = this.mySpaceInEmptyTag.isSelected();
        settings.HTML_ALIGN_ATTRIBUTES = this.myAlignAttributes.isSelected();
        settings.HTML_ALIGN_TEXT = this.myAlignText.isSelected();
        settings.HTML_KEEP_WHITESPACES = this.myKeepWhiteSpaces.isSelected();
        settings.HTML_SPACE_AROUND_EQUALITY_IN_ATTRIBUTE = this.mySpacesAroundEquality.isSelected();
        settings.HTML_SPACE_AFTER_TAG_NAME = this.mySpacesAroundTagName.isSelected();
        settings.HTML_ELEMENTS_TO_INSERT_NEW_LINE_BEFORE = this.myInsertNewLineTagNames.getText();
        settings.HTML_ELEMENTS_TO_REMOVE_NEW_LINE_BEFORE = this.myRemoveNewLineTagNames.getText();
        settings.HTML_DO_NOT_INDENT_CHILDREN_OF = this.myDoNotAlignChildrenTagNames.getText();
        settings.HTML_DO_NOT_ALIGN_CHILDREN_OF_MIN_LINES = CodeStyleHtmlPanel.getIntValue(this.myDoNotAlignChildrenMinSize);
        settings.HTML_INLINE_ELEMENTS = this.myInlineElementsTagNames.getText();
        settings.HTML_DONT_ADD_BREAKS_IF_INLINE_CONTENT = this.myDontBreakIfInlineContent.getText();
        settings.HTML_KEEP_WHITESPACES_INSIDE = this.myKeepWhiteSpacesTagNames.getText();
        settings.HTML_KEEP_LINE_BREAKS = this.myShouldKeepBlankLines.isSelected();
        settings.HTML_KEEP_LINE_BREAKS_IN_TEXT = this.myShouldKeepLineBreaksInText.isSelected();
        settings.HTML_QUOTE_STYLE = (CodeStyleSettings.QuoteStyle)this.myQuotesCombo.getSelectedItem();
        settings.HTML_ENFORCE_QUOTES = this.myEnforceQuotesBox.isSelected();
        settings.HTML_NEWLINE_BEFORE_FIRST_ATTRIBUTE = (CodeStyleSettings.HtmlTagNewLineStyle)this.myBeforeFirstAttributeCombo.getSelectedItem();
        settings.HTML_NEWLINE_AFTER_LAST_ATTRIBUTE = (CodeStyleSettings.HtmlTagNewLineStyle)this.myAfterLastAttributeCombo.getSelectedItem();
        this.myRightMarginForm.apply(rootSettings);
        this.myPanelCustomizers.forEach(el -> el.apply(rootSettings));
    }

    private static int getIntValue(JTextField keepBlankLines) {
        try {
            return Integer.parseInt(keepBlankLines.getText());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    protected void resetImpl(CodeStyleSettings rootSettings) {
        HtmlCodeStyleSettings settings = (HtmlCodeStyleSettings)rootSettings.getCustomSettings(HtmlCodeStyleSettings.class);
        this.myKeepBlankLines.setText(String.valueOf(settings.HTML_KEEP_BLANK_LINES));
        this.myWrapAttributes.setSelectedIndex(CodeStyleHtmlPanel.getIndexForWrapping(settings.HTML_ATTRIBUTE_WRAP));
        this.myWrapText.setSelected(settings.HTML_TEXT_WRAP != 0);
        this.mySpaceInEmptyTag.setSelected(settings.HTML_SPACE_INSIDE_EMPTY_TAG);
        this.myAlignAttributes.setSelected(settings.HTML_ALIGN_ATTRIBUTES);
        this.myAlignText.setSelected(settings.HTML_ALIGN_TEXT);
        this.myKeepWhiteSpaces.setSelected(settings.HTML_KEEP_WHITESPACES);
        this.mySpacesAroundTagName.setSelected(settings.HTML_SPACE_AFTER_TAG_NAME);
        this.mySpacesAroundEquality.setSelected(settings.HTML_SPACE_AROUND_EQUALITY_IN_ATTRIBUTE);
        this.myShouldKeepBlankLines.setSelected(settings.HTML_KEEP_LINE_BREAKS);
        this.myShouldKeepLineBreaksInText.setSelected(settings.HTML_KEEP_LINE_BREAKS_IN_TEXT);
        this.myInsertNewLineTagNames.setText(settings.HTML_ELEMENTS_TO_INSERT_NEW_LINE_BEFORE);
        this.myRemoveNewLineTagNames.setText(settings.HTML_ELEMENTS_TO_REMOVE_NEW_LINE_BEFORE);
        this.myDoNotAlignChildrenTagNames.setText(settings.HTML_DO_NOT_INDENT_CHILDREN_OF);
        this.myDoNotAlignChildrenMinSize.setText(settings.HTML_DO_NOT_ALIGN_CHILDREN_OF_MIN_LINES == 0 ? "" : String.valueOf(settings.HTML_DO_NOT_ALIGN_CHILDREN_OF_MIN_LINES));
        this.myInlineElementsTagNames.setText(settings.HTML_INLINE_ELEMENTS);
        this.myDontBreakIfInlineContent.setText(settings.HTML_DONT_ADD_BREAKS_IF_INLINE_CONTENT);
        this.myKeepWhiteSpacesTagNames.setText(settings.HTML_KEEP_WHITESPACES_INSIDE);
        this.myRightMarginForm.reset(rootSettings);
        this.myQuotesCombo.setSelectedItem(settings.HTML_QUOTE_STYLE);
        this.myEnforceQuotesBox.setSelected(settings.HTML_ENFORCE_QUOTES);
        this.myBeforeFirstAttributeCombo.setSelectedItem((Object)settings.HTML_NEWLINE_BEFORE_FIRST_ATTRIBUTE);
        this.myAfterLastAttributeCombo.setSelectedItem((Object)settings.HTML_NEWLINE_AFTER_LAST_ATTRIBUTE);
        this.myPanelCustomizers.forEach(el -> el.reset(rootSettings));
    }

    @Override
    public boolean isModified(CodeStyleSettings rootSettings) {
        HtmlCodeStyleSettings settings = (HtmlCodeStyleSettings)rootSettings.getCustomSettings(HtmlCodeStyleSettings.class);
        if (settings.HTML_KEEP_BLANK_LINES != CodeStyleHtmlPanel.getIntValue(this.myKeepBlankLines)) {
            return true;
        }
        if (settings.HTML_ATTRIBUTE_WRAP != ourWrappings[this.myWrapAttributes.getSelectedIndex()]) {
            return true;
        }
        if (settings.HTML_TEXT_WRAP == 1 != this.myWrapText.isSelected()) {
            return true;
        }
        if (settings.HTML_SPACE_INSIDE_EMPTY_TAG != this.mySpaceInEmptyTag.isSelected()) {
            return true;
        }
        if (settings.HTML_ALIGN_ATTRIBUTES != this.myAlignAttributes.isSelected()) {
            return true;
        }
        if (settings.HTML_ALIGN_TEXT != this.myAlignText.isSelected()) {
            return true;
        }
        if (settings.HTML_KEEP_WHITESPACES != this.myKeepWhiteSpaces.isSelected()) {
            return true;
        }
        if (settings.HTML_SPACE_AROUND_EQUALITY_IN_ATTRIBUTE != this.mySpacesAroundEquality.isSelected()) {
            return true;
        }
        if (settings.HTML_SPACE_AFTER_TAG_NAME != this.mySpacesAroundTagName.isSelected()) {
            return true;
        }
        if (!Comparing.equal((String)settings.HTML_ELEMENTS_TO_INSERT_NEW_LINE_BEFORE, (String)this.myInsertNewLineTagNames.getText().trim())) {
            return true;
        }
        if (!Comparing.equal((String)settings.HTML_ELEMENTS_TO_REMOVE_NEW_LINE_BEFORE, (String)this.myRemoveNewLineTagNames.getText().trim())) {
            return true;
        }
        if (!Comparing.equal((String)settings.HTML_DO_NOT_INDENT_CHILDREN_OF, (String)this.myDoNotAlignChildrenTagNames.getText().trim())) {
            return true;
        }
        if (settings.HTML_DO_NOT_ALIGN_CHILDREN_OF_MIN_LINES != CodeStyleHtmlPanel.getIntValue(this.myDoNotAlignChildrenMinSize)) {
            return true;
        }
        if (!Comparing.equal((String)settings.HTML_INLINE_ELEMENTS, (String)this.myInlineElementsTagNames.getText().trim())) {
            return true;
        }
        if (!Comparing.equal((String)settings.HTML_DONT_ADD_BREAKS_IF_INLINE_CONTENT, (String)this.myDontBreakIfInlineContent.getText().trim())) {
            return true;
        }
        if (!Comparing.equal((String)settings.HTML_KEEP_WHITESPACES_INSIDE, (String)this.myKeepWhiteSpacesTagNames.getText().trim())) {
            return true;
        }
        if (this.myShouldKeepBlankLines.isSelected() != settings.HTML_KEEP_LINE_BREAKS) {
            return true;
        }
        if (this.myShouldKeepLineBreaksInText.isSelected() != settings.HTML_KEEP_LINE_BREAKS_IN_TEXT) {
            return true;
        }
        if (this.myQuotesCombo.getSelectedItem() != settings.HTML_QUOTE_STYLE) {
            return true;
        }
        if (this.myBeforeFirstAttributeCombo.getSelectedItem() != settings.HTML_NEWLINE_BEFORE_FIRST_ATTRIBUTE) {
            return true;
        }
        if (this.myAfterLastAttributeCombo.getSelectedItem() != settings.HTML_NEWLINE_AFTER_LAST_ATTRIBUTE) {
            return true;
        }
        if (this.myRightMarginForm.isModified(rootSettings) || this.myEnforceQuotesBox.isSelected() != settings.HTML_ENFORCE_QUOTES) {
            return true;
        }
        return this.myPanelCustomizers.stream().anyMatch(el -> el.isModified(rootSettings));
    }

    @Override
    public JComponent getPanel() {
        return this.myPanel;
    }

    @Override
    protected String getPreviewText() {
        return CodeStyleHtmlPanel.readFromFile(this.getClass(), "preview.html.template");
    }

    @Override
    @NotNull
    protected FileType getFileType() {
        LanguageFileType languageFileType = StdFileTypes.HTML;
        if (languageFileType == null) {
            CodeStyleHtmlPanel.$$$reportNull$$$0(0);
        }
        return languageFileType;
    }

    private static <T extends Enum<T>> void fillEnumCombobox(JComboBox combo, Class<T> enumClass) {
        combo.setModel(new EnumComboBoxModel(enumClass));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/CodeStyleHtmlPanel", "getFileType"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JComboBox jComboBox;
        JTextField jTextField;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JCheckBox jCheckBox9;
        ComboBox comboBox2;
        ComboBox comboBox3;
        JBCheckBox jBCheckBox;
        JComboBox jComboBox2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        TextFieldWithBrowseButton textFieldWithBrowseButton3;
        TextFieldWithBrowseButton textFieldWithBrowseButton4;
        TextFieldWithBrowseButton textFieldWithBrowseButton5;
        TextFieldWithBrowseButton textFieldWithBrowseButton6;
        JTextField jTextField2;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.createUIComponents();
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 4, -1, false, false));
        this.myPreviewPanel = jPanel2 = new JPanel();
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = this.myJBScrollPane;
        jBScrollPane.setHorizontalScrollBarPolicy(31);
        jPanel4.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 9, 0, 0, 3, null, null, null));
        jBScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel5);
        this.mySettingsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(11, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.or.if.tag.size.more.than"));
        jPanel.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.myDoNotAlignChildrenMinSize = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(3, 1, 1, 1, 8, 0, 1, 0, null, new Dimension(50, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.lines"));
        jPanel.add((Component)jLabel2, new GridConstraints(3, 2, 1, 1, 0, 1, 4, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.insert.new.line.before"));
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.remove.new.line.before"));
        jPanel.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.do.not.indent.children.of"));
        jPanel.add((Component)jLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInsertNewLineTagNames = textFieldWithBrowseButton6 = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton6.setText("");
        jPanel.add((Component)textFieldWithBrowseButton6, new GridConstraints(0, 1, 1, 2, 8, 3, 1, 0, null, new Dimension(100, -1), null));
        this.myRemoveNewLineTagNames = textFieldWithBrowseButton5 = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton5.setText("");
        jPanel.add((Component)textFieldWithBrowseButton5, new GridConstraints(1, 1, 1, 2, 8, 3, 1, 0, null, new Dimension(100, -1), null));
        this.myDoNotAlignChildrenTagNames = textFieldWithBrowseButton4 = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton4.setText("");
        jPanel.add((Component)textFieldWithBrowseButton4, new GridConstraints(2, 1, 1, 2, 8, 3, 1, 0, null, new Dimension(100, -1), null));
        this.myInlineElementsTagNames = textFieldWithBrowseButton3 = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton3.setText("");
        jPanel.add((Component)textFieldWithBrowseButton3, new GridConstraints(4, 1, 1, 2, 8, 3, 1, 0, null, new Dimension(100, -1), null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("messages/ApplicationBundle").getString("inline.elements"));
        jPanel.add((Component)jLabel6, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.keep.white.spaces.inside"));
        jPanel.add((Component)jLabel7, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, ResourceBundle.getBundle("messages/ApplicationBundle").getString("don.t.break.if.inline.content"));
        jPanel.add((Component)jLabel8, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myKeepWhiteSpacesTagNames = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton2.setText("");
        jPanel.add((Component)textFieldWithBrowseButton2, new GridConstraints(5, 1, 1, 2, 8, 3, 1, 0, null, new Dimension(100, -1), null));
        this.myDontBreakIfInlineContent = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setText("");
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(6, 1, 1, 2, 8, 3, 1, 0, null, new Dimension(100, -1), null));
        JLabel jLabel9 = new JLabel();
        this.$$$loadLabelText$$$(jLabel9, ResourceBundle.getBundle("messages/ApplicationBundle").getString("generated.quote.marks"));
        jPanel.add((Component)jLabel9, new GridConstraints(9, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myQuotesCombo = jComboBox2 = new JComboBox();
        jPanel.add(jComboBox2, new GridConstraints(9, 1, 1, 2, 8, 1, 2, 0, null, null, null));
        this.myEnforceQuotesBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/ApplicationBundle").getString("generated.quote.enforce.format"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(10, 1, 1, 2, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("html.label.new.line.before.first.attribute"));
        jPanel.add((Component)jBLabel, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myBeforeFirstAttributeCombo = comboBox3 = new ComboBox();
        jPanel.add((Component)comboBox3, new GridConstraints(7, 1, 1, 2, 0, 1, 2, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("html.label.new.line.after.last.attribute"));
        jPanel.add((Component)jBLabel2, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAfterLastAttributeCombo = comboBox2 = new ComboBox();
        jPanel.add((Component)comboBox2, new GridConstraints(8, 1, 1, 2, 0, 1, 2, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 1, null, null, null));
        this.myAlignAttributes = jCheckBox9 = new JCheckBox();
        jCheckBox9.setMargin(new Insets(0, 0, 0, 0));
        this.$$$loadButtonText$$$(jCheckBox9, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.align.attributes"));
        jPanel7.add((Component)jCheckBox9, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAlignText = jCheckBox8 = new JCheckBox();
        jCheckBox8.setMargin(new Insets(0, 0, 0, 0));
        this.$$$loadButtonText$$$(jCheckBox8, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.align.text"));
        jPanel7.add((Component)jCheckBox8, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myKeepWhiteSpaces = jCheckBox7 = new JCheckBox();
        jCheckBox7.setMargin(new Insets(0, 0, 0, 0));
        this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.keep.white.spaces"));
        jPanel7.add((Component)jCheckBox7, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myWrapText = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.wrap.text"));
        jPanel7.add((Component)jCheckBox6, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel6.add((Component)jPanel8, new GridConstraints(0, 1, 1, 1, 1, 1, 3, 1, null, null, null));
        jPanel8.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)ResourceBundle.getBundle("messages/ApplicationBundle").getString("title.spaces"), (int)0, (int)0, null, null));
        this.mySpacesAroundEquality = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.spaces.around.equals.in.attribute"));
        jPanel8.add((Component)jCheckBox5, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySpacesAroundTagName = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.spaces.around.tag.name"));
        jPanel8.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySpaceInEmptyTag = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.spaces.in.empty.tag"));
        jPanel8.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel9, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myShouldKeepBlankLines = jCheckBox2 = new JCheckBox();
        jCheckBox2.setMargin(new Insets(0, 0, 0, 0));
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.keep.line.breaks"));
        jPanel9.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JLabel jLabel10 = new JLabel();
        this.$$$loadLabelText$$$(jLabel10, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.wrap.attributes"));
        jPanel9.add((Component)jLabel10, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel11 = new JLabel();
        this.$$$loadLabelText$$$(jLabel11, ResourceBundle.getBundle("messages/ApplicationBundle").getString("editbox.keep.blank.lines"));
        jPanel9.add((Component)jLabel11, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myKeepBlankLines = jTextField = new JTextField();
        jTextField.setColumns(3);
        jPanel9.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(50, -1), null));
        this.myWrapAttributes = jComboBox = new JComboBox();
        ((Component)jComboBox).setEnabled(true);
        jPanel9.add(jComboBox, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myShouldKeepLineBreaksInText = jCheckBox = new JCheckBox();
        jCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.keep.line.breaks.in.text"));
        jPanel9.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JPanel jPanel10 = this.myRightMarginPanel;
        jPanel5.add((Component)jPanel10, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jBLabel.setLabelFor((Component)comboBox3);
        jBLabel2.setLabelFor((Component)comboBox2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

