/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.FoldingData;
import com.intellij.codeInsight.editorActions.FoldingTransferableData;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.CodeFoldingManagerImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiFile;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CopyPasteFoldingProcessor
extends CopyPastePostProcessor<FoldingTransferableData> {
    @Override
    @NotNull
    public List<FoldingTransferableData> collectTransferableData(PsiFile file2, Editor editor, int[] startOffsets, int[] endOffsets) {
        FoldRegion[] regions;
        ArrayList<FoldingData> list2 = new ArrayList<FoldingData>();
        block0: for (FoldRegion region : regions = editor.getFoldingModel().getAllFoldRegions()) {
            if (!region.isValid()) continue;
            int refOffset = 0;
            for (int j = 0; j < startOffsets.length; ++j) {
                refOffset += startOffsets[j];
                if (startOffsets[j] <= region.getStartOffset() && region.getEndOffset() <= endOffsets[j]) {
                    list2.add(new FoldingData(region.getStartOffset() - refOffset, region.getEndOffset() - refOffset, region.isExpanded()));
                    continue block0;
                }
                refOffset -= endOffsets[j] + 1;
            }
        }
        List<FoldingTransferableData> list3 = Collections.singletonList(new FoldingTransferableData(list2.toArray(new FoldingData[0])));
        if (list3 == null) {
            CopyPasteFoldingProcessor.$$$reportNull$$$0(0);
        }
        return list3;
    }

    @Override
    @NotNull
    public List<FoldingTransferableData> extractTransferableData(Transferable content) {
        FoldingTransferableData foldingData = null;
        try {
            DataFlavor flavor = FoldingData.getDataFlavor();
            if (flavor != null) {
                foldingData = (FoldingTransferableData)content.getTransferData(flavor);
            }
        }
        catch (UnsupportedFlavorException | IOException exception) {
            // empty catch block
        }
        if (foldingData != null) {
            List<FoldingTransferableData> list2 = Collections.singletonList(foldingData.clone());
            if (list2 == null) {
                CopyPasteFoldingProcessor.$$$reportNull$$$0(1);
            }
            return list2;
        }
        List<FoldingTransferableData> list3 = Collections.emptyList();
        if (list3 == null) {
            CopyPasteFoldingProcessor.$$$reportNull$$$0(2);
        }
        return list3;
    }

    @Override
    public void processTransferableData(Project project, Editor editor, RangeMarker bounds2, int caretOffset, Ref<Boolean> indented, List<FoldingTransferableData> values) {
        assert (values.size() == 1);
        FoldingTransferableData value = values.get(0);
        if (value.getData().length == 0) {
            return;
        }
        CodeFoldingManagerImpl foldingManager = (CodeFoldingManagerImpl)CodeFoldingManager.getInstance(project);
        if (foldingManager == null) {
            return;
        }
        foldingManager.updateFoldRegions(editor, true);
        Runnable operation = () -> {
            for (FoldingData data : value.getData()) {
                FoldRegion region = foldingManager.findFoldRegion(editor, data.startOffset + bounds2.getStartOffset(), data.endOffset + bounds2.getStartOffset());
                if (region == null) continue;
                region.setExpanded(data.isExpanded);
            }
        };
        editor.getFoldingModel().runBatchFoldingOperation(operation);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/codeInsight/editorActions/CopyPasteFoldingProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTransferableData";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "extractTransferableData";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

