/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.editor;

import com.intellij.codeInsight.editorActions.EnterHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.JsonLanguage;
import com.intellij.json.editor.JsonEditorOptions;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class JsonEnterHandler
extends EnterHandlerDelegateAdapter {
    @Override
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvanceRef, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file2 == null) {
            JsonEnterHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            JsonEnterHandler.$$$reportNull$$$0(1);
        }
        if (caretOffsetRef == null) {
            JsonEnterHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvanceRef == null) {
            JsonEnterHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            JsonEnterHandler.$$$reportNull$$$0(4);
        }
        if (!JsonEditorOptions.getInstance().COMMA_ON_ENTER) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Language language = EnterHandler.getLanguage(dataContext);
        if (!(language instanceof JsonLanguage)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int caretOffset = (Integer)caretOffsetRef.get();
        PsiElement psiAtOffset = file2.findElementAt(caretOffset);
        if (psiAtOffset == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (psiAtOffset instanceof LeafPsiElement && JsonEnterHandler.handleComma(caretOffsetRef, psiAtOffset, editor)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        JsonValue literal = (JsonValue)ObjectUtils.tryCast((Object)psiAtOffset.getParent(), JsonValue.class);
        if (!(literal == null || literal instanceof JsonStringLiteral && ((JsonLanguage)language).hasPermissiveStrings())) {
            JsonEnterHandler.handleJsonValue(literal, editor, caretOffsetRef);
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static boolean handleComma(@NotNull Ref<Integer> caretOffsetRef, @NotNull PsiElement psiAtOffset, @NotNull Editor editor) {
        IElementType elementType;
        if (caretOffsetRef == null) {
            JsonEnterHandler.$$$reportNull$$$0(5);
        }
        if (psiAtOffset == null) {
            JsonEnterHandler.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            JsonEnterHandler.$$$reportNull$$$0(7);
        }
        PsiElement nextSibling = psiAtOffset;
        while (nextSibling instanceof PsiWhiteSpace) {
            nextSibling = nextSibling.getNextSibling();
        }
        LeafPsiElement leafPsiElement = (LeafPsiElement)ObjectUtils.tryCast((Object)nextSibling, LeafPsiElement.class);
        IElementType iElementType = elementType = leafPsiElement == null ? null : leafPsiElement.getElementType();
        if (elementType == JsonElementTypes.COMMA || elementType == JsonElementTypes.R_CURLY) {
            PsiElement prevSibling = nextSibling.getPrevSibling();
            while (prevSibling instanceof PsiWhiteSpace) {
                prevSibling = prevSibling.getPrevSibling();
            }
            if (prevSibling instanceof JsonProperty && ((JsonProperty)prevSibling).getValue() != null) {
                int offset;
                int n = offset = elementType == JsonElementTypes.COMMA ? nextSibling.getTextRange().getEndOffset() : prevSibling.getTextRange().getEndOffset();
                if (offset < editor.getDocument().getTextLength()) {
                    if (elementType == JsonElementTypes.R_CURLY) {
                        editor.getDocument().insertString(offset, (CharSequence)",");
                        ++offset;
                    }
                    caretOffsetRef.set((Object)offset);
                }
                return true;
            }
            return false;
        }
        if (nextSibling instanceof JsonProperty) {
            PsiElement prevSibling = nextSibling.getPrevSibling();
            while (prevSibling instanceof PsiWhiteSpace || prevSibling instanceof PsiErrorElement) {
                prevSibling = prevSibling.getPrevSibling();
            }
            if (prevSibling instanceof JsonProperty) {
                int offset = prevSibling.getTextRange().getEndOffset();
                if (offset < editor.getDocument().getTextLength()) {
                    editor.getDocument().insertString(offset, (CharSequence)",");
                    caretOffsetRef.set((Object)(offset + 1));
                }
                return true;
            }
        }
        return false;
    }

    private static void handleJsonValue(@NotNull JsonValue literal, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef) {
        PsiElement parent;
        if (literal == null) {
            JsonEnterHandler.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            JsonEnterHandler.$$$reportNull$$$0(9);
        }
        if (caretOffsetRef == null) {
            JsonEnterHandler.$$$reportNull$$$0(10);
        }
        if (!((parent = literal.getParent()) instanceof JsonProperty) || ((JsonProperty)parent).getValue() != literal) {
            return;
        }
        PsiElement nextSibling = parent.getNextSibling();
        while (nextSibling instanceof PsiWhiteSpace || nextSibling instanceof PsiErrorElement) {
            nextSibling = nextSibling.getNextSibling();
        }
        int offset = literal.getTextRange().getEndOffset();
        if (literal instanceof JsonObject || literal instanceof JsonArray) {
            if (nextSibling instanceof LeafPsiElement && ((LeafPsiElement)nextSibling).getElementType() == JsonElementTypes.COMMA || !(nextSibling instanceof JsonProperty)) {
                return;
            }
            Document document = editor.getDocument();
            if (offset < document.getTextLength()) {
                document.insertString(offset, (CharSequence)",");
            }
            return;
        }
        if (nextSibling instanceof LeafPsiElement && ((LeafPsiElement)nextSibling).getElementType() == JsonElementTypes.COMMA) {
            offset = nextSibling.getTextRange().getEndOffset();
        } else {
            Document document = editor.getDocument();
            if (offset < document.getTextLength()) {
                document.insertString(offset, (CharSequence)",");
            }
            ++offset;
        }
        if (offset < editor.getDocument().getTextLength()) {
            caretOffsetRef.set((Object)offset);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffsetRef";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvanceRef";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAtOffset";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
        }
        objectArray2[1] = "com/intellij/json/editor/JsonEnterHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "preprocessEnter";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "handleComma";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "handleJsonValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

