/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.inplace;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import com.intellij.refactoring.rename.PreferrableNameSuggestionProvider;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class MyLookupExpression
extends Expression {
    protected final String myName;
    protected final LookupElement[] myLookupItems;
    private final String myAdvertisementText;

    public MyLookupExpression(String name, LinkedHashSet<String> names, PsiNamedElement elementToRename, PsiElement nameSuggestionContext, boolean shouldSelectAll, String advertisement) {
        this.myName = name;
        this.myAdvertisementText = advertisement;
        this.myLookupItems = MyLookupExpression.initLookupItems(names, elementToRename, nameSuggestionContext, shouldSelectAll);
    }

    private static LookupElement[] initLookupItems(LinkedHashSet<String> names, PsiNamedElement elementToRename, PsiElement nameSuggestionContext, final boolean shouldSelectAll) {
        if (names == null) {
            NameSuggestionProvider provider;
            SuggestedNameInfo suggestedNameInfo;
            names = new LinkedHashSet();
            Iterator iterator = NameSuggestionProvider.EP_NAME.getExtensionList().iterator();
            while (iterator.hasNext() && ((suggestedNameInfo = (provider = (NameSuggestionProvider)iterator.next()).getSuggestedNames((PsiElement)elementToRename, nameSuggestionContext, names)) == null || !(provider instanceof PreferrableNameSuggestionProvider) || ((PreferrableNameSuggestionProvider)provider).shouldCheckOthers())) {
            }
        }
        LookupElement[] lookupElements = new LookupElement[names.size()];
        Iterator iterator = names.iterator();
        for (int i = 0; i < lookupElements.length; ++i) {
            final String suggestion = (String)iterator.next();
            lookupElements[i] = LookupElementBuilder.create((String)suggestion).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                    TextRange range2;
                    if (context == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (item == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (shouldSelectAll) {
                        return;
                    }
                    Editor topLevelEditor = InjectedLanguageUtil.getTopLevelEditor(context.getEditor());
                    TemplateState templateState = TemplateManagerImpl.getTemplateState(topLevelEditor);
                    if (templateState != null && (range2 = templateState.getCurrentVariableRange()) != null) {
                        topLevelEditor.getDocument().replaceString(range2.getStartOffset(), range2.getEndOffset(), (CharSequence)suggestion);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "context";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "item";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/refactoring/rename/inplace/MyLookupExpression$1";
                    objectArray[2] = "handleInsert";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        return lookupElements;
    }

    public LookupElement[] calculateLookupItems(ExpressionContext context) {
        return this.myLookupItems;
    }

    public Result calculateQuickResult(ExpressionContext context) {
        return this.calculateResult(context);
    }

    public Result calculateResult(ExpressionContext context) {
        TextResult insertedValue;
        TemplateState templateState = TemplateManagerImpl.getTemplateState(context.getEditor());
        TextResult textResult = insertedValue = templateState != null ? templateState.getVariableValue("PrimaryVariable") : null;
        if (insertedValue != null && !insertedValue.getText().isEmpty()) {
            return insertedValue;
        }
        return new TextResult(this.myName);
    }

    public String getAdvertisingText() {
        return this.myAdvertisementText;
    }
}

