/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.basic;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class ThreadSafeSimpleDateFormat {
    private final String formatString;
    private final int initialPoolSize;
    private final int maxPoolSize;
    private transient DateFormat[] pool;
    private transient int nextAvailable;
    private transient Object mutex = new Object();

    public ThreadSafeSimpleDateFormat(String format, int initialPoolSize, int maxPoolSize) {
        this.formatString = format;
        this.initialPoolSize = initialPoolSize;
        this.maxPoolSize = maxPoolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(Date date) {
        DateFormat format = this.fetchFromPool();
        try {
            String string = format.format(date);
            return string;
        }
        finally {
            this.putInPool(format);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date parse(String date) throws ParseException {
        DateFormat format = this.fetchFromPool();
        try {
            Date date2 = format.parse(date);
            return date2;
        }
        finally {
            this.putInPool(format);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DateFormat fetchFromPool() {
        DateFormat result;
        Object object = this.mutex;
        synchronized (object) {
            if (this.pool == null) {
                this.nextAvailable = -1;
                this.pool = new DateFormat[this.maxPoolSize];
                for (int i = 0; i < this.initialPoolSize; ++i) {
                    this.putInPool(this.createNew());
                }
            }
            while (this.nextAvailable < 0) {
                try {
                    this.mutex.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Interrupted whilst waiting for a free item in the pool : " + e.getMessage());
                }
            }
            result = this.pool[this.nextAvailable];
            --this.nextAvailable;
        }
        if (result == null) {
            result = this.createNew();
            this.putInPool(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putInPool(DateFormat format) {
        Object object = this.mutex;
        synchronized (object) {
            ++this.nextAvailable;
            this.pool[this.nextAvailable] = format;
            this.mutex.notify();
        }
    }

    private DateFormat createNew() {
        return new SimpleDateFormat(this.formatString, Locale.ENGLISH);
    }

    private Object readResolve() {
        this.mutex = new Object();
        return this;
    }
}

