/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import java.math.BigDecimal;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssCheckableValue;
import org.w3c.css.values.CssUnitsCSS3;

public class CssFlexibleLength
extends CssCheckableValue {
    public static final int type = 21;
    private BigDecimal value = BigDecimal.ZERO;
    protected String unit;

    @Override
    public final int getType() {
        return 21;
    }

    @Override
    public void set(String s, ApplContext ac) throws InvalidParamException {
        String low_s = s.toLowerCase();
        int length = low_s.length();
        int unitIdx = length - 1;
        char c = low_s.charAt(unitIdx);
        while (unitIdx > 0 && c <= 'z' && c >= 'a') {
            c = low_s.charAt(--unitIdx);
        }
        if (unitIdx == length - 1) {
            throw new InvalidParamException("unit", s, ac);
        }
        String unit_str = low_s.substring(++unitIdx, length);
        switch (ac.getCssVersion()) {
            case CSS3: {
                CssUnitsCSS3.parseFlexibleLengthUnit(unit_str, this, ac);
                break;
            }
            default: {
                throw new InvalidParamException("unit", s, ac);
            }
        }
        try {
            this.value = new BigDecimal(low_s.substring(0, unitIdx));
        }
        catch (NumberFormatException nex) {
            throw new InvalidParamException("invalid-number", low_s.substring(0, unitIdx), ac);
        }
    }

    @Override
    public void setValue(BigDecimal v) {
        this.value = v;
    }

    public CssFlexibleLength getFlexibleLength() throws InvalidParamException {
        return this;
    }

    @Override
    public Object get() {
        return new Float(this.value.floatValue());
    }

    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public boolean isPositive() {
        return this.value.signum() >= 0;
    }

    @Override
    public boolean isStrictlyPositive() {
        return this.value.signum() == 1;
    }

    @Override
    public boolean isZero() {
        return BigDecimal.ZERO.compareTo(this.value) == 0;
    }

    public String getUnit() {
        return this.unit;
    }

    public String toString() {
        if (BigDecimal.ZERO.compareTo(this.value) == 0) {
            return BigDecimal.ZERO.toPlainString();
        }
        return this.value.toPlainString() + this.unit;
    }

    @Override
    public boolean equals(Object value) {
        return value instanceof CssFlexibleLength && this.value.equals(((CssFlexibleLength)value).value) && this.unit.equals(((CssFlexibleLength)value).unit);
    }

    @Override
    public void checkEqualsZero(ApplContext ac, String callername) throws InvalidParamException {
        this.checkEqualsZero(ac, new String[]{"length", this.toString(), callername});
    }

    @Override
    public void warnEqualsZero(ApplContext ac, String callername) {
        this.warnEqualsZero(ac, new String[]{"length", callername});
    }
}

