/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import org.armedbear.lisp.AbstractString;
import org.armedbear.lisp.AbstractVector;
import org.armedbear.lisp.Bignum;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Complex;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.DispatchMacroFunction;
import org.armedbear.lisp.DocString;
import org.armedbear.lisp.DoubleFloat;
import org.armedbear.lisp.EndOfFile;
import org.armedbear.lisp.Environment;
import org.armedbear.lisp.FaslReadtable;
import org.armedbear.lisp.FileStream;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispCharacter;
import org.armedbear.lisp.LispClass;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Operator;
import org.armedbear.lisp.Package;
import org.armedbear.lisp.Pathname;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.ReaderError;
import org.armedbear.lisp.ReaderMacroFunction;
import org.armedbear.lisp.Readtable;
import org.armedbear.lisp.SimpleArray_T;
import org.armedbear.lisp.SimpleBitVector;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.SimpleVector;
import org.armedbear.lisp.SingleFloat;
import org.armedbear.lisp.SpecialBindingsMark;
import org.armedbear.lisp.StreamError;
import org.armedbear.lisp.StringInputStream;
import org.armedbear.lisp.StructureClass;
import org.armedbear.lisp.StructureObject;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;
import org.armedbear.lisp.Utilities;
import org.armedbear.lisp.WrongNumberOfArgumentsException;
import org.armedbear.lisp.ZeroRankArray;
import org.armedbear.lisp.util.DecodingReader;

public class Stream
extends StructureObject {
    protected LispObject elementType;
    protected boolean isInputStream;
    protected boolean isOutputStream;
    protected boolean isCharacterStream;
    protected boolean isBinaryStream;
    private boolean pastEnd = false;
    private boolean interactive;
    private boolean open = true;
    protected PushbackReader reader;
    protected int offset;
    protected int lineNumber;
    private Writer writer;
    protected int charPos;
    protected static final Symbol keywordDefault = Lisp.internKeyword("DEFAULT");
    private static final Symbol keywordCodePage = Lisp.internKeyword("CODE-PAGE");
    private static final Symbol keywordID = Lisp.internKeyword("ID");
    private static final Symbol keywordEolStyle = Lisp.internKeyword("EOL-STYLE");
    private static final Symbol keywordCR = Lisp.internKeyword("CR");
    private static final Symbol keywordLF = Lisp.internKeyword("LF");
    private static final Symbol keywordCRLF = Lisp.internKeyword("CRLF");
    private static final Symbol keywordRAW = Lisp.internKeyword("RAW");
    public static final EolStyle platformEolStyle = Utilities.isPlatformWindows ? EolStyle.CRLF : EolStyle.LF;
    protected EolStyle eolStyle = platformEolStyle;
    protected char eolChar = (char)(this.eolStyle == EolStyle.CR ? 13 : 10);
    protected LispObject externalFormat = keywordDefault;
    protected String encoding = null;
    protected char lastChar = '\u0000';
    private InputStream in;
    private OutputStream out;
    public static final Primitive STREAM_EXTERNAL_FORMAT = new pf_stream_external_format();
    public static final Primitive SET_STREAM_EXTERNAL_FORMAT = new pf__set_stream_external_format();
    public static final Primitive AVAILABLE_ENCODINGS = new pf_available_encodings();
    public static ReadtableAccessor currentReadtable = new ReadtableAccessor(){

        @Override
        public Readtable rt(LispThread thread) {
            return (Readtable)Symbol.CURRENT_READTABLE.symbolValue(thread);
        }
    };
    public static ReadtableAccessor faslReadtable = new ReadtableAccessor(){

        @Override
        public Readtable rt(LispThread thread) {
            return FaslReadtable.getInstance();
        }
    };
    private static final Symbol _SHARP_EQUAL_ALIST_ = Lisp.internSpecial("*SHARP-EQUAL-ALIST*", Lisp.PACKAGE_SYS, Lisp.NIL);
    private static final Symbol _SHARP_SHARP_ALIST_ = Lisp.internSpecial("*SHARP-SHARP-ALIST*", Lisp.PACKAGE_SYS, Lisp.NIL);
    private static final Primitive _WRITE_CHAR = new Primitive("%stream-write-char", Lisp.PACKAGE_SYS, true, "character output-stream"){

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            Lisp.checkStream(second)._writeChar(LispCharacter.getValue(first));
            return first;
        }
    };
    private static final Primitive _STREAM_WRITE_CHAR = new Primitive("%write-char", Lisp.PACKAGE_SYS, false, "character output-stream"){

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            char c = LispCharacter.getValue(first);
            if (second == Lisp.T) {
                second = Symbol.TERMINAL_IO.symbolValue();
            } else if (second == Lisp.NIL) {
                second = Symbol.STANDARD_OUTPUT.symbolValue();
            }
            Stream stream = Lisp.checkStream(second);
            stream._writeChar(c);
            return first;
        }
    };
    private static final Primitive _WRITE_STRING = new Primitive("%write-string", Lisp.PACKAGE_SYS, false, "string output-stream start end"){

        @Override
        public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth) {
            AbstractString s = Lisp.checkString(first);
            char[] chars = s.chars();
            Stream out = Lisp.outSynonymOf(second);
            int start = Fixnum.getValue(third);
            int end = fourth == Lisp.NIL ? chars.length : Fixnum.getValue(fourth);
            Lisp.checkBounds(start, end, chars.length);
            out._writeChars(chars, start, end);
            return first;
        }
    };
    private static final Primitive _FINISH_OUTPUT = new Primitive("%finish-output", Lisp.PACKAGE_SYS, false, "output-stream"){

        @Override
        public LispObject execute(LispObject arg) {
            return Stream.finishOutput(arg);
        }
    };
    private static final Primitive _FORCE_OUTPUT = new Primitive("%force-output", Lisp.PACKAGE_SYS, false, "output-stream"){

        @Override
        public LispObject execute(LispObject arg) {
            return Stream.finishOutput(arg);
        }
    };
    private static final Primitive CLEAR_INPUT = new Primitive(Symbol.CLEAR_INPUT, "&optional input-stream"){

        @Override
        public LispObject execute(LispObject[] args) {
            if (args.length > 1) {
                return Lisp.error(new WrongNumberOfArgumentsException((Operator)this, -1, 1));
            }
            Stream in = args.length == 0 ? Lisp.checkCharacterInputStream(Symbol.STANDARD_INPUT.symbolValue()) : Lisp.inSynonymOf(args[0]);
            in.clearInput();
            return Lisp.NIL;
        }
    };
    private static final Primitive _CLEAR_OUTPUT = new Primitive("%clear-output", Lisp.PACKAGE_SYS, false, "output-stream"){

        @Override
        public LispObject execute(LispObject arg) {
            if (arg == Lisp.T) {
                return Lisp.NIL;
            }
            if (arg == Lisp.NIL) {
                return Lisp.NIL;
            }
            if (arg instanceof Stream) {
                return Lisp.NIL;
            }
            return Lisp.type_error(arg, Symbol.STREAM);
        }
    };
    private static final Primitive CLOSE = new Primitive(Symbol.CLOSE, "stream &key abort"){

        @Override
        public LispObject execute(LispObject arg) {
            return Lisp.checkStream(arg).close(Lisp.NIL);
        }

        @Override
        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            Stream stream = Lisp.checkStream(first);
            if (second == Keyword.ABORT) {
                return stream.close(third);
            }
            return Lisp.program_error("Unrecognized keyword argument " + second.princToString() + ".");
        }
    };
    private static final Primitive OUT_SYNONYM_OF = new Primitive("out-synonym-of", Lisp.PACKAGE_SYS, true, "stream-designator"){

        @Override
        public LispObject execute(LispObject arg) {
            if (arg instanceof Stream) {
                return arg;
            }
            if (arg == Lisp.T) {
                return Symbol.TERMINAL_IO.symbolValue();
            }
            if (arg == Lisp.NIL) {
                return Symbol.STANDARD_OUTPUT.symbolValue();
            }
            return arg;
        }
    };
    private static final Primitive WRITE_8_BITS = new Primitive("write-8-bits", Lisp.PACKAGE_SYS, true, "byte stream"){

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            int n = Fixnum.getValue(first);
            if (n < 0 || n > 255) {
                return Lisp.type_error(first, Lisp.UNSIGNED_BYTE_8);
            }
            Lisp.checkStream(second)._writeByte(n);
            return Lisp.NIL;
        }
    };
    private static final Primitive READ_8_BITS = new Primitive("read-8-bits", Lisp.PACKAGE_SYS, true, "stream &optional eof-error-p eof-value"){

        @Override
        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            return Lisp.checkBinaryInputStream(first).readByte(second != Lisp.NIL, third);
        }

        @Override
        public LispObject execute(LispObject[] args) {
            int length = args.length;
            if (length < 1 || length > 3) {
                return Lisp.error(new WrongNumberOfArgumentsException((Operator)this, 1, 3));
            }
            Stream in = Lisp.checkBinaryInputStream(args[0]);
            boolean eofError = length > 1 ? args[1] != Lisp.NIL : true;
            Symbol eofValue = length > 2 ? args[2] : Lisp.NIL;
            return in.readByte(eofError, eofValue);
        }
    };
    private static final Primitive READ_LINE = new Primitive(Symbol.READ_LINE, "&optional input-stream eof-error-p eof-value recursive-p"){

        @Override
        public LispObject execute() {
            LispObject obj = Symbol.STANDARD_INPUT.symbolValue();
            Stream stream = Lisp.checkStream(obj);
            return stream.readLine(true, Lisp.NIL);
        }

        @Override
        public LispObject execute(LispObject arg) {
            if (arg == Lisp.T) {
                arg = Symbol.TERMINAL_IO.symbolValue();
            } else if (arg == Lisp.NIL) {
                arg = Symbol.STANDARD_INPUT.symbolValue();
            }
            Stream stream = Lisp.checkStream(arg);
            return stream.readLine(true, Lisp.NIL);
        }

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            if (first == Lisp.T) {
                first = Symbol.TERMINAL_IO.symbolValue();
            } else if (first == Lisp.NIL) {
                first = Symbol.STANDARD_INPUT.symbolValue();
            }
            Stream stream = Lisp.checkStream(first);
            return stream.readLine(second != Lisp.NIL, Lisp.NIL);
        }

        @Override
        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            if (first == Lisp.T) {
                first = Symbol.TERMINAL_IO.symbolValue();
            } else if (first == Lisp.NIL) {
                first = Symbol.STANDARD_INPUT.symbolValue();
            }
            Stream stream = Lisp.checkStream(first);
            return stream.readLine(second != Lisp.NIL, third);
        }

        @Override
        public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth) {
            if (first == Lisp.T) {
                first = Symbol.TERMINAL_IO.symbolValue();
            } else if (first == Lisp.NIL) {
                first = Symbol.STANDARD_INPUT.symbolValue();
            }
            Stream stream = Lisp.checkStream(first);
            return stream.readLine(second != Lisp.NIL, third);
        }
    };
    private static final Primitive _READ_FROM_STRING = new Primitive("%read-from-string", Lisp.PACKAGE_SYS, false){

        @Override
        public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth, LispObject fifth, LispObject sixth) {
            String s = first.getStringValue();
            boolean eofError = second != Lisp.NIL;
            boolean preserveWhitespace = sixth != Lisp.NIL;
            int startIndex = fourth != Lisp.NIL ? Fixnum.getValue(fourth) : 0;
            int endIndex = fifth != Lisp.NIL ? Fixnum.getValue(fifth) : s.length();
            StringInputStream in = new StringInputStream(s, startIndex, endIndex);
            LispThread thread = LispThread.currentThread();
            LispObject result = preserveWhitespace ? in.readPreservingWhitespace(eofError, third, false, thread, currentReadtable) : in.read(eofError, third, false, thread, currentReadtable);
            return thread.setValues(result, Fixnum.getInstance(in.getOffset()));
        }
    };
    private static final Primitive READ = new Primitive(Symbol.READ, "&optional input-stream eof-error-p eof-value recursive-p"){

        @Override
        public LispObject execute() {
            LispThread thread = LispThread.currentThread();
            LispObject obj = Symbol.STANDARD_INPUT.symbolValue(thread);
            Stream stream = Lisp.checkStream(obj);
            return stream.read(true, Lisp.NIL, false, thread, currentReadtable);
        }

        @Override
        public LispObject execute(LispObject arg) {
            LispThread thread = LispThread.currentThread();
            if (arg == Lisp.T) {
                arg = Symbol.TERMINAL_IO.symbolValue(thread);
            } else if (arg == Lisp.NIL) {
                arg = Symbol.STANDARD_INPUT.symbolValue(thread);
            }
            Stream stream = Lisp.checkStream(arg);
            return stream.read(true, Lisp.NIL, false, thread, currentReadtable);
        }

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            LispThread thread = LispThread.currentThread();
            if (first == Lisp.T) {
                first = Symbol.TERMINAL_IO.symbolValue(thread);
            } else if (first == Lisp.NIL) {
                first = Symbol.STANDARD_INPUT.symbolValue(thread);
            }
            Stream stream = Lisp.checkStream(first);
            return stream.read(second != Lisp.NIL, Lisp.NIL, false, thread, currentReadtable);
        }

        @Override
        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            LispThread thread = LispThread.currentThread();
            if (first == Lisp.T) {
                first = Symbol.TERMINAL_IO.symbolValue(thread);
            } else if (first == Lisp.NIL) {
                first = Symbol.STANDARD_INPUT.symbolValue(thread);
            }
            Stream stream = Lisp.checkStream(first);
            return stream.read(second != Lisp.NIL, third, false, thread, currentReadtable);
        }

        @Override
        public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth) {
            LispThread thread = LispThread.currentThread();
            if (first == Lisp.T) {
                first = Symbol.TERMINAL_IO.symbolValue(thread);
            } else if (first == Lisp.NIL) {
                first = Symbol.STANDARD_INPUT.symbolValue(thread);
            }
            Stream stream = Lisp.checkStream(first);
            return stream.read(second != Lisp.NIL, third, fourth != Lisp.NIL, thread, currentReadtable);
        }
    };
    private static final Primitive READ_PRESERVING_WHITESPACE = new Primitive(Symbol.READ_PRESERVING_WHITESPACE, "&optional input-stream eof-error-p eof-value recursive-p"){

        @Override
        public LispObject execute(LispObject[] args) {
            Symbol eofValue;
            Stream stream;
            int length = args.length;
            if (length > 4) {
                return Lisp.error(new WrongNumberOfArgumentsException((Operator)this, -1, 4));
            }
            Stream stream2 = stream = length > 0 ? Lisp.inSynonymOf(args[0]) : Lisp.getStandardInput();
            boolean eofError = length > 1 ? args[1] != Lisp.NIL : true;
            LispObject lispObject = eofValue = length > 2 ? args[2] : Lisp.NIL;
            boolean recursive = length > 3 ? args[3] != Lisp.NIL : false;
            return stream.readPreservingWhitespace(eofError, eofValue, recursive, LispThread.currentThread(), currentReadtable);
        }
    };
    private static final Primitive READ_CHAR = new Primitive(Symbol.READ_CHAR, "&optional input-stream eof-error-p eof-value recursive-p"){

        @Override
        public LispObject execute() {
            return Lisp.checkCharacterInputStream(Symbol.STANDARD_INPUT.symbolValue()).readChar();
        }

        @Override
        public LispObject execute(LispObject arg) {
            return Lisp.inSynonymOf(arg).readChar();
        }

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            return Lisp.inSynonymOf(first).readChar(second != Lisp.NIL, Lisp.NIL);
        }

        @Override
        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            return Lisp.inSynonymOf(first).readChar(second != Lisp.NIL, third);
        }

        @Override
        public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth) {
            return Lisp.inSynonymOf(first).readChar(second != Lisp.NIL, third);
        }
    };
    private static final Primitive READ_CHAR_NO_HANG = new Primitive("read-char-no-hang", "&optional input-stream eof-error-p eof-value recursive-p"){

        @Override
        public LispObject execute(LispObject[] args) {
            Stream stream;
            int length = args.length;
            if (length > 4) {
                Lisp.error(new WrongNumberOfArgumentsException((Operator)this, -1, 4));
            }
            Stream stream2 = stream = length > 0 ? Lisp.inSynonymOf(args[0]) : Lisp.getStandardInput();
            boolean eofError = length > 1 ? args[1] != Lisp.NIL : true;
            Symbol eofValue = length > 2 ? args[2] : Lisp.NIL;
            return stream.readCharNoHang(eofError, eofValue);
        }
    };
    private static final Primitive READ_DELIMITED_LIST = new Primitive("read-delimited-list", "char &optional input-stream recursive-p"){

        @Override
        public LispObject execute(LispObject[] args) {
            int length = args.length;
            if (length < 1 || length > 3) {
                Lisp.error(new WrongNumberOfArgumentsException((Operator)this, 1, 3));
            }
            char c = LispCharacter.getValue(args[0]);
            Stream stream = length > 1 ? Lisp.inSynonymOf(args[1]) : Lisp.getStandardInput();
            return stream.readDelimitedList(c);
        }
    };
    private static final Primitive UNREAD_CHAR = new Primitive(Symbol.UNREAD_CHAR, "character &optional input-stream"){

        @Override
        public LispObject execute(LispObject arg) {
            return Lisp.getStandardInput().unreadChar(Lisp.checkCharacter(arg));
        }

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            Stream stream = Lisp.inSynonymOf(second);
            return stream.unreadChar(Lisp.checkCharacter(first));
        }
    };
    private static final Primitive WRITE_VECTOR_UNSIGNED_BYTE_8 = new Primitive("write-vector-unsigned-byte-8", Lisp.PACKAGE_SYS, true, "vector stream start end"){

        @Override
        public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth) {
            AbstractVector v = Lisp.checkVector(first);
            Stream stream = Lisp.checkStream(second);
            int start = Fixnum.getValue(third);
            int end = Fixnum.getValue(fourth);
            for (int i = start; i < end; ++i) {
                stream._writeByte(v.aref(i));
            }
            return v;
        }
    };
    private static final Primitive READ_VECTOR_UNSIGNED_BYTE_8 = new Primitive("read-vector-unsigned-byte-8", Lisp.PACKAGE_SYS, true, "vector stream start end"){

        @Override
        public LispObject execute(LispObject first, LispObject second, LispObject third, LispObject fourth) {
            AbstractVector v = Lisp.checkVector(first);
            Stream stream = Lisp.checkBinaryInputStream(second);
            int start = Fixnum.getValue(third);
            int end = Fixnum.getValue(fourth);
            if (!v.getElementType().equal(Lisp.UNSIGNED_BYTE_8)) {
                return Lisp.type_error(first, Lisp.list(Symbol.VECTOR, Lisp.UNSIGNED_BYTE_8));
            }
            for (int i = start; i < end; ++i) {
                int n = stream._readByte();
                if (n < 0) {
                    return Fixnum.getInstance(i);
                }
                v.aset(i, n);
            }
            return fourth;
        }
    };
    private static final Primitive FILE_POSITION = new Primitive("file-position", "stream &optional position-spec"){

        @Override
        public LispObject execute(LispObject arg) {
            return Lisp.checkStream(arg).getFilePosition();
        }

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            return Lisp.checkStream(first).setFilePosition(second);
        }
    };
    private static final Primitive STREAM_LINE_NUMBER = new Primitive("stream-line-number", Lisp.PACKAGE_SYS, false, "stream"){

        @Override
        public LispObject execute(LispObject arg) {
            return Fixnum.getInstance(Lisp.checkStream(arg).getLineNumber() + 1);
        }
    };
    private static final Primitive STREAM_OFFSET = new Primitive("stream-offset", Lisp.PACKAGE_SYS, false, "stream"){

        @Override
        public LispObject execute(LispObject arg) {
            return Lisp.number(Lisp.checkStream(arg).getOffset());
        }
    };
    private static final Primitive STREAM_CHARPOS = new Primitive("stream-charpos", Lisp.PACKAGE_SYS, false){

        @Override
        public LispObject execute(LispObject arg) {
            Stream stream = Lisp.checkCharacterOutputStream(arg);
            return Fixnum.getInstance(stream.getCharPos());
        }
    };
    private static final Primitive STREAM_SET_CHARPOS = new Primitive("stream-%set-charpos", Lisp.PACKAGE_SYS, false){

        @Override
        public LispObject execute(LispObject first, LispObject second) {
            Stream stream = Lisp.checkCharacterOutputStream(first);
            stream.setCharPos(Fixnum.getValue(second));
            return second;
        }
    };

    protected Stream(Symbol structureClass) {
        super(structureClass);
    }

    public Stream(Symbol structureClass, InputStream stream) {
        this(structureClass);
        this.initAsBinaryInputStream(stream);
    }

    public Stream(Symbol structureClass, Reader r) {
        this(structureClass);
        this.initAsCharacterInputStream(r);
    }

    public Stream(Symbol structureClass, OutputStream stream) {
        this(structureClass);
        this.initAsBinaryOutputStream(stream);
    }

    public Stream(Symbol structureClass, Writer w) {
        this(structureClass);
        this.initAsCharacterOutputStream(w);
    }

    public Stream(Symbol structureClass, InputStream inputStream, LispObject elementType) {
        this(structureClass, inputStream, elementType, (LispObject)keywordDefault);
    }

    public Stream(Symbol structureClass, InputStream inputStream, LispObject elementType, LispObject format) {
        this(structureClass);
        this.elementType = elementType;
        this.setExternalFormat(format);
        if (elementType == Symbol.CHARACTER || elementType == Symbol.BASE_CHAR) {
            DecodingReader r = new DecodingReader(inputStream, 4096, this.encoding == null ? Charset.defaultCharset() : Charset.forName(this.encoding));
            this.initAsCharacterInputStream(r);
        } else {
            this.isBinaryStream = true;
            BufferedInputStream stream = new BufferedInputStream(inputStream);
            this.initAsBinaryInputStream(stream);
        }
    }

    public Stream(Symbol structureClass, InputStream inputStream, LispObject elementType, boolean interactive) {
        this(structureClass, inputStream, elementType);
        this.setInteractive(interactive);
    }

    public Stream(Symbol structureClass, OutputStream outputStream, LispObject elementType) {
        this(structureClass, outputStream, elementType, (LispObject)keywordDefault);
    }

    public Stream(Symbol structureClass, OutputStream outputStream, LispObject elementType, LispObject format) {
        this(structureClass);
        this.elementType = elementType;
        this.setExternalFormat(format);
        if (elementType == Symbol.CHARACTER || elementType == Symbol.BASE_CHAR) {
            OutputStreamWriter w = this.encoding == null ? new OutputStreamWriter(outputStream) : new OutputStreamWriter(outputStream, Charset.forName(this.encoding).newEncoder());
            this.initAsCharacterOutputStream(w);
        } else {
            BufferedOutputStream stream = new BufferedOutputStream(outputStream);
            this.initAsBinaryOutputStream(stream);
        }
    }

    public Stream(Symbol structureClass, OutputStream outputStream, LispObject elementType, boolean interactive) {
        this(structureClass, outputStream, elementType);
        this.setInteractive(interactive);
    }

    protected void initAsCharacterInputStream(Reader reader) {
        this.reader = !(reader instanceof PushbackReader) ? new PushbackReader(reader, 5) : (PushbackReader)reader;
        this.isInputStream = true;
        this.isCharacterStream = true;
    }

    protected void initAsBinaryInputStream(InputStream in) {
        this.in = in;
        this.isInputStream = true;
        this.isBinaryStream = true;
    }

    protected void initAsCharacterOutputStream(Writer writer) {
        this.writer = writer;
        this.isOutputStream = true;
        this.isCharacterStream = true;
    }

    protected void initAsBinaryOutputStream(OutputStream out) {
        this.out = out;
        this.isOutputStream = true;
        this.isBinaryStream = true;
    }

    public boolean isInputStream() {
        return this.isInputStream;
    }

    public boolean isOutputStream() {
        return this.isOutputStream;
    }

    public boolean isCharacterInputStream() {
        return this.isCharacterStream && this.isInputStream;
    }

    public boolean isBinaryInputStream() {
        return this.isBinaryStream && this.isInputStream;
    }

    public boolean isCharacterOutputStream() {
        return this.isCharacterStream && this.isOutputStream;
    }

    public boolean isBinaryOutputStream() {
        return this.isBinaryStream && this.isOutputStream;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean b) {
        this.interactive = b;
    }

    public LispObject getExternalFormat() {
        return this.externalFormat;
    }

    public String getEncoding() {
        return this.encoding;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setExternalFormat(LispObject format) {
        LispObject enc;
        boolean encIsCp;
        block16: {
            block17: {
                LispObject eol;
                block18: {
                    this.finishOutput();
                    if (format == keywordDefault) {
                        this.encoding = null;
                        this.eolStyle = platformEolStyle;
                        this.eolChar = (char)(this.eolStyle == EolStyle.CR ? 13 : 10);
                        this.externalFormat = format;
                        return;
                    }
                    encIsCp = false;
                    if (!(format instanceof Cons)) break block17;
                    enc = format.car();
                    if (enc == keywordCodePage) {
                        encIsCp = true;
                        enc = Lisp.getf(format.cdr(), keywordID, null);
                    }
                    if ((eol = Lisp.getf(format.cdr(), keywordEolStyle, keywordRAW)) != keywordCR) break block18;
                    this.eolStyle = EolStyle.CR;
                    break block16;
                }
                if (eol == keywordLF) {
                    this.eolStyle = EolStyle.LF;
                    break block16;
                } else if (eol == keywordCRLF) {
                    this.eolStyle = EolStyle.CRLF;
                    break block16;
                } else if (eol == keywordRAW) {
                    // empty if block
                }
                break block16;
            }
            enc = format;
        }
        if (enc.numberp()) {
            this.encoding = enc.toString();
        } else if (enc instanceof AbstractString) {
            this.encoding = enc.getStringValue();
        } else if (enc == keywordDefault) {
            this.encoding = null;
        } else if (enc instanceof Symbol) {
            this.encoding = ((Symbol)enc).getName();
        }
        if (encIsCp) {
            this.encoding = "Cp" + this.encoding;
        }
        this.eolChar = (char)(this.eolStyle == EolStyle.CR ? 13 : 10);
        this.externalFormat = format;
        if (this.reader != null && this.reader instanceof DecodingReader) {
            ((DecodingReader)this.reader).setCharset(Charset.forName(this.encoding));
        }
    }

    public static List<Symbol> availableEncodings() {
        LinkedList<Symbol> result = new LinkedList<Symbol>();
        SortedMap<String, Charset> available = Charset.availableCharsets();
        Set<String> encodings = available.keySet();
        for (String charset : encodings) {
            result.add(Lisp.PACKAGE_KEYWORD.intern(charset));
        }
        return result;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean b) {
        this.open = b;
    }

    @Override
    public LispObject typeOf() {
        return Symbol.SYSTEM_STREAM;
    }

    @Override
    public LispObject classOf() {
        return BuiltInClass.SYSTEM_STREAM;
    }

    @Override
    public LispObject typep(LispObject typeSpecifier) {
        if (typeSpecifier == Symbol.SYSTEM_STREAM) {
            return Lisp.T;
        }
        if (typeSpecifier == Symbol.STREAM) {
            return Lisp.T;
        }
        if (typeSpecifier == BuiltInClass.STREAM) {
            return Lisp.T;
        }
        return super.typep(typeSpecifier);
    }

    public LispObject getElementType() {
        return this.elementType;
    }

    public int getOffset() {
        return this.offset;
    }

    public final int getLineNumber() {
        return this.lineNumber;
    }

    protected void setWriter(Writer writer) {
        this.writer = writer;
    }

    public int getCharPos() {
        return this.charPos;
    }

    public void setCharPos(int n) {
        this.charPos = n;
    }

    public LispObject read(boolean eofError, LispObject eofValue, boolean recursive, LispThread thread, ReadtableAccessor rta) {
        LispObject result = this.readPreservingWhitespace(eofError, eofValue, recursive, thread, rta);
        if (result != eofValue && !recursive) {
            try {
                int n;
                if (this._charReady() && (n = this._readChar()) >= 0) {
                    char c = (char)n;
                    Readtable rt = rta.rt(thread);
                    if (!rt.isWhitespace(c)) {
                        this._unreadChar(c);
                    }
                }
            }
            catch (IOException e) {
                return Lisp.error(new StreamError(this, e));
            }
        }
        if (Symbol.READ_SUPPRESS.symbolValue(thread) != Lisp.NIL) {
            return Lisp.NIL;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LispObject readPreservingWhitespace(boolean eofError, LispObject eofValue, boolean recursive, LispThread thread, ReadtableAccessor rta) {
        if (recursive) {
            LispObject result;
            int n;
            char c;
            Readtable rt = rta.rt(thread);
            do {
                n = -1;
                try {
                    n = this._readChar();
                }
                catch (IOException e) {
                    Debug.trace(e);
                    Lisp.error(new StreamError(this, e));
                }
                if (n >= 0) continue;
                if (eofError) {
                    return Lisp.error(new EndOfFile(this));
                }
                return eofValue;
            } while (rt.isWhitespace(c = (char)n) || (result = this.processChar(thread, c, rt)) == null);
            return result;
        }
        SpecialBindingsMark mark = thread.markSpecialBindings();
        thread.bindSpecial(_SHARP_EQUAL_ALIST_, Lisp.NIL);
        thread.bindSpecial(_SHARP_SHARP_ALIST_, Lisp.NIL);
        try {
            LispObject lispObject = this.readPreservingWhitespace(eofError, eofValue, true, thread, rta);
            return lispObject;
        }
        finally {
            thread.resetSpecialBindings(mark);
        }
    }

    private final LispObject processChar(LispThread thread, char c, Readtable rt) {
        LispObject[] values;
        LispObject value;
        LispObject handler = rt.getReaderMacroFunction(c);
        if (handler instanceof ReaderMacroFunction) {
            thread._values = null;
            value = ((ReaderMacroFunction)handler).execute(this, c);
        } else if (handler != null && handler != Lisp.NIL) {
            thread._values = null;
            value = handler.execute((LispObject)this, LispCharacter.getInstance(c));
        } else {
            return this.readToken(c, rt);
        }
        if (value == Lisp.NIL && (values = thread._values) != null && values.length == 0) {
            value = null;
            thread._values = null;
        }
        return value;
    }

    public LispObject readPathname(ReadtableAccessor rta) {
        LispObject obj = this.read(true, Lisp.NIL, false, LispThread.currentThread(), rta);
        if (obj instanceof AbstractString) {
            return Pathname.parseNamestring((AbstractString)obj);
        }
        if (obj.listp()) {
            return Pathname.makePathname(obj);
        }
        return Lisp.error(new TypeError("#p requires a string argument."));
    }

    public LispObject readSymbol() {
        Readtable rt = (Readtable)Symbol.CURRENT_READTABLE.symbolValue(LispThread.currentThread());
        return this.readSymbol(rt);
    }

    public LispObject readSymbol(Readtable rt) {
        StringBuilder sb = new StringBuilder();
        BitSet flags = this._readToken(sb, rt);
        return new Symbol(rt.getReadtableCase() == Keyword.INVERT ? Stream.invert(sb.toString(), flags) : sb.toString());
    }

    public LispObject readStructure(ReadtableAccessor rta) {
        LispThread thread = LispThread.currentThread();
        LispObject obj = this.read(true, Lisp.NIL, true, thread, rta);
        if (Symbol.READ_SUPPRESS.symbolValue(thread) != Lisp.NIL) {
            return Lisp.NIL;
        }
        if (obj.listp()) {
            Symbol structure = Lisp.checkSymbol(obj.car());
            LispClass c = LispClass.findClass(structure);
            if (!(c instanceof StructureClass)) {
                return Lisp.error(new ReaderError(structure.getName() + " is not a defined structure type.", this));
            }
            LispObject args = obj.cdr();
            Symbol DEFSTRUCT_DEFAULT_CONSTRUCTOR = Lisp.PACKAGE_SYS.intern("DEFSTRUCT-DEFAULT-CONSTRUCTOR");
            LispObject constructor = DEFSTRUCT_DEFAULT_CONSTRUCTOR.getSymbolFunctionOrDie().execute(structure);
            int length = args.length();
            if (length % 2 != 0) {
                return Lisp.error(new ReaderError("Odd number of keyword arguments following #S: " + obj.princToString(), this));
            }
            LispObject[] array = new LispObject[length];
            LispObject rest = args;
            for (int i = 0; i < length; i += 2) {
                LispObject key = rest.car();
                array[i] = key instanceof Symbol && ((Symbol)key).getPackage() == Lisp.PACKAGE_KEYWORD ? key : Lisp.PACKAGE_KEYWORD.intern(Lisp.javaString(key));
                array[i + 1] = rest.cadr();
                rest = rest.cddr();
            }
            return Lisp.funcall(constructor.getSymbolFunctionOrDie(), array, thread);
        }
        return Lisp.error(new ReaderError("Non-list following #S: " + obj.princToString(), this));
    }

    public LispObject readString(char terminator, ReadtableAccessor rta) {
        LispThread thread = LispThread.currentThread();
        Readtable rt = rta.rt(thread);
        StringBuilder sb = new StringBuilder();
        try {
            while (true) {
                int n;
                if ((n = this._readChar()) < 0) {
                    return Lisp.error(new EndOfFile(this));
                }
                char c = (char)n;
                if (rt.getSyntaxType(c) == 4) {
                    n = this._readChar();
                    if (n < 0) {
                        return Lisp.error(new EndOfFile(this));
                    }
                    sb.append((char)n);
                    continue;
                }
                if (c != terminator) {
                    sb.append(c);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            return new SimpleString(sb);
        }
        return new SimpleString(sb);
    }

    public LispObject readList(boolean requireProperList, ReadtableAccessor rta) {
        LispThread thread = LispThread.currentThread();
        Cons first = null;
        Cons last2 = null;
        try {
            while (true) {
                LispObject obj;
                Readtable rt;
                char c;
                if ((c = this.flushWhitespace(rt = rta.rt(thread))) == ')') {
                    return first == null ? Lisp.NIL : first;
                }
                if (c == '.') {
                    int n = this._readChar();
                    if (n < 0) {
                        return Lisp.error(new EndOfFile(this));
                    }
                    char nextChar = (char)n;
                    if (Stream.isTokenDelimiter(nextChar, rt)) {
                        if (last2 == null) {
                            if (Symbol.READ_SUPPRESS.symbolValue(thread) != Lisp.NIL) {
                                return Lisp.NIL;
                            }
                            return Lisp.error(new ReaderError("Nothing appears before . in list.", this));
                        }
                        this._unreadChar(nextChar);
                        LispObject obj2 = this.read(true, Lisp.NIL, true, thread, rta);
                        if (requireProperList && !obj2.listp()) {
                            Lisp.error(new ReaderError("The value " + obj2.princToString() + " is not of type " + Symbol.LIST.princToString() + ".", this));
                        }
                        last2.cdr = obj2;
                        continue;
                    }
                    this._unreadChar(nextChar);
                }
                if ((obj = this.processChar(thread, c, rt)) == null) continue;
                if (first == null) {
                    last2 = first = new Cons(obj);
                    continue;
                }
                Cons newCons = new Cons(obj);
                last2.cdr = newCons;
                last2 = newCons;
            }
        }
        catch (IOException e) {
            Lisp.error(new StreamError(this, e));
            return null;
        }
    }

    private static final boolean isTokenDelimiter(char c, Readtable rt) {
        byte type = rt.getSyntaxType(c);
        return type == 2 || type == 1;
    }

    public LispObject readDispatchChar(char dispChar, ReadtableAccessor rta) {
        int numArg = -1;
        char c = '\u0000';
        try {
            while (true) {
                int n;
                if ((n = this._readChar()) < 0) {
                    return Lisp.error(new EndOfFile(this));
                }
                c = (char)n;
                if (c >= '0' && c <= '9') {
                    if (numArg < 0) {
                        numArg = 0;
                    }
                    numArg = numArg * 10 + c - 48;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            Lisp.error(new StreamError(this, e));
        }
        LispThread thread = LispThread.currentThread();
        Readtable rt = rta.rt(thread);
        LispObject fun = rt.getDispatchMacroCharacter(dispChar, c);
        if (fun != Lisp.NIL) {
            thread._values = null;
            if (fun instanceof DispatchMacroFunction) {
                return ((DispatchMacroFunction)fun).execute(this, c, numArg);
            }
            return thread.execute(fun, this, LispCharacter.getInstance(c), numArg < 0 ? Lisp.NIL : Fixnum.getInstance(numArg));
        }
        if (Symbol.READ_SUPPRESS.symbolValue(thread) != Lisp.NIL) {
            return null;
        }
        return Lisp.error(new ReaderError("No dispatch function defined for #\\" + c, this));
    }

    public LispObject readSharpLeftParen(char c, int n, ReadtableAccessor rta) {
        LispThread thread = LispThread.currentThread();
        LispObject list = this.readList(true, rta);
        if (Lisp._BACKQUOTE_COUNT_.symbolValue(thread).zerop()) {
            if (n >= 0) {
                LispObject[] array = new LispObject[n];
                for (int i = 0; i < n; ++i) {
                    array[i] = list.car();
                    if (list.cdr() == Lisp.NIL) continue;
                    list = list.cdr();
                }
                return new SimpleVector(array);
            }
            return new SimpleVector(list);
        }
        return new Cons(Lisp._BQ_VECTOR_FLAG_.symbolValue(thread), list);
    }

    public LispObject readSharpStar(char ignored, int n, ReadtableAccessor rta) {
        char c;
        LispThread thread = LispThread.currentThread();
        Readtable rt = rta.rt(thread);
        boolean suppress = Symbol.READ_SUPPRESS.symbolValue(thread) != Lisp.NIL;
        StringBuilder sb = new StringBuilder();
        try {
            int ch;
            while ((ch = this._readChar()) >= 0) {
                c = (char)ch;
                if (c == '0' || c == '1') {
                    sb.append(c);
                    continue;
                }
                byte syntaxType = rt.getSyntaxType(c);
                if (syntaxType == 1 || syntaxType == 2) {
                    this._unreadChar(c);
                    break;
                }
                if (suppress) continue;
                String name = LispCharacter.charToName(c);
                if (name == null) {
                    name = "#\\" + c;
                }
                Lisp.error(new ReaderError("Illegal element for bit-vector: " + name, this));
            }
        }
        catch (IOException e) {
            Lisp.error(new ReaderError("IO error: ", this));
            return Lisp.NIL;
        }
        if (suppress) {
            return Lisp.NIL;
        }
        if (n >= 0) {
            int length = sb.length();
            if (length == 0 && n > 0) {
                return Lisp.error(new ReaderError("No element specified for bit vector of length " + n + '.', this));
            }
            if (n > length) {
                c = sb.charAt(length - 1);
                for (int i = length; i < n; ++i) {
                    sb.append(c);
                }
            } else if (n < length) {
                return Lisp.error(new ReaderError("Bit vector is longer than specified length: #" + n + '*' + sb.toString(), this));
            }
        }
        return new SimpleBitVector(sb.toString());
    }

    public LispObject readSharpDot(char c, int n, ReadtableAccessor rta) {
        LispThread thread = LispThread.currentThread();
        if (Symbol.READ_EVAL.symbolValue(thread) == Lisp.NIL) {
            return Lisp.error(new ReaderError("Can't read #. when *READ-EVAL* is NIL.", this));
        }
        return Lisp.eval(this.read(true, Lisp.NIL, true, thread, rta), new Environment(), thread);
    }

    public LispObject readCharacterLiteral(Readtable rt, LispThread thread) {
        try {
            int n = this._readChar();
            if (n < 0) {
                return Lisp.error(new EndOfFile(this));
            }
            char c = (char)n;
            StringBuilder sb = new StringBuilder(String.valueOf(c));
            while ((n = this._readChar()) >= 0 && !rt.isWhitespace(c = (char)n)) {
                if (rt.getSyntaxType(c) == 2) {
                    this._unreadChar(c);
                    break;
                }
                sb.append(c);
            }
            if (Symbol.READ_SUPPRESS.symbolValue(thread) != Lisp.NIL) {
                return Lisp.NIL;
            }
            if (sb.length() == 1) {
                return LispCharacter.getInstance(sb.charAt(0));
            }
            String token = sb.toString();
            n = LispCharacter.nameToChar(token);
            if (n >= 0) {
                return LispCharacter.getInstance((char)n);
            }
            return Lisp.error(new LispError("Unrecognized character name: \"" + token + '\"'));
        }
        catch (IOException e) {
            return Lisp.error(new StreamError(this, e));
        }
    }

    public void skipBalancedComment() {
        try {
            while (true) {
                int n;
                if ((n = this._readChar()) < 0) {
                    return;
                }
                if (n == 124) {
                    n = this._readChar();
                    if (n == 35) {
                        return;
                    }
                    this._unreadChar(n);
                    continue;
                }
                if (n != 35) continue;
                n = this._readChar();
                if (n == 124) {
                    this.skipBalancedComment();
                    continue;
                }
                this._unreadChar(n);
            }
        }
        catch (IOException e) {
            Lisp.error(new StreamError(this, e));
            return;
        }
    }

    public LispObject readArray(int rank, ReadtableAccessor rta) {
        LispThread thread = LispThread.currentThread();
        LispObject obj = this.read(true, Lisp.NIL, true, thread, rta);
        if (Symbol.READ_SUPPRESS.symbolValue(thread) != Lisp.NIL) {
            return Lisp.NIL;
        }
        switch (rank) {
            case -1: {
                return Lisp.error(new ReaderError("No dimensions argument to #A.", this));
            }
            case 0: {
                return new ZeroRankArray(Lisp.T, obj, false);
            }
            case 1: {
                if (obj.listp() || obj instanceof AbstractVector) {
                    return new SimpleVector(obj);
                }
                return Lisp.error(new ReaderError(obj.princToString() + " is not a sequence.", this));
            }
        }
        return new SimpleArray_T(rank, obj);
    }

    public LispObject readComplex(ReadtableAccessor rta) {
        LispThread thread = LispThread.currentThread();
        LispObject obj = this.read(true, Lisp.NIL, true, thread, rta);
        if (Symbol.READ_SUPPRESS.symbolValue(thread) != Lisp.NIL) {
            return Lisp.NIL;
        }
        if (obj instanceof Cons && obj.length() == 2) {
            return Complex.getInstance(obj.car(), obj.cadr());
        }
        StringBuilder sb = new StringBuilder("Invalid complex number format");
        if (this instanceof FileStream) {
            String namestring;
            Pathname p = ((FileStream)this).getPathname();
            if (p != null && (namestring = p.getNamestring()) != null) {
                sb.append(" in #P\"");
                sb.append(namestring);
                sb.append('\"');
            }
            sb.append(" at offset ");
            sb.append(this._getFilePosition());
        }
        sb.append(": #C");
        sb.append(obj.printObject());
        return Lisp.error(new ReaderError(sb.toString(), this));
    }

    private String readMultipleEscape(Readtable rt) {
        StringBuilder sb = new StringBuilder();
        try {
            while (true) {
                int n;
                if ((n = this._readChar()) < 0) {
                    return Lisp.serror(new EndOfFile(this));
                }
                char c = (char)n;
                byte syntaxType = rt.getSyntaxType(c);
                if (syntaxType == 4) {
                    n = this._readChar();
                    if (n < 0) {
                        return Lisp.serror(new EndOfFile(this));
                    }
                    sb.append((char)n);
                    continue;
                }
                if (syntaxType != 5) {
                    sb.append(c);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            return Lisp.serror(new StreamError(this, e));
        }
        return sb.toString();
    }

    private static final int findUnescapedSingleColon(String s, BitSet flags) {
        if (flags == null) {
            return s.indexOf(58);
        }
        int limit = s.length();
        for (int i = 0; i < limit; ++i) {
            if (s.charAt(i) != ':' || flags.get(i)) continue;
            return i;
        }
        return -1;
    }

    private static final int findUnescapedDoubleColon(String s, BitSet flags) {
        if (flags == null) {
            return s.indexOf("::");
        }
        int limit = s.length() - 1;
        for (int i = 0; i < limit; ++i) {
            if (s.charAt(i) != ':' || flags.get(i) || s.charAt(i + 1) != ':' || flags.get(i + 1)) continue;
            return i;
        }
        return -1;
    }

    private final LispObject readToken(char c, Readtable rt) {
        StringBuilder sb = new StringBuilder(String.valueOf(c));
        LispThread thread = LispThread.currentThread();
        BitSet flags = this._readToken(sb, rt);
        if (Symbol.READ_SUPPRESS.symbolValue(thread) != Lisp.NIL) {
            return Lisp.NIL;
        }
        LispObject readtableCase = rt.getReadtableCase();
        String token = sb.toString();
        boolean invert = readtableCase == Keyword.INVERT;
        int length = token.length();
        if (length > 0) {
            BitSet symbolFlags;
            String symbolName;
            char firstChar = token.charAt(0);
            if (flags == null) {
                LispObject number;
                if (firstChar == '.') {
                    boolean ok = false;
                    int i = length;
                    while (i-- > 1) {
                        if (token.charAt(i) == '.') continue;
                        ok = true;
                        break;
                    }
                    if (!ok) {
                        String message = length > 1 ? "Too many dots." : "Dot context error.";
                        return Lisp.error(new ReaderError(message, this));
                    }
                }
                int radix = Stream.getReadBase(thread);
                if ("+-.0123456789".indexOf(firstChar) >= 0) {
                    LispObject number2 = this.makeNumber(token, length, radix);
                    if (number2 != null) {
                        return number2;
                    }
                } else if (Character.digit(firstChar, radix) >= 0 && (number = this.makeNumber(token, length, radix)) != null) {
                    return number;
                }
            }
            String packageName = null;
            BitSet packageFlags = null;
            Package pkg = null;
            boolean internSymbol = true;
            if (!(firstChar != ':' || flags != null && flags.get(0))) {
                symbolName = token.substring(1);
                pkg = Lisp.PACKAGE_KEYWORD;
                symbolFlags = flags != null ? flags.get(1, flags.size()) : null;
            } else {
                int index = Stream.findUnescapedDoubleColon(token, flags);
                if (index > 0) {
                    packageName = token.substring(0, index);
                    packageFlags = flags != null ? flags.get(0, index) : null;
                    symbolName = token.substring(index + 2);
                    symbolFlags = flags != null ? flags.get(index + 2, flags.size()) : null;
                } else {
                    index = Stream.findUnescapedSingleColon(token, flags);
                    if (index > 0) {
                        packageName = token.substring(0, index);
                        packageFlags = flags != null ? flags.get(0, index) : null;
                        symbolName = token.substring(index + 1);
                        symbolFlags = flags != null ? flags.get(index + 2, flags.size()) : null;
                        internSymbol = false;
                    } else {
                        pkg = (Package)Symbol._PACKAGE_.symbolValue(thread);
                        symbolName = token;
                        symbolFlags = flags;
                    }
                }
            }
            if (pkg == null) {
                if (invert) {
                    packageName = Stream.invert(packageName, packageFlags);
                }
                if ((pkg = Lisp.getCurrentPackage().findPackage(packageName)) == null) {
                    return Lisp.error(new ReaderError("The package \"" + packageName + "\" can't be found.", this));
                }
            }
            if (invert) {
                symbolName = Stream.invert(symbolName, symbolFlags);
            }
            if (internSymbol) {
                return pkg.intern(symbolName);
            }
            Symbol symbol = pkg.findExternalSymbol(symbolName);
            if (symbol != null) {
                return symbol;
            }
            if (pkg.findInternalSymbol(symbolName) != null) {
                return Lisp.error(new ReaderError("The symbol \"~A\" is not external in package ~A.", this, new SimpleString(symbolName), new SimpleString(packageName)));
            }
            return Lisp.error(new ReaderError("The symbol \"~A\" was not found in package ~A.", this, new SimpleString(symbolName), new SimpleString(packageName)));
        }
        Package pkg = (Package)Symbol._PACKAGE_.symbolValue(thread);
        return pkg.intern("");
    }

    private final BitSet _readToken(StringBuilder sb, Readtable rt) {
        BitSet flags = null;
        LispObject readtableCase = rt.getReadtableCase();
        if (sb.length() > 0) {
            Debug.assertTrue(sb.length() == 1);
            char c = sb.charAt(0);
            byte syntaxType = rt.getSyntaxType(c);
            if (syntaxType == 4) {
                int n = -1;
                try {
                    n = this._readChar();
                }
                catch (IOException e) {
                    Lisp.error(new StreamError(this, e));
                    return flags;
                }
                if (n < 0) {
                    Lisp.error(new EndOfFile(this));
                    return null;
                }
                sb.setCharAt(0, (char)n);
                flags = new BitSet(1);
                flags.set(0);
            } else if (syntaxType == 5) {
                sb.setLength(0);
                sb.append(this.readMultipleEscape(rt));
                flags = new BitSet(sb.length());
                flags.set(0, sb.length());
            } else if (rt.isInvalid(c)) {
                rt.checkInvalid(c, this);
            } else if (readtableCase == Keyword.UPCASE) {
                sb.setCharAt(0, LispCharacter.toUpperCase(c));
            } else if (readtableCase == Keyword.DOWNCASE) {
                sb.setCharAt(0, LispCharacter.toLowerCase(c));
            }
        }
        try {
            int n;
            while ((n = this._readChar()) >= 0) {
                char c = (char)n;
                if (rt.isWhitespace(c)) {
                    this._unreadChar(n);
                    break;
                }
                byte syntaxType = rt.getSyntaxType(c);
                if (syntaxType == 2) {
                    this._unreadChar(c);
                    break;
                }
                rt.checkInvalid(c, this);
                if (syntaxType == 4) {
                    n = this._readChar();
                    if (n >= 0) {
                        sb.append((char)n);
                        if (flags == null) {
                            flags = new BitSet(sb.length());
                        }
                        flags.set(sb.length() - 1);
                        continue;
                    }
                    break;
                }
                if (syntaxType == 5) {
                    int begin = sb.length();
                    sb.append(this.readMultipleEscape(rt));
                    int end = sb.length();
                    if (flags == null) {
                        flags = new BitSet(sb.length());
                    }
                    flags.set(begin, end);
                    continue;
                }
                if (readtableCase == Keyword.UPCASE) {
                    c = LispCharacter.toUpperCase(c);
                } else if (readtableCase == Keyword.DOWNCASE) {
                    c = LispCharacter.toLowerCase(c);
                }
                sb.append(c);
            }
        }
        catch (IOException e) {
            Lisp.error(new StreamError(this, e));
            return flags;
        }
        return flags;
    }

    public static final String invert(String s, BitSet flags) {
        int limit = s.length();
        boolean LOWER = true;
        int UPPER = 2;
        int state = 0;
        for (int i = 0; i < limit; ++i) {
            if (flags != null && flags.get(i)) continue;
            char c = s.charAt(i);
            if (Character.isUpperCase(c)) {
                if (state == 1) {
                    return s;
                }
                state = 2;
            }
            if (!Character.isLowerCase(c)) continue;
            if (state == 2) {
                return s;
            }
            state = 1;
        }
        StringBuilder sb = new StringBuilder(limit);
        for (int i = 0; i < limit; ++i) {
            char c = s.charAt(i);
            if (flags != null && flags.get(i)) {
                sb.append(c);
                continue;
            }
            if (Character.isUpperCase(c)) {
                sb.append(Character.toLowerCase(c));
                continue;
            }
            if (Character.isLowerCase(c)) {
                sb.append(Character.toUpperCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static final int getReadBase(LispThread thread) {
        LispObject readBaseObject = Symbol.READ_BASE.symbolValue(thread);
        if (!(readBaseObject instanceof Fixnum)) {
            return Lisp.ierror(new LispError("The value of *READ-BASE* is not of type '(INTEGER 2 36)."));
        }
        int readBase = ((Fixnum)readBaseObject).value;
        if (readBase < 2 || readBase > 36) {
            return Lisp.ierror(new LispError("The value of *READ-BASE* is not of type '(INTEGER 2 36)."));
        }
        return readBase;
    }

    private final LispObject makeNumber(String token, int length, int radix) {
        int i;
        if (length == 0) {
            return null;
        }
        if (token.indexOf(47) >= 0) {
            return this.makeRatio(token, radix);
        }
        if (token.charAt(length - 1) == '.') {
            radix = 10;
            token = token.substring(0, --length);
        }
        boolean numeric = true;
        if (radix == 10) {
            i = length;
            while (i-- > 0) {
                char c = token.charAt(i);
                if (c >= '0' && c <= '9' || i <= 0 && (c == '-' || c == '+')) continue;
                numeric = false;
                break;
            }
        } else {
            i = length;
            while (i-- > 0) {
                char c = token.charAt(i);
                if (Character.digit(c, radix) >= 0 || i <= 0 && (c == '-' || c == '+')) continue;
                numeric = false;
                break;
            }
        }
        if (!numeric) {
            return Stream.makeFloat(token, length);
        }
        if (token.charAt(0) == '+') {
            token = token.substring(1);
        }
        try {
            int n = Integer.parseInt(token, radix);
            return n >= 0 && n <= 255 ? Fixnum.constants[n] : Fixnum.getInstance(n);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Bignum.getInstance(token, radix);
            }
            catch (NumberFormatException numberFormatException2) {
                return null;
            }
        }
    }

    private final LispObject makeRatio(String token, int radix) {
        int index = token.indexOf(47);
        if (index < 0) {
            return null;
        }
        try {
            BigInteger numerator = new BigInteger(token.substring(0, index), radix);
            BigInteger denominator = new BigInteger(token.substring(index + 1), radix);
            if (denominator.signum() == 0) {
                Lisp.error(new ReaderError("Division by zero.", this));
            }
            return Lisp.number(numerator, denominator);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static final LispObject makeFloat(String token, int length) {
        LispObject format;
        if (length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        boolean maybe = false;
        int marker = 0;
        char c = token.charAt(i);
        if (c == '-' || c == '+') {
            sb.append(c);
            ++i;
        }
        while (i < length && ((c = token.charAt(i)) == '.' || c >= '0' && c <= '9')) {
            if (c == '.') {
                maybe = true;
            }
            sb.append(c);
            ++i;
        }
        if (i < length && "esfdlESFDL".indexOf(c = token.charAt(i)) >= 0) {
            maybe = true;
            marker = LispCharacter.toUpperCase(c);
            if (marker == 83) {
                marker = 70;
            } else if (marker == 76) {
                marker = 68;
            } else if (marker == 69) {
                format = Symbol.READ_DEFAULT_FLOAT_FORMAT.symbolValue();
                marker = format == Symbol.SINGLE_FLOAT || format == Symbol.SHORT_FLOAT ? 70 : 68;
            }
            sb.append('E');
            ++i;
        }
        if (!maybe) {
            return null;
        }
        sb.append(token.substring(i));
        c = sb.charAt(sb.length() - 1);
        if ('0' > c || c > '9') {
            return null;
        }
        try {
            if (marker == 0) {
                format = Symbol.READ_DEFAULT_FLOAT_FORMAT.symbolValue();
                marker = format == Symbol.SINGLE_FLOAT || format == Symbol.SHORT_FLOAT ? 70 : 68;
            }
            if (marker == 68) {
                return new DoubleFloat(Double.parseDouble(sb.toString()));
            }
            return new SingleFloat(Float.parseFloat(sb.toString()));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public LispObject readRadix(int radix, ReadtableAccessor rta) {
        boolean escaped;
        StringBuilder sb = new StringBuilder();
        LispThread thread = LispThread.currentThread();
        Readtable rt = rta.rt(thread);
        boolean bl = escaped = this._readToken(sb, rt) != null;
        if (Symbol.READ_SUPPRESS.symbolValue(thread) != Lisp.NIL) {
            return Lisp.NIL;
        }
        if (escaped) {
            return Lisp.error(new ReaderError("Illegal syntax for number.", this));
        }
        String s = sb.toString();
        if (s.indexOf(47) >= 0) {
            return this.makeRatio(s, radix);
        }
        if (s.charAt(0) == '+') {
            s = s.substring(1);
        }
        try {
            int n = Integer.parseInt(s, radix);
            return n >= 0 && n <= 255 ? Fixnum.constants[n] : Fixnum.getInstance(n);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Bignum.getInstance(s, radix);
            }
            catch (NumberFormatException numberFormatException2) {
                return Lisp.error(new LispError());
            }
        }
    }

    private char flushWhitespace(Readtable rt) {
        try {
            int n;
            char c;
            do {
                if ((n = this._readChar()) >= 0) continue;
                return (char)Lisp.ierror(new EndOfFile(this));
            } while (rt.isWhitespace(c = (char)n));
            return c;
        }
        catch (IOException e) {
            Lisp.error(new StreamError(this, e));
            return '\u0000';
        }
    }

    public LispObject readDelimitedList(char delimiter) {
        Readtable rt;
        char c;
        LispThread thread = LispThread.currentThread();
        LispObject result = Lisp.NIL;
        while ((c = this.flushWhitespace(rt = (Readtable)Symbol.CURRENT_READTABLE.symbolValue(thread))) != delimiter) {
            LispObject obj = this.processChar(thread, c, rt);
            if (obj == null) continue;
            result = new Cons(obj, result);
        }
        if (Symbol.READ_SUPPRESS.symbolValue(thread) != Lisp.NIL) {
            return Lisp.NIL;
        }
        return result.nreverse();
    }

    public LispObject readLine(boolean eofError, LispObject eofValue) {
        LispThread thread = LispThread.currentThread();
        StringBuilder sb = new StringBuilder();
        try {
            while (true) {
                int n;
                if ((n = this._readChar()) < 0) {
                    if (sb.length() == 0) {
                        if (eofError) {
                            return Lisp.error(new EndOfFile(this));
                        }
                        return thread.setValues(eofValue, Lisp.T);
                    }
                    return thread.setValues(new SimpleString(sb), Lisp.T);
                }
                if (n == 10) {
                    return thread.setValues(new SimpleString(sb), Lisp.NIL);
                }
                sb.append((char)n);
            }
        }
        catch (IOException e) {
            return Lisp.error(new StreamError(this, e));
        }
    }

    public LispObject readChar() {
        try {
            int n = this._readChar();
            if (n < 0) {
                return Lisp.error(new EndOfFile(this));
            }
            return LispCharacter.getInstance((char)n);
        }
        catch (IOException e) {
            return Lisp.error(new StreamError(this, e));
        }
    }

    public LispObject readChar(boolean eofError, LispObject eofValue) {
        try {
            int n = this._readChar();
            if (n < 0) {
                if (eofError) {
                    return Lisp.error(new EndOfFile(this));
                }
                return eofValue;
            }
            return LispCharacter.getInstance((char)n);
        }
        catch (IOException e) {
            return Lisp.error(new StreamError(this, e));
        }
    }

    public LispObject readCharNoHang(boolean eofError, LispObject eofValue) {
        try {
            return this._charReady() ? this.readChar(eofError, eofValue) : Lisp.NIL;
        }
        catch (IOException e) {
            return Lisp.error(new StreamError(this, e));
        }
    }

    public LispObject unreadChar(LispCharacter c) {
        try {
            this._unreadChar(c.value);
            return Lisp.NIL;
        }
        catch (IOException e) {
            return Lisp.error(new StreamError(this, e));
        }
    }

    public LispObject finishOutput() {
        this._finishOutput();
        return Lisp.NIL;
    }

    public LispObject clearInput() {
        this._clearInput();
        return Lisp.NIL;
    }

    public LispObject getFilePosition() {
        long pos = this._getFilePosition();
        return pos >= 0L ? Lisp.number(pos) : Lisp.NIL;
    }

    public LispObject setFilePosition(LispObject arg) {
        return this._setFilePosition(arg) ? Lisp.T : Lisp.NIL;
    }

    public LispObject close(LispObject abort) {
        this._close();
        return Lisp.T;
    }

    public LispObject readByte(boolean eofError, LispObject eofValue) {
        int n = this._readByte();
        if (n < 0) {
            if (eofError) {
                return Lisp.error(new EndOfFile(this));
            }
            return eofValue;
        }
        return Fixnum.constants[n];
    }

    public LispObject terpri() {
        this._writeChar('\n');
        return Lisp.NIL;
    }

    public LispObject freshLine() {
        if (this.charPos == 0) {
            return Lisp.NIL;
        }
        this._writeChar('\n');
        return Lisp.T;
    }

    public void print(char c) {
        this._writeChar(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prin1(LispObject obj) {
        LispThread thread = LispThread.currentThread();
        SpecialBindingsMark mark = thread.markSpecialBindings();
        thread.bindSpecial(Symbol.PRINT_ESCAPE, Lisp.T);
        try {
            this._writeString(obj.printObject());
        }
        finally {
            thread.resetSpecialBindings(mark);
        }
    }

    public LispObject listen() {
        if (this.pastEnd) {
            return Lisp.NIL;
        }
        try {
            if (this.isCharacterInputStream()) {
                if (!this._charReady()) {
                    return Lisp.NIL;
                }
                int n = this._readChar();
                if (n < 0) {
                    return Lisp.NIL;
                }
                this._unreadChar(n);
                return Lisp.T;
            }
            if (this.isInputStream()) {
                if (!this._byteReady()) {
                    return Lisp.NIL;
                }
                return Lisp.T;
            }
            return Lisp.error(new StreamError(this, "Not an input stream"));
        }
        catch (IOException e) {
            return Lisp.error(new StreamError(this, e));
        }
    }

    public LispObject fileLength() {
        return Lisp.type_error(this, Symbol.FILE_STREAM);
    }

    public LispObject fileStringLength(LispObject arg) {
        if (arg instanceof LispCharacter) {
            if (Utilities.isPlatformWindows && ((LispCharacter)arg).value == '\n') {
                return Fixnum.TWO;
            }
            return Fixnum.ONE;
        }
        if (arg instanceof AbstractString) {
            if (Utilities.isPlatformWindows) {
                int fileStringLength = 0;
                char[] chars = ((AbstractString)arg).getStringChars();
                int i = chars.length;
                while (i-- > 0) {
                    if (chars[i] == '\n') {
                        fileStringLength += 2;
                        continue;
                    }
                    ++fileStringLength;
                }
                return Lisp.number(fileStringLength);
            }
            return Lisp.number(arg.length());
        }
        return Lisp.error(new TypeError(arg.princToString() + " is neither a string nor a character."));
    }

    protected int _readChar() throws IOException {
        int n;
        if (this.reader == null) {
            this.streamNotCharacterInputStream();
        }
        if ((n = this.reader.read()) < 0) {
            this.pastEnd = true;
            return -1;
        }
        ++this.offset;
        if (n == 13 && this.eolStyle == EolStyle.CRLF) {
            n = this._readChar();
            if (n != 10) {
                this._unreadChar(n);
                return 13;
            }
            return 10;
        }
        if (n == this.eolChar) {
            ++this.lineNumber;
            return 10;
        }
        return n;
    }

    protected void _unreadChar(int n) throws IOException {
        if (this.reader == null) {
            this.streamNotCharacterInputStream();
        }
        --this.offset;
        if (n == 10) {
            n = this.eolChar;
            --this.lineNumber;
        }
        this.reader.unread(n);
        this.pastEnd = false;
    }

    protected boolean _charReady() throws IOException {
        if (this.reader == null) {
            this.streamNotCharacterInputStream();
        }
        return this.reader.ready();
    }

    protected boolean _byteReady() throws IOException {
        if (this.in == null) {
            this.streamNotInputStream();
        }
        return this.in.available() != 0;
    }

    public void _writeChar(char c) {
        try {
            if (c == '\n') {
                if (this.eolStyle == EolStyle.CRLF && this.lastChar != '\r') {
                    this.writer.write(13);
                }
                this.writer.write(this.eolChar);
                this.lastChar = this.eolChar;
                this.writer.flush();
                this.charPos = 0;
            } else {
                this.writer.write(c);
                this.lastChar = c;
                ++this.charPos;
            }
        }
        catch (NullPointerException e) {
            this.streamNotCharacterOutputStream();
        }
        catch (IOException e) {
            Lisp.error(new StreamError(this, e));
        }
    }

    public void _writeChars(char[] chars, int start, int end) {
        try {
            if (this.eolStyle != EolStyle.RAW) {
                for (int i = start; i < end; ++i) {
                    this._writeChar(chars[i]);
                }
                return;
            }
            this.writer.write(chars, start, end - start);
            if (start < end) {
                this.lastChar = chars[end - 1];
            }
            int index = -1;
            int i = end;
            while (i-- > start) {
                if (chars[i] != '\n') continue;
                index = i;
                break;
            }
            if (index < 0) {
                this.charPos += end - start;
            } else {
                this.charPos = end - (index + 1);
                this.writer.flush();
            }
        }
        catch (NullPointerException e) {
            if (this.writer == null) {
                this.streamNotCharacterOutputStream();
            }
            throw e;
        }
        catch (IOException e) {
            Lisp.error(new StreamError(this, e));
        }
    }

    public void _writeString(String s) {
        try {
            this._writeChars(s.toCharArray(), 0, s.length());
        }
        catch (NullPointerException e) {
            if (this.writer == null) {
                this.streamNotCharacterOutputStream();
            }
            throw e;
        }
    }

    public void _writeLine(String s) {
        try {
            this._writeString(s);
            this._writeChar('\n');
        }
        catch (NullPointerException e) {
            this.streamNotCharacterOutputStream();
        }
    }

    public int _readByte() {
        try {
            int n = this.in.read();
            if (n < 0) {
                this.pastEnd = true;
            }
            return n;
        }
        catch (IOException e) {
            return Lisp.ierror(new StreamError(this, e));
        }
    }

    public void _writeByte(int n) {
        try {
            this.out.write(n);
        }
        catch (NullPointerException e) {
            this.streamNotBinaryOutputStream();
        }
        catch (IOException e) {
            Lisp.error(new StreamError(this, e));
        }
    }

    public void _finishOutput() {
        try {
            if (this.writer != null) {
                this.writer.flush();
            }
            if (this.out != null) {
                this.out.flush();
            }
        }
        catch (IOException e) {
            Lisp.error(new StreamError(this, e));
        }
    }

    public void _clearInput() {
        if (this.reader != null) {
            int c = 0;
            try {
                while (this._charReady() && c >= 0) {
                    c = this._readChar();
                }
            }
            catch (IOException e) {
                Lisp.error(new StreamError(this, e));
            }
        } else if (this.in != null) {
            try {
                int n = 0;
                while (this.in.available() > 0) {
                    n = this.in.read();
                }
                if (n < 0) {
                    this.pastEnd = true;
                }
            }
            catch (IOException e) {
                Lisp.error(new StreamError(this, e));
            }
        }
    }

    protected long _getFilePosition() {
        return -1L;
    }

    protected boolean _setFilePosition(LispObject arg) {
        return false;
    }

    public void _close() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
            if (this.in != null) {
                this.in.close();
            }
            if (this.writer != null) {
                this.writer.close();
            }
            if (this.out != null) {
                this.out.close();
            }
            this.setOpen(false);
        }
        catch (IOException e) {
            Lisp.error(new StreamError(this, e));
        }
    }

    public void printStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        try {
            this.writer.write(sw.toString());
            this.writer.write(10);
            this.lastChar = (char)10;
            this.writer.flush();
            this.charPos = 0;
        }
        catch (IOException e) {
            Lisp.error(new StreamError(this, e));
        }
    }

    protected LispObject streamNotInputStream() {
        return Lisp.error(new StreamError(this, this.princToString() + " is not an input stream."));
    }

    protected LispObject streamNotCharacterInputStream() {
        return Lisp.error(new StreamError(this, this.princToString() + " is not a character input stream."));
    }

    protected LispObject streamNotOutputStream() {
        return Lisp.error(new StreamError(this, this.princToString() + " is not an output stream."));
    }

    protected LispObject streamNotBinaryOutputStream() {
        return Lisp.error(new StreamError(this, this.princToString() + " is not a binary output stream."));
    }

    protected LispObject streamNotCharacterOutputStream() {
        return Lisp.error(new StreamError(this, this.princToString() + " is not a character output stream."));
    }

    static final LispObject finishOutput(LispObject arg) {
        LispObject out = arg == Lisp.T ? Symbol.TERMINAL_IO.symbolValue() : (arg == Lisp.NIL ? Symbol.STANDARD_OUTPUT.symbolValue() : arg);
        return Lisp.checkStream(out).finishOutput();
    }

    public InputStream getWrappedInputStream() {
        return this.in;
    }

    public OutputStream getWrappedOutputStream() {
        return this.out;
    }

    public Writer getWrappedWriter() {
        return this.writer;
    }

    public PushbackReader getWrappedReader() {
        return this.reader;
    }

    public static abstract class ReadtableAccessor {
        public abstract Readtable rt(LispThread var1);
    }

    @DocString(name="available-encodings", returns="encodings", doc="Returns all charset encodings suitable for passing to a stream constructor available at runtime.")
    private static final class pf_available_encodings
    extends Primitive {
        pf_available_encodings() {
            super("available-encodings", Lisp.PACKAGE_SYS, true);
        }

        @Override
        public LispObject execute() {
            LispObject result = Lisp.NIL;
            for (Symbol encoding : Stream.availableEncodings()) {
                result = result.push(encoding);
            }
            return result.nreverse();
        }
    }

    @DocString(name="%set-stream-external-format", args="stream format")
    private static final class pf__set_stream_external_format
    extends Primitive {
        pf__set_stream_external_format() {
            super("%set-stream-external-format", Lisp.PACKAGE_SYS, false, "stream external-format");
        }

        @Override
        public LispObject execute(LispObject stream, LispObject format) {
            Stream s = Lisp.checkStream(stream);
            s.setExternalFormat(format);
            return format;
        }
    }

    @DocString(name="stream-external-format", args="stream", doc="Returns the external format of STREAM.")
    private static final class pf_stream_external_format
    extends Primitive {
        pf_stream_external_format() {
            super("stream-external-format", "stream");
        }

        @Override
        public LispObject execute(LispObject arg) {
            if (arg instanceof Stream) {
                return ((Stream)arg).getExternalFormat();
            }
            return Lisp.type_error(arg, Symbol.STREAM);
        }
    }

    public static enum EolStyle {
        RAW,
        CR,
        CRLF,
        LF;

    }
}

