/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.authz.permission;

import java.util.Set;
import org.apache.shiro.authz.permission.WildcardPermission;
import org.apache.shiro.util.StringUtils;

public class DomainPermission
extends WildcardPermission {
    private String domain = this.getDomain(this.getClass());
    private Set<String> actions;
    private Set<String> targets;
    private static final long serialVersionUID = 1L;

    public DomainPermission() {
        this.setParts(this.getDomain(this.getClass()));
    }

    public DomainPermission(String actions) {
        this.actions = StringUtils.splitToSet(actions, ",");
        this.encodeParts(this.domain, actions, null);
    }

    public DomainPermission(String actions, String targets) {
        this.actions = StringUtils.splitToSet(actions, ",");
        this.targets = StringUtils.splitToSet(targets, ",");
        this.encodeParts(this.domain, actions, targets);
    }

    protected DomainPermission(Set<String> actions, Set<String> targets) {
        this.setParts(this.domain, actions, targets);
    }

    private void encodeParts(String domain, String actions, String targets) {
        if (!StringUtils.hasText(domain)) {
            throw new IllegalArgumentException("domain argument cannot be null or empty.");
        }
        StringBuilder sb = new StringBuilder(domain);
        if (!StringUtils.hasText(actions)) {
            if (StringUtils.hasText(targets)) {
                sb.append(":").append("*");
            }
        } else {
            sb.append(":").append(actions);
        }
        if (StringUtils.hasText(targets)) {
            sb.append(":").append(targets);
        }
        this.setParts(sb.toString());
    }

    protected void setParts(String domain, Set<String> actions, Set<String> targets) {
        String actionsString = StringUtils.toDelimitedString(actions, ",");
        String targetsString = StringUtils.toDelimitedString(targets, ",");
        this.encodeParts(domain, actionsString, targetsString);
        this.domain = domain;
        this.actions = actions;
        this.targets = targets;
    }

    protected String getDomain(Class<? extends DomainPermission> clazz) {
        String domain = clazz.getSimpleName().toLowerCase();
        int index = domain.lastIndexOf("permission");
        if (index != -1) {
            domain = domain.substring(0, index);
        }
        return domain;
    }

    public String getDomain() {
        return this.domain;
    }

    protected void setDomain(String domain) {
        if (this.domain != null && this.domain.equals(domain)) {
            return;
        }
        this.domain = domain;
        this.setParts(domain, this.actions, this.targets);
    }

    public Set<String> getActions() {
        return this.actions;
    }

    protected void setActions(Set<String> actions) {
        if (this.actions != null && this.actions.equals(actions)) {
            return;
        }
        this.actions = actions;
        this.setParts(this.domain, actions, this.targets);
    }

    public Set<String> getTargets() {
        return this.targets;
    }

    protected void setTargets(Set<String> targets) {
        this.targets = targets;
        if (this.targets != null && this.targets.equals(targets)) {
            return;
        }
        this.targets = targets;
        this.setParts(this.domain, this.actions, targets);
    }
}

