/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.packet;

import java.io.EOFException;
import java.io.IOException;
import org.apache.activeio.packet.Packet;

public final class PacketData {
    private final Packet packet;
    private final boolean bigEndian;

    public PacketData(Packet packet) {
        this(packet, true);
    }

    public PacketData(Packet packet, boolean bigEndian) {
        this.packet = packet;
        this.bigEndian = bigEndian;
    }

    private static void spaceNeeded(Packet packet, int space) throws IOException {
        if (packet.remaining() < space) {
            throw new EOFException("Not enough space left in the packet.");
        }
    }

    public void readFully(byte[] b) throws IOException {
        PacketData.readFully(this.packet, b, 0, b.length);
    }

    public static void readFully(Packet packet, byte[] b) throws IOException {
        PacketData.readFully(packet, b, 0, b.length);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        PacketData.readFully(this.packet, b, off, len);
    }

    public static void readFully(Packet packet, byte[] b, int off, int len) throws IOException {
        PacketData.spaceNeeded(packet, len);
        packet.read(b, off, len);
    }

    public int skipBytes(int n) throws IOException {
        return PacketData.skipBytes(this.packet, n);
    }

    public static int skipBytes(Packet packet, int n) throws IOException {
        int rc = Math.min(n, packet.remaining());
        packet.position(packet.position() + rc);
        return rc;
    }

    public boolean readBoolean() throws IOException {
        return PacketData.readBoolean(this.packet);
    }

    public static boolean readBoolean(Packet packet) throws IOException {
        PacketData.spaceNeeded(packet, 1);
        return packet.read() != 0;
    }

    public byte readByte() throws IOException {
        return PacketData.readByte(this.packet);
    }

    public static byte readByte(Packet packet) throws IOException {
        PacketData.spaceNeeded(packet, 1);
        return (byte)packet.read();
    }

    public int readUnsignedByte() throws IOException {
        return PacketData.readUnsignedByte(this.packet);
    }

    public static int readUnsignedByte(Packet packet) throws IOException {
        PacketData.spaceNeeded(packet, 1);
        return packet.read();
    }

    public short readShort() throws IOException {
        if (this.bigEndian) {
            return PacketData.readShortBig(this.packet);
        }
        return PacketData.readShortLittle(this.packet);
    }

    public static short readShortBig(Packet packet) throws IOException {
        PacketData.spaceNeeded(packet, 2);
        return (short)((packet.read() << 8) + (packet.read() << 0));
    }

    public static short readShortLittle(Packet packet) throws IOException {
        PacketData.spaceNeeded(packet, 2);
        return (short)((packet.read() << 0) + (packet.read() << 8));
    }

    public int readUnsignedShort() throws IOException {
        if (this.bigEndian) {
            return PacketData.readUnsignedShortBig(this.packet);
        }
        return PacketData.readUnsignedShortLittle(this.packet);
    }

    public static int readUnsignedShortBig(Packet packet) throws IOException {
        PacketData.spaceNeeded(packet, 2);
        return (packet.read() << 8) + (packet.read() << 0);
    }

    public static int readUnsignedShortLittle(Packet packet) throws IOException {
        PacketData.spaceNeeded(packet, 2);
        return (packet.read() << 0) + (packet.read() << 8);
    }

    public char readChar() throws IOException {
        if (this.bigEndian) {
            return PacketData.readCharBig(this.packet);
        }
        return PacketData.readCharLittle(this.packet);
    }

    public static char readCharBig(Packet packet) throws IOException {
        PacketData.spaceNeeded(packet, 2);
        return (char)((packet.read() << 8) + (packet.read() << 0));
    }

    public static char readCharLittle(Packet packet) throws IOException {
        PacketData.spaceNeeded(packet, 2);
        return (char)((packet.read() << 0) + (packet.read() << 8));
    }

    public int readInt() throws IOException {
        if (this.bigEndian) {
            return PacketData.readIntBig(this.packet);
        }
        return PacketData.readIntLittle(this.packet);
    }

    public static int readIntBig(Packet packet) throws IOException {
        PacketData.spaceNeeded(packet, 4);
        return (packet.read() << 24) + (packet.read() << 16) + (packet.read() << 8) + (packet.read() << 0);
    }

    public static int readIntLittle(Packet packet) throws IOException {
        PacketData.spaceNeeded(packet, 4);
        return (packet.read() << 0) + (packet.read() << 8) + (packet.read() << 16) + (packet.read() << 24);
    }

    public long readLong() throws IOException {
        if (this.bigEndian) {
            return PacketData.readLongBig(this.packet);
        }
        return PacketData.readLongLittle(this.packet);
    }

    public static long readLongBig(Packet packet) throws IOException {
        PacketData.spaceNeeded(packet, 8);
        return ((long)packet.read() << 56) + ((long)packet.read() << 48) + ((long)packet.read() << 40) + ((long)packet.read() << 32) + ((long)packet.read() << 24) + (long)(packet.read() << 16) + (long)(packet.read() << 8) + (long)(packet.read() << 0);
    }

    public static long readLongLittle(Packet packet) throws IOException {
        PacketData.spaceNeeded(packet, 8);
        return (long)((packet.read() << 0) + (packet.read() << 8) + (packet.read() << 16)) + ((long)packet.read() << 24) + ((long)packet.read() << 32) + ((long)packet.read() << 40) + ((long)packet.read() << 48) + ((long)packet.read() << 56);
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public static double readDoubleBig(Packet packet) throws IOException {
        return Double.longBitsToDouble(PacketData.readLongBig(packet));
    }

    public static double readDoubleLittle(Packet packet) throws IOException {
        return Double.longBitsToDouble(PacketData.readLongLittle(packet));
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public static float readFloatBig(Packet packet) throws IOException {
        return Float.intBitsToFloat(PacketData.readIntBig(packet));
    }

    public static float readFloatLittle(Packet packet) throws IOException {
        return Float.intBitsToFloat(PacketData.readIntLittle(packet));
    }

    public void write(int b) throws IOException {
        PacketData.write(this.packet, b);
    }

    public static void write(Packet packet, int b) throws IOException {
        PacketData.spaceNeeded(packet, 1);
        packet.write(b);
    }

    public void write(byte[] b) throws IOException {
        PacketData.write(this.packet, b, 0, b.length);
    }

    public static void write(Packet packet, byte[] b) throws IOException {
        PacketData.write(packet, b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        PacketData.write(this.packet, b, off, len);
    }

    public static void write(Packet packet, byte[] b, int off, int len) throws IOException {
        PacketData.spaceNeeded(packet, len);
        packet.write(b, off, len);
    }

    public void writeBoolean(boolean v) throws IOException {
        PacketData.writeBoolean(this.packet, v);
    }

    public static void writeBoolean(Packet packet, boolean v) throws IOException {
        PacketData.spaceNeeded(packet, 1);
        packet.write(v ? 1 : 0);
    }

    public void writeByte(int v) throws IOException {
        PacketData.writeByte(this.packet, v);
    }

    public static void writeByte(Packet packet, int v) throws IOException {
        PacketData.spaceNeeded(packet, 1);
        packet.write(v);
    }

    public void writeShort(int v) throws IOException {
        if (this.bigEndian) {
            PacketData.writeShortBig(this.packet, v);
        } else {
            PacketData.writeShortLittle(this.packet, v);
        }
    }

    public static void writeShortBig(Packet packet, int v) throws IOException {
        PacketData.spaceNeeded(packet, 2);
        packet.write(v >>> 8 & 0xFF);
        packet.write(v >>> 0 & 0xFF);
    }

    public static void writeShortLittle(Packet packet, int v) throws IOException {
        PacketData.spaceNeeded(packet, 2);
        packet.write(v >>> 0 & 0xFF);
        packet.write(v >>> 8 & 0xFF);
    }

    public void writeChar(int v) throws IOException {
        if (this.bigEndian) {
            PacketData.writeCharBig(this.packet, v);
        } else {
            PacketData.writeCharLittle(this.packet, v);
        }
    }

    public static void writeCharBig(Packet packet, int v) throws IOException {
        PacketData.spaceNeeded(packet, 2);
        packet.write(v >>> 8 & 0xFF);
        packet.write(v >>> 0 & 0xFF);
    }

    public static void writeCharLittle(Packet packet, int v) throws IOException {
        PacketData.spaceNeeded(packet, 2);
        packet.write(v >>> 0 & 0xFF);
        packet.write(v >>> 8 & 0xFF);
    }

    public void writeInt(int v) throws IOException {
        if (this.bigEndian) {
            PacketData.writeIntBig(this.packet, v);
        } else {
            PacketData.writeIntLittle(this.packet, v);
        }
    }

    public static void writeIntBig(Packet packet, int v) throws IOException {
        PacketData.spaceNeeded(packet, 4);
        packet.write(v >>> 24 & 0xFF);
        packet.write(v >>> 16 & 0xFF);
        packet.write(v >>> 8 & 0xFF);
        packet.write(v >>> 0 & 0xFF);
    }

    public static void writeIntLittle(Packet packet, int v) throws IOException {
        PacketData.spaceNeeded(packet, 4);
        packet.write(v >>> 0 & 0xFF);
        packet.write(v >>> 8 & 0xFF);
        packet.write(v >>> 16 & 0xFF);
        packet.write(v >>> 24 & 0xFF);
    }

    public void writeLong(long v) throws IOException {
        if (this.bigEndian) {
            PacketData.writeLongBig(this.packet, v);
        } else {
            PacketData.writeLongLittle(this.packet, v);
        }
    }

    public static void writeLongBig(Packet packet, long v) throws IOException {
        PacketData.spaceNeeded(packet, 8);
        packet.write((int)(v >>> 56) & 0xFF);
        packet.write((int)(v >>> 48) & 0xFF);
        packet.write((int)(v >>> 40) & 0xFF);
        packet.write((int)(v >>> 32) & 0xFF);
        packet.write((int)(v >>> 24) & 0xFF);
        packet.write((int)(v >>> 16) & 0xFF);
        packet.write((int)(v >>> 8) & 0xFF);
        packet.write((int)(v >>> 0) & 0xFF);
    }

    public static void writeLongLittle(Packet packet, long v) throws IOException {
        PacketData.spaceNeeded(packet, 8);
        packet.write((int)(v >>> 0) & 0xFF);
        packet.write((int)(v >>> 8) & 0xFF);
        packet.write((int)(v >>> 16) & 0xFF);
        packet.write((int)(v >>> 24) & 0xFF);
        packet.write((int)(v >>> 32) & 0xFF);
        packet.write((int)(v >>> 40) & 0xFF);
        packet.write((int)(v >>> 48) & 0xFF);
        packet.write((int)(v >>> 56) & 0xFF);
    }

    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public static void writeDoubleBig(Packet packet, double v) throws IOException {
        PacketData.writeLongBig(packet, Double.doubleToLongBits(v));
    }

    public static void writeDoubleLittle(Packet packet, double v) throws IOException {
        PacketData.writeLongLittle(packet, Double.doubleToLongBits(v));
    }

    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public static void writeFloatBig(Packet packet, float v) throws IOException {
        PacketData.writeIntBig(packet, Float.floatToIntBits(v));
    }

    public static void writeFloatLittle(Packet packet, float v) throws IOException {
        PacketData.writeIntLittle(packet, Float.floatToIntBits(v));
    }

    public void writeRawDouble(double v) throws IOException {
        this.writeLong(Double.doubleToRawLongBits(v));
    }

    public static void writeRawDoubleBig(Packet packet, double v) throws IOException {
        PacketData.writeLongBig(packet, Double.doubleToRawLongBits(v));
    }

    public static void writeRawDoubleLittle(Packet packet, double v) throws IOException {
        PacketData.writeLongLittle(packet, Double.doubleToRawLongBits(v));
    }

    public void writeRawFloat(float v) throws IOException {
        this.writeInt(Float.floatToRawIntBits(v));
    }

    public static void writeRawFloatBig(Packet packet, float v) throws IOException {
        PacketData.writeIntBig(packet, Float.floatToRawIntBits(v));
    }

    public static void writeRawFloatLittle(Packet packet, float v) throws IOException {
        PacketData.writeIntLittle(packet, Float.floatToRawIntBits(v));
    }
}

