/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.text;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.linkedin.util.reflect.ObjectProxy;

public class IdentityString {
    public static final IdentityString FULL_IDENTITY_STRING = new IdentityString(new ClassNameExtractor(){

        @Override
        public String getClassName(Object o) {
            return o.getClass().getName();
        }
    });
    public static final IdentityString SHORT_IDENTITY_STRING = new IdentityString(new ClassNameExtractor(){

        @Override
        public String getClassName(Object o) {
            return o.getClass().getSimpleName();
        }
    });
    private final ClassNameExtractor _classNameExtractor;

    public IdentityString(ClassNameExtractor classNameExtractor) {
        this._classNameExtractor = classNameExtractor;
    }

    public String getIdentity(Object o) {
        InvocationHandler invocationHandler;
        if (o == null) {
            return "null";
        }
        if (o.getClass().isArray()) {
            int len = Array.getLength(o);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(this.getIdentity(Array.get(o, i)));
            }
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this._classNameExtractor.getClassName(o)).append('@').append(Integer.toHexString(System.identityHashCode(o)));
        if (Proxy.isProxyClass(o.getClass()) && (invocationHandler = Proxy.getInvocationHandler(o)) instanceof ObjectProxy) {
            ObjectProxy objectProxy = (ObjectProxy)((Object)invocationHandler);
            Object proxiedObject = objectProxy.getProxiedObject();
            sb.append(" (proxy of: ").append(this.getIdentity(proxiedObject)).append(")");
        }
        return sb.toString();
    }

    private static interface ClassNameExtractor {
        public String getClassName(Object var1);
    }
}

