/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.camel;

import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.TopicPublisher;
import javax.jms.TopicSubscriber;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.CustomDestination;
import org.apache.activemq.camel.CamelConnection;
import org.apache.activemq.camel.CamelMessageConsumer;
import org.apache.activemq.camel.CamelMessageProducer;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.component.jms.JmsBinding;
import org.apache.camel.component.jms.JmsEndpoint;

public class CamelDestination
implements CustomDestination,
CamelContextAware {
    private String uri;
    private Endpoint endpoint;
    private CamelContext camelContext;
    private JmsBinding binding = new JmsBinding(new JmsEndpoint());

    public CamelDestination() {
    }

    public CamelDestination(String uri) {
        this.uri = uri;
    }

    public String toString() {
        return this.uri.toString();
    }

    public MessageConsumer createConsumer(ActiveMQSession session, String messageSelector) {
        return this.createConsumer(session, messageSelector, false);
    }

    public MessageConsumer createConsumer(ActiveMQSession session, String messageSelector, boolean noLocal) {
        return new CamelMessageConsumer(this, this.resolveEndpoint(session), session, messageSelector, noLocal);
    }

    public TopicSubscriber createSubscriber(ActiveMQSession session, String messageSelector, boolean noLocal) {
        return this.createDurableSubscriber(session, null, messageSelector, noLocal);
    }

    public TopicSubscriber createDurableSubscriber(ActiveMQSession session, String name, String messageSelector, boolean noLocal) {
        throw new UnsupportedOperationException("This destination is not a Topic: " + this);
    }

    public QueueReceiver createReceiver(ActiveMQSession session, String messageSelector) {
        throw new UnsupportedOperationException("This destination is not a Queue: " + this);
    }

    public MessageProducer createProducer(ActiveMQSession session) throws JMSException {
        return new CamelMessageProducer(this, this.resolveEndpoint(session), session);
    }

    public TopicPublisher createPublisher(ActiveMQSession session) throws JMSException {
        throw new UnsupportedOperationException("This destination is not a Topic: " + this);
    }

    public QueueSender createSender(ActiveMQSession session) throws JMSException {
        throw new UnsupportedOperationException("This destination is not a Queue: " + this);
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public JmsBinding getBinding() {
        return this.binding;
    }

    public void setBinding(JmsBinding binding) {
        this.binding = binding;
    }

    protected Endpoint resolveEndpoint(ActiveMQSession session) {
        Endpoint answer = this.getEndpoint();
        if (answer == null && (answer = this.resolveCamelContext(session).getEndpoint(this.getUri())) == null) {
            throw new IllegalArgumentException("No endpoint could be found for URI: " + this.getUri());
        }
        return answer;
    }

    protected CamelContext resolveCamelContext(ActiveMQSession session) {
        ActiveMQConnection connection;
        CamelContext answer = this.getCamelContext();
        if (answer == null && (connection = session.getConnection()) instanceof CamelConnection) {
            CamelConnection camelConnection = (CamelConnection)connection;
            answer = camelConnection.getCamelContext();
        }
        if (answer == null) {
            throw new IllegalArgumentException("No CamelContext has been configured");
        }
        return answer;
    }
}

