/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap;

import ca.sqlpower.architect.olap.OLAPObject;
import ca.sqlpower.architect.olap.OLAPUtil;
import ca.sqlpower.validation.Status;
import ca.sqlpower.validation.ValidateResult;
import ca.sqlpower.validation.Validator;

public class OLAPObjectNameValidator
implements Validator {
    private final OLAPObject parent;
    private final OLAPObject obj;
    private final boolean allowNull;

    public OLAPObjectNameValidator(OLAPObject parent, OLAPObject obj, boolean allowNull) {
        this.parent = parent;
        this.obj = obj;
        this.allowNull = allowNull;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ValidateResult validate(Object contents) {
        String value = (String)contents;
        if (value == null || value.length() == 0) {
            if (!this.allowNull) return ValidateResult.createValidateResult((Status)Status.FAIL, (String)"A name is required.");
            if (this.obj.getName() == null || OLAPUtil.isNameUnique(this.parent, ((Object)((Object)this.obj)).getClass(), null)) return ValidateResult.createValidateResult((Status)Status.OK, (String)"");
            return ValidateResult.createValidateResult((Status)Status.FAIL, (String)"Name already exists.");
        }
        if (value.equalsIgnoreCase(this.obj.getName()) || OLAPUtil.isNameUnique(this.parent, ((Object)((Object)this.obj)).getClass(), value)) return ValidateResult.createValidateResult((Status)Status.OK, (String)"");
        return ValidateResult.createValidateResult((Status)Status.FAIL, (String)"Name already exists.");
    }
}

