/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;

public class FetchDocValuesContext {
    private final List<FieldAndFormat> fields;

    public FetchDocValuesContext(List<FieldAndFormat> fields) {
        this.fields = fields;
    }

    public List<FieldAndFormat> fields() {
        return this.fields;
    }

    public static final class FieldAndFormat
    implements Writeable {
        private static final ConstructingObjectParser<FieldAndFormat, Void> PARSER = new ConstructingObjectParser("script", a -> new FieldAndFormat((String)a[0], (String)a[1]));
        public final String field;
        public final String format;

        public static FieldAndFormat fromXContent(XContentParser parser) throws IOException {
            XContentParser.Token token = parser.currentToken();
            if (token.isValue()) {
                return new FieldAndFormat(parser.text(), null);
            }
            return (FieldAndFormat)PARSER.apply(parser, null);
        }

        public FieldAndFormat(String field, @Nullable String format) {
            this.field = Objects.requireNonNull(field);
            this.format = format;
        }

        public FieldAndFormat(StreamInput in) throws IOException {
            this.field = in.readString();
            this.format = in.getVersion().onOrAfter(Version.V_6_4_0) ? in.readOptionalString() : null;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.field);
            if (out.getVersion().onOrAfter(Version.V_6_4_0)) {
                out.writeOptionalString(this.format);
            }
        }

        public int hashCode() {
            int h = this.field.hashCode();
            h = 31 * h + Objects.hashCode(this.format);
            return h;
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FieldAndFormat other = (FieldAndFormat)obj;
            return this.field.equals(other.field) && Objects.equals(this.format, other.format);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("field", new String[0]));
            PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), new ParseField("format", new String[0]));
        }
    }
}

