/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ctc;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.ocf.EncryptionFilter;
import com.adobe.epubcheck.util.NamespaceHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class XmlDocParser {
    private final ZipFile zip;
    private final Hashtable<String, EncryptionFilter> enc;
    private final Report report;

    public XmlDocParser(ZipFile zip, Report report) {
        this.zip = zip;
        this.enc = new Hashtable();
        this.report = report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document parseDocument(String fileEntry) {
        Document doc = null;
        InputStream is = null;
        try {
            is = this.getInputStream(fileEntry);
            if (is == null) {
                String fileName = new File(this.zip.getName()).getName();
                this.report.message(MessageId.RSC_001, EPUBLocation.create(fileName), fileEntry);
            } else {
                doc = this.readXML(this.report, fileEntry, is, "elementLineNumber", "elementColumnNumber");
            }
        }
        catch (IOException fileName) {
        }
        catch (SAXException e) {
            doc = null;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return doc;
    }

    InputStream getInputStream(String name) throws IOException {
        ZipEntry entry = this.zip.getEntry(name);
        if (entry == null) {
            return null;
        }
        InputStream in = this.zip.getInputStream(entry);
        EncryptionFilter filter = this.enc.get(name);
        if (filter == null) {
            return in;
        }
        if (filter.canDecrypt()) {
            return filter.decrypt(in);
        }
        return null;
    }

    private Document readXML(Report report, String fileEntry, InputStream is, String lineNumAttribName, String columnNumAttribName) throws IOException, SAXException {
        Document doc;
        SAXParser parser;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setFeature("http://xml.org/sax/features/namespaces", true);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            parser = factory.newSAXParser();
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            docBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            doc = docBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Can't create SAX parser / DOM builder.", e);
        }
        MyHandler handler = new MyHandler(doc, report, fileEntry, lineNumAttribName, columnNumAttribName);
        parser.parse(is, (DefaultHandler)handler);
        return doc;
    }

    public static int getElementLineNumber(Element element) {
        return XmlDocParser.getElementAttributeAsInt(element, "elementLineNumber");
    }

    public static int getElementColumnNumber(Element element) {
        return XmlDocParser.getElementAttributeAsInt(element, "elementColumnNumber");
    }

    static int getElementAttributeAsInt(Element whichElement, String whichAttribute) {
        int result = -1;
        String attr = whichElement.getAttribute(whichAttribute);
        if (attr != null && attr.length() > 0) {
            result = Integer.parseInt(attr);
        }
        return result;
    }

    class MyHandler
    extends DefaultHandler {
        private Locator locator;
        private final NamespaceHelper namespaceHelper = new NamespaceHelper();
        private Report report;
        private String fileName;
        private Document doc;
        private String lineNumAttribName;
        private String columnNumAttribName;
        final Stack<Element> elementStack = new Stack();
        final StringBuilder textBuffer = new StringBuilder();

        public MyHandler(Document doc, Report report, String fileName, String lineNumAttribName, String columnNumAttribName) {
            this.doc = doc;
            this.report = report;
            this.fileName = fileName;
            this.lineNumAttribName = lineNumAttribName;
            this.columnNumAttribName = columnNumAttribName;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void setReport(Report report) {
            this.report = report;
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.namespaceHelper.declareNamespace(prefix, uri, EPUBLocation.create(this.fileName, this.locator.getLineNumber(), this.locator.getColumnNumber(), prefix), this.report);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.namespaceHelper.onStartElement(this.fileName, this.locator, uri, qName, attributes, this.report);
            this.addTextIfNeeded();
            Element el = this.doc.createElementNS(uri, qName);
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attributeURI = attributes.getURI(i);
                if (attributeURI == null || attributeURI.equals("")) {
                    attributeURI = uri;
                }
                el.setAttributeNS(attributeURI, attributes.getQName(i), attributes.getValue(i));
            }
            el.setAttribute(this.lineNumAttribName, String.valueOf(this.locator.getLineNumber()));
            el.setAttribute(this.columnNumAttribName, String.valueOf(this.locator.getColumnNumber()));
            this.elementStack.push(el);
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            this.addTextIfNeeded();
            Element closedEl = this.elementStack.pop();
            if (this.elementStack.isEmpty()) {
                this.doc.appendChild(closedEl);
            } else {
                Element parentEl = this.elementStack.peek();
                parentEl.appendChild(closedEl);
            }
            this.namespaceHelper.onEndElement(this.report);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.textBuffer.append(ch, start, length);
        }

        private void addTextIfNeeded() {
            if (this.textBuffer.length() > 0) {
                Element el = this.elementStack.peek();
                Text textNode = this.doc.createTextNode(this.textBuffer.toString());
                el.appendChild(textNode);
                this.textBuffer.delete(0, this.textBuffer.length());
            }
        }
    }
}

