/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.correlator.program;

import generic.DominantPair;
import generic.lsh.Partition;
import generic.lsh.vector.HashEntry;
import generic.lsh.vector.LSHCosineVectorAccum;
import ghidra.util.task.TaskMonitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

class LSHMultiHash<P> {
    private final int L;
    private int[][] partitionIdentities;
    private HashMap<Integer, HashSet<DominantPair<P, LSHCosineVectorAccum>>>[] maps;

    LSHMultiHash(int k, int L) {
        this.partitionIdentities = new int[L][];
        this.maps = new HashMap[L];
        Random random = new Random(23L);
        for (int ii = 0; ii < L; ++ii) {
            this.partitionIdentities[ii] = new int[k];
            for (int jj = 0; jj < k; ++jj) {
                this.partitionIdentities[ii][jj] = random.nextInt();
            }
            this.maps[ii] = new HashMap();
        }
        this.L = L;
    }

    synchronized void add(DominantPair<P, LSHCosineVectorAccum> entry) {
        int[] hashes = this.hashes((LSHCosineVectorAccum)entry.second);
        for (int ii = 0; ii < hashes.length; ++ii) {
            HashSet<Object> list = this.maps[ii].get(hashes[ii]);
            if (list == null) {
                list = new HashSet();
                this.maps[ii].put(hashes[ii], list);
            }
            list.add(entry);
        }
    }

    public synchronized void add(List<DominantPair<P, LSHCosineVectorAccum>> coll, TaskMonitor monitor) {
        monitor.setIndeterminate(false);
        monitor.initialize((long)coll.size());
        for (DominantPair<P, LSHCosineVectorAccum> entry : coll) {
            if (monitor.isCancelled()) break;
            monitor.incrementProgress(1L);
            if (entry.second == null) continue;
            int[] hashes = this.hashes((LSHCosineVectorAccum)entry.second);
            for (int ii = 0; ii < hashes.length; ++ii) {
                HashSet<Object> list = this.maps[ii].get(hashes[ii]);
                if (list == null) {
                    list = new HashSet();
                    this.maps[ii].put(hashes[ii], list);
                }
                list.add(entry);
            }
        }
    }

    public synchronized void add(Map<P, LSHCosineVectorAccum> map, TaskMonitor monitor) {
        monitor.setIndeterminate(false);
        monitor.initialize((long)map.size());
        for (Map.Entry<P, LSHCosineVectorAccum> entry : map.entrySet()) {
            if (monitor.isCancelled()) break;
            monitor.incrementProgress(1L);
            if (entry.getValue() == null) continue;
            int[] hashes = this.hashes(entry.getValue());
            for (int ii = 0; ii < hashes.length; ++ii) {
                HashSet<Object> list = this.maps[ii].get(hashes[ii]);
                if (list == null) {
                    list = new HashSet();
                    this.maps[ii].put(hashes[ii], list);
                }
                list.add(new DominantPair(entry.getKey(), (Object)entry.getValue()));
            }
        }
    }

    Set<DominantPair<P, LSHCosineVectorAccum>> lookup(LSHCosineVectorAccum vector) {
        HashSet<DominantPair<P, LSHCosineVectorAccum>> result = new HashSet<DominantPair<P, LSHCosineVectorAccum>>();
        int[] hashes = this.hashes(vector);
        for (int ii = 0; ii < hashes.length; ++ii) {
            HashSet<DominantPair<P, LSHCosineVectorAccum>> list = this.maps[ii].get(hashes[ii]);
            if (list == null) continue;
            result.addAll(list);
        }
        return result;
    }

    private int[] hashes(LSHCosineVectorAccum vector) {
        vector.doFinalize();
        int[] result = new int[this.L];
        HashEntry[] values = vector.getEntries();
        for (int ii = 0; ii < this.L; ++ii) {
            int hash;
            result[ii] = hash = Partition.hash((int[])this.partitionIdentities[ii], (HashEntry[])values);
        }
        return result;
    }
}

