/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.wizard;

import docking.options.editor.ButtonPanelFactory;
import docking.wizard.AbstractMageJPanel;
import docking.wizard.WizardPanelDisplayability;
import docking.wizard.WizardState;
import ghidra.app.util.task.OpenProgramTask;
import ghidra.feature.vt.gui.wizard.VTWizardStateKey;
import ghidra.feature.vt.gui.wizard.VTWizardUtils;
import ghidra.framework.main.DataTreeDialog;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.InvalidNameException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import resources.ResourceManager;

public class NewSessionPanel
extends AbstractMageJPanel<VTWizardStateKey> {
    private static final int MAX_LENGTH_FOR_VT_SESSION_NAME = 20;
    private static final Icon SWAP_ICON = ResourceManager.loadImage((String)"images/doubleArrowUpDown.png");
    private static final Icon INFO_ICON = ResourceManager.loadImage((String)"images/information.png");
    private DomainFile sourceProgramFile;
    private DomainFile destinationProgramFile;
    private JTextField placeholderForSourceProgram;
    private JTextField placeholderForDestinationProgram;
    private JButton sourceProgramBrowseButton;
    private JButton destinationProgramBrowseButton;
    private JButton swapProgramsButton;
    private JTextField sessionNameField;
    private JTextField folderNameField;
    private DomainFolder folder;
    private final PluginTool tool;
    private Program sourceProgram;
    private Program destinationProgram;

    NewSessionPanel(PluginTool tool) {
        this.tool = tool;
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        JLabel folderLabel = new JLabel("Project folder ");
        folderLabel.setHorizontalAlignment(4);
        folderLabel.setToolTipText("The folder to store the new Version Tracking Session");
        this.folderNameField = new JTextField();
        this.folderNameField.setFont(new Font("Monospaced", 0, 12));
        this.folderNameField.setEditable(false);
        JButton browseFolderButton = ButtonPanelFactory.createButton((int)2);
        browseFolderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewSessionPanel.this.browseDataTreeFolders();
            }
        });
        Font font = browseFolderButton.getFont();
        browseFolderButton.setFont(new Font(font.getName(), 1, font.getSize()));
        JLabel newSessionLabel = new JLabel("New Session Name: ");
        newSessionLabel.setToolTipText("The name for the new Version Tracking Session");
        newSessionLabel.setHorizontalAlignment(4);
        this.sessionNameField = new JTextField(25);
        this.sessionNameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                NewSessionPanel.this.notifyListenersOfValidityChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                NewSessionPanel.this.notifyListenersOfValidityChanged();
            }
        });
        JLabel sourceLabel = new JLabel("Source Program: ");
        sourceLabel.setIcon(INFO_ICON);
        sourceLabel.setToolTipText("Analyzed program with markup to transfer");
        sourceLabel.setHorizontalAlignment(4);
        JLabel destinationLabel = new JLabel("Destination Program: ");
        destinationLabel.setIcon(INFO_ICON);
        destinationLabel.setToolTipText("New program that receives the transferred markup");
        destinationLabel.setHorizontalAlignment(4);
        this.placeholderForSourceProgram = new JTextField(25);
        this.placeholderForSourceProgram.setEditable(false);
        this.placeholderForDestinationProgram = new JTextField(25);
        this.placeholderForDestinationProgram.setEditable(false);
        this.sourceProgramBrowseButton = this.createSourceBrowseButton();
        this.destinationProgramBrowseButton = this.createDestinationBrowseButton();
        this.swapProgramsButton = new JButton(SWAP_ICON);
        this.swapProgramsButton.setText("swap");
        this.swapProgramsButton.setName("SWAP_BUTTON");
        this.swapProgramsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NewSessionPanel.this.swapPrograms();
            }
        });
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        mainPanel.add(Box.createVerticalStrut(15), gbc);
        ++gbc.gridy;
        gbc.fill = 2;
        mainPanel.add((Component)folderLabel, gbc);
        ++gbc.gridx;
        mainPanel.add((Component)this.folderNameField, gbc);
        ++gbc.gridx;
        mainPanel.add(Box.createHorizontalStrut(5), gbc);
        ++gbc.gridx;
        mainPanel.add((Component)browseFolderButton, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        mainPanel.add(Box.createVerticalStrut(10), gbc);
        ++gbc.gridy;
        gbc.fill = 2;
        mainPanel.add((Component)newSessionLabel, gbc);
        ++gbc.gridx;
        mainPanel.add((Component)this.sessionNameField, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        mainPanel.add(Box.createVerticalStrut(15), gbc);
        ++gbc.gridy;
        gbc.gridwidth = 4;
        mainPanel.add((Component)new JSeparator(), gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        mainPanel.add(Box.createVerticalStrut(25), gbc);
        ++gbc.gridy;
        mainPanel.add((Component)sourceLabel, gbc);
        ++gbc.gridx;
        mainPanel.add((Component)this.placeholderForSourceProgram, gbc);
        gbc.gridx += 2;
        mainPanel.add((Component)this.sourceProgramBrowseButton, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.fill = 0;
        gbc.gridwidth = 4;
        mainPanel.add((Component)this.swapProgramsButton, gbc);
        gbc.gridwidth = 1;
        ++gbc.gridy;
        gbc.fill = 2;
        mainPanel.add((Component)destinationLabel, gbc);
        ++gbc.gridx;
        mainPanel.add((Component)this.placeholderForDestinationProgram, gbc);
        gbc.gridx += 2;
        mainPanel.add((Component)this.destinationProgramBrowseButton, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        mainPanel.add(Box.createVerticalStrut(25), gbc);
        ++gbc.gridy;
        gbc.gridwidth = 4;
        mainPanel.add((Component)new JSeparator(), gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        mainPanel.add(Box.createVerticalStrut(60), gbc);
        this.setLayout(new BorderLayout());
        this.add(mainPanel, "North");
    }

    private void initializePrograms(WizardState<VTWizardStateKey> state) {
        DomainFile source = (DomainFile)state.get((Object)VTWizardStateKey.SOURCE_PROGRAM_FILE);
        DomainFile destintation = (DomainFile)state.get((Object)VTWizardStateKey.DESTINATION_PROGRAM_FILE);
        if (source != null) {
            this.setSourceProgram(source);
        }
        if (destintation != null) {
            this.setDestinationProgram(destintation);
        }
    }

    private void browseDataTreeFolders() {
        final DataTreeDialog dataTreeDialog = new DataTreeDialog((Component)((Object)this), "Choose a project folder", 2);
        dataTreeDialog.addOkActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dataTreeDialog.close();
                NewSessionPanel.this.setFolder(dataTreeDialog.getDomainFolder());
            }
        });
        dataTreeDialog.showComponent();
    }

    void setFolder(DomainFolder folder) {
        this.folder = folder;
        if (folder != null) {
            this.folderNameField.setText(folder.toString());
        } else {
            this.folderNameField.setText("< Choose a folder >");
        }
        this.notifyListenersOfValidityChanged();
    }

    private void setSourceProgram(DomainFile programFile) {
        this.notifyListenersOfStatusMessage(" ");
        this.sourceProgramFile = programFile;
        String path = programFile == null ? "" : programFile.getPathname();
        this.placeholderForSourceProgram.setText(path);
        this.updateSessionNameIfBlank();
        this.notifyListenersOfValidityChanged();
    }

    private void updateSessionNameIfBlank() {
        if (this.sessionNameField.getText().trim().length() != 0) {
            return;
        }
        if (this.sourceProgramFile == null || this.destinationProgramFile == null) {
            return;
        }
        String sourceName = this.sourceProgramFile.getName();
        String destinationName = this.destinationProgramFile.getName();
        if (sourceName.length() > 20) {
            sourceName = sourceName.substring(0, 20);
        }
        if (destinationName.length() > 20) {
            destinationName = destinationName.substring(0, 20);
        }
        String defaultSessionName = "VT__" + sourceName + "__" + destinationName;
        this.sessionNameField.setText(defaultSessionName);
    }

    private void setDestinationProgram(DomainFile programFile) {
        this.notifyListenersOfStatusMessage(" ");
        this.destinationProgramFile = programFile;
        String path = programFile == null ? "" : programFile.getPathname();
        this.placeholderForDestinationProgram.setText(path);
        this.updateSessionNameIfBlank();
        this.notifyListenersOfValidityChanged();
    }

    private void swapPrograms() {
        this.notifyListenersOfStatusMessage(" ");
        DomainFile tmpFile = this.destinationProgramFile;
        Program tmpProgram = this.destinationProgram;
        this.destinationProgramFile = this.sourceProgramFile;
        this.destinationProgram = this.sourceProgram;
        this.sourceProgramFile = tmpFile;
        this.sourceProgram = tmpProgram;
        if (this.sourceProgramFile != null) {
            this.placeholderForSourceProgram.setText(this.sourceProgramFile.getPathname());
        } else {
            this.placeholderForSourceProgram.setText("");
        }
        if (this.destinationProgramFile != null) {
            this.placeholderForDestinationProgram.setText(this.destinationProgramFile.getPathname());
        } else {
            this.placeholderForDestinationProgram.setText("");
        }
        this.notifyListenersOfValidityChanged();
    }

    public HelpLocation getHelpLocation() {
        return new HelpLocation("VersionTrackingPlugin", "New_Session_Panel");
    }

    private void releaseConsumers() {
        if (this.sourceProgram != null) {
            this.sourceProgram.release((Object)this.tool);
            this.sourceProgram = null;
        }
        if (this.destinationProgram != null) {
            this.destinationProgram.release((Object)this.tool);
            this.destinationProgram = null;
        }
    }

    public void enterPanel(WizardState<VTWizardStateKey> state) {
        this.initializePrograms(state);
    }

    public WizardPanelDisplayability getPanelDisplayabilityAndUpdateState(WizardState<VTWizardStateKey> state) {
        return WizardPanelDisplayability.MUST_BE_DISPLAYED;
    }

    public void leavePanel(WizardState<VTWizardStateKey> state) {
        this.updateStateObjectWithPanelInfo(state);
    }

    public void updateStateObjectWithPanelInfo(WizardState<VTWizardStateKey> state) {
        state.put((Object)VTWizardStateKey.SOURCE_PROGRAM_FILE, (Object)this.sourceProgramFile);
        state.put((Object)VTWizardStateKey.DESTINATION_PROGRAM_FILE, (Object)this.destinationProgramFile);
        state.put((Object)VTWizardStateKey.SESSION_NAME, (Object)this.sessionNameField.getText());
        state.put((Object)VTWizardStateKey.NEW_SESSION_FOLDER, (Object)this.folder);
        state.put((Object)VTWizardStateKey.SOURCE_PROGRAM, (Object)this.sourceProgram);
        state.put((Object)VTWizardStateKey.DESTINATION_PROGRAM, (Object)this.destinationProgram);
    }

    private Program updateProgram(DomainFile file, Program currentProgram) {
        if (currentProgram != null) {
            if (currentProgram.getDomainFile().equals(file)) {
                return currentProgram;
            }
            currentProgram.release((Object)this.tool);
        }
        if (file == null) {
            return null;
        }
        OpenProgramTask openProgramTask = new OpenProgramTask(file, (Object)this.tool);
        new TaskLauncher((Task)openProgramTask, (Component)this.tool.getActiveWindow());
        return openProgramTask.getOpenProgram();
    }

    public String getTitle() {
        return "New Version Tracking Session";
    }

    public void initialize() {
        this.sourceProgramFile = null;
        this.destinationProgramFile = null;
        this.sessionNameField.setText("");
        this.placeholderForSourceProgram.setText("");
        this.placeholderForDestinationProgram.setText("");
        this.setFolder(this.tool.getProject().getProjectData().getRootFolder());
    }

    public boolean isValidInformation() {
        if (this.folder == null) {
            this.notifyListenersOfStatusMessage("Choose a project folder to continue!");
            return false;
        }
        if (this.sourceProgramFile == null || this.destinationProgramFile == null) {
            return false;
        }
        if (this.sourceProgramFile.equals(this.destinationProgramFile)) {
            this.notifyListenersOfStatusMessage("Source and Destination Programs must be different");
            this.releaseConsumers();
            return false;
        }
        String name = this.sessionNameField.getText().trim();
        if ("".equals(name)) {
            this.notifyListenersOfStatusMessage("Please enter a name for this session");
            return false;
        }
        try {
            this.tool.getProject().getProjectData().testValidName(name, false);
        }
        catch (InvalidNameException e) {
            this.notifyListenersOfStatusMessage("'" + name + "' contains invalid characters");
            return false;
        }
        DomainFile file = this.folder.getFile(name);
        if (file != null) {
            this.notifyListenersOfStatusMessage("'" + file.getPathname() + "' is the name of an existing domain file");
            return false;
        }
        this.sourceProgram = this.updateProgram(this.sourceProgramFile, this.sourceProgram);
        if (this.sourceProgram == null) {
            this.notifyListenersOfStatusMessage("Can't open source program " + this.sourceProgramFile.getName());
            return false;
        }
        this.destinationProgram = this.updateProgram(this.destinationProgramFile, this.destinationProgram);
        if (this.destinationProgram == null) {
            this.notifyListenersOfStatusMessage("Can't open destination program " + this.destinationProgramFile.getName());
            return false;
        }
        this.notifyListenersOfStatusMessage(" ");
        return true;
    }

    public void addDependencies(WizardState<VTWizardStateKey> state) {
    }

    private JButton createSourceBrowseButton() {
        JButton button = ButtonPanelFactory.createButton((int)2);
        button.setName("SOURCE_BUTTON");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DomainFile programFile = VTWizardUtils.chooseDomainFile((Component)((Object)NewSessionPanel.this), "a source program", VTWizardUtils.PROGRAM_FILTER, null);
                if (programFile != null) {
                    NewSessionPanel.this.setSourceProgram(programFile);
                }
            }
        });
        return button;
    }

    private JButton createDestinationBrowseButton() {
        JButton button = ButtonPanelFactory.createButton((int)2);
        button.setName("DESTINATION_BUTTON");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DomainFile programFile = VTWizardUtils.chooseDomainFile((Component)((Object)NewSessionPanel.this), "a destination program", VTWizardUtils.PROGRAM_FILTER, null);
                if (programFile != null) {
                    NewSessionPanel.this.setDestinationProgram(programFile);
                }
            }
        });
        return button;
    }

    public void dispose() {
        this.releaseConsumers();
    }
}

