/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format.attributes;

import ghidra.app.util.bin.BinaryReader;
import ghidra.javaclass.format.attributes.AbstractAttributeInfo;
import ghidra.javaclass.format.attributes.AttributeFactory;
import ghidra.javaclass.format.attributes.ExceptionHandlerJava;
import ghidra.javaclass.format.attributes.LocalVariableTableAttribute;
import ghidra.javaclass.format.constantpool.AbstractConstantPoolInfoJava;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class CodeAttribute
extends AbstractAttributeInfo {
    private long _codeOffset;
    private short maxStack;
    private short maxLocals;
    private int codeLength;
    private byte[] code;
    private short exceptionTableLength;
    private ExceptionHandlerJava[] exceptionTable;
    private short attributesCount;
    private AbstractAttributeInfo[] attributes;

    public CodeAttribute(BinaryReader reader, AbstractConstantPoolInfoJava[] constantPool) throws IOException {
        super(reader);
        int i;
        this.maxStack = reader.readNextShort();
        this.maxLocals = reader.readNextShort();
        this.codeLength = reader.readNextInt();
        this._codeOffset = reader.getPointerIndex();
        this.code = reader.readNextByteArray(this.codeLength);
        this.exceptionTableLength = reader.readNextShort();
        this.exceptionTable = new ExceptionHandlerJava[this.exceptionTableLength];
        for (i = 0; i < this.exceptionTableLength; ++i) {
            this.exceptionTable[i] = new ExceptionHandlerJava(reader);
        }
        this.attributesCount = reader.readNextShort();
        this.attributes = new AbstractAttributeInfo[this.attributesCount];
        for (i = 0; i < this.attributesCount; ++i) {
            this.attributes[i] = AttributeFactory.get(reader, constantPool);
        }
    }

    public short getMaxStack() {
        return this.maxStack;
    }

    public short getMaxLocals() {
        return this.maxLocals;
    }

    public int getCodeLength() {
        return this.codeLength;
    }

    public byte[] getCode() {
        return this.code;
    }

    public short getExceptionTableLength() {
        return this.exceptionTableLength;
    }

    public ExceptionHandlerJava[] getExceptionTable() {
        return this.exceptionTable;
    }

    public short getAttributesCount() {
        return this.attributesCount;
    }

    public AbstractAttributeInfo[] getAttributes() {
        return this.attributes;
    }

    public LocalVariableTableAttribute getLocalVariableTableAttribute() {
        for (AbstractAttributeInfo attributeInfo : this.attributes) {
            if (!(attributeInfo instanceof LocalVariableTableAttribute)) continue;
            return (LocalVariableTableAttribute)attributeInfo;
        }
        return null;
    }

    public long getCodeOffset() {
        return this._codeOffset;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        int i;
        String name = "Code_attribute|" + this.exceptionTableLength + "|" + this.attributesCount + "|";
        StructureDataType structure = this.getBaseStructure(name);
        structure.add(WORD, "max_stack", null);
        structure.add(WORD, "max_locals", null);
        structure.add(DWORD, "code_length", null);
        if (this.code.length > 0) {
            ArrayDataType array = new ArrayDataType(BYTE, this.code.length, BYTE.getLength());
            structure.add((DataType)array, "code", null);
        }
        structure.add(WORD, "exception_table_length", null);
        for (i = 0; i < this.exceptionTable.length; ++i) {
            structure.add(this.exceptionTable[i].toDataType(), "exception_table_" + i, null);
        }
        structure.add(WORD, "attributes_count", null);
        for (i = 0; i < this.attributes.length; ++i) {
            structure.add(this.attributes[i].toDataType(), "attributes_" + i, null);
        }
        return structure;
    }
}

