/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.store.db;

import db.DBChangeSet;
import db.DBHandle;
import db.buffers.BufferFile;
import generic.jar.ResourceFile;
import ghidra.framework.store.db.PackedDatabase;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateFileException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;

public class PackedDBHandle
extends DBHandle {
    private PackedDatabase pdb;
    private String contentType;

    public PackedDBHandle(String contentType) throws IOException {
        this.contentType = contentType;
    }

    PackedDBHandle(PackedDatabase pdb, BufferFile bfile) throws IOException {
        super(bfile);
        this.pdb = pdb;
        this.contentType = pdb.getContentType();
    }

    public synchronized void save(String comment, DBChangeSet changeSet, TaskMonitor monitor) throws IOException, CancelledException {
        super.save(comment, changeSet, monitor);
        if (this.pdb != null && !this.pdb.isReadOnly()) {
            this.pdb.packDatabase(monitor);
        }
    }

    public synchronized void save(TaskMonitor monitor) throws IOException, CancelledException {
        this.save("", null, monitor);
    }

    protected synchronized void saveAs(BufferFile outFile, Long newDatabaseId, TaskMonitor monitor) throws IOException, CancelledException {
        super.saveAs(outFile, newDatabaseId, monitor);
        if (this.pdb != null) {
            this.pdb.dispose();
            this.pdb = null;
        }
    }

    public synchronized void saveAs(BufferFile outFile, boolean associateWithNewFile, TaskMonitor monitor) throws IOException, CancelledException {
        super.saveAs(outFile, associateWithNewFile, monitor);
        if (associateWithNewFile && this.pdb != null) {
            this.pdb.dispose();
            this.pdb = null;
        }
    }

    public synchronized void close() {
        super.close();
        if (this.pdb != null) {
            this.pdb.dispose();
            this.pdb = null;
        }
    }

    public synchronized PackedDatabase saveAs(String itemName, File dir, String packedFileName, TaskMonitor monitor) throws IOException, DuplicateFileException, CancelledException {
        if (this.isTransactionActive()) {
            throw new IllegalStateException("Can't saveAs during transaction");
        }
        ResourceFile packedDbFile = new ResourceFile(new File(dir, packedFileName));
        this.pdb = new PackedDatabase(this, packedDbFile, itemName, null, monitor);
        return this.pdb;
    }

    public synchronized PackedDatabase saveAs(String itemName, File dir, String packedFileName, Long newDatabaseId, TaskMonitor monitor) throws IOException, DuplicateFileException, CancelledException {
        if (this.isTransactionActive()) {
            throw new IllegalStateException("Can't saveAs during transaction");
        }
        ResourceFile packedDbFile = new ResourceFile(new File(dir, packedFileName));
        this.pdb = new PackedDatabase(this, packedDbFile, itemName, newDatabaseId, monitor);
        return this.pdb;
    }

    public String getContentType() {
        return this.contentType;
    }

    public PackedDatabase getPackedDatabase() {
        return this.pdb;
    }
}

